package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;

import android.content.Context;
import android.content.Intent;

import androidx.test.espresso.NoMatchingViewException;
import androidx.test.ext.junit.rules.ActivityScenarioRule;

import org.junit.Rule;
import org.junit.Test;

import java.util.concurrent.TimeUnit;


abstract class AgeVerificationTest extends MainActivityTestBase {
    protected void prepare() {
        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getFakeVerifiedUser());
        try {
            onView(withText(R.string.ok)).perform(click());
        } catch (NoMatchingViewException e) {
            // that's ok
        }
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        AgeVerificationProviderImpl.setFakeAgeSignalsManager(null);
    }
}
