/*
Test script for JavaScriptTests.input
*/
emu.setOption("string","__STRING__");
emu.setOption("integer",42);
emu.setOption("bool", true);
emu.log(emu.LOG_VERBOSE, emu.getOption("string"));
emu.log(emu.LOG_VERBOSE, emu.getOption("integer"));
emu.log(emu.LOG_VERBOSE, emu.getOption("bool"));
// Action: Press F1
// Expected: disk is attached
emu.addKeyboardListener(emu.KEY_PRESSED, 0, 4, () => {
    emu.attachDiskImage(8, "flipdisk 1.d64");

});
// Action: Press F3
// Expected: disk is detached

emu.addKeyboardListener(emu.KEY_PRESSED, 0, 5, () => {
    emu.detachDiskImage(8);
});
// Action: Press F5
// Expected: palette flipping
emu.addKeyboardListener(emu.KEY_PRESSED, 0, 6, () => {
    emu.log(emu.LOG_VERBOSE, emu.getResource("VICIIExternalPaletteFile"));
});
// Action: Press F7
// Expected: crt emulation flipping
emu.addKeyboardListener(emu.KEY_PRESSED, 0, 3, () => {
    if (emu.getResource("VICIIFilter") != 0) {
        emu.setResource("VICIIFilter",0); 
    } else {
        emu.setResource("VICIIFilter",1); 
    }
});
// Action: Press STOP
// Expected result:
// * First time: black border
// * Second time: grey border
emu.addKeyboardListener(emu.KEY_PRESSED, 7, 7, () => {
    if (emu.hasOption("border")) {
        emu.poke(53280, emu.getOption("border"));
    } else {
        emu.setOption("border",15);
        emu.poke(53280,0);
    }
});