/*
Test script for JavaScriptTests.input
*/
function pokeTextSync(addr, screentext) {
    emu.log(emu.LOG_VERBOSE, "pokeTextSync");
    emu.addTask(() => emu.poke(addr, screentext));
    return true;
}
emu.addKeyboardListener(emu.KEY_PRESSED, 0, 3, () => {
    t = emu.charconvert("+", emu.SCREENCODE);
    f = emu.charconvert("-", emu.SCREENCODE);
    pressed = emu.charconvert("p", emu.SCREENCODE);
    released = emu.charconvert(" ", emu.SCREENCODE);
    emu.addTask(() => {
        emu.poke(1344, emu.charconvert("button a ?", emu.SCREENCODE));
        emu.poke(1384, emu.charconvert("button b ?", emu.SCREENCODE))
        emu.poke(1424, emu.charconvert("button x ?", emu.SCREENCODE));
        emu.poke(1464, emu.charconvert("button y ?", emu.SCREENCODE));
        emu.addKeyboardListener(emu.KEY_PRESSED, 7, 4, () => {
            emu.log(emu.LOG_VERBOSE,"SPACE PRESSED");
            pokeTextSync(1353, emu.isKeyAvailable(emu.KEYCODE_BUTTON_A) ? t : f);
            pokeTextSync(1393, emu.isKeyAvailable(emu.KEYCODE_BUTTON_B) ? t : f);
            pokeTextSync(1433, emu.isKeyAvailable(emu.KEYCODE_BUTTON_X) ? t : f);
            pokeTextSync(1473, emu.isKeyAvailable(emu.KEYCODE_BUTTON_Y) ? t : f);
            if (emu.isKeyAvailable(emu.PSEUDO_KEYCODE_FIREBUTTON)) {
                emu.poke(1504, emu.charconvert("fire: ", emu.SCREENCODE));
            }                
            return false;        
        });
        emu.addGamepadButtonListener(emu.BTN_PRESSED, emu.PSEUDO_KEYCODE_FIREBUTTON, () => pokeTextSync (1511,pressed));
        emu.addGamepadButtonListener(emu.BTN_RELEASED, emu.PSEUDO_KEYCODE_FIREBUTTON, () => pokeTextSync (1511,released));

        emu.addGamepadButtonListener(emu.BTN_PRESSED, emu.KEYCODE_BUTTON_A, () => pokeTextSync (1355,pressed));
        emu.addGamepadButtonListener(emu.BTN_RELEASED, emu.KEYCODE_BUTTON_A, () => pokeTextSync (1355,released));
        emu.addGamepadButtonListener(emu.BTN_PRESSED, emu.KEYCODE_BUTTON_X, () => pokeTextSync (1435,pressed));
        emu.addGamepadButtonListener(emu.BTN_RELEASED, emu.KEYCODE_BUTTON_X, () => pokeTextSync (1435,released));
    });
});
