# 8-Bit Wonders

8-Bit Wonders is a flexible and easy to use Commodore 8-bit emulator with builtin games. You can play both old and new pixel games in the style of the 80s while retaining all the advantages of your modern Android device (of course, other programs besides games also work).
8-Bit-Wonders is based on VICE and adds an androidish user interface.

At the moment, the following devices are supported:

* [Commodore C64](https://en.wikipedia.org/wiki/Commodore_64)
* [Commodore VIC 20](https://en.wikipedia.org/wiki/VIC-20)
* [Commodore C128](https://en.wikipedia.org/wiki/Commodore_128)
* [Commodore PET series (200x, 30xx, 40xx and 80xx)](https://en.wikipedia.org/wiki/Commodore_PET)
* [Commodore Plus/4](https://en.wikipedia.org/wiki/Plus/4) and [Commodore 16](https://en.wikipedia.org/wiki/Commodore_16)

More devices will follow (also non commodore).

Features:
* **Device Compatibility**: Mobile devices and TVs
* **Input Support**: Hardware joysticks, game pads, mice and virtual touch joystick
* **Keyboard Options**: Hardware and virtual keyboard with original layout
* **Game and Application Management**:
  * The app comes with an initial library of the computers mentioned above and preinstalled games.
  * Add emulation save states to the app's library
  * Easy download from archive.org
  * Import more games and applications as 8BW files created with 8-Bit Wonders or RP9 files used by other tools like C64 Forever  
* **Customization**: Map buttons to keystrokes or enable auto fire
* **Extras**: Save states and a time machine to turn back time and undo any mistakes or unfortunate events during your gameplay
* **CRT emulation** for real retro feeling.
* **Demo mode** play audio in background or visual demos in movie screen mode (without android ui elements)
## Installation

### Stores

The app is available on F-Droid store, Google Play and Amazon Appstore, see [gitlab page](https://eightbitwonders.gitlab.io/app) for links.

### Build with Android Studio

You can get the sources within Android Studio by choosing `File`➔`New`➔`Project from Version Control`. The required URL is https://gitlab.com/eightbitwonders/app.git.

### Build using Android SDK

After cloning the repository from  https://gitlab.com/eightbitwonders/app.git type

```
cd /path/to/repository
./gradlew assembleDebug
```

### Build with docker

After cloning the repository from  https://gitlab.com/eightbitwonders/app.git type

```
docker run  -it -v /path/to/repository:/project registry.gitlab.com/eightbitwonders/buildcontainer/buildcontainer:stable ./gradlew assembleDebug
```

## Getting started

There is an introduction available in [english](https://eightbitwonders.gitlab.io/app/manual/) and [german](https://eightbitwonders.gitlab.io/de/app/manual/).

## Support

See the [english feedback page](https://eightbitwonders.gitlab.io/app/feedback/) or the [german feedback page](https://eightbitwonders.gitlab.io/de/app/feedback/).

## Roadmap

### For Now

- [X] Refactor legacy code for clarity and maintainability.
- [X] Do the final tests.
- [X] Get added to F-Droid store.
- [X] Add TV-Support.
- [X] Get added to Amazon Appstore.
- [X] Get added to Google Play.
- [X] Create access to some free and legal content.
- [X] Create access to even more free and legal content. 
- [X] Add PET emulation.
- [X] Add C128 emulation
- [X] Add CRT simulation
- [X] Unified user interface for TVs and mobile devices
- [ ] Detect well known games when a disk, tape or cartridge is inserted and autoconfigure the emulation
- [ ] Support archives

### Future Plans
 
- [ ] Add non-Commodore stuff
- [ ] Why not have a version running in browsers?

## Authors and acknowledgment
A really huge "Thank you!" to the [VICE-Team](https://vice-emu.sourceforge.io/), but many others must not be forgotten. Get more info with "License and information" in the app's main menu.

## License

[GPL 2.0](https://opensource.org/licenses/gpl-2.0.php)

