#!/usr/bin/env python3
# Rebuild Mapping from GTK-keysymbols to Android-keycodes for VICE's gtk3-vkm-files

SRC_URL="https://github.com/tindzk/GTK/blob/master/gdk/gdkkeysyms.h"
TARGETFILE="../../app/src/main/java/de/rainerhock/eightbitwonders/vice/GtkKeySymbols.java"

HEADER="""
//noinspection ConstantNames
//noinspection FileLength
package de.rainerhock.eightbitwonders.vice;



import java.util.HashMap;
import java.util.Map;
final class GtkKeySymbols {
    static int getKeycode(final String keyname) {
      if (KEYCODES.containsKey(keyname)) {
        //noinspection ConstantConditions
        return KEYCODES.get(keyname);
      }
      return KEYSYM_VoidSymbol;

    }
    private GtkKeySymbols() { }

    private static final Map<String, Integer> KEYCODES = new HashMap<String, Integer>() {{
"""
#        put("Pause", 0xFF13);
#    }};
#
#}

from urllib.request import urlopen


if __name__=="__main__":
    f = open(TARGETFILE, "w")
    f.write(HEADER)
    mappings={}
    with urlopen("https://raw.githubusercontent.com/tindzk/GTK/master/gdk/gdkkeysyms.h") as response:
        body = response.read()
        print (body)
        for line in body.split(b'\n'):
            if line.startswith(b"#define"):
                parts = line.split(b" ");
                if len(parts) == 3:

                    #mappings[parts[2]] = parts[1][4:]
                    mappings[parts[1][4:]] = parts[2]
    print (mappings)
    for key in mappings.keys():
        f.write ("      put(\"%s\", KEYSYM_%s);\n" % (key.decode(), key.decode()))
    f.write("    }};\n")
    for key in mappings.keys():
        label = mappings.get(key).decode()
        #f.write("   // noinspection ConstantConditions\n");
        f.write("   static final int KEYSYM_%s = %s;\n" % (key.decode(), label))
    f.write("}\n")
    f.close()
