#!/usr/bin/python3
import hashlib
import sys
import urllib.request
from urllib.error import HTTPError
from urllib.parse import urlparse
import yaml

def parsefile(filename):

    ret = True
    with open(filename, "r") as f:
        downloads = yaml.safe_load(f)
        for localfile in downloads["files"]:
            print ("*** " + localfile["name"] + "***")
            count = 0
            for download in localfile["downloads"]:
                data = None
                #print (download["parts"])
                httperror = False
                for part in download["parts"]:

                    url =  urlparse(part)

                    if url:
                        if url.scheme == "https" and filename:
                            try:
                                req = urllib.request.Request(part, headers={'User-Agent': "curl/8.5.0"})
                                response = urllib.request.urlopen(req)
                                if data:
                                    data += response.read()
                                else:
                                    data = response.read()
                            except HTTPError as e:
                                if e.getcode() == 406 and "Server" in e.headers and e.headers["Server"] == "cloudflare":
                                    sys.stdout.write("[W] Cloudflare error 406 for %s\n" % e.geturl())
                                    data = None
                                else:
                                    sys.stderr.write("HTTP Result %d for %s" % (e.getcode(), e.geturl()))
                                    for h in e.headers:
                                        sys.stderr.write(h + ": " + e.headers[h] + "\n")
                                    sys.stderr.write("\n")
                                    data=None
                                    httperror = True
                                    ret = False
                if data:
                    hashdigest = hashlib.md5(data).hexdigest()
                    if hashdigest == download["hash"]:
                        count = count + 1
                    else:
                        if not httperror:
                            sys.stderr.write ("hash %s calculated for %s does not match stored value %s\n" % (hashdigest, " ".join(download["parts"]), download["hash"]))
                        ret = False

            print ("%s: found %d sources with correct hash" % (localfile["name"], count))
    return ret



if __name__ == "__main__":
    ret=True
    for filename in sys.argv[1:]:
        print ("Parsing %s" % filename)
        if not parsefile(filename):
            ret=False
    if not ret:
        sys.exit(1)