(async function(callId) {
    nodelist=document.evaluate("//dl[@class='metadata-definition']", document, null, XPathResult.ANY_TYPE, null);
    try {
        if (nodelist != null) {
            map = new Map();
            for (node=nodelist.iterateNext(); node != null; node=nodelist.iterateNext()) {
                key=document.evaluate("./dt", node, null, XPathResult.ANY_TYPE, null)
                    .iterateNext().innerText;
                value=document.evaluate("./dd", node, null, XPathResult.ANY_TYPE, null)
                    .iterateNext().innerText;
                   map.set(key, value);
            }
            nodelist=document.evaluate("//a[text()='SHOW ALL']", document, null, XPathResult.ANY_TYPE, null);
            relref = nodelist.iterateNext().getAttribute("href")
            absref=new URL(relref, document.URL).href
            if (!absref.endsWith("/")) {
                absref = absref+"/";
            }
            map.set("href", absref);
            const response = await fetch(absref, {}) // type: Promise<Response>
            if (!response.ok) {
                callback.logError(response.statusText);
            }
            text = await response.text();
            doc2 = new DOMParser().parseFromString(text, 'text/html');
            callback.logVerbose("Result: "+ text +" => "+doc2);
            assetlist="";
            nodelist=doc2.evaluate("//table[@class='directory-listing-table']//td/a", doc2, null, XPathResult.ANY_TYPE, null);
            //nodelist=doc2.evaluate("//table", doc2, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
            callback.logVerbose(nodelist.toString());
            for (node=nodelist.iterateNext(); node != null; node=nodelist.iterateNext()) {
                linktarget = new URL(node.getAttribute("href"),absref).href;
                if (linktarget.endsWith("vice.conf") || linktarget.endsWith("__ia_thumb.jpg") || linktarget.endsWith(map.get("Emulator_ext"))) {
                    if (assetlist.length > 0) {
                        assetlist = assetlist+"\n";
                    }
                    callback.logVerbose(">>>");
                    callback.logVerbose(node.getAttribute("href"));
                    callback.logVerbose(absref);
                    callback.logVerbose(new URL(node.getAttribute("href"),absref).href);
                    assetlist = assetlist+node.textContent+"\t"+linktarget;
                }
            }
            map.set("__assets__", assetlist);
            try {
                map.set("__title__",
                    document.evaluate("//h1[@class='item-title']", document, null, XPathResult.ANY_TYPE, null)
                        .iterateNext().textContent.trim());
            } catch (error) {
                map.set("__title__", document.title);
            }
            map.set("__url__", document.URL);
            result={}
            for (k of map.keys()) {
                result[k] = map.get(k);
            }
            callback.setEmulationDescription(callId, JSON.stringify(result));
        } else {
            callback.setEmulationDescription(callId,"");
        }
    } catch (error) {
        callback.logError("unexpected: "+error);
        callback.setEmulationDescription(callId,"");
    }
})('_%%_CALL_ID_%%_');


