//
// Created by rainer on 07.03.23.
//
#include <string.h>
#include <math.h>
#include "javascript.h"
#include "javascript_callbacks.h"
#include "resources.h"
#include "lib.h"
#include "attach.h"
#include "logginghelpers.h"

static JSValue setResource(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"name", JS_TAG_STRING, 1, 1, 255},
            {"value", JS_TAG_UNDEFINED, 0, 0, 0}

    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        ret = JS_UNDEFINED;
        int set = 0;
        const char* param = JS_ToCString(ctx, argv[0]);
        if (JS_IsString(argv[1])) {
            const char* value = JS_ToCString(ctx, argv[1]);
            if (resources_query_type(param) == RES_STRING) {
                resources_set_string(param, value);
                set = 1;
            }
            JS_FreeCString(ctx, value);
        } else if (JS_IsNumber(argv[1])) {
            int32_t val;
            JS_ToInt32(ctx, &val, argv[1]);
            if (resources_query_type(param) == RES_INTEGER) {
                resources_set_int(param, val);
                set = 1;
            }
        }
        if (!set) {
            switch ((int)resources_query_type(param)) {
                case RES_STRING:
                    ret = JS_ThrowTypeError(ctx, "%s must be string according to vice.", param);
                    set = 1;
                    break;
                case RES_INTEGER:
                    ret = JS_ThrowTypeError(ctx, "%s must be an integer according to vice.", param);
                    set = 1;
                    break;
            }
            if (!set) {
                ret = JS_ThrowTypeError(ctx, "%s is not a valid resource name.",param);
            }
        }
        JS_FreeCString(ctx, param);
    }
    return ret;

}
extern char* script_filename;



static JSValue getResource(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters params[] = {
            {"name", JS_TAG_STRING, 1, 1, 255},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, params, LEN(params));
    if (!JS_IsException(ret)) {
        const char *name = JS_ToCString(ctx, argv[0]);
        if (resources_query_type(name) == RES_STRING) {
            const char* value = NULL;
            resources_get_string(name,&value);
            ret = value ? JS_NewString(ctx, value) : JS_UNDEFINED;
        } else if (resources_query_type(name) == RES_INTEGER) {
            int value = 0;
            if (resources_get_int(name,&value)) {
                ret = JS_UNDEFINED;
            } else {
                ret = JS_NewUint32(ctx, value);
            }
        } else {
            ret = JS_ThrowTypeError(ctx, "%s is not a member of emulation's properties", name);
        }
        JS_FreeCString(ctx, name);
    }
    return ret;
}

static JSValue attachDiskImage(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters parameters[] = {
            {"drive", JS_TAG_INT,1,8,11},
            {"filename",JS_TAG_STRING,0,0,0},
    };
    JSValue  ret = js_checksyntax(__FUNCTION__ , ctx, argc, argv,  parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        uint32_t drive;
        JS_ToUint32(ctx, &drive, argv[0]);
        const char* filename = JS_ToCString(ctx, argv[1]);
        char* path=get_abs_filepath(filename);
        ret = JS_NewBool(ctx, file_system_attach_disk(drive, 0, path) == 0);
        JS_FreeCString(ctx, filename);
        lib_free(path);
    }
    return ret;
}

static JSValue detachDiskImage(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters parameters[] = {
            {"drive", JS_TAG_INT,1,8,11}
    };
    JSValue  ret = js_checksyntax(__FUNCTION__ , ctx, argc, argv,  parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        uint32_t drive;
        JS_ToUint32(ctx, &drive, argv[0]);
        char* log = lib_strdup("Detaching drive ?");
        LOGV("[JS]: Detaching drive %d", drive);
        file_system_detach_disk(drive, 0);
        LOGV("[JS]: Detached drive %d", drive);
        ret = JS_UNDEFINED;
    } else {
        LOGV("[JS]: Detaching caused exception");
    }
    return ret;
}

const JSCFunctionListEntry resourcefunctions[] = {
        JS_CFUNC_DEF("attachDiskImage", 2, attachDiskImage),
        JS_CFUNC_DEF("detachDiskImage", 1, detachDiskImage),
        JS_CFUNC_DEF("setResource", 2, setResource),
        JS_CFUNC_DEF("getResource", 1, getResource),
};
int resourcefunctions_size = sizeof(resourcefunctions) / sizeof(resourcefunctions[0]);