//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------



//noinspection ConstantNames
//noinspection FileLength
package de.rainerhock.eightbitwonders.vice;



import java.util.HashMap;
import java.util.Map;
final class GtkKeySymbols {
    static int getKeycode(final String keyname) {
      if (KEYCODES.containsKey(keyname)) {
        //noinspection ConstantConditions
        return KEYCODES.get(keyname);
      }
      return KEYSYM_VoidSymbol;

    }
    private GtkKeySymbols() { }

    private static final Map<String, Integer> KEYCODES = new HashMap<String, Integer>() {{
      put("VoidSymbol", KEYSYM_VoidSymbol);
      put("BackSpace", KEYSYM_BackSpace);
      put("Tab", KEYSYM_Tab);
      put("Linefeed", KEYSYM_Linefeed);
      put("Clear", KEYSYM_Clear);
      put("Return", KEYSYM_Return);
      put("Pause", KEYSYM_Pause);
      put("Scroll_Lock", KEYSYM_Scroll_Lock);
      put("Sys_Req", KEYSYM_Sys_Req);
      put("Escape", KEYSYM_Escape);
      put("Delete", KEYSYM_Delete);
      put("Multi_key", KEYSYM_Multi_key);
      put("SingleCandidate", KEYSYM_SingleCandidate);
      put("MultipleCandidate", KEYSYM_MultipleCandidate);
      put("PreviousCandidate", KEYSYM_PreviousCandidate);
      put("Kanji", KEYSYM_Kanji);
      put("Muhenkan", KEYSYM_Muhenkan);
      put("Henkan_Mode", KEYSYM_Henkan_Mode);
      put("Henkan", KEYSYM_Henkan);
      put("Romaji", KEYSYM_Romaji);
      put("Hiragana", KEYSYM_Hiragana);
      put("Katakana", KEYSYM_Katakana);
      put("Hiragana_Katakana", KEYSYM_Hiragana_Katakana);
      put("Zenkaku", KEYSYM_Zenkaku);
      put("Hankaku", KEYSYM_Hankaku);
      put("Zenkaku_Hankaku", KEYSYM_Zenkaku_Hankaku);
      put("Touroku", KEYSYM_Touroku);
      put("Massyo", KEYSYM_Massyo);
      put("Kana_Lock", KEYSYM_Kana_Lock);
      put("Kana_Shift", KEYSYM_Kana_Shift);
      put("Eisu_Shift", KEYSYM_Eisu_Shift);
      put("Eisu_toggle", KEYSYM_Eisu_toggle);
      put("Zen_Koho", KEYSYM_Zen_Koho);
      put("Mae_Koho", KEYSYM_Mae_Koho);
      put("Home", KEYSYM_Home);
      put("Left", KEYSYM_Left);
      put("Up", KEYSYM_Up);
      put("Right", KEYSYM_Right);
      put("Down", KEYSYM_Down);
      put("Prior", KEYSYM_Prior);
      put("Page_Up", KEYSYM_Page_Up);
      put("Next", KEYSYM_Next);
      put("Page_Down", KEYSYM_Page_Down);
      put("End", KEYSYM_End);
      put("Begin", KEYSYM_Begin);
      put("Select", KEYSYM_Select);
      put("Print", KEYSYM_Print);
      put("Execute", KEYSYM_Execute);
      put("Insert", KEYSYM_Insert);
      put("Undo", KEYSYM_Undo);
      put("Redo", KEYSYM_Redo);
      put("Menu", KEYSYM_Menu);
      put("Find", KEYSYM_Find);
      put("Cancel", KEYSYM_Cancel);
      put("Help", KEYSYM_Help);
      put("Break", KEYSYM_Break);
      put("Mode_switch", KEYSYM_Mode_switch);
      put("script_switch", KEYSYM_script_switch);
      put("Num_Lock", KEYSYM_Num_Lock);
      put("KP_Space", KEYSYM_KP_Space);
      put("KP_Tab", KEYSYM_KP_Tab);
      put("KP_Enter", KEYSYM_KP_Enter);
      put("KP_F1", KEYSYM_KP_F1);
      put("KP_F2", KEYSYM_KP_F2);
      put("KP_F3", KEYSYM_KP_F3);
      put("KP_F4", KEYSYM_KP_F4);
      put("KP_Home", KEYSYM_KP_Home);
      put("KP_Left", KEYSYM_KP_Left);
      put("KP_Up", KEYSYM_KP_Up);
      put("KP_Right", KEYSYM_KP_Right);
      put("KP_Down", KEYSYM_KP_Down);
      put("KP_Prior", KEYSYM_KP_Prior);
      put("KP_Page_Up", KEYSYM_KP_Page_Up);
      put("KP_Next", KEYSYM_KP_Next);
      put("KP_Page_Down", KEYSYM_KP_Page_Down);
      put("KP_End", KEYSYM_KP_End);
      put("KP_Begin", KEYSYM_KP_Begin);
      put("KP_Insert", KEYSYM_KP_Insert);
      put("KP_Delete", KEYSYM_KP_Delete);
      put("KP_Equal", KEYSYM_KP_Equal);
      put("KP_Multiply", KEYSYM_KP_Multiply);
      put("KP_Add", KEYSYM_KP_Add);
      put("KP_Separator", KEYSYM_KP_Separator);
      put("KP_Subtract", KEYSYM_KP_Subtract);
      put("KP_Decimal", KEYSYM_KP_Decimal);
      put("KP_Divide", KEYSYM_KP_Divide);
      put("KP_0", KEYSYM_KP_0);
      put("KP_1", KEYSYM_KP_1);
      put("KP_2", KEYSYM_KP_2);
      put("KP_3", KEYSYM_KP_3);
      put("KP_4", KEYSYM_KP_4);
      put("KP_5", KEYSYM_KP_5);
      put("KP_6", KEYSYM_KP_6);
      put("KP_7", KEYSYM_KP_7);
      put("KP_8", KEYSYM_KP_8);
      put("KP_9", KEYSYM_KP_9);
      put("F1", KEYSYM_F1);
      put("F2", KEYSYM_F2);
      put("F3", KEYSYM_F3);
      put("F4", KEYSYM_F4);
      put("F5", KEYSYM_F5);
      put("F6", KEYSYM_F6);
      put("F7", KEYSYM_F7);
      put("F8", KEYSYM_F8);
      put("F9", KEYSYM_F9);
      put("F10", KEYSYM_F10);
      put("F11", KEYSYM_F11);
      put("L1", KEYSYM_L1);
      put("F12", KEYSYM_F12);
      put("L2", KEYSYM_L2);
      put("F13", KEYSYM_F13);
      put("L3", KEYSYM_L3);
      put("F14", KEYSYM_F14);
      put("L4", KEYSYM_L4);
      put("F15", KEYSYM_F15);
      put("L5", KEYSYM_L5);
      put("F16", KEYSYM_F16);
      put("L6", KEYSYM_L6);
      put("F17", KEYSYM_F17);
      put("L7", KEYSYM_L7);
      put("F18", KEYSYM_F18);
      put("L8", KEYSYM_L8);
      put("F19", KEYSYM_F19);
      put("L9", KEYSYM_L9);
      put("F20", KEYSYM_F20);
      put("L10", KEYSYM_L10);
      put("F21", KEYSYM_F21);
      put("R1", KEYSYM_R1);
      put("F22", KEYSYM_F22);
      put("R2", KEYSYM_R2);
      put("F23", KEYSYM_F23);
      put("R3", KEYSYM_R3);
      put("F24", KEYSYM_F24);
      put("R4", KEYSYM_R4);
      put("F25", KEYSYM_F25);
      put("R5", KEYSYM_R5);
      put("F26", KEYSYM_F26);
      put("R6", KEYSYM_R6);
      put("F27", KEYSYM_F27);
      put("R7", KEYSYM_R7);
      put("F28", KEYSYM_F28);
      put("R8", KEYSYM_R8);
      put("F29", KEYSYM_F29);
      put("R9", KEYSYM_R9);
      put("F30", KEYSYM_F30);
      put("R10", KEYSYM_R10);
      put("F31", KEYSYM_F31);
      put("R11", KEYSYM_R11);
      put("F32", KEYSYM_F32);
      put("R12", KEYSYM_R12);
      put("F33", KEYSYM_F33);
      put("R13", KEYSYM_R13);
      put("F34", KEYSYM_F34);
      put("R14", KEYSYM_R14);
      put("F35", KEYSYM_F35);
      put("R15", KEYSYM_R15);
      put("Shift_L", KEYSYM_Shift_L);
      put("Shift_R", KEYSYM_Shift_R);
      put("Control_L", KEYSYM_Control_L);
      put("Control_R", KEYSYM_Control_R);
      put("Caps_Lock", KEYSYM_Caps_Lock);
      put("Shift_Lock", KEYSYM_Shift_Lock);
      put("Meta_L", KEYSYM_Meta_L);
      put("Meta_R", KEYSYM_Meta_R);
      put("Alt_L", KEYSYM_Alt_L);
      put("Alt_R", KEYSYM_Alt_R);
      put("Super_L", KEYSYM_Super_L);
      put("Super_R", KEYSYM_Super_R);
      put("Hyper_L", KEYSYM_Hyper_L);
      put("Hyper_R", KEYSYM_Hyper_R);
      put("ISO_Lock", KEYSYM_ISO_Lock);
      put("ISO_Level2_Latch", KEYSYM_ISO_Level2_Latch);
      put("ISO_Level3_Shift", KEYSYM_ISO_Level3_Shift);
      put("ISO_Level3_Latch", KEYSYM_ISO_Level3_Latch);
      put("ISO_Level3_Lock", KEYSYM_ISO_Level3_Lock);
      put("ISO_Group_Shift", KEYSYM_ISO_Group_Shift);
      put("ISO_Group_Latch", KEYSYM_ISO_Group_Latch);
      put("ISO_Group_Lock", KEYSYM_ISO_Group_Lock);
      put("ISO_Next_Group", KEYSYM_ISO_Next_Group);
      put("ISO_Next_Group_Lock", KEYSYM_ISO_Next_Group_Lock);
      put("ISO_Prev_Group", KEYSYM_ISO_Prev_Group);
      put("ISO_Prev_Group_Lock", KEYSYM_ISO_Prev_Group_Lock);
      put("ISO_First_Group", KEYSYM_ISO_First_Group);
      put("ISO_First_Group_Lock", KEYSYM_ISO_First_Group_Lock);
      put("ISO_Last_Group", KEYSYM_ISO_Last_Group);
      put("ISO_Last_Group_Lock", KEYSYM_ISO_Last_Group_Lock);
      put("ISO_Left_Tab", KEYSYM_ISO_Left_Tab);
      put("ISO_Move_Line_Up", KEYSYM_ISO_Move_Line_Up);
      put("ISO_Move_Line_Down", KEYSYM_ISO_Move_Line_Down);
      put("ISO_Partial_Line_Up", KEYSYM_ISO_Partial_Line_Up);
      put("ISO_Partial_Line_Down", KEYSYM_ISO_Partial_Line_Down);
      put("ISO_Partial_Space_Left", KEYSYM_ISO_Partial_Space_Left);
      put("ISO_Partial_Space_Right", KEYSYM_ISO_Partial_Space_Right);
      put("ISO_Set_Margin_Left", KEYSYM_ISO_Set_Margin_Left);
      put("ISO_Set_Margin_Right", KEYSYM_ISO_Set_Margin_Right);
      put("ISO_Release_Margin_Left", KEYSYM_ISO_Release_Margin_Left);
      put("ISO_Release_Margin_Right", KEYSYM_ISO_Release_Margin_Right);
      put("ISO_Release_Both_Margins", KEYSYM_ISO_Release_Both_Margins);
      put("ISO_Fast_Cursor_Left", KEYSYM_ISO_Fast_Cursor_Left);
      put("ISO_Fast_Cursor_Right", KEYSYM_ISO_Fast_Cursor_Right);
      put("ISO_Fast_Cursor_Up", KEYSYM_ISO_Fast_Cursor_Up);
      put("ISO_Fast_Cursor_Down", KEYSYM_ISO_Fast_Cursor_Down);
      put("ISO_Continuous_Underline", KEYSYM_ISO_Continuous_Underline);
      put("ISO_Discontinuous_Underline", KEYSYM_ISO_Discontinuous_Underline);
      put("ISO_Emphasize", KEYSYM_ISO_Emphasize);
      put("ISO_Center_Object", KEYSYM_ISO_Center_Object);
      put("ISO_Enter", KEYSYM_ISO_Enter);
      put("dead_grave", KEYSYM_dead_grave);
      put("dead_acute", KEYSYM_dead_acute);
      put("dead_circumflex", KEYSYM_dead_circumflex);
      put("dead_tilde", KEYSYM_dead_tilde);
      put("dead_macron", KEYSYM_dead_macron);
      put("dead_breve", KEYSYM_dead_breve);
      put("dead_abovedot", KEYSYM_dead_abovedot);
      put("dead_diaeresis", KEYSYM_dead_diaeresis);
      put("dead_abovering", KEYSYM_dead_abovering);
      put("dead_doubleacute", KEYSYM_dead_doubleacute);
      put("dead_caron", KEYSYM_dead_caron);
      put("dead_cedilla", KEYSYM_dead_cedilla);
      put("dead_ogonek", KEYSYM_dead_ogonek);
      put("dead_iota", KEYSYM_dead_iota);
      put("dead_voiced_sound", KEYSYM_dead_voiced_sound);
      put("dead_semivoiced_sound", KEYSYM_dead_semivoiced_sound);
      put("dead_belowdot", KEYSYM_dead_belowdot);
      put("First_Virtual_Screen", KEYSYM_First_Virtual_Screen);
      put("Prev_Virtual_Screen", KEYSYM_Prev_Virtual_Screen);
      put("Next_Virtual_Screen", KEYSYM_Next_Virtual_Screen);
      put("Last_Virtual_Screen", KEYSYM_Last_Virtual_Screen);
      put("Terminate_Server", KEYSYM_Terminate_Server);
      put("AccessX_Enable", KEYSYM_AccessX_Enable);
      put("AccessX_Feedback_Enable", KEYSYM_AccessX_Feedback_Enable);
      put("RepeatKeys_Enable", KEYSYM_RepeatKeys_Enable);
      put("SlowKeys_Enable", KEYSYM_SlowKeys_Enable);
      put("BounceKeys_Enable", KEYSYM_BounceKeys_Enable);
      put("StickyKeys_Enable", KEYSYM_StickyKeys_Enable);
      put("MouseKeys_Enable", KEYSYM_MouseKeys_Enable);
      put("MouseKeys_Accel_Enable", KEYSYM_MouseKeys_Accel_Enable);
      put("Overlay1_Enable", KEYSYM_Overlay1_Enable);
      put("Overlay2_Enable", KEYSYM_Overlay2_Enable);
      put("AudibleBell_Enable", KEYSYM_AudibleBell_Enable);
      put("Pointer_Left", KEYSYM_Pointer_Left);
      put("Pointer_Right", KEYSYM_Pointer_Right);
      put("Pointer_Up", KEYSYM_Pointer_Up);
      put("Pointer_Down", KEYSYM_Pointer_Down);
      put("Pointer_UpLeft", KEYSYM_Pointer_UpLeft);
      put("Pointer_UpRight", KEYSYM_Pointer_UpRight);
      put("Pointer_DownLeft", KEYSYM_Pointer_DownLeft);
      put("Pointer_DownRight", KEYSYM_Pointer_DownRight);
      put("Pointer_Button_Dflt", KEYSYM_Pointer_Button_Dflt);
      put("Pointer_Button1", KEYSYM_Pointer_Button1);
      put("Pointer_Button2", KEYSYM_Pointer_Button2);
      put("Pointer_Button3", KEYSYM_Pointer_Button3);
      put("Pointer_Button4", KEYSYM_Pointer_Button4);
      put("Pointer_Button5", KEYSYM_Pointer_Button5);
      put("Pointer_DblClick_Dflt", KEYSYM_Pointer_DblClick_Dflt);
      put("Pointer_DblClick1", KEYSYM_Pointer_DblClick1);
      put("Pointer_DblClick2", KEYSYM_Pointer_DblClick2);
      put("Pointer_DblClick3", KEYSYM_Pointer_DblClick3);
      put("Pointer_DblClick4", KEYSYM_Pointer_DblClick4);
      put("Pointer_DblClick5", KEYSYM_Pointer_DblClick5);
      put("Pointer_Drag_Dflt", KEYSYM_Pointer_Drag_Dflt);
      put("Pointer_Drag1", KEYSYM_Pointer_Drag1);
      put("Pointer_Drag2", KEYSYM_Pointer_Drag2);
      put("Pointer_Drag3", KEYSYM_Pointer_Drag3);
      put("Pointer_Drag4", KEYSYM_Pointer_Drag4);
      put("Pointer_Drag5", KEYSYM_Pointer_Drag5);
      put("Pointer_EnableKeys", KEYSYM_Pointer_EnableKeys);
      put("Pointer_Accelerate", KEYSYM_Pointer_Accelerate);
      put("Pointer_DfltBtnNext", KEYSYM_Pointer_DfltBtnNext);
      put("Pointer_DfltBtnPrev", KEYSYM_Pointer_DfltBtnPrev);
      put("3270_Duplicate", KEYSYM_3270_Duplicate);
      put("3270_FieldMark", KEYSYM_3270_FieldMark);
      put("3270_Right2", KEYSYM_3270_Right2);
      put("3270_Left2", KEYSYM_3270_Left2);
      put("3270_BackTab", KEYSYM_3270_BackTab);
      put("3270_EraseEOF", KEYSYM_3270_EraseEOF);
      put("3270_EraseInput", KEYSYM_3270_EraseInput);
      put("3270_Reset", KEYSYM_3270_Reset);
      put("3270_Quit", KEYSYM_3270_Quit);
      put("3270_PA1", KEYSYM_3270_PA1);
      put("3270_PA2", KEYSYM_3270_PA2);
      put("3270_PA3", KEYSYM_3270_PA3);
      put("3270_Test", KEYSYM_3270_Test);
      put("3270_Attn", KEYSYM_3270_Attn);
      put("3270_CursorBlink", KEYSYM_3270_CursorBlink);
      put("3270_AltCursor", KEYSYM_3270_AltCursor);
      put("3270_KeyClick", KEYSYM_3270_KeyClick);
      put("3270_Jump", KEYSYM_3270_Jump);
      put("3270_Ident", KEYSYM_3270_Ident);
      put("3270_Rule", KEYSYM_3270_Rule);
      put("3270_Copy", KEYSYM_3270_Copy);
      put("3270_Play", KEYSYM_3270_Play);
      put("3270_Setup", KEYSYM_3270_Setup);
      put("3270_Record", KEYSYM_3270_Record);
      put("3270_ChangeScreen", KEYSYM_3270_ChangeScreen);
      put("3270_DeleteWord", KEYSYM_3270_DeleteWord);
      put("3270_ExSelect", KEYSYM_3270_ExSelect);
      put("3270_CursorSelect", KEYSYM_3270_CursorSelect);
      put("3270_PrintScreen", KEYSYM_3270_PrintScreen);
      put("3270_Enter", KEYSYM_3270_Enter);
      put("space", KEYSYM_space);
      put("exclam", KEYSYM_exclam);
      put("quotedbl", KEYSYM_quotedbl);
      put("numbersign", KEYSYM_numbersign);
      put("dollar", KEYSYM_dollar);
      put("percent", KEYSYM_percent);
      put("ampersand", KEYSYM_ampersand);
      put("apostrophe", KEYSYM_apostrophe);
      put("quoteright", KEYSYM_quoteright);
      put("parenleft", KEYSYM_parenleft);
      put("parenright", KEYSYM_parenright);
      put("asterisk", KEYSYM_asterisk);
      put("plus", KEYSYM_plus);
      put("comma", KEYSYM_comma);
      put("minus", KEYSYM_minus);
      put("period", KEYSYM_period);
      put("slash", KEYSYM_slash);
      put("0", KEYSYM_0);
      put("1", KEYSYM_1);
      put("2", KEYSYM_2);
      put("3", KEYSYM_3);
      put("4", KEYSYM_4);
      put("5", KEYSYM_5);
      put("6", KEYSYM_6);
      put("7", KEYSYM_7);
      put("8", KEYSYM_8);
      put("9", KEYSYM_9);
      put("colon", KEYSYM_colon);
      put("semicolon", KEYSYM_semicolon);
      put("less", KEYSYM_less);
      put("equal", KEYSYM_equal);
      put("greater", KEYSYM_greater);
      put("question", KEYSYM_question);
      put("at", KEYSYM_at);
      put("A", KEYSYM_A);
      put("B", KEYSYM_B);
      put("C", KEYSYM_C);
      put("D", KEYSYM_D);
      put("E", KEYSYM_E);
      put("F", KEYSYM_F);
      put("G", KEYSYM_G);
      put("H", KEYSYM_H);
      put("I", KEYSYM_I);
      put("J", KEYSYM_J);
      put("K", KEYSYM_K);
      put("L", KEYSYM_L);
      put("M", KEYSYM_M);
      put("N", KEYSYM_N);
      put("O", KEYSYM_O);
      put("P", KEYSYM_P);
      put("Q", KEYSYM_Q);
      put("R", KEYSYM_R);
      put("S", KEYSYM_S);
      put("T", KEYSYM_T);
      put("U", KEYSYM_U);
      put("V", KEYSYM_V);
      put("W", KEYSYM_W);
      put("X", KEYSYM_X);
      put("Y", KEYSYM_Y);
      put("Z", KEYSYM_Z);
      put("bracketleft", KEYSYM_bracketleft);
      put("backslash", KEYSYM_backslash);
      put("bracketright", KEYSYM_bracketright);
      put("asciicircum", KEYSYM_asciicircum);
      put("underscore", KEYSYM_underscore);
      put("grave", KEYSYM_grave);
      put("quoteleft", KEYSYM_quoteleft);
      put("a", KEYSYM_a);
      put("b", KEYSYM_b);
      put("c", KEYSYM_c);
      put("d", KEYSYM_d);
      put("e", KEYSYM_e);
      put("f", KEYSYM_f);
      put("g", KEYSYM_g);
      put("h", KEYSYM_h);
      put("i", KEYSYM_i);
      put("j", KEYSYM_j);
      put("k", KEYSYM_k);
      put("l", KEYSYM_l);
      put("m", KEYSYM_m);
      put("n", KEYSYM_n);
      put("o", KEYSYM_o);
      put("p", KEYSYM_p);
      put("q", KEYSYM_q);
      put("r", KEYSYM_r);
      put("s", KEYSYM_s);
      put("t", KEYSYM_t);
      put("u", KEYSYM_u);
      put("v", KEYSYM_v);
      put("w", KEYSYM_w);
      put("x", KEYSYM_x);
      put("y", KEYSYM_y);
      put("z", KEYSYM_z);
      put("braceleft", KEYSYM_braceleft);
      put("bar", KEYSYM_bar);
      put("braceright", KEYSYM_braceright);
      put("asciitilde", KEYSYM_asciitilde);
      put("nobreakspace", KEYSYM_nobreakspace);
      put("exclamdown", KEYSYM_exclamdown);
      put("cent", KEYSYM_cent);
      put("sterling", KEYSYM_sterling);
      put("currency", KEYSYM_currency);
      put("yen", KEYSYM_yen);
      put("brokenbar", KEYSYM_brokenbar);
      put("section", KEYSYM_section);
      put("diaeresis", KEYSYM_diaeresis);
      put("copyright", KEYSYM_copyright);
      put("ordfeminine", KEYSYM_ordfeminine);
      put("guillemotleft", KEYSYM_guillemotleft);
      put("notsign", KEYSYM_notsign);
      put("hyphen", KEYSYM_hyphen);
      put("registered", KEYSYM_registered);
      put("macron", KEYSYM_macron);
      put("degree", KEYSYM_degree);
      put("plusminus", KEYSYM_plusminus);
      put("twosuperior", KEYSYM_twosuperior);
      put("threesuperior", KEYSYM_threesuperior);
      put("acute", KEYSYM_acute);
      put("mu", KEYSYM_mu);
      put("paragraph", KEYSYM_paragraph);
      put("periodcentered", KEYSYM_periodcentered);
      put("cedilla", KEYSYM_cedilla);
      put("onesuperior", KEYSYM_onesuperior);
      put("masculine", KEYSYM_masculine);
      put("guillemotright", KEYSYM_guillemotright);
      put("onequarter", KEYSYM_onequarter);
      put("onehalf", KEYSYM_onehalf);
      put("threequarters", KEYSYM_threequarters);
      put("questiondown", KEYSYM_questiondown);
      put("Agrave", KEYSYM_Agrave);
      put("Aacute", KEYSYM_Aacute);
      put("Acircumflex", KEYSYM_Acircumflex);
      put("Atilde", KEYSYM_Atilde);
      put("Adiaeresis", KEYSYM_Adiaeresis);
      put("Aring", KEYSYM_Aring);
      put("AE", KEYSYM_AE);
      put("Ccedilla", KEYSYM_Ccedilla);
      put("Egrave", KEYSYM_Egrave);
      put("Eacute", KEYSYM_Eacute);
      put("Ecircumflex", KEYSYM_Ecircumflex);
      put("Ediaeresis", KEYSYM_Ediaeresis);
      put("Igrave", KEYSYM_Igrave);
      put("Iacute", KEYSYM_Iacute);
      put("Icircumflex", KEYSYM_Icircumflex);
      put("Idiaeresis", KEYSYM_Idiaeresis);
      put("ETH", KEYSYM_ETH);
      put("Eth", KEYSYM_Eth);
      put("Ntilde", KEYSYM_Ntilde);
      put("Ograve", KEYSYM_Ograve);
      put("Oacute", KEYSYM_Oacute);
      put("Ocircumflex", KEYSYM_Ocircumflex);
      put("Otilde", KEYSYM_Otilde);
      put("Odiaeresis", KEYSYM_Odiaeresis);
      put("multiply", KEYSYM_multiply);
      put("Ooblique", KEYSYM_Ooblique);
      put("Ugrave", KEYSYM_Ugrave);
      put("Uacute", KEYSYM_Uacute);
      put("Ucircumflex", KEYSYM_Ucircumflex);
      put("Udiaeresis", KEYSYM_Udiaeresis);
      put("Yacute", KEYSYM_Yacute);
      put("THORN", KEYSYM_THORN);
      put("Thorn", KEYSYM_Thorn);
      put("ssharp", KEYSYM_ssharp);
      put("agrave", KEYSYM_agrave);
      put("aacute", KEYSYM_aacute);
      put("acircumflex", KEYSYM_acircumflex);
      put("atilde", KEYSYM_atilde);
      put("adiaeresis", KEYSYM_adiaeresis);
      put("aring", KEYSYM_aring);
      put("ae", KEYSYM_ae);
      put("ccedilla", KEYSYM_ccedilla);
      put("egrave", KEYSYM_egrave);
      put("eacute", KEYSYM_eacute);
      put("ecircumflex", KEYSYM_ecircumflex);
      put("ediaeresis", KEYSYM_ediaeresis);
      put("igrave", KEYSYM_igrave);
      put("iacute", KEYSYM_iacute);
      put("icircumflex", KEYSYM_icircumflex);
      put("idiaeresis", KEYSYM_idiaeresis);
      put("eth", KEYSYM_eth);
      put("ntilde", KEYSYM_ntilde);
      put("ograve", KEYSYM_ograve);
      put("oacute", KEYSYM_oacute);
      put("ocircumflex", KEYSYM_ocircumflex);
      put("otilde", KEYSYM_otilde);
      put("odiaeresis", KEYSYM_odiaeresis);
      put("division", KEYSYM_division);
      put("oslash", KEYSYM_oslash);
      put("ugrave", KEYSYM_ugrave);
      put("uacute", KEYSYM_uacute);
      put("ucircumflex", KEYSYM_ucircumflex);
      put("udiaeresis", KEYSYM_udiaeresis);
      put("yacute", KEYSYM_yacute);
      put("thorn", KEYSYM_thorn);
      put("ydiaeresis", KEYSYM_ydiaeresis);
      put("Aogonek", KEYSYM_Aogonek);
      put("breve", KEYSYM_breve);
      put("Lstroke", KEYSYM_Lstroke);
      put("Lcaron", KEYSYM_Lcaron);
      put("Sacute", KEYSYM_Sacute);
      put("Scaron", KEYSYM_Scaron);
      put("Scedilla", KEYSYM_Scedilla);
      put("Tcaron", KEYSYM_Tcaron);
      put("Zacute", KEYSYM_Zacute);
      put("Zcaron", KEYSYM_Zcaron);
      put("Zabovedot", KEYSYM_Zabovedot);
      put("aogonek", KEYSYM_aogonek);
      put("ogonek", KEYSYM_ogonek);
      put("lstroke", KEYSYM_lstroke);
      put("lcaron", KEYSYM_lcaron);
      put("sacute", KEYSYM_sacute);
      put("caron", KEYSYM_caron);
      put("scaron", KEYSYM_scaron);
      put("scedilla", KEYSYM_scedilla);
      put("tcaron", KEYSYM_tcaron);
      put("zacute", KEYSYM_zacute);
      put("doubleacute", KEYSYM_doubleacute);
      put("zcaron", KEYSYM_zcaron);
      put("zabovedot", KEYSYM_zabovedot);
      put("Racute", KEYSYM_Racute);
      put("Abreve", KEYSYM_Abreve);
      put("Lacute", KEYSYM_Lacute);
      put("Cacute", KEYSYM_Cacute);
      put("Ccaron", KEYSYM_Ccaron);
      put("Eogonek", KEYSYM_Eogonek);
      put("Ecaron", KEYSYM_Ecaron);
      put("Dcaron", KEYSYM_Dcaron);
      put("Dstroke", KEYSYM_Dstroke);
      put("Nacute", KEYSYM_Nacute);
      put("Ncaron", KEYSYM_Ncaron);
      put("Odoubleacute", KEYSYM_Odoubleacute);
      put("Rcaron", KEYSYM_Rcaron);
      put("Uring", KEYSYM_Uring);
      put("Udoubleacute", KEYSYM_Udoubleacute);
      put("Tcedilla", KEYSYM_Tcedilla);
      put("racute", KEYSYM_racute);
      put("abreve", KEYSYM_abreve);
      put("lacute", KEYSYM_lacute);
      put("cacute", KEYSYM_cacute);
      put("ccaron", KEYSYM_ccaron);
      put("eogonek", KEYSYM_eogonek);
      put("ecaron", KEYSYM_ecaron);
      put("dcaron", KEYSYM_dcaron);
      put("dstroke", KEYSYM_dstroke);
      put("nacute", KEYSYM_nacute);
      put("ncaron", KEYSYM_ncaron);
      put("odoubleacute", KEYSYM_odoubleacute);
      put("udoubleacute", KEYSYM_udoubleacute);
      put("rcaron", KEYSYM_rcaron);
      put("uring", KEYSYM_uring);
      put("tcedilla", KEYSYM_tcedilla);
      put("abovedot", KEYSYM_abovedot);
      put("Hstroke", KEYSYM_Hstroke);
      put("Hcircumflex", KEYSYM_Hcircumflex);
      put("Iabovedot", KEYSYM_Iabovedot);
      put("Gbreve", KEYSYM_Gbreve);
      put("Jcircumflex", KEYSYM_Jcircumflex);
      put("hstroke", KEYSYM_hstroke);
      put("hcircumflex", KEYSYM_hcircumflex);
      put("idotless", KEYSYM_idotless);
      put("gbreve", KEYSYM_gbreve);
      put("jcircumflex", KEYSYM_jcircumflex);
      put("Cabovedot", KEYSYM_Cabovedot);
      put("Ccircumflex", KEYSYM_Ccircumflex);
      put("Gabovedot", KEYSYM_Gabovedot);
      put("Gcircumflex", KEYSYM_Gcircumflex);
      put("Ubreve", KEYSYM_Ubreve);
      put("Scircumflex", KEYSYM_Scircumflex);
      put("cabovedot", KEYSYM_cabovedot);
      put("ccircumflex", KEYSYM_ccircumflex);
      put("gabovedot", KEYSYM_gabovedot);
      put("gcircumflex", KEYSYM_gcircumflex);
      put("ubreve", KEYSYM_ubreve);
      put("scircumflex", KEYSYM_scircumflex);
      put("kra", KEYSYM_kra);
      put("kappa", KEYSYM_kappa);
      put("Rcedilla", KEYSYM_Rcedilla);
      put("Itilde", KEYSYM_Itilde);
      put("Lcedilla", KEYSYM_Lcedilla);
      put("Emacron", KEYSYM_Emacron);
      put("Gcedilla", KEYSYM_Gcedilla);
      put("Tslash", KEYSYM_Tslash);
      put("rcedilla", KEYSYM_rcedilla);
      put("itilde", KEYSYM_itilde);
      put("lcedilla", KEYSYM_lcedilla);
      put("emacron", KEYSYM_emacron);
      put("gcedilla", KEYSYM_gcedilla);
      put("tslash", KEYSYM_tslash);
      put("ENG", KEYSYM_ENG);
      put("eng", KEYSYM_eng);
      put("Amacron", KEYSYM_Amacron);
      put("Iogonek", KEYSYM_Iogonek);
      put("Eabovedot", KEYSYM_Eabovedot);
      put("Imacron", KEYSYM_Imacron);
      put("Ncedilla", KEYSYM_Ncedilla);
      put("Omacron", KEYSYM_Omacron);
      put("Kcedilla", KEYSYM_Kcedilla);
      put("Uogonek", KEYSYM_Uogonek);
      put("Utilde", KEYSYM_Utilde);
      put("Umacron", KEYSYM_Umacron);
      put("amacron", KEYSYM_amacron);
      put("iogonek", KEYSYM_iogonek);
      put("eabovedot", KEYSYM_eabovedot);
      put("imacron", KEYSYM_imacron);
      put("ncedilla", KEYSYM_ncedilla);
      put("omacron", KEYSYM_omacron);
      put("kcedilla", KEYSYM_kcedilla);
      put("uogonek", KEYSYM_uogonek);
      put("utilde", KEYSYM_utilde);
      put("umacron", KEYSYM_umacron);
      put("overline", KEYSYM_overline);
      put("kana_fullstop", KEYSYM_kana_fullstop);
      put("kana_openingbracket", KEYSYM_kana_openingbracket);
      put("kana_closingbracket", KEYSYM_kana_closingbracket);
      put("kana_comma", KEYSYM_kana_comma);
      put("kana_conjunctive", KEYSYM_kana_conjunctive);
      put("kana_middledot", KEYSYM_kana_middledot);
      put("kana_WO", KEYSYM_kana_WO);
      put("kana_a", KEYSYM_kana_a);
      put("kana_i", KEYSYM_kana_i);
      put("kana_u", KEYSYM_kana_u);
      put("kana_e", KEYSYM_kana_e);
      put("kana_o", KEYSYM_kana_o);
      put("kana_ya", KEYSYM_kana_ya);
      put("kana_yu", KEYSYM_kana_yu);
      put("kana_yo", KEYSYM_kana_yo);
      put("kana_tsu", KEYSYM_kana_tsu);
      put("kana_tu", KEYSYM_kana_tu);
      put("prolongedsound", KEYSYM_prolongedsound);
      put("kana_A", KEYSYM_kana_A);
      put("kana_I", KEYSYM_kana_I);
      put("kana_U", KEYSYM_kana_U);
      put("kana_E", KEYSYM_kana_E);
      put("kana_O", KEYSYM_kana_O);
      put("kana_KA", KEYSYM_kana_KA);
      put("kana_KI", KEYSYM_kana_KI);
      put("kana_KU", KEYSYM_kana_KU);
      put("kana_KE", KEYSYM_kana_KE);
      put("kana_KO", KEYSYM_kana_KO);
      put("kana_SA", KEYSYM_kana_SA);
      put("kana_SHI", KEYSYM_kana_SHI);
      put("kana_SU", KEYSYM_kana_SU);
      put("kana_SE", KEYSYM_kana_SE);
      put("kana_SO", KEYSYM_kana_SO);
      put("kana_TA", KEYSYM_kana_TA);
      put("kana_CHI", KEYSYM_kana_CHI);
      put("kana_TI", KEYSYM_kana_TI);
      put("kana_TSU", KEYSYM_kana_TSU);
      put("kana_TU", KEYSYM_kana_TU);
      put("kana_TE", KEYSYM_kana_TE);
      put("kana_TO", KEYSYM_kana_TO);
      put("kana_NA", KEYSYM_kana_NA);
      put("kana_NI", KEYSYM_kana_NI);
      put("kana_NU", KEYSYM_kana_NU);
      put("kana_NE", KEYSYM_kana_NE);
      put("kana_NO", KEYSYM_kana_NO);
      put("kana_HA", KEYSYM_kana_HA);
      put("kana_HI", KEYSYM_kana_HI);
      put("kana_FU", KEYSYM_kana_FU);
      put("kana_HU", KEYSYM_kana_HU);
      put("kana_HE", KEYSYM_kana_HE);
      put("kana_HO", KEYSYM_kana_HO);
      put("kana_MA", KEYSYM_kana_MA);
      put("kana_MI", KEYSYM_kana_MI);
      put("kana_MU", KEYSYM_kana_MU);
      put("kana_ME", KEYSYM_kana_ME);
      put("kana_MO", KEYSYM_kana_MO);
      put("kana_YA", KEYSYM_kana_YA);
      put("kana_YU", KEYSYM_kana_YU);
      put("kana_YO", KEYSYM_kana_YO);
      put("kana_RA", KEYSYM_kana_RA);
      put("kana_RI", KEYSYM_kana_RI);
      put("kana_RU", KEYSYM_kana_RU);
      put("kana_RE", KEYSYM_kana_RE);
      put("kana_RO", KEYSYM_kana_RO);
      put("kana_WA", KEYSYM_kana_WA);
      put("kana_N", KEYSYM_kana_N);
      put("voicedsound", KEYSYM_voicedsound);
      put("semivoicedsound", KEYSYM_semivoicedsound);
      put("kana_switch", KEYSYM_kana_switch);
      put("Arabic_comma", KEYSYM_Arabic_comma);
      put("Arabic_semicolon", KEYSYM_Arabic_semicolon);
      put("Arabic_question_mark", KEYSYM_Arabic_question_mark);
      put("Arabic_hamza", KEYSYM_Arabic_hamza);
      put("Arabic_maddaonalef", KEYSYM_Arabic_maddaonalef);
      put("Arabic_hamzaonalef", KEYSYM_Arabic_hamzaonalef);
      put("Arabic_hamzaonwaw", KEYSYM_Arabic_hamzaonwaw);
      put("Arabic_hamzaunderalef", KEYSYM_Arabic_hamzaunderalef);
      put("Arabic_hamzaonyeh", KEYSYM_Arabic_hamzaonyeh);
      put("Arabic_alef", KEYSYM_Arabic_alef);
      put("Arabic_beh", KEYSYM_Arabic_beh);
      put("Arabic_tehmarbuta", KEYSYM_Arabic_tehmarbuta);
      put("Arabic_teh", KEYSYM_Arabic_teh);
      put("Arabic_theh", KEYSYM_Arabic_theh);
      put("Arabic_jeem", KEYSYM_Arabic_jeem);
      put("Arabic_hah", KEYSYM_Arabic_hah);
      put("Arabic_khah", KEYSYM_Arabic_khah);
      put("Arabic_dal", KEYSYM_Arabic_dal);
      put("Arabic_thal", KEYSYM_Arabic_thal);
      put("Arabic_ra", KEYSYM_Arabic_ra);
      put("Arabic_zain", KEYSYM_Arabic_zain);
      put("Arabic_seen", KEYSYM_Arabic_seen);
      put("Arabic_sheen", KEYSYM_Arabic_sheen);
      put("Arabic_sad", KEYSYM_Arabic_sad);
      put("Arabic_dad", KEYSYM_Arabic_dad);
      put("Arabic_tah", KEYSYM_Arabic_tah);
      put("Arabic_zah", KEYSYM_Arabic_zah);
      put("Arabic_ain", KEYSYM_Arabic_ain);
      put("Arabic_ghain", KEYSYM_Arabic_ghain);
      put("Arabic_tatweel", KEYSYM_Arabic_tatweel);
      put("Arabic_feh", KEYSYM_Arabic_feh);
      put("Arabic_qaf", KEYSYM_Arabic_qaf);
      put("Arabic_kaf", KEYSYM_Arabic_kaf);
      put("Arabic_lam", KEYSYM_Arabic_lam);
      put("Arabic_meem", KEYSYM_Arabic_meem);
      put("Arabic_noon", KEYSYM_Arabic_noon);
      put("Arabic_ha", KEYSYM_Arabic_ha);
      put("Arabic_heh", KEYSYM_Arabic_heh);
      put("Arabic_waw", KEYSYM_Arabic_waw);
      put("Arabic_alefmaksura", KEYSYM_Arabic_alefmaksura);
      put("Arabic_yeh", KEYSYM_Arabic_yeh);
      put("Arabic_fathatan", KEYSYM_Arabic_fathatan);
      put("Arabic_dammatan", KEYSYM_Arabic_dammatan);
      put("Arabic_kasratan", KEYSYM_Arabic_kasratan);
      put("Arabic_fatha", KEYSYM_Arabic_fatha);
      put("Arabic_damma", KEYSYM_Arabic_damma);
      put("Arabic_kasra", KEYSYM_Arabic_kasra);
      put("Arabic_shadda", KEYSYM_Arabic_shadda);
      put("Arabic_sukun", KEYSYM_Arabic_sukun);
      put("Arabic_switch", KEYSYM_Arabic_switch);
      put("Serbian_dje", KEYSYM_Serbian_dje);
      put("Macedonia_gje", KEYSYM_Macedonia_gje);
      put("Cyrillic_io", KEYSYM_Cyrillic_io);
      put("Ukrainian_ie", KEYSYM_Ukrainian_ie);
      put("Ukranian_je", KEYSYM_Ukranian_je);
      put("Macedonia_dse", KEYSYM_Macedonia_dse);
      put("Ukrainian_i", KEYSYM_Ukrainian_i);
      put("Ukranian_i", KEYSYM_Ukranian_i);
      put("Ukrainian_yi", KEYSYM_Ukrainian_yi);
      put("Ukranian_yi", KEYSYM_Ukranian_yi);
      put("Cyrillic_je", KEYSYM_Cyrillic_je);
      put("Serbian_je", KEYSYM_Serbian_je);
      put("Cyrillic_lje", KEYSYM_Cyrillic_lje);
      put("Serbian_lje", KEYSYM_Serbian_lje);
      put("Cyrillic_nje", KEYSYM_Cyrillic_nje);
      put("Serbian_nje", KEYSYM_Serbian_nje);
      put("Serbian_tshe", KEYSYM_Serbian_tshe);
      put("Macedonia_kje", KEYSYM_Macedonia_kje);
      put("Byelorussian_shortu", KEYSYM_Byelorussian_shortu);
      put("Cyrillic_dzhe", KEYSYM_Cyrillic_dzhe);
      put("Serbian_dze", KEYSYM_Serbian_dze);
      put("numerosign", KEYSYM_numerosign);
      put("Serbian_DJE", KEYSYM_Serbian_DJE);
      put("Macedonia_GJE", KEYSYM_Macedonia_GJE);
      put("Cyrillic_IO", KEYSYM_Cyrillic_IO);
      put("Ukrainian_IE", KEYSYM_Ukrainian_IE);
      put("Ukranian_JE", KEYSYM_Ukranian_JE);
      put("Macedonia_DSE", KEYSYM_Macedonia_DSE);
      put("Ukrainian_I", KEYSYM_Ukrainian_I);
      put("Ukranian_I", KEYSYM_Ukranian_I);
      put("Ukrainian_YI", KEYSYM_Ukrainian_YI);
      put("Ukranian_YI", KEYSYM_Ukranian_YI);
      put("Cyrillic_JE", KEYSYM_Cyrillic_JE);
      put("Serbian_JE", KEYSYM_Serbian_JE);
      put("Cyrillic_LJE", KEYSYM_Cyrillic_LJE);
      put("Serbian_LJE", KEYSYM_Serbian_LJE);
      put("Cyrillic_NJE", KEYSYM_Cyrillic_NJE);
      put("Serbian_NJE", KEYSYM_Serbian_NJE);
      put("Serbian_TSHE", KEYSYM_Serbian_TSHE);
      put("Macedonia_KJE", KEYSYM_Macedonia_KJE);
      put("Byelorussian_SHORTU", KEYSYM_Byelorussian_SHORTU);
      put("Cyrillic_DZHE", KEYSYM_Cyrillic_DZHE);
      put("Serbian_DZE", KEYSYM_Serbian_DZE);
      put("Cyrillic_yu", KEYSYM_Cyrillic_yu);
      put("Cyrillic_a", KEYSYM_Cyrillic_a);
      put("Cyrillic_be", KEYSYM_Cyrillic_be);
      put("Cyrillic_tse", KEYSYM_Cyrillic_tse);
      put("Cyrillic_de", KEYSYM_Cyrillic_de);
      put("Cyrillic_ie", KEYSYM_Cyrillic_ie);
      put("Cyrillic_ef", KEYSYM_Cyrillic_ef);
      put("Cyrillic_ghe", KEYSYM_Cyrillic_ghe);
      put("Cyrillic_ha", KEYSYM_Cyrillic_ha);
      put("Cyrillic_i", KEYSYM_Cyrillic_i);
      put("Cyrillic_shorti", KEYSYM_Cyrillic_shorti);
      put("Cyrillic_ka", KEYSYM_Cyrillic_ka);
      put("Cyrillic_el", KEYSYM_Cyrillic_el);
      put("Cyrillic_em", KEYSYM_Cyrillic_em);
      put("Cyrillic_en", KEYSYM_Cyrillic_en);
      put("Cyrillic_o", KEYSYM_Cyrillic_o);
      put("Cyrillic_pe", KEYSYM_Cyrillic_pe);
      put("Cyrillic_ya", KEYSYM_Cyrillic_ya);
      put("Cyrillic_er", KEYSYM_Cyrillic_er);
      put("Cyrillic_es", KEYSYM_Cyrillic_es);
      put("Cyrillic_te", KEYSYM_Cyrillic_te);
      put("Cyrillic_u", KEYSYM_Cyrillic_u);
      put("Cyrillic_zhe", KEYSYM_Cyrillic_zhe);
      put("Cyrillic_ve", KEYSYM_Cyrillic_ve);
      put("Cyrillic_softsign", KEYSYM_Cyrillic_softsign);
      put("Cyrillic_yeru", KEYSYM_Cyrillic_yeru);
      put("Cyrillic_ze", KEYSYM_Cyrillic_ze);
      put("Cyrillic_sha", KEYSYM_Cyrillic_sha);
      put("Cyrillic_e", KEYSYM_Cyrillic_e);
      put("Cyrillic_shcha", KEYSYM_Cyrillic_shcha);
      put("Cyrillic_che", KEYSYM_Cyrillic_che);
      put("Cyrillic_hardsign", KEYSYM_Cyrillic_hardsign);
      put("Cyrillic_YU", KEYSYM_Cyrillic_YU);
      put("Cyrillic_A", KEYSYM_Cyrillic_A);
      put("Cyrillic_BE", KEYSYM_Cyrillic_BE);
      put("Cyrillic_TSE", KEYSYM_Cyrillic_TSE);
      put("Cyrillic_DE", KEYSYM_Cyrillic_DE);
      put("Cyrillic_IE", KEYSYM_Cyrillic_IE);
      put("Cyrillic_EF", KEYSYM_Cyrillic_EF);
      put("Cyrillic_GHE", KEYSYM_Cyrillic_GHE);
      put("Cyrillic_HA", KEYSYM_Cyrillic_HA);
      put("Cyrillic_I", KEYSYM_Cyrillic_I);
      put("Cyrillic_SHORTI", KEYSYM_Cyrillic_SHORTI);
      put("Cyrillic_KA", KEYSYM_Cyrillic_KA);
      put("Cyrillic_EL", KEYSYM_Cyrillic_EL);
      put("Cyrillic_EM", KEYSYM_Cyrillic_EM);
      put("Cyrillic_EN", KEYSYM_Cyrillic_EN);
      put("Cyrillic_O", KEYSYM_Cyrillic_O);
      put("Cyrillic_PE", KEYSYM_Cyrillic_PE);
      put("Cyrillic_YA", KEYSYM_Cyrillic_YA);
      put("Cyrillic_ER", KEYSYM_Cyrillic_ER);
      put("Cyrillic_ES", KEYSYM_Cyrillic_ES);
      put("Cyrillic_TE", KEYSYM_Cyrillic_TE);
      put("Cyrillic_U", KEYSYM_Cyrillic_U);
      put("Cyrillic_ZHE", KEYSYM_Cyrillic_ZHE);
      put("Cyrillic_VE", KEYSYM_Cyrillic_VE);
      put("Cyrillic_SOFTSIGN", KEYSYM_Cyrillic_SOFTSIGN);
      put("Cyrillic_YERU", KEYSYM_Cyrillic_YERU);
      put("Cyrillic_ZE", KEYSYM_Cyrillic_ZE);
      put("Cyrillic_SHA", KEYSYM_Cyrillic_SHA);
      put("Cyrillic_E", KEYSYM_Cyrillic_E);
      put("Cyrillic_SHCHA", KEYSYM_Cyrillic_SHCHA);
      put("Cyrillic_CHE", KEYSYM_Cyrillic_CHE);
      put("Cyrillic_HARDSIGN", KEYSYM_Cyrillic_HARDSIGN);
      put("Greek_ALPHAaccent", KEYSYM_Greek_ALPHAaccent);
      put("Greek_EPSILONaccent", KEYSYM_Greek_EPSILONaccent);
      put("Greek_ETAaccent", KEYSYM_Greek_ETAaccent);
      put("Greek_IOTAaccent", KEYSYM_Greek_IOTAaccent);
      put("Greek_IOTAdiaeresis", KEYSYM_Greek_IOTAdiaeresis);
      put("Greek_OMICRONaccent", KEYSYM_Greek_OMICRONaccent);
      put("Greek_UPSILONaccent", KEYSYM_Greek_UPSILONaccent);
      put("Greek_UPSILONdieresis", KEYSYM_Greek_UPSILONdieresis);
      put("Greek_OMEGAaccent", KEYSYM_Greek_OMEGAaccent);
      put("Greek_accentdieresis", KEYSYM_Greek_accentdieresis);
      put("Greek_horizbar", KEYSYM_Greek_horizbar);
      put("Greek_alphaaccent", KEYSYM_Greek_alphaaccent);
      put("Greek_epsilonaccent", KEYSYM_Greek_epsilonaccent);
      put("Greek_etaaccent", KEYSYM_Greek_etaaccent);
      put("Greek_iotaaccent", KEYSYM_Greek_iotaaccent);
      put("Greek_iotadieresis", KEYSYM_Greek_iotadieresis);
      put("Greek_iotaaccentdieresis", KEYSYM_Greek_iotaaccentdieresis);
      put("Greek_omicronaccent", KEYSYM_Greek_omicronaccent);
      put("Greek_upsilonaccent", KEYSYM_Greek_upsilonaccent);
      put("Greek_upsilondieresis", KEYSYM_Greek_upsilondieresis);
      put("Greek_upsilonaccentdieresis", KEYSYM_Greek_upsilonaccentdieresis);
      put("Greek_omegaaccent", KEYSYM_Greek_omegaaccent);
      put("Greek_ALPHA", KEYSYM_Greek_ALPHA);
      put("Greek_BETA", KEYSYM_Greek_BETA);
      put("Greek_GAMMA", KEYSYM_Greek_GAMMA);
      put("Greek_DELTA", KEYSYM_Greek_DELTA);
      put("Greek_EPSILON", KEYSYM_Greek_EPSILON);
      put("Greek_ZETA", KEYSYM_Greek_ZETA);
      put("Greek_ETA", KEYSYM_Greek_ETA);
      put("Greek_THETA", KEYSYM_Greek_THETA);
      put("Greek_IOTA", KEYSYM_Greek_IOTA);
      put("Greek_KAPPA", KEYSYM_Greek_KAPPA);
      put("Greek_LAMDA", KEYSYM_Greek_LAMDA);
      put("Greek_LAMBDA", KEYSYM_Greek_LAMBDA);
      put("Greek_MU", KEYSYM_Greek_MU);
      put("Greek_NU", KEYSYM_Greek_NU);
      put("Greek_XI", KEYSYM_Greek_XI);
      put("Greek_OMICRON", KEYSYM_Greek_OMICRON);
      put("Greek_PI", KEYSYM_Greek_PI);
      put("Greek_RHO", KEYSYM_Greek_RHO);
      put("Greek_SIGMA", KEYSYM_Greek_SIGMA);
      put("Greek_TAU", KEYSYM_Greek_TAU);
      put("Greek_UPSILON", KEYSYM_Greek_UPSILON);
      put("Greek_PHI", KEYSYM_Greek_PHI);
      put("Greek_CHI", KEYSYM_Greek_CHI);
      put("Greek_PSI", KEYSYM_Greek_PSI);
      put("Greek_OMEGA", KEYSYM_Greek_OMEGA);
      put("Greek_alpha", KEYSYM_Greek_alpha);
      put("Greek_beta", KEYSYM_Greek_beta);
      put("Greek_gamma", KEYSYM_Greek_gamma);
      put("Greek_delta", KEYSYM_Greek_delta);
      put("Greek_epsilon", KEYSYM_Greek_epsilon);
      put("Greek_zeta", KEYSYM_Greek_zeta);
      put("Greek_eta", KEYSYM_Greek_eta);
      put("Greek_theta", KEYSYM_Greek_theta);
      put("Greek_iota", KEYSYM_Greek_iota);
      put("Greek_kappa", KEYSYM_Greek_kappa);
      put("Greek_lamda", KEYSYM_Greek_lamda);
      put("Greek_lambda", KEYSYM_Greek_lambda);
      put("Greek_mu", KEYSYM_Greek_mu);
      put("Greek_nu", KEYSYM_Greek_nu);
      put("Greek_xi", KEYSYM_Greek_xi);
      put("Greek_omicron", KEYSYM_Greek_omicron);
      put("Greek_pi", KEYSYM_Greek_pi);
      put("Greek_rho", KEYSYM_Greek_rho);
      put("Greek_sigma", KEYSYM_Greek_sigma);
      put("Greek_finalsmallsigma", KEYSYM_Greek_finalsmallsigma);
      put("Greek_tau", KEYSYM_Greek_tau);
      put("Greek_upsilon", KEYSYM_Greek_upsilon);
      put("Greek_phi", KEYSYM_Greek_phi);
      put("Greek_chi", KEYSYM_Greek_chi);
      put("Greek_psi", KEYSYM_Greek_psi);
      put("Greek_omega", KEYSYM_Greek_omega);
      put("Greek_switch", KEYSYM_Greek_switch);
      put("leftradical", KEYSYM_leftradical);
      put("topleftradical", KEYSYM_topleftradical);
      put("horizconnector", KEYSYM_horizconnector);
      put("topintegral", KEYSYM_topintegral);
      put("botintegral", KEYSYM_botintegral);
      put("vertconnector", KEYSYM_vertconnector);
      put("topleftsqbracket", KEYSYM_topleftsqbracket);
      put("botleftsqbracket", KEYSYM_botleftsqbracket);
      put("toprightsqbracket", KEYSYM_toprightsqbracket);
      put("botrightsqbracket", KEYSYM_botrightsqbracket);
      put("topleftparens", KEYSYM_topleftparens);
      put("botleftparens", KEYSYM_botleftparens);
      put("toprightparens", KEYSYM_toprightparens);
      put("botrightparens", KEYSYM_botrightparens);
      put("leftmiddlecurlybrace", KEYSYM_leftmiddlecurlybrace);
      put("rightmiddlecurlybrace", KEYSYM_rightmiddlecurlybrace);
      put("topleftsummation", KEYSYM_topleftsummation);
      put("botleftsummation", KEYSYM_botleftsummation);
      put("topvertsummationconnector", KEYSYM_topvertsummationconnector);
      put("botvertsummationconnector", KEYSYM_botvertsummationconnector);
      put("toprightsummation", KEYSYM_toprightsummation);
      put("botrightsummation", KEYSYM_botrightsummation);
      put("rightmiddlesummation", KEYSYM_rightmiddlesummation);
      put("lessthanequal", KEYSYM_lessthanequal);
      put("notequal", KEYSYM_notequal);
      put("greaterthanequal", KEYSYM_greaterthanequal);
      put("integral", KEYSYM_integral);
      put("therefore", KEYSYM_therefore);
      put("variation", KEYSYM_variation);
      put("infinity", KEYSYM_infinity);
      put("nabla", KEYSYM_nabla);
      put("approximate", KEYSYM_approximate);
      put("similarequal", KEYSYM_similarequal);
      put("ifonlyif", KEYSYM_ifonlyif);
      put("implies", KEYSYM_implies);
      put("identical", KEYSYM_identical);
      put("radical", KEYSYM_radical);
      put("includedin", KEYSYM_includedin);
      put("includes", KEYSYM_includes);
      put("intersection", KEYSYM_intersection);
      put("union", KEYSYM_union);
      put("logicaland", KEYSYM_logicaland);
      put("logicalor", KEYSYM_logicalor);
      put("partialderivative", KEYSYM_partialderivative);
      put("function", KEYSYM_function);
      put("leftarrow", KEYSYM_leftarrow);
      put("uparrow", KEYSYM_uparrow);
      put("rightarrow", KEYSYM_rightarrow);
      put("downarrow", KEYSYM_downarrow);
      put("blank", KEYSYM_blank);
      put("soliddiamond", KEYSYM_soliddiamond);
      put("checkerboard", KEYSYM_checkerboard);
      put("ht", KEYSYM_ht);
      put("ff", KEYSYM_ff);
      put("cr", KEYSYM_cr);
      put("lf", KEYSYM_lf);
      put("nl", KEYSYM_nl);
      put("vt", KEYSYM_vt);
      put("lowrightcorner", KEYSYM_lowrightcorner);
      put("uprightcorner", KEYSYM_uprightcorner);
      put("upleftcorner", KEYSYM_upleftcorner);
      put("lowleftcorner", KEYSYM_lowleftcorner);
      put("crossinglines", KEYSYM_crossinglines);
      put("horizlinescan1", KEYSYM_horizlinescan1);
      put("horizlinescan3", KEYSYM_horizlinescan3);
      put("horizlinescan5", KEYSYM_horizlinescan5);
      put("horizlinescan7", KEYSYM_horizlinescan7);
      put("horizlinescan9", KEYSYM_horizlinescan9);
      put("leftt", KEYSYM_leftt);
      put("rightt", KEYSYM_rightt);
      put("bott", KEYSYM_bott);
      put("topt", KEYSYM_topt);
      put("vertbar", KEYSYM_vertbar);
      put("emspace", KEYSYM_emspace);
      put("enspace", KEYSYM_enspace);
      put("em3space", KEYSYM_em3space);
      put("em4space", KEYSYM_em4space);
      put("digitspace", KEYSYM_digitspace);
      put("punctspace", KEYSYM_punctspace);
      put("thinspace", KEYSYM_thinspace);
      put("hairspace", KEYSYM_hairspace);
      put("emdash", KEYSYM_emdash);
      put("endash", KEYSYM_endash);
      put("signifblank", KEYSYM_signifblank);
      put("ellipsis", KEYSYM_ellipsis);
      put("doubbaselinedot", KEYSYM_doubbaselinedot);
      put("onethird", KEYSYM_onethird);
      put("twothirds", KEYSYM_twothirds);
      put("onefifth", KEYSYM_onefifth);
      put("twofifths", KEYSYM_twofifths);
      put("threefifths", KEYSYM_threefifths);
      put("fourfifths", KEYSYM_fourfifths);
      put("onesixth", KEYSYM_onesixth);
      put("fivesixths", KEYSYM_fivesixths);
      put("careof", KEYSYM_careof);
      put("figdash", KEYSYM_figdash);
      put("leftanglebracket", KEYSYM_leftanglebracket);
      put("decimalpoint", KEYSYM_decimalpoint);
      put("rightanglebracket", KEYSYM_rightanglebracket);
      put("marker", KEYSYM_marker);
      put("oneeighth", KEYSYM_oneeighth);
      put("threeeighths", KEYSYM_threeeighths);
      put("fiveeighths", KEYSYM_fiveeighths);
      put("seveneighths", KEYSYM_seveneighths);
      put("trademark", KEYSYM_trademark);
      put("signaturemark", KEYSYM_signaturemark);
      put("trademarkincircle", KEYSYM_trademarkincircle);
      put("leftopentriangle", KEYSYM_leftopentriangle);
      put("rightopentriangle", KEYSYM_rightopentriangle);
      put("emopencircle", KEYSYM_emopencircle);
      put("emopenrectangle", KEYSYM_emopenrectangle);
      put("leftsinglequotemark", KEYSYM_leftsinglequotemark);
      put("rightsinglequotemark", KEYSYM_rightsinglequotemark);
      put("leftdoublequotemark", KEYSYM_leftdoublequotemark);
      put("rightdoublequotemark", KEYSYM_rightdoublequotemark);
      put("prescription", KEYSYM_prescription);
      put("minutes", KEYSYM_minutes);
      put("seconds", KEYSYM_seconds);
      put("latincross", KEYSYM_latincross);
      put("hexagram", KEYSYM_hexagram);
      put("filledrectbullet", KEYSYM_filledrectbullet);
      put("filledlefttribullet", KEYSYM_filledlefttribullet);
      put("filledrighttribullet", KEYSYM_filledrighttribullet);
      put("emfilledcircle", KEYSYM_emfilledcircle);
      put("emfilledrect", KEYSYM_emfilledrect);
      put("enopencircbullet", KEYSYM_enopencircbullet);
      put("enopensquarebullet", KEYSYM_enopensquarebullet);
      put("openrectbullet", KEYSYM_openrectbullet);
      put("opentribulletup", KEYSYM_opentribulletup);
      put("opentribulletdown", KEYSYM_opentribulletdown);
      put("openstar", KEYSYM_openstar);
      put("enfilledcircbullet", KEYSYM_enfilledcircbullet);
      put("enfilledsqbullet", KEYSYM_enfilledsqbullet);
      put("filledtribulletup", KEYSYM_filledtribulletup);
      put("filledtribulletdown", KEYSYM_filledtribulletdown);
      put("leftpointer", KEYSYM_leftpointer);
      put("rightpointer", KEYSYM_rightpointer);
      put("club", KEYSYM_club);
      put("diamond", KEYSYM_diamond);
      put("heart", KEYSYM_heart);
      put("maltesecross", KEYSYM_maltesecross);
      put("dagger", KEYSYM_dagger);
      put("doubledagger", KEYSYM_doubledagger);
      put("checkmark", KEYSYM_checkmark);
      put("ballotcross", KEYSYM_ballotcross);
      put("musicalsharp", KEYSYM_musicalsharp);
      put("musicalflat", KEYSYM_musicalflat);
      put("malesymbol", KEYSYM_malesymbol);
      put("femalesymbol", KEYSYM_femalesymbol);
      put("telephone", KEYSYM_telephone);
      put("telephonerecorder", KEYSYM_telephonerecorder);
      put("phonographcopyright", KEYSYM_phonographcopyright);
      put("caret", KEYSYM_caret);
      put("singlelowquotemark", KEYSYM_singlelowquotemark);
      put("doublelowquotemark", KEYSYM_doublelowquotemark);
      put("cursor", KEYSYM_cursor);
      put("leftcaret", KEYSYM_leftcaret);
      put("rightcaret", KEYSYM_rightcaret);
      put("downcaret", KEYSYM_downcaret);
      put("upcaret", KEYSYM_upcaret);
      put("overbar", KEYSYM_overbar);
      put("downtack", KEYSYM_downtack);
      put("upshoe", KEYSYM_upshoe);
      put("downstile", KEYSYM_downstile);
      put("underbar", KEYSYM_underbar);
      put("jot", KEYSYM_jot);
      put("quad", KEYSYM_quad);
      put("uptack", KEYSYM_uptack);
      put("circle", KEYSYM_circle);
      put("upstile", KEYSYM_upstile);
      put("downshoe", KEYSYM_downshoe);
      put("rightshoe", KEYSYM_rightshoe);
      put("leftshoe", KEYSYM_leftshoe);
      put("lefttack", KEYSYM_lefttack);
      put("righttack", KEYSYM_righttack);
      put("hebrew_doublelowline", KEYSYM_hebrew_doublelowline);
      put("hebrew_aleph", KEYSYM_hebrew_aleph);
      put("hebrew_bet", KEYSYM_hebrew_bet);
      put("hebrew_beth", KEYSYM_hebrew_beth);
      put("hebrew_gimel", KEYSYM_hebrew_gimel);
      put("hebrew_gimmel", KEYSYM_hebrew_gimmel);
      put("hebrew_dalet", KEYSYM_hebrew_dalet);
      put("hebrew_daleth", KEYSYM_hebrew_daleth);
      put("hebrew_he", KEYSYM_hebrew_he);
      put("hebrew_waw", KEYSYM_hebrew_waw);
      put("hebrew_zain", KEYSYM_hebrew_zain);
      put("hebrew_zayin", KEYSYM_hebrew_zayin);
      put("hebrew_chet", KEYSYM_hebrew_chet);
      put("hebrew_het", KEYSYM_hebrew_het);
      put("hebrew_tet", KEYSYM_hebrew_tet);
      put("hebrew_teth", KEYSYM_hebrew_teth);
      put("hebrew_yod", KEYSYM_hebrew_yod);
      put("hebrew_finalkaph", KEYSYM_hebrew_finalkaph);
      put("hebrew_kaph", KEYSYM_hebrew_kaph);
      put("hebrew_lamed", KEYSYM_hebrew_lamed);
      put("hebrew_finalmem", KEYSYM_hebrew_finalmem);
      put("hebrew_mem", KEYSYM_hebrew_mem);
      put("hebrew_finalnun", KEYSYM_hebrew_finalnun);
      put("hebrew_nun", KEYSYM_hebrew_nun);
      put("hebrew_samech", KEYSYM_hebrew_samech);
      put("hebrew_samekh", KEYSYM_hebrew_samekh);
      put("hebrew_ayin", KEYSYM_hebrew_ayin);
      put("hebrew_finalpe", KEYSYM_hebrew_finalpe);
      put("hebrew_pe", KEYSYM_hebrew_pe);
      put("hebrew_finalzade", KEYSYM_hebrew_finalzade);
      put("hebrew_finalzadi", KEYSYM_hebrew_finalzadi);
      put("hebrew_zade", KEYSYM_hebrew_zade);
      put("hebrew_zadi", KEYSYM_hebrew_zadi);
      put("hebrew_qoph", KEYSYM_hebrew_qoph);
      put("hebrew_kuf", KEYSYM_hebrew_kuf);
      put("hebrew_resh", KEYSYM_hebrew_resh);
      put("hebrew_shin", KEYSYM_hebrew_shin);
      put("hebrew_taw", KEYSYM_hebrew_taw);
      put("hebrew_taf", KEYSYM_hebrew_taf);
      put("Hebrew_switch", KEYSYM_Hebrew_switch);
      put("Thai_kokai", KEYSYM_Thai_kokai);
      put("Thai_khokhai", KEYSYM_Thai_khokhai);
      put("Thai_khokhuat", KEYSYM_Thai_khokhuat);
      put("Thai_khokhwai", KEYSYM_Thai_khokhwai);
      put("Thai_khokhon", KEYSYM_Thai_khokhon);
      put("Thai_khorakhang", KEYSYM_Thai_khorakhang);
      put("Thai_ngongu", KEYSYM_Thai_ngongu);
      put("Thai_chochan", KEYSYM_Thai_chochan);
      put("Thai_choching", KEYSYM_Thai_choching);
      put("Thai_chochang", KEYSYM_Thai_chochang);
      put("Thai_soso", KEYSYM_Thai_soso);
      put("Thai_chochoe", KEYSYM_Thai_chochoe);
      put("Thai_yoying", KEYSYM_Thai_yoying);
      put("Thai_dochada", KEYSYM_Thai_dochada);
      put("Thai_topatak", KEYSYM_Thai_topatak);
      put("Thai_thothan", KEYSYM_Thai_thothan);
      put("Thai_thonangmontho", KEYSYM_Thai_thonangmontho);
      put("Thai_thophuthao", KEYSYM_Thai_thophuthao);
      put("Thai_nonen", KEYSYM_Thai_nonen);
      put("Thai_dodek", KEYSYM_Thai_dodek);
      put("Thai_totao", KEYSYM_Thai_totao);
      put("Thai_thothung", KEYSYM_Thai_thothung);
      put("Thai_thothahan", KEYSYM_Thai_thothahan);
      put("Thai_thothong", KEYSYM_Thai_thothong);
      put("Thai_nonu", KEYSYM_Thai_nonu);
      put("Thai_bobaimai", KEYSYM_Thai_bobaimai);
      put("Thai_popla", KEYSYM_Thai_popla);
      put("Thai_phophung", KEYSYM_Thai_phophung);
      put("Thai_fofa", KEYSYM_Thai_fofa);
      put("Thai_phophan", KEYSYM_Thai_phophan);
      put("Thai_fofan", KEYSYM_Thai_fofan);
      put("Thai_phosamphao", KEYSYM_Thai_phosamphao);
      put("Thai_moma", KEYSYM_Thai_moma);
      put("Thai_yoyak", KEYSYM_Thai_yoyak);
      put("Thai_rorua", KEYSYM_Thai_rorua);
      put("Thai_ru", KEYSYM_Thai_ru);
      put("Thai_loling", KEYSYM_Thai_loling);
      put("Thai_lu", KEYSYM_Thai_lu);
      put("Thai_wowaen", KEYSYM_Thai_wowaen);
      put("Thai_sosala", KEYSYM_Thai_sosala);
      put("Thai_sorusi", KEYSYM_Thai_sorusi);
      put("Thai_sosua", KEYSYM_Thai_sosua);
      put("Thai_hohip", KEYSYM_Thai_hohip);
      put("Thai_lochula", KEYSYM_Thai_lochula);
      put("Thai_oang", KEYSYM_Thai_oang);
      put("Thai_honokhuk", KEYSYM_Thai_honokhuk);
      put("Thai_paiyannoi", KEYSYM_Thai_paiyannoi);
      put("Thai_saraa", KEYSYM_Thai_saraa);
      put("Thai_maihanakat", KEYSYM_Thai_maihanakat);
      put("Thai_saraaa", KEYSYM_Thai_saraaa);
      put("Thai_saraam", KEYSYM_Thai_saraam);
      put("Thai_sarai", KEYSYM_Thai_sarai);
      put("Thai_saraii", KEYSYM_Thai_saraii);
      put("Thai_saraue", KEYSYM_Thai_saraue);
      put("Thai_sarauee", KEYSYM_Thai_sarauee);
      put("Thai_sarau", KEYSYM_Thai_sarau);
      put("Thai_sarauu", KEYSYM_Thai_sarauu);
      put("Thai_phinthu", KEYSYM_Thai_phinthu);
      put("Thai_maihanakat_maitho", KEYSYM_Thai_maihanakat_maitho);
      put("Thai_baht", KEYSYM_Thai_baht);
      put("Thai_sarae", KEYSYM_Thai_sarae);
      put("Thai_saraae", KEYSYM_Thai_saraae);
      put("Thai_sarao", KEYSYM_Thai_sarao);
      put("Thai_saraaimaimuan", KEYSYM_Thai_saraaimaimuan);
      put("Thai_saraaimaimalai", KEYSYM_Thai_saraaimaimalai);
      put("Thai_lakkhangyao", KEYSYM_Thai_lakkhangyao);
      put("Thai_maiyamok", KEYSYM_Thai_maiyamok);
      put("Thai_maitaikhu", KEYSYM_Thai_maitaikhu);
      put("Thai_maiek", KEYSYM_Thai_maiek);
      put("Thai_maitho", KEYSYM_Thai_maitho);
      put("Thai_maitri", KEYSYM_Thai_maitri);
      put("Thai_maichattawa", KEYSYM_Thai_maichattawa);
      put("Thai_thanthakhat", KEYSYM_Thai_thanthakhat);
      put("Thai_nikhahit", KEYSYM_Thai_nikhahit);
      put("Thai_leksun", KEYSYM_Thai_leksun);
      put("Thai_leknung", KEYSYM_Thai_leknung);
      put("Thai_leksong", KEYSYM_Thai_leksong);
      put("Thai_leksam", KEYSYM_Thai_leksam);
      put("Thai_leksi", KEYSYM_Thai_leksi);
      put("Thai_lekha", KEYSYM_Thai_lekha);
      put("Thai_lekhok", KEYSYM_Thai_lekhok);
      put("Thai_lekchet", KEYSYM_Thai_lekchet);
      put("Thai_lekpaet", KEYSYM_Thai_lekpaet);
      put("Thai_lekkao", KEYSYM_Thai_lekkao);
      put("Hangul", KEYSYM_Hangul);
      put("Hangul_Start", KEYSYM_Hangul_Start);
      put("Hangul_End", KEYSYM_Hangul_End);
      put("Hangul_Hanja", KEYSYM_Hangul_Hanja);
      put("Hangul_Jamo", KEYSYM_Hangul_Jamo);
      put("Hangul_Romaja", KEYSYM_Hangul_Romaja);
      put("Hangul_Codeinput", KEYSYM_Hangul_Codeinput);
      put("Hangul_Jeonja", KEYSYM_Hangul_Jeonja);
      put("Hangul_Banja", KEYSYM_Hangul_Banja);
      put("Hangul_PreHanja", KEYSYM_Hangul_PreHanja);
      put("Hangul_PostHanja", KEYSYM_Hangul_PostHanja);
      put("Hangul_SingleCandidate", KEYSYM_Hangul_SingleCandidate);
      put("Hangul_MultipleCandidate", KEYSYM_Hangul_MultipleCandidate);
      put("Hangul_PreviousCandidate", KEYSYM_Hangul_PreviousCandidate);
      put("Hangul_Special", KEYSYM_Hangul_Special);
      put("Hangul_switch", KEYSYM_Hangul_switch);
      put("Hangul_Kiyeog", KEYSYM_Hangul_Kiyeog);
      put("Hangul_SsangKiyeog", KEYSYM_Hangul_SsangKiyeog);
      put("Hangul_KiyeogSios", KEYSYM_Hangul_KiyeogSios);
      put("Hangul_Nieun", KEYSYM_Hangul_Nieun);
      put("Hangul_NieunJieuj", KEYSYM_Hangul_NieunJieuj);
      put("Hangul_NieunHieuh", KEYSYM_Hangul_NieunHieuh);
      put("Hangul_Dikeud", KEYSYM_Hangul_Dikeud);
      put("Hangul_SsangDikeud", KEYSYM_Hangul_SsangDikeud);
      put("Hangul_Rieul", KEYSYM_Hangul_Rieul);
      put("Hangul_RieulKiyeog", KEYSYM_Hangul_RieulKiyeog);
      put("Hangul_RieulMieum", KEYSYM_Hangul_RieulMieum);
      put("Hangul_RieulPieub", KEYSYM_Hangul_RieulPieub);
      put("Hangul_RieulSios", KEYSYM_Hangul_RieulSios);
      put("Hangul_RieulTieut", KEYSYM_Hangul_RieulTieut);
      put("Hangul_RieulPhieuf", KEYSYM_Hangul_RieulPhieuf);
      put("Hangul_RieulHieuh", KEYSYM_Hangul_RieulHieuh);
      put("Hangul_Mieum", KEYSYM_Hangul_Mieum);
      put("Hangul_Pieub", KEYSYM_Hangul_Pieub);
      put("Hangul_SsangPieub", KEYSYM_Hangul_SsangPieub);
      put("Hangul_PieubSios", KEYSYM_Hangul_PieubSios);
      put("Hangul_Sios", KEYSYM_Hangul_Sios);
      put("Hangul_SsangSios", KEYSYM_Hangul_SsangSios);
      put("Hangul_Ieung", KEYSYM_Hangul_Ieung);
      put("Hangul_Jieuj", KEYSYM_Hangul_Jieuj);
      put("Hangul_SsangJieuj", KEYSYM_Hangul_SsangJieuj);
      put("Hangul_Cieuc", KEYSYM_Hangul_Cieuc);
      put("Hangul_Khieuq", KEYSYM_Hangul_Khieuq);
      put("Hangul_Tieut", KEYSYM_Hangul_Tieut);
      put("Hangul_Phieuf", KEYSYM_Hangul_Phieuf);
      put("Hangul_Hieuh", KEYSYM_Hangul_Hieuh);
      put("Hangul_A", KEYSYM_Hangul_A);
      put("Hangul_AE", KEYSYM_Hangul_AE);
      put("Hangul_YA", KEYSYM_Hangul_YA);
      put("Hangul_YAE", KEYSYM_Hangul_YAE);
      put("Hangul_EO", KEYSYM_Hangul_EO);
      put("Hangul_E", KEYSYM_Hangul_E);
      put("Hangul_YEO", KEYSYM_Hangul_YEO);
      put("Hangul_YE", KEYSYM_Hangul_YE);
      put("Hangul_O", KEYSYM_Hangul_O);
      put("Hangul_WA", KEYSYM_Hangul_WA);
      put("Hangul_WAE", KEYSYM_Hangul_WAE);
      put("Hangul_OE", KEYSYM_Hangul_OE);
      put("Hangul_YO", KEYSYM_Hangul_YO);
      put("Hangul_U", KEYSYM_Hangul_U);
      put("Hangul_WEO", KEYSYM_Hangul_WEO);
      put("Hangul_WE", KEYSYM_Hangul_WE);
      put("Hangul_WI", KEYSYM_Hangul_WI);
      put("Hangul_YU", KEYSYM_Hangul_YU);
      put("Hangul_EU", KEYSYM_Hangul_EU);
      put("Hangul_YI", KEYSYM_Hangul_YI);
      put("Hangul_I", KEYSYM_Hangul_I);
      put("Hangul_J_Kiyeog", KEYSYM_Hangul_J_Kiyeog);
      put("Hangul_J_SsangKiyeog", KEYSYM_Hangul_J_SsangKiyeog);
      put("Hangul_J_KiyeogSios", KEYSYM_Hangul_J_KiyeogSios);
      put("Hangul_J_Nieun", KEYSYM_Hangul_J_Nieun);
      put("Hangul_J_NieunJieuj", KEYSYM_Hangul_J_NieunJieuj);
      put("Hangul_J_NieunHieuh", KEYSYM_Hangul_J_NieunHieuh);
      put("Hangul_J_Dikeud", KEYSYM_Hangul_J_Dikeud);
      put("Hangul_J_Rieul", KEYSYM_Hangul_J_Rieul);
      put("Hangul_J_RieulKiyeog", KEYSYM_Hangul_J_RieulKiyeog);
      put("Hangul_J_RieulMieum", KEYSYM_Hangul_J_RieulMieum);
      put("Hangul_J_RieulPieub", KEYSYM_Hangul_J_RieulPieub);
      put("Hangul_J_RieulSios", KEYSYM_Hangul_J_RieulSios);
      put("Hangul_J_RieulTieut", KEYSYM_Hangul_J_RieulTieut);
      put("Hangul_J_RieulPhieuf", KEYSYM_Hangul_J_RieulPhieuf);
      put("Hangul_J_RieulHieuh", KEYSYM_Hangul_J_RieulHieuh);
      put("Hangul_J_Mieum", KEYSYM_Hangul_J_Mieum);
      put("Hangul_J_Pieub", KEYSYM_Hangul_J_Pieub);
      put("Hangul_J_PieubSios", KEYSYM_Hangul_J_PieubSios);
      put("Hangul_J_Sios", KEYSYM_Hangul_J_Sios);
      put("Hangul_J_SsangSios", KEYSYM_Hangul_J_SsangSios);
      put("Hangul_J_Ieung", KEYSYM_Hangul_J_Ieung);
      put("Hangul_J_Jieuj", KEYSYM_Hangul_J_Jieuj);
      put("Hangul_J_Cieuc", KEYSYM_Hangul_J_Cieuc);
      put("Hangul_J_Khieuq", KEYSYM_Hangul_J_Khieuq);
      put("Hangul_J_Tieut", KEYSYM_Hangul_J_Tieut);
      put("Hangul_J_Phieuf", KEYSYM_Hangul_J_Phieuf);
      put("Hangul_J_Hieuh", KEYSYM_Hangul_J_Hieuh);
      put("Hangul_RieulYeorinHieuh", KEYSYM_Hangul_RieulYeorinHieuh);
      put("Hangul_SunkyeongeumMieum", KEYSYM_Hangul_SunkyeongeumMieum);
      put("Hangul_SunkyeongeumPieub", KEYSYM_Hangul_SunkyeongeumPieub);
      put("Hangul_PanSios", KEYSYM_Hangul_PanSios);
      put("Hangul_KkogjiDalrinIeung", KEYSYM_Hangul_KkogjiDalrinIeung);
      put("Hangul_SunkyeongeumPhieuf", KEYSYM_Hangul_SunkyeongeumPhieuf);
      put("Hangul_YeorinHieuh", KEYSYM_Hangul_YeorinHieuh);
      put("Hangul_AraeA", KEYSYM_Hangul_AraeA);
      put("Hangul_AraeAE", KEYSYM_Hangul_AraeAE);
      put("Hangul_J_PanSios", KEYSYM_Hangul_J_PanSios);
      put("Hangul_J_KkogjiDalrinIeung", KEYSYM_Hangul_J_KkogjiDalrinIeung);
      put("Hangul_J_YeorinHieuh", KEYSYM_Hangul_J_YeorinHieuh);
      put("Korean_Won", KEYSYM_Korean_Won);
    }};
   static final int KEYSYM_VoidSymbol = 0xFFFFFF;
   static final int KEYSYM_BackSpace = 0xFF08;
   static final int KEYSYM_Tab = 0xFF09;
   static final int KEYSYM_Linefeed = 0xFF0A;
   static final int KEYSYM_Clear = 0xFF0B;
   static final int KEYSYM_Return = 0xFF0D;
   static final int KEYSYM_Pause = 0xFF13;
   static final int KEYSYM_Scroll_Lock = 0xFF14;
   static final int KEYSYM_Sys_Req = 0xFF15;
   static final int KEYSYM_Escape = 0xFF1B;
   static final int KEYSYM_Delete = 0xFFFF;
   static final int KEYSYM_Multi_key = 0xFF20;
   static final int KEYSYM_SingleCandidate = 0xFF3C;
   static final int KEYSYM_MultipleCandidate = 0xFF3D;
   static final int KEYSYM_PreviousCandidate = 0xFF3E;
   static final int KEYSYM_Kanji = 0xFF21;
   static final int KEYSYM_Muhenkan = 0xFF22;
   static final int KEYSYM_Henkan_Mode = 0xFF23;
   static final int KEYSYM_Henkan = 0xFF23;
   static final int KEYSYM_Romaji = 0xFF24;
   static final int KEYSYM_Hiragana = 0xFF25;
   static final int KEYSYM_Katakana = 0xFF26;
   static final int KEYSYM_Hiragana_Katakana = 0xFF27;
   static final int KEYSYM_Zenkaku = 0xFF28;
   static final int KEYSYM_Hankaku = 0xFF29;
   static final int KEYSYM_Zenkaku_Hankaku = 0xFF2A;
   static final int KEYSYM_Touroku = 0xFF2B;
   static final int KEYSYM_Massyo = 0xFF2C;
   static final int KEYSYM_Kana_Lock = 0xFF2D;
   static final int KEYSYM_Kana_Shift = 0xFF2E;
   static final int KEYSYM_Eisu_Shift = 0xFF2F;
   static final int KEYSYM_Eisu_toggle = 0xFF30;
   static final int KEYSYM_Zen_Koho = 0xFF3D;
   static final int KEYSYM_Mae_Koho = 0xFF3E;
   static final int KEYSYM_Home = 0xFF50;
   static final int KEYSYM_Left = 0xFF51;
   static final int KEYSYM_Up = 0xFF52;
   static final int KEYSYM_Right = 0xFF53;
   static final int KEYSYM_Down = 0xFF54;
   static final int KEYSYM_Prior = 0xFF55;
   static final int KEYSYM_Page_Up = 0xFF55;
   static final int KEYSYM_Next = 0xFF56;
   static final int KEYSYM_Page_Down = 0xFF56;
   static final int KEYSYM_End = 0xFF57;
   static final int KEYSYM_Begin = 0xFF58;
   static final int KEYSYM_Select = 0xFF60;
   static final int KEYSYM_Print = 0xFF61;
   static final int KEYSYM_Execute = 0xFF62;
   static final int KEYSYM_Insert = 0xFF63;
   static final int KEYSYM_Undo = 0xFF65;
   static final int KEYSYM_Redo = 0xFF66;
   static final int KEYSYM_Menu = 0xFF67;
   static final int KEYSYM_Find = 0xFF68;
   static final int KEYSYM_Cancel = 0xFF69;
   static final int KEYSYM_Help = 0xFF6A;
   static final int KEYSYM_Break = 0xFF6B;
   static final int KEYSYM_Mode_switch = 0xFF7E;
   static final int KEYSYM_script_switch = 0xFF7E;
   static final int KEYSYM_Num_Lock = 0xFF7F;
   static final int KEYSYM_KP_Space = 0xFF80;
   static final int KEYSYM_KP_Tab = 0xFF89;
   static final int KEYSYM_KP_Enter = 0xFF8D;
   static final int KEYSYM_KP_F1 = 0xFF91;
   static final int KEYSYM_KP_F2 = 0xFF92;
   static final int KEYSYM_KP_F3 = 0xFF93;
   static final int KEYSYM_KP_F4 = 0xFF94;
   static final int KEYSYM_KP_Home = 0xFF95;
   static final int KEYSYM_KP_Left = 0xFF96;
   static final int KEYSYM_KP_Up = 0xFF97;
   static final int KEYSYM_KP_Right = 0xFF98;
   static final int KEYSYM_KP_Down = 0xFF99;
   static final int KEYSYM_KP_Prior = 0xFF9A;
   static final int KEYSYM_KP_Page_Up = 0xFF9A;
   static final int KEYSYM_KP_Next = 0xFF9B;
   static final int KEYSYM_KP_Page_Down = 0xFF9B;
   static final int KEYSYM_KP_End = 0xFF9C;
   static final int KEYSYM_KP_Begin = 0xFF9D;
   static final int KEYSYM_KP_Insert = 0xFF9E;
   static final int KEYSYM_KP_Delete = 0xFF9F;
   static final int KEYSYM_KP_Equal = 0xFFBD;
   static final int KEYSYM_KP_Multiply = 0xFFAA;
   static final int KEYSYM_KP_Add = 0xFFAB;
   static final int KEYSYM_KP_Separator = 0xFFAC;
   static final int KEYSYM_KP_Subtract = 0xFFAD;
   static final int KEYSYM_KP_Decimal = 0xFFAE;
   static final int KEYSYM_KP_Divide = 0xFFAF;
   static final int KEYSYM_KP_0 = 0xFFB0;
   static final int KEYSYM_KP_1 = 0xFFB1;
   static final int KEYSYM_KP_2 = 0xFFB2;
   static final int KEYSYM_KP_3 = 0xFFB3;
   static final int KEYSYM_KP_4 = 0xFFB4;
   static final int KEYSYM_KP_5 = 0xFFB5;
   static final int KEYSYM_KP_6 = 0xFFB6;
   static final int KEYSYM_KP_7 = 0xFFB7;
   static final int KEYSYM_KP_8 = 0xFFB8;
   static final int KEYSYM_KP_9 = 0xFFB9;
   static final int KEYSYM_F1 = 0xFFBE;
   static final int KEYSYM_F2 = 0xFFBF;
   static final int KEYSYM_F3 = 0xFFC0;
   static final int KEYSYM_F4 = 0xFFC1;
   static final int KEYSYM_F5 = 0xFFC2;
   static final int KEYSYM_F6 = 0xFFC3;
   static final int KEYSYM_F7 = 0xFFC4;
   static final int KEYSYM_F8 = 0xFFC5;
   static final int KEYSYM_F9 = 0xFFC6;
   static final int KEYSYM_F10 = 0xFFC7;
   static final int KEYSYM_F11 = 0xFFC8;
   static final int KEYSYM_L1 = 0xFFC8;
   static final int KEYSYM_F12 = 0xFFC9;
   static final int KEYSYM_L2 = 0xFFC9;
   static final int KEYSYM_F13 = 0xFFCA;
   static final int KEYSYM_L3 = 0xFFCA;
   static final int KEYSYM_F14 = 0xFFCB;
   static final int KEYSYM_L4 = 0xFFCB;
   static final int KEYSYM_F15 = 0xFFCC;
   static final int KEYSYM_L5 = 0xFFCC;
   static final int KEYSYM_F16 = 0xFFCD;
   static final int KEYSYM_L6 = 0xFFCD;
   static final int KEYSYM_F17 = 0xFFCE;
   static final int KEYSYM_L7 = 0xFFCE;
   static final int KEYSYM_F18 = 0xFFCF;
   static final int KEYSYM_L8 = 0xFFCF;
   static final int KEYSYM_F19 = 0xFFD0;
   static final int KEYSYM_L9 = 0xFFD0;
   static final int KEYSYM_F20 = 0xFFD1;
   static final int KEYSYM_L10 = 0xFFD1;
   static final int KEYSYM_F21 = 0xFFD2;
   static final int KEYSYM_R1 = 0xFFD2;
   static final int KEYSYM_F22 = 0xFFD3;
   static final int KEYSYM_R2 = 0xFFD3;
   static final int KEYSYM_F23 = 0xFFD4;
   static final int KEYSYM_R3 = 0xFFD4;
   static final int KEYSYM_F24 = 0xFFD5;
   static final int KEYSYM_R4 = 0xFFD5;
   static final int KEYSYM_F25 = 0xFFD6;
   static final int KEYSYM_R5 = 0xFFD6;
   static final int KEYSYM_F26 = 0xFFD7;
   static final int KEYSYM_R6 = 0xFFD7;
   static final int KEYSYM_F27 = 0xFFD8;
   static final int KEYSYM_R7 = 0xFFD8;
   static final int KEYSYM_F28 = 0xFFD9;
   static final int KEYSYM_R8 = 0xFFD9;
   static final int KEYSYM_F29 = 0xFFDA;
   static final int KEYSYM_R9 = 0xFFDA;
   static final int KEYSYM_F30 = 0xFFDB;
   static final int KEYSYM_R10 = 0xFFDB;
   static final int KEYSYM_F31 = 0xFFDC;
   static final int KEYSYM_R11 = 0xFFDC;
   static final int KEYSYM_F32 = 0xFFDD;
   static final int KEYSYM_R12 = 0xFFDD;
   static final int KEYSYM_F33 = 0xFFDE;
   static final int KEYSYM_R13 = 0xFFDE;
   static final int KEYSYM_F34 = 0xFFDF;
   static final int KEYSYM_R14 = 0xFFDF;
   static final int KEYSYM_F35 = 0xFFE0;
   static final int KEYSYM_R15 = 0xFFE0;
   static final int KEYSYM_Shift_L = 0xFFE1;
   static final int KEYSYM_Shift_R = 0xFFE2;
   static final int KEYSYM_Control_L = 0xFFE3;
   static final int KEYSYM_Control_R = 0xFFE4;
   static final int KEYSYM_Caps_Lock = 0xFFE5;
   static final int KEYSYM_Shift_Lock = 0xFFE6;
   static final int KEYSYM_Meta_L = 0xFFE7;
   static final int KEYSYM_Meta_R = 0xFFE8;
   static final int KEYSYM_Alt_L = 0xFFE9;
   static final int KEYSYM_Alt_R = 0xFFEA;
   static final int KEYSYM_Super_L = 0xFFEB;
   static final int KEYSYM_Super_R = 0xFFEC;
   static final int KEYSYM_Hyper_L = 0xFFED;
   static final int KEYSYM_Hyper_R = 0xFFEE;
   static final int KEYSYM_ISO_Lock = 0xFE01;
   static final int KEYSYM_ISO_Level2_Latch = 0xFE02;
   static final int KEYSYM_ISO_Level3_Shift = 0xFE03;
   static final int KEYSYM_ISO_Level3_Latch = 0xFE04;
   static final int KEYSYM_ISO_Level3_Lock = 0xFE05;
   static final int KEYSYM_ISO_Group_Shift = 0xFF7E;
   static final int KEYSYM_ISO_Group_Latch = 0xFE06;
   static final int KEYSYM_ISO_Group_Lock = 0xFE07;
   static final int KEYSYM_ISO_Next_Group = 0xFE08;
   static final int KEYSYM_ISO_Next_Group_Lock = 0xFE09;
   static final int KEYSYM_ISO_Prev_Group = 0xFE0A;
   static final int KEYSYM_ISO_Prev_Group_Lock = 0xFE0B;
   static final int KEYSYM_ISO_First_Group = 0xFE0C;
   static final int KEYSYM_ISO_First_Group_Lock = 0xFE0D;
   static final int KEYSYM_ISO_Last_Group = 0xFE0E;
   static final int KEYSYM_ISO_Last_Group_Lock = 0xFE0F;
   static final int KEYSYM_ISO_Left_Tab = 0xFE20;
   static final int KEYSYM_ISO_Move_Line_Up = 0xFE21;
   static final int KEYSYM_ISO_Move_Line_Down = 0xFE22;
   static final int KEYSYM_ISO_Partial_Line_Up = 0xFE23;
   static final int KEYSYM_ISO_Partial_Line_Down = 0xFE24;
   static final int KEYSYM_ISO_Partial_Space_Left = 0xFE25;
   static final int KEYSYM_ISO_Partial_Space_Right = 0xFE26;
   static final int KEYSYM_ISO_Set_Margin_Left = 0xFE27;
   static final int KEYSYM_ISO_Set_Margin_Right = 0xFE28;
   static final int KEYSYM_ISO_Release_Margin_Left = 0xFE29;
   static final int KEYSYM_ISO_Release_Margin_Right = 0xFE2A;
   static final int KEYSYM_ISO_Release_Both_Margins = 0xFE2B;
   static final int KEYSYM_ISO_Fast_Cursor_Left = 0xFE2C;
   static final int KEYSYM_ISO_Fast_Cursor_Right = 0xFE2D;
   static final int KEYSYM_ISO_Fast_Cursor_Up = 0xFE2E;
   static final int KEYSYM_ISO_Fast_Cursor_Down = 0xFE2F;
   static final int KEYSYM_ISO_Continuous_Underline = 0xFE30;
   static final int KEYSYM_ISO_Discontinuous_Underline = 0xFE31;
   static final int KEYSYM_ISO_Emphasize = 0xFE32;
   static final int KEYSYM_ISO_Center_Object = 0xFE33;
   static final int KEYSYM_ISO_Enter = 0xFE34;
   static final int KEYSYM_dead_grave = 0xFE50;
   static final int KEYSYM_dead_acute = 0xFE51;
   static final int KEYSYM_dead_circumflex = 0xFE52;
   static final int KEYSYM_dead_tilde = 0xFE53;
   static final int KEYSYM_dead_macron = 0xFE54;
   static final int KEYSYM_dead_breve = 0xFE55;
   static final int KEYSYM_dead_abovedot = 0xFE56;
   static final int KEYSYM_dead_diaeresis = 0xFE57;
   static final int KEYSYM_dead_abovering = 0xFE58;
   static final int KEYSYM_dead_doubleacute = 0xFE59;
   static final int KEYSYM_dead_caron = 0xFE5A;
   static final int KEYSYM_dead_cedilla = 0xFE5B;
   static final int KEYSYM_dead_ogonek = 0xFE5C;
   static final int KEYSYM_dead_iota = 0xFE5D;
   static final int KEYSYM_dead_voiced_sound = 0xFE5E;
   static final int KEYSYM_dead_semivoiced_sound = 0xFE5F;
   static final int KEYSYM_dead_belowdot = 0xFE60;
   static final int KEYSYM_First_Virtual_Screen = 0xFED0;
   static final int KEYSYM_Prev_Virtual_Screen = 0xFED1;
   static final int KEYSYM_Next_Virtual_Screen = 0xFED2;
   static final int KEYSYM_Last_Virtual_Screen = 0xFED4;
   static final int KEYSYM_Terminate_Server = 0xFED5;
   static final int KEYSYM_AccessX_Enable = 0xFE70;
   static final int KEYSYM_AccessX_Feedback_Enable = 0xFE71;
   static final int KEYSYM_RepeatKeys_Enable = 0xFE72;
   static final int KEYSYM_SlowKeys_Enable = 0xFE73;
   static final int KEYSYM_BounceKeys_Enable = 0xFE74;
   static final int KEYSYM_StickyKeys_Enable = 0xFE75;
   static final int KEYSYM_MouseKeys_Enable = 0xFE76;
   static final int KEYSYM_MouseKeys_Accel_Enable = 0xFE77;
   static final int KEYSYM_Overlay1_Enable = 0xFE78;
   static final int KEYSYM_Overlay2_Enable = 0xFE79;
   static final int KEYSYM_AudibleBell_Enable = 0xFE7A;
   static final int KEYSYM_Pointer_Left = 0xFEE0;
   static final int KEYSYM_Pointer_Right = 0xFEE1;
   static final int KEYSYM_Pointer_Up = 0xFEE2;
   static final int KEYSYM_Pointer_Down = 0xFEE3;
   static final int KEYSYM_Pointer_UpLeft = 0xFEE4;
   static final int KEYSYM_Pointer_UpRight = 0xFEE5;
   static final int KEYSYM_Pointer_DownLeft = 0xFEE6;
   static final int KEYSYM_Pointer_DownRight = 0xFEE7;
   static final int KEYSYM_Pointer_Button_Dflt = 0xFEE8;
   static final int KEYSYM_Pointer_Button1 = 0xFEE9;
   static final int KEYSYM_Pointer_Button2 = 0xFEEA;
   static final int KEYSYM_Pointer_Button3 = 0xFEEB;
   static final int KEYSYM_Pointer_Button4 = 0xFEEC;
   static final int KEYSYM_Pointer_Button5 = 0xFEED;
   static final int KEYSYM_Pointer_DblClick_Dflt = 0xFEEE;
   static final int KEYSYM_Pointer_DblClick1 = 0xFEEF;
   static final int KEYSYM_Pointer_DblClick2 = 0xFEF0;
   static final int KEYSYM_Pointer_DblClick3 = 0xFEF1;
   static final int KEYSYM_Pointer_DblClick4 = 0xFEF2;
   static final int KEYSYM_Pointer_DblClick5 = 0xFEF3;
   static final int KEYSYM_Pointer_Drag_Dflt = 0xFEF4;
   static final int KEYSYM_Pointer_Drag1 = 0xFEF5;
   static final int KEYSYM_Pointer_Drag2 = 0xFEF6;
   static final int KEYSYM_Pointer_Drag3 = 0xFEF7;
   static final int KEYSYM_Pointer_Drag4 = 0xFEF8;
   static final int KEYSYM_Pointer_Drag5 = 0xFEFD;
   static final int KEYSYM_Pointer_EnableKeys = 0xFEF9;
   static final int KEYSYM_Pointer_Accelerate = 0xFEFA;
   static final int KEYSYM_Pointer_DfltBtnNext = 0xFEFB;
   static final int KEYSYM_Pointer_DfltBtnPrev = 0xFEFC;
   static final int KEYSYM_3270_Duplicate = 0xFD01;
   static final int KEYSYM_3270_FieldMark = 0xFD02;
   static final int KEYSYM_3270_Right2 = 0xFD03;
   static final int KEYSYM_3270_Left2 = 0xFD04;
   static final int KEYSYM_3270_BackTab = 0xFD05;
   static final int KEYSYM_3270_EraseEOF = 0xFD06;
   static final int KEYSYM_3270_EraseInput = 0xFD07;
   static final int KEYSYM_3270_Reset = 0xFD08;
   static final int KEYSYM_3270_Quit = 0xFD09;
   static final int KEYSYM_3270_PA1 = 0xFD0A;
   static final int KEYSYM_3270_PA2 = 0xFD0B;
   static final int KEYSYM_3270_PA3 = 0xFD0C;
   static final int KEYSYM_3270_Test = 0xFD0D;
   static final int KEYSYM_3270_Attn = 0xFD0E;
   static final int KEYSYM_3270_CursorBlink = 0xFD0F;
   static final int KEYSYM_3270_AltCursor = 0xFD10;
   static final int KEYSYM_3270_KeyClick = 0xFD11;
   static final int KEYSYM_3270_Jump = 0xFD12;
   static final int KEYSYM_3270_Ident = 0xFD13;
   static final int KEYSYM_3270_Rule = 0xFD14;
   static final int KEYSYM_3270_Copy = 0xFD15;
   static final int KEYSYM_3270_Play = 0xFD16;
   static final int KEYSYM_3270_Setup = 0xFD17;
   static final int KEYSYM_3270_Record = 0xFD18;
   static final int KEYSYM_3270_ChangeScreen = 0xFD19;
   static final int KEYSYM_3270_DeleteWord = 0xFD1A;
   static final int KEYSYM_3270_ExSelect = 0xFD1B;
   static final int KEYSYM_3270_CursorSelect = 0xFD1C;
   static final int KEYSYM_3270_PrintScreen = 0xFD1D;
   static final int KEYSYM_3270_Enter = 0xFD1E;
   static final int KEYSYM_space = 0x020;
   static final int KEYSYM_exclam = 0x021;
   static final int KEYSYM_quotedbl = 0x022;
   static final int KEYSYM_numbersign = 0x023;
   static final int KEYSYM_dollar = 0x024;
   static final int KEYSYM_percent = 0x025;
   static final int KEYSYM_ampersand = 0x026;
   static final int KEYSYM_apostrophe = 0x027;
   static final int KEYSYM_quoteright = 0x027;
   static final int KEYSYM_parenleft = 0x028;
   static final int KEYSYM_parenright = 0x029;
   static final int KEYSYM_asterisk = 0x02a;
   static final int KEYSYM_plus = 0x02b;
   static final int KEYSYM_comma = 0x02c;
   static final int KEYSYM_minus = 0x02d;
   static final int KEYSYM_period = 0x02e;
   static final int KEYSYM_slash = 0x02f;
   static final int KEYSYM_0 = 0x030;
   static final int KEYSYM_1 = 0x031;
   static final int KEYSYM_2 = 0x032;
   static final int KEYSYM_3 = 0x033;
   static final int KEYSYM_4 = 0x034;
   static final int KEYSYM_5 = 0x035;
   static final int KEYSYM_6 = 0x036;
   static final int KEYSYM_7 = 0x037;
   static final int KEYSYM_8 = 0x038;
   static final int KEYSYM_9 = 0x039;
   static final int KEYSYM_colon = 0x03a;
   static final int KEYSYM_semicolon = 0x03b;
   static final int KEYSYM_less = 0x03c;
   static final int KEYSYM_equal = 0x03d;
   static final int KEYSYM_greater = 0x03e;
   static final int KEYSYM_question = 0x03f;
   static final int KEYSYM_at = 0x040;
   static final int KEYSYM_A = 0x041;
   static final int KEYSYM_B = 0x042;
   static final int KEYSYM_C = 0x043;
   static final int KEYSYM_D = 0x044;
   static final int KEYSYM_E = 0x045;
   static final int KEYSYM_F = 0x046;
   static final int KEYSYM_G = 0x047;
   static final int KEYSYM_H = 0x048;
   static final int KEYSYM_I = 0x049;
   static final int KEYSYM_J = 0x04a;
   static final int KEYSYM_K = 0x04b;
   static final int KEYSYM_L = 0x04c;
   static final int KEYSYM_M = 0x04d;
   static final int KEYSYM_N = 0x04e;
   static final int KEYSYM_O = 0x04f;
   static final int KEYSYM_P = 0x050;
   static final int KEYSYM_Q = 0x051;
   static final int KEYSYM_R = 0x052;
   static final int KEYSYM_S = 0x053;
   static final int KEYSYM_T = 0x054;
   static final int KEYSYM_U = 0x055;
   static final int KEYSYM_V = 0x056;
   static final int KEYSYM_W = 0x057;
   static final int KEYSYM_X = 0x058;
   static final int KEYSYM_Y = 0x059;
   static final int KEYSYM_Z = 0x05a;
   static final int KEYSYM_bracketleft = 0x05b;
   static final int KEYSYM_backslash = 0x05c;
   static final int KEYSYM_bracketright = 0x05d;
   static final int KEYSYM_asciicircum = 0x05e;
   static final int KEYSYM_underscore = 0x05f;
   static final int KEYSYM_grave = 0x060;
   static final int KEYSYM_quoteleft = 0x060;
   static final int KEYSYM_a = 0x061;
   static final int KEYSYM_b = 0x062;
   static final int KEYSYM_c = 0x063;
   static final int KEYSYM_d = 0x064;
   static final int KEYSYM_e = 0x065;
   static final int KEYSYM_f = 0x066;
   static final int KEYSYM_g = 0x067;
   static final int KEYSYM_h = 0x068;
   static final int KEYSYM_i = 0x069;
   static final int KEYSYM_j = 0x06a;
   static final int KEYSYM_k = 0x06b;
   static final int KEYSYM_l = 0x06c;
   static final int KEYSYM_m = 0x06d;
   static final int KEYSYM_n = 0x06e;
   static final int KEYSYM_o = 0x06f;
   static final int KEYSYM_p = 0x070;
   static final int KEYSYM_q = 0x071;
   static final int KEYSYM_r = 0x072;
   static final int KEYSYM_s = 0x073;
   static final int KEYSYM_t = 0x074;
   static final int KEYSYM_u = 0x075;
   static final int KEYSYM_v = 0x076;
   static final int KEYSYM_w = 0x077;
   static final int KEYSYM_x = 0x078;
   static final int KEYSYM_y = 0x079;
   static final int KEYSYM_z = 0x07a;
   static final int KEYSYM_braceleft = 0x07b;
   static final int KEYSYM_bar = 0x07c;
   static final int KEYSYM_braceright = 0x07d;
   static final int KEYSYM_asciitilde = 0x07e;
   static final int KEYSYM_nobreakspace = 0x0a0;
   static final int KEYSYM_exclamdown = 0x0a1;
   static final int KEYSYM_cent = 0x0a2;
   static final int KEYSYM_sterling = 0x0a3;
   static final int KEYSYM_currency = 0x0a4;
   static final int KEYSYM_yen = 0x0a5;
   static final int KEYSYM_brokenbar = 0x0a6;
   static final int KEYSYM_section = 0x0a7;
   static final int KEYSYM_diaeresis = 0x0a8;
   static final int KEYSYM_copyright = 0x0a9;
   static final int KEYSYM_ordfeminine = 0x0aa;
   static final int KEYSYM_guillemotleft = 0x0ab;
   static final int KEYSYM_notsign = 0x0ac;
   static final int KEYSYM_hyphen = 0x0ad;
   static final int KEYSYM_registered = 0x0ae;
   static final int KEYSYM_macron = 0x0af;
   static final int KEYSYM_degree = 0x0b0;
   static final int KEYSYM_plusminus = 0x0b1;
   static final int KEYSYM_twosuperior = 0x0b2;
   static final int KEYSYM_threesuperior = 0x0b3;
   static final int KEYSYM_acute = 0x0b4;
   static final int KEYSYM_mu = 0x0b5;
   static final int KEYSYM_paragraph = 0x0b6;
   static final int KEYSYM_periodcentered = 0x0b7;
   static final int KEYSYM_cedilla = 0x0b8;
   static final int KEYSYM_onesuperior = 0x0b9;
   static final int KEYSYM_masculine = 0x0ba;
   static final int KEYSYM_guillemotright = 0x0bb;
   static final int KEYSYM_onequarter = 0x0bc;
   static final int KEYSYM_onehalf = 0x0bd;
   static final int KEYSYM_threequarters = 0x0be;
   static final int KEYSYM_questiondown = 0x0bf;
   static final int KEYSYM_Agrave = 0x0c0;
   static final int KEYSYM_Aacute = 0x0c1;
   static final int KEYSYM_Acircumflex = 0x0c2;
   static final int KEYSYM_Atilde = 0x0c3;
   static final int KEYSYM_Adiaeresis = 0x0c4;
   static final int KEYSYM_Aring = 0x0c5;
   static final int KEYSYM_AE = 0x0c6;
   static final int KEYSYM_Ccedilla = 0x0c7;
   static final int KEYSYM_Egrave = 0x0c8;
   static final int KEYSYM_Eacute = 0x0c9;
   static final int KEYSYM_Ecircumflex = 0x0ca;
   static final int KEYSYM_Ediaeresis = 0x0cb;
   static final int KEYSYM_Igrave = 0x0cc;
   static final int KEYSYM_Iacute = 0x0cd;
   static final int KEYSYM_Icircumflex = 0x0ce;
   static final int KEYSYM_Idiaeresis = 0x0cf;
   static final int KEYSYM_ETH = 0x0d0;
   static final int KEYSYM_Eth = 0x0d0;
   static final int KEYSYM_Ntilde = 0x0d1;
   static final int KEYSYM_Ograve = 0x0d2;
   static final int KEYSYM_Oacute = 0x0d3;
   static final int KEYSYM_Ocircumflex = 0x0d4;
   static final int KEYSYM_Otilde = 0x0d5;
   static final int KEYSYM_Odiaeresis = 0x0d6;
   static final int KEYSYM_multiply = 0x0d7;
   static final int KEYSYM_Ooblique = 0x0d8;
   static final int KEYSYM_Ugrave = 0x0d9;
   static final int KEYSYM_Uacute = 0x0da;
   static final int KEYSYM_Ucircumflex = 0x0db;
   static final int KEYSYM_Udiaeresis = 0x0dc;
   static final int KEYSYM_Yacute = 0x0dd;
   static final int KEYSYM_THORN = 0x0de;
   static final int KEYSYM_Thorn = 0x0de;
   static final int KEYSYM_ssharp = 0x0df;
   static final int KEYSYM_agrave = 0x0e0;
   static final int KEYSYM_aacute = 0x0e1;
   static final int KEYSYM_acircumflex = 0x0e2;
   static final int KEYSYM_atilde = 0x0e3;
   static final int KEYSYM_adiaeresis = 0x0e4;
   static final int KEYSYM_aring = 0x0e5;
   static final int KEYSYM_ae = 0x0e6;
   static final int KEYSYM_ccedilla = 0x0e7;
   static final int KEYSYM_egrave = 0x0e8;
   static final int KEYSYM_eacute = 0x0e9;
   static final int KEYSYM_ecircumflex = 0x0ea;
   static final int KEYSYM_ediaeresis = 0x0eb;
   static final int KEYSYM_igrave = 0x0ec;
   static final int KEYSYM_iacute = 0x0ed;
   static final int KEYSYM_icircumflex = 0x0ee;
   static final int KEYSYM_idiaeresis = 0x0ef;
   static final int KEYSYM_eth = 0x0f0;
   static final int KEYSYM_ntilde = 0x0f1;
   static final int KEYSYM_ograve = 0x0f2;
   static final int KEYSYM_oacute = 0x0f3;
   static final int KEYSYM_ocircumflex = 0x0f4;
   static final int KEYSYM_otilde = 0x0f5;
   static final int KEYSYM_odiaeresis = 0x0f6;
   static final int KEYSYM_division = 0x0f7;
   static final int KEYSYM_oslash = 0x0f8;
   static final int KEYSYM_ugrave = 0x0f9;
   static final int KEYSYM_uacute = 0x0fa;
   static final int KEYSYM_ucircumflex = 0x0fb;
   static final int KEYSYM_udiaeresis = 0x0fc;
   static final int KEYSYM_yacute = 0x0fd;
   static final int KEYSYM_thorn = 0x0fe;
   static final int KEYSYM_ydiaeresis = 0x0ff;
   static final int KEYSYM_Aogonek = 0x1a1;
   static final int KEYSYM_breve = 0x1a2;
   static final int KEYSYM_Lstroke = 0x1a3;
   static final int KEYSYM_Lcaron = 0x1a5;
   static final int KEYSYM_Sacute = 0x1a6;
   static final int KEYSYM_Scaron = 0x1a9;
   static final int KEYSYM_Scedilla = 0x1aa;
   static final int KEYSYM_Tcaron = 0x1ab;
   static final int KEYSYM_Zacute = 0x1ac;
   static final int KEYSYM_Zcaron = 0x1ae;
   static final int KEYSYM_Zabovedot = 0x1af;
   static final int KEYSYM_aogonek = 0x1b1;
   static final int KEYSYM_ogonek = 0x1b2;
   static final int KEYSYM_lstroke = 0x1b3;
   static final int KEYSYM_lcaron = 0x1b5;
   static final int KEYSYM_sacute = 0x1b6;
   static final int KEYSYM_caron = 0x1b7;
   static final int KEYSYM_scaron = 0x1b9;
   static final int KEYSYM_scedilla = 0x1ba;
   static final int KEYSYM_tcaron = 0x1bb;
   static final int KEYSYM_zacute = 0x1bc;
   static final int KEYSYM_doubleacute = 0x1bd;
   static final int KEYSYM_zcaron = 0x1be;
   static final int KEYSYM_zabovedot = 0x1bf;
   static final int KEYSYM_Racute = 0x1c0;
   static final int KEYSYM_Abreve = 0x1c3;
   static final int KEYSYM_Lacute = 0x1c5;
   static final int KEYSYM_Cacute = 0x1c6;
   static final int KEYSYM_Ccaron = 0x1c8;
   static final int KEYSYM_Eogonek = 0x1ca;
   static final int KEYSYM_Ecaron = 0x1cc;
   static final int KEYSYM_Dcaron = 0x1cf;
   static final int KEYSYM_Dstroke = 0x1d0;
   static final int KEYSYM_Nacute = 0x1d1;
   static final int KEYSYM_Ncaron = 0x1d2;
   static final int KEYSYM_Odoubleacute = 0x1d5;
   static final int KEYSYM_Rcaron = 0x1d8;
   static final int KEYSYM_Uring = 0x1d9;
   static final int KEYSYM_Udoubleacute = 0x1db;
   static final int KEYSYM_Tcedilla = 0x1de;
   static final int KEYSYM_racute = 0x1e0;
   static final int KEYSYM_abreve = 0x1e3;
   static final int KEYSYM_lacute = 0x1e5;
   static final int KEYSYM_cacute = 0x1e6;
   static final int KEYSYM_ccaron = 0x1e8;
   static final int KEYSYM_eogonek = 0x1ea;
   static final int KEYSYM_ecaron = 0x1ec;
   static final int KEYSYM_dcaron = 0x1ef;
   static final int KEYSYM_dstroke = 0x1f0;
   static final int KEYSYM_nacute = 0x1f1;
   static final int KEYSYM_ncaron = 0x1f2;
   static final int KEYSYM_odoubleacute = 0x1f5;
   static final int KEYSYM_udoubleacute = 0x1fb;
   static final int KEYSYM_rcaron = 0x1f8;
   static final int KEYSYM_uring = 0x1f9;
   static final int KEYSYM_tcedilla = 0x1fe;
   static final int KEYSYM_abovedot = 0x1ff;
   static final int KEYSYM_Hstroke = 0x2a1;
   static final int KEYSYM_Hcircumflex = 0x2a6;
   static final int KEYSYM_Iabovedot = 0x2a9;
   static final int KEYSYM_Gbreve = 0x2ab;
   static final int KEYSYM_Jcircumflex = 0x2ac;
   static final int KEYSYM_hstroke = 0x2b1;
   static final int KEYSYM_hcircumflex = 0x2b6;
   static final int KEYSYM_idotless = 0x2b9;
   static final int KEYSYM_gbreve = 0x2bb;
   static final int KEYSYM_jcircumflex = 0x2bc;
   static final int KEYSYM_Cabovedot = 0x2c5;
   static final int KEYSYM_Ccircumflex = 0x2c6;
   static final int KEYSYM_Gabovedot = 0x2d5;
   static final int KEYSYM_Gcircumflex = 0x2d8;
   static final int KEYSYM_Ubreve = 0x2dd;
   static final int KEYSYM_Scircumflex = 0x2de;
   static final int KEYSYM_cabovedot = 0x2e5;
   static final int KEYSYM_ccircumflex = 0x2e6;
   static final int KEYSYM_gabovedot = 0x2f5;
   static final int KEYSYM_gcircumflex = 0x2f8;
   static final int KEYSYM_ubreve = 0x2fd;
   static final int KEYSYM_scircumflex = 0x2fe;
   static final int KEYSYM_kra = 0x3a2;
   static final int KEYSYM_kappa = 0x3a2;
   static final int KEYSYM_Rcedilla = 0x3a3;
   static final int KEYSYM_Itilde = 0x3a5;
   static final int KEYSYM_Lcedilla = 0x3a6;
   static final int KEYSYM_Emacron = 0x3aa;
   static final int KEYSYM_Gcedilla = 0x3ab;
   static final int KEYSYM_Tslash = 0x3ac;
   static final int KEYSYM_rcedilla = 0x3b3;
   static final int KEYSYM_itilde = 0x3b5;
   static final int KEYSYM_lcedilla = 0x3b6;
   static final int KEYSYM_emacron = 0x3ba;
   static final int KEYSYM_gcedilla = 0x3bb;
   static final int KEYSYM_tslash = 0x3bc;
   static final int KEYSYM_ENG = 0x3bd;
   static final int KEYSYM_eng = 0x3bf;
   static final int KEYSYM_Amacron = 0x3c0;
   static final int KEYSYM_Iogonek = 0x3c7;
   static final int KEYSYM_Eabovedot = 0x3cc;
   static final int KEYSYM_Imacron = 0x3cf;
   static final int KEYSYM_Ncedilla = 0x3d1;
   static final int KEYSYM_Omacron = 0x3d2;
   static final int KEYSYM_Kcedilla = 0x3d3;
   static final int KEYSYM_Uogonek = 0x3d9;
   static final int KEYSYM_Utilde = 0x3dd;
   static final int KEYSYM_Umacron = 0x3de;
   static final int KEYSYM_amacron = 0x3e0;
   static final int KEYSYM_iogonek = 0x3e7;
   static final int KEYSYM_eabovedot = 0x3ec;
   static final int KEYSYM_imacron = 0x3ef;
   static final int KEYSYM_ncedilla = 0x3f1;
   static final int KEYSYM_omacron = 0x3f2;
   static final int KEYSYM_kcedilla = 0x3f3;
   static final int KEYSYM_uogonek = 0x3f9;
   static final int KEYSYM_utilde = 0x3fd;
   static final int KEYSYM_umacron = 0x3fe;
   static final int KEYSYM_overline = 0x47e;
   static final int KEYSYM_kana_fullstop = 0x4a1;
   static final int KEYSYM_kana_openingbracket = 0x4a2;
   static final int KEYSYM_kana_closingbracket = 0x4a3;
   static final int KEYSYM_kana_comma = 0x4a4;
   static final int KEYSYM_kana_conjunctive = 0x4a5;
   static final int KEYSYM_kana_middledot = 0x4a5;
   static final int KEYSYM_kana_WO = 0x4a6;
   static final int KEYSYM_kana_a = 0x4a7;
   static final int KEYSYM_kana_i = 0x4a8;
   static final int KEYSYM_kana_u = 0x4a9;
   static final int KEYSYM_kana_e = 0x4aa;
   static final int KEYSYM_kana_o = 0x4ab;
   static final int KEYSYM_kana_ya = 0x4ac;
   static final int KEYSYM_kana_yu = 0x4ad;
   static final int KEYSYM_kana_yo = 0x4ae;
   static final int KEYSYM_kana_tsu = 0x4af;
   static final int KEYSYM_kana_tu = 0x4af;
   static final int KEYSYM_prolongedsound = 0x4b0;
   static final int KEYSYM_kana_A = 0x4b1;
   static final int KEYSYM_kana_I = 0x4b2;
   static final int KEYSYM_kana_U = 0x4b3;
   static final int KEYSYM_kana_E = 0x4b4;
   static final int KEYSYM_kana_O = 0x4b5;
   static final int KEYSYM_kana_KA = 0x4b6;
   static final int KEYSYM_kana_KI = 0x4b7;
   static final int KEYSYM_kana_KU = 0x4b8;
   static final int KEYSYM_kana_KE = 0x4b9;
   static final int KEYSYM_kana_KO = 0x4ba;
   static final int KEYSYM_kana_SA = 0x4bb;
   static final int KEYSYM_kana_SHI = 0x4bc;
   static final int KEYSYM_kana_SU = 0x4bd;
   static final int KEYSYM_kana_SE = 0x4be;
   static final int KEYSYM_kana_SO = 0x4bf;
   static final int KEYSYM_kana_TA = 0x4c0;
   static final int KEYSYM_kana_CHI = 0x4c1;
   static final int KEYSYM_kana_TI = 0x4c1;
   static final int KEYSYM_kana_TSU = 0x4c2;
   static final int KEYSYM_kana_TU = 0x4c2;
   static final int KEYSYM_kana_TE = 0x4c3;
   static final int KEYSYM_kana_TO = 0x4c4;
   static final int KEYSYM_kana_NA = 0x4c5;
   static final int KEYSYM_kana_NI = 0x4c6;
   static final int KEYSYM_kana_NU = 0x4c7;
   static final int KEYSYM_kana_NE = 0x4c8;
   static final int KEYSYM_kana_NO = 0x4c9;
   static final int KEYSYM_kana_HA = 0x4ca;
   static final int KEYSYM_kana_HI = 0x4cb;
   static final int KEYSYM_kana_FU = 0x4cc;
   static final int KEYSYM_kana_HU = 0x4cc;
   static final int KEYSYM_kana_HE = 0x4cd;
   static final int KEYSYM_kana_HO = 0x4ce;
   static final int KEYSYM_kana_MA = 0x4cf;
   static final int KEYSYM_kana_MI = 0x4d0;
   static final int KEYSYM_kana_MU = 0x4d1;
   static final int KEYSYM_kana_ME = 0x4d2;
   static final int KEYSYM_kana_MO = 0x4d3;
   static final int KEYSYM_kana_YA = 0x4d4;
   static final int KEYSYM_kana_YU = 0x4d5;
   static final int KEYSYM_kana_YO = 0x4d6;
   static final int KEYSYM_kana_RA = 0x4d7;
   static final int KEYSYM_kana_RI = 0x4d8;
   static final int KEYSYM_kana_RU = 0x4d9;
   static final int KEYSYM_kana_RE = 0x4da;
   static final int KEYSYM_kana_RO = 0x4db;
   static final int KEYSYM_kana_WA = 0x4dc;
   static final int KEYSYM_kana_N = 0x4dd;
   static final int KEYSYM_voicedsound = 0x4de;
   static final int KEYSYM_semivoicedsound = 0x4df;
   static final int KEYSYM_kana_switch = 0xFF7E;
   static final int KEYSYM_Arabic_comma = 0x5ac;
   static final int KEYSYM_Arabic_semicolon = 0x5bb;
   static final int KEYSYM_Arabic_question_mark = 0x5bf;
   static final int KEYSYM_Arabic_hamza = 0x5c1;
   static final int KEYSYM_Arabic_maddaonalef = 0x5c2;
   static final int KEYSYM_Arabic_hamzaonalef = 0x5c3;
   static final int KEYSYM_Arabic_hamzaonwaw = 0x5c4;
   static final int KEYSYM_Arabic_hamzaunderalef = 0x5c5;
   static final int KEYSYM_Arabic_hamzaonyeh = 0x5c6;
   static final int KEYSYM_Arabic_alef = 0x5c7;
   static final int KEYSYM_Arabic_beh = 0x5c8;
   static final int KEYSYM_Arabic_tehmarbuta = 0x5c9;
   static final int KEYSYM_Arabic_teh = 0x5ca;
   static final int KEYSYM_Arabic_theh = 0x5cb;
   static final int KEYSYM_Arabic_jeem = 0x5cc;
   static final int KEYSYM_Arabic_hah = 0x5cd;
   static final int KEYSYM_Arabic_khah = 0x5ce;
   static final int KEYSYM_Arabic_dal = 0x5cf;
   static final int KEYSYM_Arabic_thal = 0x5d0;
   static final int KEYSYM_Arabic_ra = 0x5d1;
   static final int KEYSYM_Arabic_zain = 0x5d2;
   static final int KEYSYM_Arabic_seen = 0x5d3;
   static final int KEYSYM_Arabic_sheen = 0x5d4;
   static final int KEYSYM_Arabic_sad = 0x5d5;
   static final int KEYSYM_Arabic_dad = 0x5d6;
   static final int KEYSYM_Arabic_tah = 0x5d7;
   static final int KEYSYM_Arabic_zah = 0x5d8;
   static final int KEYSYM_Arabic_ain = 0x5d9;
   static final int KEYSYM_Arabic_ghain = 0x5da;
   static final int KEYSYM_Arabic_tatweel = 0x5e0;
   static final int KEYSYM_Arabic_feh = 0x5e1;
   static final int KEYSYM_Arabic_qaf = 0x5e2;
   static final int KEYSYM_Arabic_kaf = 0x5e3;
   static final int KEYSYM_Arabic_lam = 0x5e4;
   static final int KEYSYM_Arabic_meem = 0x5e5;
   static final int KEYSYM_Arabic_noon = 0x5e6;
   static final int KEYSYM_Arabic_ha = 0x5e7;
   static final int KEYSYM_Arabic_heh = 0x5e7;
   static final int KEYSYM_Arabic_waw = 0x5e8;
   static final int KEYSYM_Arabic_alefmaksura = 0x5e9;
   static final int KEYSYM_Arabic_yeh = 0x5ea;
   static final int KEYSYM_Arabic_fathatan = 0x5eb;
   static final int KEYSYM_Arabic_dammatan = 0x5ec;
   static final int KEYSYM_Arabic_kasratan = 0x5ed;
   static final int KEYSYM_Arabic_fatha = 0x5ee;
   static final int KEYSYM_Arabic_damma = 0x5ef;
   static final int KEYSYM_Arabic_kasra = 0x5f0;
   static final int KEYSYM_Arabic_shadda = 0x5f1;
   static final int KEYSYM_Arabic_sukun = 0x5f2;
   static final int KEYSYM_Arabic_switch = 0xFF7E;
   static final int KEYSYM_Serbian_dje = 0x6a1;
   static final int KEYSYM_Macedonia_gje = 0x6a2;
   static final int KEYSYM_Cyrillic_io = 0x6a3;
   static final int KEYSYM_Ukrainian_ie = 0x6a4;
   static final int KEYSYM_Ukranian_je = 0x6a4;
   static final int KEYSYM_Macedonia_dse = 0x6a5;
   static final int KEYSYM_Ukrainian_i = 0x6a6;
   static final int KEYSYM_Ukranian_i = 0x6a6;
   static final int KEYSYM_Ukrainian_yi = 0x6a7;
   static final int KEYSYM_Ukranian_yi = 0x6a7;
   static final int KEYSYM_Cyrillic_je = 0x6a8;
   static final int KEYSYM_Serbian_je = 0x6a8;
   static final int KEYSYM_Cyrillic_lje = 0x6a9;
   static final int KEYSYM_Serbian_lje = 0x6a9;
   static final int KEYSYM_Cyrillic_nje = 0x6aa;
   static final int KEYSYM_Serbian_nje = 0x6aa;
   static final int KEYSYM_Serbian_tshe = 0x6ab;
   static final int KEYSYM_Macedonia_kje = 0x6ac;
   static final int KEYSYM_Byelorussian_shortu = 0x6ae;
   static final int KEYSYM_Cyrillic_dzhe = 0x6af;
   static final int KEYSYM_Serbian_dze = 0x6af;
   static final int KEYSYM_numerosign = 0x6b0;
   static final int KEYSYM_Serbian_DJE = 0x6b1;
   static final int KEYSYM_Macedonia_GJE = 0x6b2;
   static final int KEYSYM_Cyrillic_IO = 0x6b3;
   static final int KEYSYM_Ukrainian_IE = 0x6b4;
   static final int KEYSYM_Ukranian_JE = 0x6b4;
   static final int KEYSYM_Macedonia_DSE = 0x6b5;
   static final int KEYSYM_Ukrainian_I = 0x6b6;
   static final int KEYSYM_Ukranian_I = 0x6b6;
   static final int KEYSYM_Ukrainian_YI = 0x6b7;
   static final int KEYSYM_Ukranian_YI = 0x6b7;
   static final int KEYSYM_Cyrillic_JE = 0x6b8;
   static final int KEYSYM_Serbian_JE = 0x6b8;
   static final int KEYSYM_Cyrillic_LJE = 0x6b9;
   static final int KEYSYM_Serbian_LJE = 0x6b9;
   static final int KEYSYM_Cyrillic_NJE = 0x6ba;
   static final int KEYSYM_Serbian_NJE = 0x6ba;
   static final int KEYSYM_Serbian_TSHE = 0x6bb;
   static final int KEYSYM_Macedonia_KJE = 0x6bc;
   static final int KEYSYM_Byelorussian_SHORTU = 0x6be;
   static final int KEYSYM_Cyrillic_DZHE = 0x6bf;
   static final int KEYSYM_Serbian_DZE = 0x6bf;
   static final int KEYSYM_Cyrillic_yu = 0x6c0;
   static final int KEYSYM_Cyrillic_a = 0x6c1;
   static final int KEYSYM_Cyrillic_be = 0x6c2;
   static final int KEYSYM_Cyrillic_tse = 0x6c3;
   static final int KEYSYM_Cyrillic_de = 0x6c4;
   static final int KEYSYM_Cyrillic_ie = 0x6c5;
   static final int KEYSYM_Cyrillic_ef = 0x6c6;
   static final int KEYSYM_Cyrillic_ghe = 0x6c7;
   static final int KEYSYM_Cyrillic_ha = 0x6c8;
   static final int KEYSYM_Cyrillic_i = 0x6c9;
   static final int KEYSYM_Cyrillic_shorti = 0x6ca;
   static final int KEYSYM_Cyrillic_ka = 0x6cb;
   static final int KEYSYM_Cyrillic_el = 0x6cc;
   static final int KEYSYM_Cyrillic_em = 0x6cd;
   static final int KEYSYM_Cyrillic_en = 0x6ce;
   static final int KEYSYM_Cyrillic_o = 0x6cf;
   static final int KEYSYM_Cyrillic_pe = 0x6d0;
   static final int KEYSYM_Cyrillic_ya = 0x6d1;
   static final int KEYSYM_Cyrillic_er = 0x6d2;
   static final int KEYSYM_Cyrillic_es = 0x6d3;
   static final int KEYSYM_Cyrillic_te = 0x6d4;
   static final int KEYSYM_Cyrillic_u = 0x6d5;
   static final int KEYSYM_Cyrillic_zhe = 0x6d6;
   static final int KEYSYM_Cyrillic_ve = 0x6d7;
   static final int KEYSYM_Cyrillic_softsign = 0x6d8;
   static final int KEYSYM_Cyrillic_yeru = 0x6d9;
   static final int KEYSYM_Cyrillic_ze = 0x6da;
   static final int KEYSYM_Cyrillic_sha = 0x6db;
   static final int KEYSYM_Cyrillic_e = 0x6dc;
   static final int KEYSYM_Cyrillic_shcha = 0x6dd;
   static final int KEYSYM_Cyrillic_che = 0x6de;
   static final int KEYSYM_Cyrillic_hardsign = 0x6df;
   static final int KEYSYM_Cyrillic_YU = 0x6e0;
   static final int KEYSYM_Cyrillic_A = 0x6e1;
   static final int KEYSYM_Cyrillic_BE = 0x6e2;
   static final int KEYSYM_Cyrillic_TSE = 0x6e3;
   static final int KEYSYM_Cyrillic_DE = 0x6e4;
   static final int KEYSYM_Cyrillic_IE = 0x6e5;
   static final int KEYSYM_Cyrillic_EF = 0x6e6;
   static final int KEYSYM_Cyrillic_GHE = 0x6e7;
   static final int KEYSYM_Cyrillic_HA = 0x6e8;
   static final int KEYSYM_Cyrillic_I = 0x6e9;
   static final int KEYSYM_Cyrillic_SHORTI = 0x6ea;
   static final int KEYSYM_Cyrillic_KA = 0x6eb;
   static final int KEYSYM_Cyrillic_EL = 0x6ec;
   static final int KEYSYM_Cyrillic_EM = 0x6ed;
   static final int KEYSYM_Cyrillic_EN = 0x6ee;
   static final int KEYSYM_Cyrillic_O = 0x6ef;
   static final int KEYSYM_Cyrillic_PE = 0x6f0;
   static final int KEYSYM_Cyrillic_YA = 0x6f1;
   static final int KEYSYM_Cyrillic_ER = 0x6f2;
   static final int KEYSYM_Cyrillic_ES = 0x6f3;
   static final int KEYSYM_Cyrillic_TE = 0x6f4;
   static final int KEYSYM_Cyrillic_U = 0x6f5;
   static final int KEYSYM_Cyrillic_ZHE = 0x6f6;
   static final int KEYSYM_Cyrillic_VE = 0x6f7;
   static final int KEYSYM_Cyrillic_SOFTSIGN = 0x6f8;
   static final int KEYSYM_Cyrillic_YERU = 0x6f9;
   static final int KEYSYM_Cyrillic_ZE = 0x6fa;
   static final int KEYSYM_Cyrillic_SHA = 0x6fb;
   static final int KEYSYM_Cyrillic_E = 0x6fc;
   static final int KEYSYM_Cyrillic_SHCHA = 0x6fd;
   static final int KEYSYM_Cyrillic_CHE = 0x6fe;
   static final int KEYSYM_Cyrillic_HARDSIGN = 0x6ff;
   static final int KEYSYM_Greek_ALPHAaccent = 0x7a1;
   static final int KEYSYM_Greek_EPSILONaccent = 0x7a2;
   static final int KEYSYM_Greek_ETAaccent = 0x7a3;
   static final int KEYSYM_Greek_IOTAaccent = 0x7a4;
   static final int KEYSYM_Greek_IOTAdiaeresis = 0x7a5;
   static final int KEYSYM_Greek_OMICRONaccent = 0x7a7;
   static final int KEYSYM_Greek_UPSILONaccent = 0x7a8;
   static final int KEYSYM_Greek_UPSILONdieresis = 0x7a9;
   static final int KEYSYM_Greek_OMEGAaccent = 0x7ab;
   static final int KEYSYM_Greek_accentdieresis = 0x7ae;
   static final int KEYSYM_Greek_horizbar = 0x7af;
   static final int KEYSYM_Greek_alphaaccent = 0x7b1;
   static final int KEYSYM_Greek_epsilonaccent = 0x7b2;
   static final int KEYSYM_Greek_etaaccent = 0x7b3;
   static final int KEYSYM_Greek_iotaaccent = 0x7b4;
   static final int KEYSYM_Greek_iotadieresis = 0x7b5;
   static final int KEYSYM_Greek_iotaaccentdieresis = 0x7b6;
   static final int KEYSYM_Greek_omicronaccent = 0x7b7;
   static final int KEYSYM_Greek_upsilonaccent = 0x7b8;
   static final int KEYSYM_Greek_upsilondieresis = 0x7b9;
   static final int KEYSYM_Greek_upsilonaccentdieresis = 0x7ba;
   static final int KEYSYM_Greek_omegaaccent = 0x7bb;
   static final int KEYSYM_Greek_ALPHA = 0x7c1;
   static final int KEYSYM_Greek_BETA = 0x7c2;
   static final int KEYSYM_Greek_GAMMA = 0x7c3;
   static final int KEYSYM_Greek_DELTA = 0x7c4;
   static final int KEYSYM_Greek_EPSILON = 0x7c5;
   static final int KEYSYM_Greek_ZETA = 0x7c6;
   static final int KEYSYM_Greek_ETA = 0x7c7;
   static final int KEYSYM_Greek_THETA = 0x7c8;
   static final int KEYSYM_Greek_IOTA = 0x7c9;
   static final int KEYSYM_Greek_KAPPA = 0x7ca;
   static final int KEYSYM_Greek_LAMDA = 0x7cb;
   static final int KEYSYM_Greek_LAMBDA = 0x7cb;
   static final int KEYSYM_Greek_MU = 0x7cc;
   static final int KEYSYM_Greek_NU = 0x7cd;
   static final int KEYSYM_Greek_XI = 0x7ce;
   static final int KEYSYM_Greek_OMICRON = 0x7cf;
   static final int KEYSYM_Greek_PI = 0x7d0;
   static final int KEYSYM_Greek_RHO = 0x7d1;
   static final int KEYSYM_Greek_SIGMA = 0x7d2;
   static final int KEYSYM_Greek_TAU = 0x7d4;
   static final int KEYSYM_Greek_UPSILON = 0x7d5;
   static final int KEYSYM_Greek_PHI = 0x7d6;
   static final int KEYSYM_Greek_CHI = 0x7d7;
   static final int KEYSYM_Greek_PSI = 0x7d8;
   static final int KEYSYM_Greek_OMEGA = 0x7d9;
   static final int KEYSYM_Greek_alpha = 0x7e1;
   static final int KEYSYM_Greek_beta = 0x7e2;
   static final int KEYSYM_Greek_gamma = 0x7e3;
   static final int KEYSYM_Greek_delta = 0x7e4;
   static final int KEYSYM_Greek_epsilon = 0x7e5;
   static final int KEYSYM_Greek_zeta = 0x7e6;
   static final int KEYSYM_Greek_eta = 0x7e7;
   static final int KEYSYM_Greek_theta = 0x7e8;
   static final int KEYSYM_Greek_iota = 0x7e9;
   static final int KEYSYM_Greek_kappa = 0x7ea;
   static final int KEYSYM_Greek_lamda = 0x7eb;
   static final int KEYSYM_Greek_lambda = 0x7eb;
   static final int KEYSYM_Greek_mu = 0x7ec;
   static final int KEYSYM_Greek_nu = 0x7ed;
   static final int KEYSYM_Greek_xi = 0x7ee;
   static final int KEYSYM_Greek_omicron = 0x7ef;
   static final int KEYSYM_Greek_pi = 0x7f0;
   static final int KEYSYM_Greek_rho = 0x7f1;
   static final int KEYSYM_Greek_sigma = 0x7f2;
   static final int KEYSYM_Greek_finalsmallsigma = 0x7f3;
   static final int KEYSYM_Greek_tau = 0x7f4;
   static final int KEYSYM_Greek_upsilon = 0x7f5;
   static final int KEYSYM_Greek_phi = 0x7f6;
   static final int KEYSYM_Greek_chi = 0x7f7;
   static final int KEYSYM_Greek_psi = 0x7f8;
   static final int KEYSYM_Greek_omega = 0x7f9;
   static final int KEYSYM_Greek_switch = 0xFF7E;
   static final int KEYSYM_leftradical = 0x8a1;
   static final int KEYSYM_topleftradical = 0x8a2;
   static final int KEYSYM_horizconnector = 0x8a3;
   static final int KEYSYM_topintegral = 0x8a4;
   static final int KEYSYM_botintegral = 0x8a5;
   static final int KEYSYM_vertconnector = 0x8a6;
   static final int KEYSYM_topleftsqbracket = 0x8a7;
   static final int KEYSYM_botleftsqbracket = 0x8a8;
   static final int KEYSYM_toprightsqbracket = 0x8a9;
   static final int KEYSYM_botrightsqbracket = 0x8aa;
   static final int KEYSYM_topleftparens = 0x8ab;
   static final int KEYSYM_botleftparens = 0x8ac;
   static final int KEYSYM_toprightparens = 0x8ad;
   static final int KEYSYM_botrightparens = 0x8ae;
   static final int KEYSYM_leftmiddlecurlybrace = 0x8af;
   static final int KEYSYM_rightmiddlecurlybrace = 0x8b0;
   static final int KEYSYM_topleftsummation = 0x8b1;
   static final int KEYSYM_botleftsummation = 0x8b2;
   static final int KEYSYM_topvertsummationconnector = 0x8b3;
   static final int KEYSYM_botvertsummationconnector = 0x8b4;
   static final int KEYSYM_toprightsummation = 0x8b5;
   static final int KEYSYM_botrightsummation = 0x8b6;
   static final int KEYSYM_rightmiddlesummation = 0x8b7;
   static final int KEYSYM_lessthanequal = 0x8bc;
   static final int KEYSYM_notequal = 0x8bd;
   static final int KEYSYM_greaterthanequal = 0x8be;
   static final int KEYSYM_integral = 0x8bf;
   static final int KEYSYM_therefore = 0x8c0;
   static final int KEYSYM_variation = 0x8c1;
   static final int KEYSYM_infinity = 0x8c2;
   static final int KEYSYM_nabla = 0x8c5;
   static final int KEYSYM_approximate = 0x8c8;
   static final int KEYSYM_similarequal = 0x8c9;
   static final int KEYSYM_ifonlyif = 0x8cd;
   static final int KEYSYM_implies = 0x8ce;
   static final int KEYSYM_identical = 0x8cf;
   static final int KEYSYM_radical = 0x8d6;
   static final int KEYSYM_includedin = 0x8da;
   static final int KEYSYM_includes = 0x8db;
   static final int KEYSYM_intersection = 0x8dc;
   static final int KEYSYM_union = 0x8dd;
   static final int KEYSYM_logicaland = 0x8de;
   static final int KEYSYM_logicalor = 0x8df;
   static final int KEYSYM_partialderivative = 0x8ef;
   static final int KEYSYM_function = 0x8f6;
   static final int KEYSYM_leftarrow = 0x8fb;
   static final int KEYSYM_uparrow = 0x8fc;
   static final int KEYSYM_rightarrow = 0x8fd;
   static final int KEYSYM_downarrow = 0x8fe;
   static final int KEYSYM_blank = 0x9df;
   static final int KEYSYM_soliddiamond = 0x9e0;
   static final int KEYSYM_checkerboard = 0x9e1;
   static final int KEYSYM_ht = 0x9e2;
   static final int KEYSYM_ff = 0x9e3;
   static final int KEYSYM_cr = 0x9e4;
   static final int KEYSYM_lf = 0x9e5;
   static final int KEYSYM_nl = 0x9e8;
   static final int KEYSYM_vt = 0x9e9;
   static final int KEYSYM_lowrightcorner = 0x9ea;
   static final int KEYSYM_uprightcorner = 0x9eb;
   static final int KEYSYM_upleftcorner = 0x9ec;
   static final int KEYSYM_lowleftcorner = 0x9ed;
   static final int KEYSYM_crossinglines = 0x9ee;
   static final int KEYSYM_horizlinescan1 = 0x9ef;
   static final int KEYSYM_horizlinescan3 = 0x9f0;
   static final int KEYSYM_horizlinescan5 = 0x9f1;
   static final int KEYSYM_horizlinescan7 = 0x9f2;
   static final int KEYSYM_horizlinescan9 = 0x9f3;
   static final int KEYSYM_leftt = 0x9f4;
   static final int KEYSYM_rightt = 0x9f5;
   static final int KEYSYM_bott = 0x9f6;
   static final int KEYSYM_topt = 0x9f7;
   static final int KEYSYM_vertbar = 0x9f8;
   static final int KEYSYM_emspace = 0xaa1;
   static final int KEYSYM_enspace = 0xaa2;
   static final int KEYSYM_em3space = 0xaa3;
   static final int KEYSYM_em4space = 0xaa4;
   static final int KEYSYM_digitspace = 0xaa5;
   static final int KEYSYM_punctspace = 0xaa6;
   static final int KEYSYM_thinspace = 0xaa7;
   static final int KEYSYM_hairspace = 0xaa8;
   static final int KEYSYM_emdash = 0xaa9;
   static final int KEYSYM_endash = 0xaaa;
   static final int KEYSYM_signifblank = 0xaac;
   static final int KEYSYM_ellipsis = 0xaae;
   static final int KEYSYM_doubbaselinedot = 0xaaf;
   static final int KEYSYM_onethird = 0xab0;
   static final int KEYSYM_twothirds = 0xab1;
   static final int KEYSYM_onefifth = 0xab2;
   static final int KEYSYM_twofifths = 0xab3;
   static final int KEYSYM_threefifths = 0xab4;
   static final int KEYSYM_fourfifths = 0xab5;
   static final int KEYSYM_onesixth = 0xab6;
   static final int KEYSYM_fivesixths = 0xab7;
   static final int KEYSYM_careof = 0xab8;
   static final int KEYSYM_figdash = 0xabb;
   static final int KEYSYM_leftanglebracket = 0xabc;
   static final int KEYSYM_decimalpoint = 0xabd;
   static final int KEYSYM_rightanglebracket = 0xabe;
   static final int KEYSYM_marker = 0xabf;
   static final int KEYSYM_oneeighth = 0xac3;
   static final int KEYSYM_threeeighths = 0xac4;
   static final int KEYSYM_fiveeighths = 0xac5;
   static final int KEYSYM_seveneighths = 0xac6;
   static final int KEYSYM_trademark = 0xac9;
   static final int KEYSYM_signaturemark = 0xaca;
   static final int KEYSYM_trademarkincircle = 0xacb;
   static final int KEYSYM_leftopentriangle = 0xacc;
   static final int KEYSYM_rightopentriangle = 0xacd;
   static final int KEYSYM_emopencircle = 0xace;
   static final int KEYSYM_emopenrectangle = 0xacf;
   static final int KEYSYM_leftsinglequotemark = 0xad0;
   static final int KEYSYM_rightsinglequotemark = 0xad1;
   static final int KEYSYM_leftdoublequotemark = 0xad2;
   static final int KEYSYM_rightdoublequotemark = 0xad3;
   static final int KEYSYM_prescription = 0xad4;
   static final int KEYSYM_minutes = 0xad6;
   static final int KEYSYM_seconds = 0xad7;
   static final int KEYSYM_latincross = 0xad9;
   static final int KEYSYM_hexagram = 0xada;
   static final int KEYSYM_filledrectbullet = 0xadb;
   static final int KEYSYM_filledlefttribullet = 0xadc;
   static final int KEYSYM_filledrighttribullet = 0xadd;
   static final int KEYSYM_emfilledcircle = 0xade;
   static final int KEYSYM_emfilledrect = 0xadf;
   static final int KEYSYM_enopencircbullet = 0xae0;
   static final int KEYSYM_enopensquarebullet = 0xae1;
   static final int KEYSYM_openrectbullet = 0xae2;
   static final int KEYSYM_opentribulletup = 0xae3;
   static final int KEYSYM_opentribulletdown = 0xae4;
   static final int KEYSYM_openstar = 0xae5;
   static final int KEYSYM_enfilledcircbullet = 0xae6;
   static final int KEYSYM_enfilledsqbullet = 0xae7;
   static final int KEYSYM_filledtribulletup = 0xae8;
   static final int KEYSYM_filledtribulletdown = 0xae9;
   static final int KEYSYM_leftpointer = 0xaea;
   static final int KEYSYM_rightpointer = 0xaeb;
   static final int KEYSYM_club = 0xaec;
   static final int KEYSYM_diamond = 0xaed;
   static final int KEYSYM_heart = 0xaee;
   static final int KEYSYM_maltesecross = 0xaf0;
   static final int KEYSYM_dagger = 0xaf1;
   static final int KEYSYM_doubledagger = 0xaf2;
   static final int KEYSYM_checkmark = 0xaf3;
   static final int KEYSYM_ballotcross = 0xaf4;
   static final int KEYSYM_musicalsharp = 0xaf5;
   static final int KEYSYM_musicalflat = 0xaf6;
   static final int KEYSYM_malesymbol = 0xaf7;
   static final int KEYSYM_femalesymbol = 0xaf8;
   static final int KEYSYM_telephone = 0xaf9;
   static final int KEYSYM_telephonerecorder = 0xafa;
   static final int KEYSYM_phonographcopyright = 0xafb;
   static final int KEYSYM_caret = 0xafc;
   static final int KEYSYM_singlelowquotemark = 0xafd;
   static final int KEYSYM_doublelowquotemark = 0xafe;
   static final int KEYSYM_cursor = 0xaff;
   static final int KEYSYM_leftcaret = 0xba3;
   static final int KEYSYM_rightcaret = 0xba6;
   static final int KEYSYM_downcaret = 0xba8;
   static final int KEYSYM_upcaret = 0xba9;
   static final int KEYSYM_overbar = 0xbc0;
   static final int KEYSYM_downtack = 0xbc2;
   static final int KEYSYM_upshoe = 0xbc3;
   static final int KEYSYM_downstile = 0xbc4;
   static final int KEYSYM_underbar = 0xbc6;
   static final int KEYSYM_jot = 0xbca;
   static final int KEYSYM_quad = 0xbcc;
   static final int KEYSYM_uptack = 0xbce;
   static final int KEYSYM_circle = 0xbcf;
   static final int KEYSYM_upstile = 0xbd3;
   static final int KEYSYM_downshoe = 0xbd6;
   static final int KEYSYM_rightshoe = 0xbd8;
   static final int KEYSYM_leftshoe = 0xbda;
   static final int KEYSYM_lefttack = 0xbdc;
   static final int KEYSYM_righttack = 0xbfc;
   static final int KEYSYM_hebrew_doublelowline = 0xcdf;
   static final int KEYSYM_hebrew_aleph = 0xce0;
   static final int KEYSYM_hebrew_bet = 0xce1;
   static final int KEYSYM_hebrew_beth = 0xce1;
   static final int KEYSYM_hebrew_gimel = 0xce2;
   static final int KEYSYM_hebrew_gimmel = 0xce2;
   static final int KEYSYM_hebrew_dalet = 0xce3;
   static final int KEYSYM_hebrew_daleth = 0xce3;
   static final int KEYSYM_hebrew_he = 0xce4;
   static final int KEYSYM_hebrew_waw = 0xce5;
   static final int KEYSYM_hebrew_zain = 0xce6;
   static final int KEYSYM_hebrew_zayin = 0xce6;
   static final int KEYSYM_hebrew_chet = 0xce7;
   static final int KEYSYM_hebrew_het = 0xce7;
   static final int KEYSYM_hebrew_tet = 0xce8;
   static final int KEYSYM_hebrew_teth = 0xce8;
   static final int KEYSYM_hebrew_yod = 0xce9;
   static final int KEYSYM_hebrew_finalkaph = 0xcea;
   static final int KEYSYM_hebrew_kaph = 0xceb;
   static final int KEYSYM_hebrew_lamed = 0xcec;
   static final int KEYSYM_hebrew_finalmem = 0xced;
   static final int KEYSYM_hebrew_mem = 0xcee;
   static final int KEYSYM_hebrew_finalnun = 0xcef;
   static final int KEYSYM_hebrew_nun = 0xcf0;
   static final int KEYSYM_hebrew_samech = 0xcf1;
   static final int KEYSYM_hebrew_samekh = 0xcf1;
   static final int KEYSYM_hebrew_ayin = 0xcf2;
   static final int KEYSYM_hebrew_finalpe = 0xcf3;
   static final int KEYSYM_hebrew_pe = 0xcf4;
   static final int KEYSYM_hebrew_finalzade = 0xcf5;
   static final int KEYSYM_hebrew_finalzadi = 0xcf5;
   static final int KEYSYM_hebrew_zade = 0xcf6;
   static final int KEYSYM_hebrew_zadi = 0xcf6;
   static final int KEYSYM_hebrew_qoph = 0xcf7;
   static final int KEYSYM_hebrew_kuf = 0xcf7;
   static final int KEYSYM_hebrew_resh = 0xcf8;
   static final int KEYSYM_hebrew_shin = 0xcf9;
   static final int KEYSYM_hebrew_taw = 0xcfa;
   static final int KEYSYM_hebrew_taf = 0xcfa;
   static final int KEYSYM_Hebrew_switch = 0xFF7E;
   static final int KEYSYM_Thai_kokai = 0xda1;
   static final int KEYSYM_Thai_khokhai = 0xda2;
   static final int KEYSYM_Thai_khokhuat = 0xda3;
   static final int KEYSYM_Thai_khokhwai = 0xda4;
   static final int KEYSYM_Thai_khokhon = 0xda5;
   static final int KEYSYM_Thai_khorakhang = 0xda6;
   static final int KEYSYM_Thai_ngongu = 0xda7;
   static final int KEYSYM_Thai_chochan = 0xda8;
   static final int KEYSYM_Thai_choching = 0xda9;
   static final int KEYSYM_Thai_chochang = 0xdaa;
   static final int KEYSYM_Thai_soso = 0xdab;
   static final int KEYSYM_Thai_chochoe = 0xdac;
   static final int KEYSYM_Thai_yoying = 0xdad;
   static final int KEYSYM_Thai_dochada = 0xdae;
   static final int KEYSYM_Thai_topatak = 0xdaf;
   static final int KEYSYM_Thai_thothan = 0xdb0;
   static final int KEYSYM_Thai_thonangmontho = 0xdb1;
   static final int KEYSYM_Thai_thophuthao = 0xdb2;
   static final int KEYSYM_Thai_nonen = 0xdb3;
   static final int KEYSYM_Thai_dodek = 0xdb4;
   static final int KEYSYM_Thai_totao = 0xdb5;
   static final int KEYSYM_Thai_thothung = 0xdb6;
   static final int KEYSYM_Thai_thothahan = 0xdb7;
   static final int KEYSYM_Thai_thothong = 0xdb8;
   static final int KEYSYM_Thai_nonu = 0xdb9;
   static final int KEYSYM_Thai_bobaimai = 0xdba;
   static final int KEYSYM_Thai_popla = 0xdbb;
   static final int KEYSYM_Thai_phophung = 0xdbc;
   static final int KEYSYM_Thai_fofa = 0xdbd;
   static final int KEYSYM_Thai_phophan = 0xdbe;
   static final int KEYSYM_Thai_fofan = 0xdbf;
   static final int KEYSYM_Thai_phosamphao = 0xdc0;
   static final int KEYSYM_Thai_moma = 0xdc1;
   static final int KEYSYM_Thai_yoyak = 0xdc2;
   static final int KEYSYM_Thai_rorua = 0xdc3;
   static final int KEYSYM_Thai_ru = 0xdc4;
   static final int KEYSYM_Thai_loling = 0xdc5;
   static final int KEYSYM_Thai_lu = 0xdc6;
   static final int KEYSYM_Thai_wowaen = 0xdc7;
   static final int KEYSYM_Thai_sosala = 0xdc8;
   static final int KEYSYM_Thai_sorusi = 0xdc9;
   static final int KEYSYM_Thai_sosua = 0xdca;
   static final int KEYSYM_Thai_hohip = 0xdcb;
   static final int KEYSYM_Thai_lochula = 0xdcc;
   static final int KEYSYM_Thai_oang = 0xdcd;
   static final int KEYSYM_Thai_honokhuk = 0xdce;
   static final int KEYSYM_Thai_paiyannoi = 0xdcf;
   static final int KEYSYM_Thai_saraa = 0xdd0;
   static final int KEYSYM_Thai_maihanakat = 0xdd1;
   static final int KEYSYM_Thai_saraaa = 0xdd2;
   static final int KEYSYM_Thai_saraam = 0xdd3;
   static final int KEYSYM_Thai_sarai = 0xdd4;
   static final int KEYSYM_Thai_saraii = 0xdd5;
   static final int KEYSYM_Thai_saraue = 0xdd6;
   static final int KEYSYM_Thai_sarauee = 0xdd7;
   static final int KEYSYM_Thai_sarau = 0xdd8;
   static final int KEYSYM_Thai_sarauu = 0xdd9;
   static final int KEYSYM_Thai_phinthu = 0xdda;
   static final int KEYSYM_Thai_maihanakat_maitho = 0xdde;
   static final int KEYSYM_Thai_baht = 0xddf;
   static final int KEYSYM_Thai_sarae = 0xde0;
   static final int KEYSYM_Thai_saraae = 0xde1;
   static final int KEYSYM_Thai_sarao = 0xde2;
   static final int KEYSYM_Thai_saraaimaimuan = 0xde3;
   static final int KEYSYM_Thai_saraaimaimalai = 0xde4;
   static final int KEYSYM_Thai_lakkhangyao = 0xde5;
   static final int KEYSYM_Thai_maiyamok = 0xde6;
   static final int KEYSYM_Thai_maitaikhu = 0xde7;
   static final int KEYSYM_Thai_maiek = 0xde8;
   static final int KEYSYM_Thai_maitho = 0xde9;
   static final int KEYSYM_Thai_maitri = 0xdea;
   static final int KEYSYM_Thai_maichattawa = 0xdeb;
   static final int KEYSYM_Thai_thanthakhat = 0xdec;
   static final int KEYSYM_Thai_nikhahit = 0xded;
   static final int KEYSYM_Thai_leksun = 0xdf0;
   static final int KEYSYM_Thai_leknung = 0xdf1;
   static final int KEYSYM_Thai_leksong = 0xdf2;
   static final int KEYSYM_Thai_leksam = 0xdf3;
   static final int KEYSYM_Thai_leksi = 0xdf4;
   static final int KEYSYM_Thai_lekha = 0xdf5;
   static final int KEYSYM_Thai_lekhok = 0xdf6;
   static final int KEYSYM_Thai_lekchet = 0xdf7;
   static final int KEYSYM_Thai_lekpaet = 0xdf8;
   static final int KEYSYM_Thai_lekkao = 0xdf9;
   static final int KEYSYM_Hangul = 0xff31;
   static final int KEYSYM_Hangul_Start = 0xff32;
   static final int KEYSYM_Hangul_End = 0xff33;
   static final int KEYSYM_Hangul_Hanja = 0xff34;
   static final int KEYSYM_Hangul_Jamo = 0xff35;
   static final int KEYSYM_Hangul_Romaja = 0xff36;
   static final int KEYSYM_Hangul_Codeinput = 0xff37;
   static final int KEYSYM_Hangul_Jeonja = 0xff38;
   static final int KEYSYM_Hangul_Banja = 0xff39;
   static final int KEYSYM_Hangul_PreHanja = 0xff3a;
   static final int KEYSYM_Hangul_PostHanja = 0xff3b;
   static final int KEYSYM_Hangul_SingleCandidate = 0xff3c;
   static final int KEYSYM_Hangul_MultipleCandidate = 0xff3d;
   static final int KEYSYM_Hangul_PreviousCandidate = 0xff3e;
   static final int KEYSYM_Hangul_Special = 0xff3f;
   static final int KEYSYM_Hangul_switch = 0xFF7E;
   static final int KEYSYM_Hangul_Kiyeog = 0xea1;
   static final int KEYSYM_Hangul_SsangKiyeog = 0xea2;
   static final int KEYSYM_Hangul_KiyeogSios = 0xea3;
   static final int KEYSYM_Hangul_Nieun = 0xea4;
   static final int KEYSYM_Hangul_NieunJieuj = 0xea5;
   static final int KEYSYM_Hangul_NieunHieuh = 0xea6;
   static final int KEYSYM_Hangul_Dikeud = 0xea7;
   static final int KEYSYM_Hangul_SsangDikeud = 0xea8;
   static final int KEYSYM_Hangul_Rieul = 0xea9;
   static final int KEYSYM_Hangul_RieulKiyeog = 0xeaa;
   static final int KEYSYM_Hangul_RieulMieum = 0xeab;
   static final int KEYSYM_Hangul_RieulPieub = 0xeac;
   static final int KEYSYM_Hangul_RieulSios = 0xead;
   static final int KEYSYM_Hangul_RieulTieut = 0xeae;
   static final int KEYSYM_Hangul_RieulPhieuf = 0xeaf;
   static final int KEYSYM_Hangul_RieulHieuh = 0xeb0;
   static final int KEYSYM_Hangul_Mieum = 0xeb1;
   static final int KEYSYM_Hangul_Pieub = 0xeb2;
   static final int KEYSYM_Hangul_SsangPieub = 0xeb3;
   static final int KEYSYM_Hangul_PieubSios = 0xeb4;
   static final int KEYSYM_Hangul_Sios = 0xeb5;
   static final int KEYSYM_Hangul_SsangSios = 0xeb6;
   static final int KEYSYM_Hangul_Ieung = 0xeb7;
   static final int KEYSYM_Hangul_Jieuj = 0xeb8;
   static final int KEYSYM_Hangul_SsangJieuj = 0xeb9;
   static final int KEYSYM_Hangul_Cieuc = 0xeba;
   static final int KEYSYM_Hangul_Khieuq = 0xebb;
   static final int KEYSYM_Hangul_Tieut = 0xebc;
   static final int KEYSYM_Hangul_Phieuf = 0xebd;
   static final int KEYSYM_Hangul_Hieuh = 0xebe;
   static final int KEYSYM_Hangul_A = 0xebf;
   static final int KEYSYM_Hangul_AE = 0xec0;
   static final int KEYSYM_Hangul_YA = 0xec1;
   static final int KEYSYM_Hangul_YAE = 0xec2;
   static final int KEYSYM_Hangul_EO = 0xec3;
   static final int KEYSYM_Hangul_E = 0xec4;
   static final int KEYSYM_Hangul_YEO = 0xec5;
   static final int KEYSYM_Hangul_YE = 0xec6;
   static final int KEYSYM_Hangul_O = 0xec7;
   static final int KEYSYM_Hangul_WA = 0xec8;
   static final int KEYSYM_Hangul_WAE = 0xec9;
   static final int KEYSYM_Hangul_OE = 0xeca;
   static final int KEYSYM_Hangul_YO = 0xecb;
   static final int KEYSYM_Hangul_U = 0xecc;
   static final int KEYSYM_Hangul_WEO = 0xecd;
   static final int KEYSYM_Hangul_WE = 0xece;
   static final int KEYSYM_Hangul_WI = 0xecf;
   static final int KEYSYM_Hangul_YU = 0xed0;
   static final int KEYSYM_Hangul_EU = 0xed1;
   static final int KEYSYM_Hangul_YI = 0xed2;
   static final int KEYSYM_Hangul_I = 0xed3;
   static final int KEYSYM_Hangul_J_Kiyeog = 0xed4;
   static final int KEYSYM_Hangul_J_SsangKiyeog = 0xed5;
   static final int KEYSYM_Hangul_J_KiyeogSios = 0xed6;
   static final int KEYSYM_Hangul_J_Nieun = 0xed7;
   static final int KEYSYM_Hangul_J_NieunJieuj = 0xed8;
   static final int KEYSYM_Hangul_J_NieunHieuh = 0xed9;
   static final int KEYSYM_Hangul_J_Dikeud = 0xeda;
   static final int KEYSYM_Hangul_J_Rieul = 0xedb;
   static final int KEYSYM_Hangul_J_RieulKiyeog = 0xedc;
   static final int KEYSYM_Hangul_J_RieulMieum = 0xedd;
   static final int KEYSYM_Hangul_J_RieulPieub = 0xede;
   static final int KEYSYM_Hangul_J_RieulSios = 0xedf;
   static final int KEYSYM_Hangul_J_RieulTieut = 0xee0;
   static final int KEYSYM_Hangul_J_RieulPhieuf = 0xee1;
   static final int KEYSYM_Hangul_J_RieulHieuh = 0xee2;
   static final int KEYSYM_Hangul_J_Mieum = 0xee3;
   static final int KEYSYM_Hangul_J_Pieub = 0xee4;
   static final int KEYSYM_Hangul_J_PieubSios = 0xee5;
   static final int KEYSYM_Hangul_J_Sios = 0xee6;
   static final int KEYSYM_Hangul_J_SsangSios = 0xee7;
   static final int KEYSYM_Hangul_J_Ieung = 0xee8;
   static final int KEYSYM_Hangul_J_Jieuj = 0xee9;
   static final int KEYSYM_Hangul_J_Cieuc = 0xeea;
   static final int KEYSYM_Hangul_J_Khieuq = 0xeeb;
   static final int KEYSYM_Hangul_J_Tieut = 0xeec;
   static final int KEYSYM_Hangul_J_Phieuf = 0xeed;
   static final int KEYSYM_Hangul_J_Hieuh = 0xeee;
   static final int KEYSYM_Hangul_RieulYeorinHieuh = 0xeef;
   static final int KEYSYM_Hangul_SunkyeongeumMieum = 0xef0;
   static final int KEYSYM_Hangul_SunkyeongeumPieub = 0xef1;
   static final int KEYSYM_Hangul_PanSios = 0xef2;
   static final int KEYSYM_Hangul_KkogjiDalrinIeung = 0xef3;
   static final int KEYSYM_Hangul_SunkyeongeumPhieuf = 0xef4;
   static final int KEYSYM_Hangul_YeorinHieuh = 0xef5;
   static final int KEYSYM_Hangul_AraeA = 0xef6;
   static final int KEYSYM_Hangul_AraeAE = 0xef7;
   static final int KEYSYM_Hangul_J_PanSios = 0xef8;
   static final int KEYSYM_Hangul_J_KkogjiDalrinIeung = 0xef9;
   static final int KEYSYM_Hangul_J_YeorinHieuh = 0xefa;
   static final int KEYSYM_Korean_Won = 0xeff;
}
