//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders.vice;

import android.view.KeyEvent;

import java.util.HashMap;

import de.rainerhock.eightbitwonders.LinkedHashMapWithDefault;

final class AndroidGtkKeyMappings {
    private AndroidGtkKeyMappings() { }
    static int getGtkAdaptedKey(final int keycode, final int unicode) {
        if (KEYS_ADAPTED_TO_GTK.containsKey(keycode)) {
            //noinspection ConstantConditions
            return KEYS_ADAPTED_TO_GTK.get(keycode);
        }
        return unicode;
    }
    private static final HashMap<Integer, Integer> KEYS_ADAPTED_TO_GTK
            = new HashMap<Integer, Integer>() {{
        put(KeyEvent.KEYCODE_ENTER, GtkKeySymbols.KEYSYM_Return);
        put(KeyEvent.KEYCODE_TAB, GtkKeySymbols.KEYSYM_Tab);
    }};
    static int getUnicodeNonChar(final int keycode) {
        return NON_UNICODE_CHARMAP.get(keycode);
    }
    private static final LinkedHashMapWithDefault<Integer, Integer> NON_UNICODE_CHARMAP
            = new LinkedHashMapWithDefault<Integer, Integer>(GtkKeySymbols.KEYSYM_VoidSymbol) {{
        put(KeyEvent.KEYCODE_SHIFT_LEFT, GtkKeySymbols.KEYSYM_Shift_L);
        put(KeyEvent.KEYCODE_SHIFT_RIGHT, GtkKeySymbols.KEYSYM_Shift_R);
        put(KeyEvent.KEYCODE_BACK, GtkKeySymbols.KEYSYM_BackSpace);
        put(KeyEvent.KEYCODE_DEL, GtkKeySymbols.KEYSYM_BackSpace);
        put(KeyEvent.KEYCODE_FORWARD_DEL, GtkKeySymbols.KEYSYM_Delete);
        put(KeyEvent.KEYCODE_CTRL_LEFT, GtkKeySymbols.KEYSYM_Control_L);
        put(KeyEvent.KEYCODE_CTRL_RIGHT, GtkKeySymbols.KEYSYM_Control_R);
        put(KeyEvent.KEYCODE_ESCAPE, GtkKeySymbols.KEYSYM_Escape);
        put(KeyEvent.KEYCODE_DPAD_LEFT, GtkKeySymbols.KEYSYM_Left);
        put(KeyEvent.KEYCODE_DPAD_RIGHT, GtkKeySymbols.KEYSYM_Right);
        put(KeyEvent.KEYCODE_DPAD_UP, GtkKeySymbols.KEYSYM_Up);
        put(KeyEvent.KEYCODE_DPAD_DOWN, GtkKeySymbols.KEYSYM_Down);
        put(KeyEvent.KEYCODE_MOVE_HOME, GtkKeySymbols.KEYSYM_Home);
        put(KeyEvent.KEYCODE_MOVE_END, GtkKeySymbols.KEYSYM_End);
        put(KeyEvent.KEYCODE_INSERT, GtkKeySymbols.KEYSYM_Insert);
        put(KeyEvent.KEYCODE_PAGE_UP, GtkKeySymbols.KEYSYM_Page_Up);
        put(KeyEvent.KEYCODE_PAGE_DOWN, GtkKeySymbols.KEYSYM_Page_Down);
        put(KeyEvent.KEYCODE_F1, GtkKeySymbols.KEYSYM_F1);
        put(KeyEvent.KEYCODE_F2, GtkKeySymbols.KEYSYM_F2);
        put(KeyEvent.KEYCODE_F3, GtkKeySymbols.KEYSYM_F3);
        put(KeyEvent.KEYCODE_F4, GtkKeySymbols.KEYSYM_F4);
        put(KeyEvent.KEYCODE_F5, GtkKeySymbols.KEYSYM_F5);
        put(KeyEvent.KEYCODE_F6, GtkKeySymbols.KEYSYM_F6);
        put(KeyEvent.KEYCODE_F7, GtkKeySymbols.KEYSYM_F7);
        put(KeyEvent.KEYCODE_F8, GtkKeySymbols.KEYSYM_F8);
        put(KeyEvent.KEYCODE_F9, GtkKeySymbols.KEYSYM_F9);
        put(KeyEvent.KEYCODE_F10, GtkKeySymbols.KEYSYM_F10);
        put(KeyEvent.KEYCODE_F11, GtkKeySymbols.KEYSYM_F11);
        put(KeyEvent.KEYCODE_F12, GtkKeySymbols.KEYSYM_F12);
        put(KeyEvent.KEYCODE_NUMPAD_0, GtkKeySymbols.KEYSYM_KP_0);
        put(KeyEvent.KEYCODE_NUMPAD_1, GtkKeySymbols.KEYSYM_KP_1);
        put(KeyEvent.KEYCODE_NUMPAD_2, GtkKeySymbols.KEYSYM_KP_2);
        put(KeyEvent.KEYCODE_NUMPAD_3, GtkKeySymbols.KEYSYM_KP_3);
        put(KeyEvent.KEYCODE_NUMPAD_4, GtkKeySymbols.KEYSYM_KP_4);
        put(KeyEvent.KEYCODE_NUMPAD_5, GtkKeySymbols.KEYSYM_KP_5);
        put(KeyEvent.KEYCODE_NUMPAD_6, GtkKeySymbols.KEYSYM_KP_6);
        put(KeyEvent.KEYCODE_NUMPAD_7, GtkKeySymbols.KEYSYM_KP_7);
        put(KeyEvent.KEYCODE_NUMPAD_8, GtkKeySymbols.KEYSYM_KP_8);
        put(KeyEvent.KEYCODE_NUMPAD_9, GtkKeySymbols.KEYSYM_KP_9);
        put(KeyEvent.KEYCODE_NUMPAD_ADD, GtkKeySymbols.KEYSYM_KP_Add);
        put(KeyEvent.KEYCODE_NUMPAD_COMMA, GtkKeySymbols.KEYSYM_KP_Decimal);
        put(KeyEvent.KEYCODE_NUMPAD_DIVIDE, GtkKeySymbols.KEYSYM_KP_Divide);
        put(KeyEvent.KEYCODE_NUMPAD_DOT, GtkKeySymbols.KEYSYM_KP_Decimal);
        put(KeyEvent.KEYCODE_NUMPAD_ENTER, GtkKeySymbols.KEYSYM_KP_Enter);
        put(KeyEvent.KEYCODE_NUMPAD_EQUALS, GtkKeySymbols.KEYSYM_KP_Equal);
        put(KeyEvent.KEYCODE_NUMPAD_MULTIPLY, GtkKeySymbols.KEYSYM_KP_Multiply);
        put(KeyEvent.KEYCODE_NUMPAD_SUBTRACT, GtkKeySymbols.KEYSYM_KP_Subtract);
        put(KeyEvent.KEYCODE_CAPS_LOCK, GtkKeySymbols.KEYSYM_Caps_Lock);
    }};
}
