//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import androidx.annotation.NonNull;

class TouchJoystick extends VirtualJoystick {

    TouchJoystick(final String description) {
        super();
        mDescriptor = description;
    }


    @Override
    boolean isPreferredType(final EmulationConfiguration.PreferredJoystickType type) {
        return type == EmulationConfiguration.PreferredJoystickType.DIRECTIONAL;
    }
    private final String mDescriptor;

    @Override
    @NonNull
    public String toString() {
        return mDescriptor;
    }
    @Override
    String getId() {
        return "touch";
    }

    protected void onChanged() {
        float x = getDirectionView().isPointingWest() ? -FULL_AMPLITUDE
                : getDirectionView().isPointingEast() ? FULL_AMPLITUDE : 0;

        float y = getDirectionView().isPointingNorth() ? -FULL_AMPLITUDE
                : getDirectionView().isPointingSouth() ? FULL_AMPLITUDE : 0;
        setXValue(x);
        setYValue(y);
        setRealButtonsPressed(getFireView().isButtonPressed());
        super.onChanged();
    }

    @Override
    boolean canLockDiagonals() {
        return true;
    }

    @Override
    int getPseudoKeycode() {
        return Joystick.PSEUDO_KEYCODE_FIREBUTTON;
    }

    @Override
    protected int getRessourceId() {
        return R.layout.fragment_config_touch_joystick;
    }
}
