const JOYSTICK_HINT_GIVEN = "joystick_hint_given";

function removehint(olddata) {
    emu.removeListener(emu.getCurrentListenerId());
    emu.addTask(() => emu.poke(emu.getScreenAddress(0,0), olddata));
    return false;
}

function showhint(textid) {
        texts = emu.loadTextRessources();
        hint = emu.getLocalText(texts, textid);
        emu.log(emu.LOG_VERBOSE,hint);
        emu.addTask(() => emu.poke(emu.getScreenAddress(1,0), emu.charconvert(hint,emu.SCREENCODE)),1);
}

function showPressButtonHint() {
    olddata = emu.peek(emu.getScreenAddress(0,0),40);
    showhint("hint_fire");
    emu.log(emu.LOG_VERBOSE,emu.peek(emu.getScreenAddress(0,0)));
    emu.addJoystickListener(2, (n, s, w, e, f)=> {
        if (f) {
            removehint(olddata);
        }
        return false;
    });
}

linebuffer = new ArrayBuffer(38);
lineview = new Int8Array(linebuffer);
lineview.fill(67);
emu.addTextVisibilityListener(linebuffer, emu.TO_VISIBLE, () => {
    emu.removeListener(emu.getCurrentListenerId());
    //if (!emu.hasOption(JOYSTICK_HINT_GIVEN) && !emu.getOption(JOYSTICK_HINT_GIVEN)) {
        emu.setOption(JOYSTICK_HINT_GIVEN, true);
        olddata = emu.peek(emu.getScreenAddress(0,0),40);
        showhint("hint_directions");
        emu.addJoystickListener(2, (n, s, w, e, f)=> removehint(olddata));
    //}
});
emu.addMemoryChangedListener(53280,emu.EQUAL, 240, () => {
    emu.removeListener(emu.getCurrentListenerId());
    emu.addTextVisibilityListener("1", emu.TO_INVISIBLE, () => {
        if (emu.peek(emu.getScreenAddress(0,0)) == 176) {
            showPressButtonHint();
        }
    });
});
