package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import android.graphics.drawable.ColorDrawable;
import android.view.View;


import androidx.annotation.StringRes;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import de.rainerhock.eightbitwonders.vice.KeyButton;
import de.rainerhock.eightbitwonders.vice.ToggledKeyButton;

public class ViceKeyboardFragmentTest extends MainActivityTestBase {
    public static Matcher<? super View> isHighlighted() {
        return new TypeSafeMatcher<View>() {
            @Override
            public void describeTo(Description description) {

            }

            @Override
            protected boolean matchesSafely(View item) {
                if (item instanceof KeyButton) {
                    KeyButton b = (KeyButton) item;
                    return b.getBackground() instanceof ColorDrawable;
                }
                if (item instanceof ToggledKeyButton) {
                    ToggledKeyButton b = (ToggledKeyButton) item;
                    return b.getBackground() instanceof ColorDrawable;
                }

                return false;
            }

        };
    }
    @Test
    public void t_1010_normalkeys_c64() {
        t_1010_normalkeys(R.string.name_c64, "screenshot-normalkeys.pixelbuffer");
    }
    @Test
    public void t_1010_normalkeys_vic20() {
        t_1010_normalkeys(R.string.name_vic20, "screenshot-vic-normalkeys.pixelbuffer");
    }
    @Test
    public void t_1080_modificatorkeys_c64() {
        t_1080_modificatorkeys(R.string.name_c64, "screenshot-keycombinations.pixelbuffer");
    }
    @Test
    public void t_1080_modificatorkeys_vic20() {
        t_1080_modificatorkeys(R.string.name_vic20, "screenshot-vic-keycombinations.pixelbuffer");
    }
    @Test
    public void t_1090_non_printables_c64() {
        t_1090_non_printables(R.string.name_c64, "screenshot-quoted-nonprintables.pixelbuffer", "2");
    }
    @Test
    public void t_1090_non_printables_vic20() {
        t_1090_non_printables(R.string.name_vic20, "screenshot-vic-quoted-nonprintables.pixelbuffer", "1");
    }

    private void t_1010_normalkeys (int machine, String assetScreenshot) {
        prepareMachine(machine);
        waitForIdle(5, TimeUnit.SECONDS);
        for (String s : new String[] {"←", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", "-", "*", "£"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        for (String s : new String[] {"q", "w", "e", "r", "t", "y", "u", "i", "o", "p"}) {
            onView(allOf(isDisplayed(), isC64Key(s.toUpperCase(Locale.ROOT)))).perform(tap());
        }
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        for (String s: new String[] {"a", "s", "d", "f", "g", "h", "j", "k", "l" }) {
            onView(allOf(isDisplayed(), isC64Key(s.toUpperCase(Locale.ROOT)))).perform(tap());
        }
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        for (String s: new String[] {"z", "x", "c", "v", "b", "n", "m"}) {
            onView(allOf(isDisplayed(), isC64Key(s.toUpperCase(Locale.ROOT)))).perform(tap());
        }
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        for (String s: new String[] {":", ";", "=", "*", "/", "@"}) {
            onView(allOf(isDisplayed(), isC64Key(s.toUpperCase(Locale.ROOT)))).perform(tap());
        }
        //onView(withId(R.id.monitorGLSurfaceView)).perform(captureEmulationScreen(assetScreenshot));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(assetScreenshot)));
    }
    private void t_1080_modificatorkeys(int machineResId, String assetScreenshot) {
        prepareMachine(machineResId);
        waitForIdle(5, TimeUnit.SECONDS);
        onView(isC64Key("SHIFT\nLOCK"))
                .perform(tap());
        onView(allOf(isDisplayed(), isC64Key("SHIFT\nLOCK"))).check(matches(isHighlighted()));
        for (String s : new String[] {"←", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", "-", "*", "£"}) {
            onView(allOf(isDisplayed(), isC64Key(s.toUpperCase(Locale.ROOT)))).perform(tap());
        }
        onView(isC64Key("SHIFT\nLOCK")).check(matches(isHighlighted()));
        onView(isC64Key("SHIFT\nLOCK")).perform(tap());
        onView(isC64Key("SHIFT\nLOCK")).check(matches(not(isHighlighted())));
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("SHIFT")).check(matches(isHighlighted()));
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("SHIFT")).check(matches(not(isHighlighted())));
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("C=")).perform(tap());
        onView(isC64Key("C=")).check(matches(isHighlighted()));
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("C=")).check(matches(not(isHighlighted())));
        onView(isC64Key("C=")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("C=")).check(matches(not(isHighlighted())));
        onView(isC64Key("SHIFT")).check(matches(not(isHighlighted())));
        //onView(withId(R.id.monitorGLSurfaceView)).perform(captureEmulationScreen(assetScreenshot));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(assetScreenshot)));

    }


    private void t_1090_non_printables(int machineResId, String assetScreenshot, String colorkey) {
        prepareMachine(machineResId);
        waitForIdle(5, TimeUnit.SECONDS);
        for (String s : new String[] {"CTRL", colorkey, "SHIFT", "2", "F1", "F3", "F5", "F7", "HOME"}) {
            onView(isC64Key(s.toUpperCase(Locale.ROOT))).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            waitForIdle();
        }
        // onView(withId(R.id.monitorGLSurfaceView)).perform(captureEmulationScreen(assetScreenshot));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(assetScreenshot)));

    }
    /** @noinspection BooleanMethodIsAlwaysInverted*/
    private boolean isKeyboardViewSwitchPseudovalue(String s) {
        if (s.equals("#->NUM#")) {
            onView(withId(R.id.sw_alpha_num))
                    .check(matches(not(isChecked())))
                    .perform(click())
                    .check(matches(isChecked()));
            waitForIdle();
            return true;
        }
        if (s.equals("#->ABC#")) {
            onView(withId(R.id.sw_alpha_num))
                    .check(matches(isChecked()))
                    .perform(click())
                    .check(matches(not(isChecked())));
            waitForIdle();
            return true;
        }
        return false;
    }
    @Test
    public void testPetGraphicalKeyboard() {
        prepareMachine(R.string.name_pet);
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        switchToPetModel("4032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032.pixelbuffer", 10, TimeUnit.SECONDS)));
        waitForIdle(1, TimeUnit.SECONDS);

        for (String[] strings : new String[][]{{
            "@", "!", "\"", "#", "$", "%", "'", "&", "\\", "←", "#->NUM#", "[", "]", "#->ABC#"}, {
            "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "↑", "<", ">"}, {
            "A", "S", "D", "F", "G", "H", "J", "K", "L",":"},{
            "Z", "X", "C", "V", "B", "N", "M", ",", ";", "?"
        }}) {
            for (String s : strings) {
                if (!isKeyboardViewSwitchPseudovalue(s)) {
                    onView(isC64Key(s)).perform(tap());
                }
            }
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-graphical-printables.pixelbuffer")));

        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("SHIFT")).check(matches(isHighlighted()));
        onView(isC64Key("HOME")).perform(tap());
        onView(withId(R.id.sw_alpha_num))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        for (String[] strings : new String[][]{{
                "7", "8", "9", "/"}, {
                "4", "5", "6", "*"}, {
                "1", "2", "3", "+"}, {
                "0", ".", "-", "="
        }}) {
            for (String s : strings) {
                if (!isKeyboardViewSwitchPseudovalue(s)) {
                    onView(isC64Key(s)).perform(tap());
                }
            }
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-graphical-numeric.pixelbuffer")));
        onView(withId(R.id.sw_alpha_num))
                .perform(click())
                .check(matches(not(isChecked())));

        for (String s :new  String[] {"SHIFT", "RETURN", "RETURN", "RVS", " ", "SHIFT", "RVS", "▲", "A", "▼", "B", "◀", "C", "▶", "D",
                "SHIFT", "RETURN", "L", "O", "A", "D", "RETURN", "STOP", "SHIFT", "S"}) {
            onView(isC64Key(s)).perform(tap());
        }
        onView(withId(R.id.sw_alpha_num))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        waitForIdle();
        onView(withId(R.id.bn_crsr_ud)).perform(tap());
        onView(isC64Key("1")).perform(tap());
        onView(withId(R.id.bn_crsr_lr)).perform(tap());
        for (String s :new  String[] {"2", "3","4","#->ABC#", "DEL", "#->NUM#"}) {
            if (!isKeyboardViewSwitchPseudovalue(s)) {
                onView(isC64Key(s)).perform(tap());
            }
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-graphical-nonprintables.pixelbuffer")));
    }
    @Test
    public void testPetBusinessKeyboard() {
        prepareMachine(R.string.name_pet);
        waitForActivity(EmulationActivity.class, 3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        switchToPetModel("8032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet8032.pixelbuffer", 10, TimeUnit.SECONDS)));
        waitForIdle(1, TimeUnit.SECONDS);
        for (String[] strings : new String[][]{{
                "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ":", "-","↑"}, {
                "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "[", "\\"}, {
                "A", "S", "D", "F", "G", "H", "J", "K", "L",";", "@", "]"},{
                "Z", "X", "C", "V", "B", "N", "M", ",", ".", "/"
        }}) {
            for (String s : strings) {
                onView(isC64Key(s)).perform(tap());
            }
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-business-printables.pixelbuffer")));
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("HOME")).perform(tap());
        onView(withId(R.id.sw_alpha_num))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        for (String s : new String[]{"0", ".", "1", "2", "3", "4", "5", "6", "7", "8", "9"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(withId(R.id.sw_alpha_num))
                .check(matches(isChecked()))
                .perform(click())
                .check(matches(not(isChecked())));

        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-business-numeric.pixelbuffer")));
        for (String s :new  String[] {"SHIFT", "HOME", "RVS", " ", "SHIFT", "RVS", "▲", "A", "▼", "B", "◀", "C", "▶", "D",
                "SHIFT", "RETURN", "L", "O", "A", "D", "RETURN", "STOP", "SHIFT", "S"}) {
            onView(isC64Key(s)).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-business-nonprintables.pixelbuffer")));
    }
    private void testLanguage(@StringRes int idCountryName, String toggleKey, List<String> hiddenKeys, List<String> typeKeys, String screenshot) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(idCountryName)).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(Matchers.allOf(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MP_RESET))),
                withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MI_RESET_HARD))))).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        waitForIdle(1, TimeUnit.SECONDS);
        if (toggleKey != null) {
            onView(isC64Key(toggleKey)).check(matches(not(isHighlightedC64Key())));
            onView(isC64Key(toggleKey)).perform(tap());
            onView(isC64Key(toggleKey)).check(matches(isHighlightedC64Key()));
        }
        for (String hidden: hiddenKeys) {
            onView(Matchers.allOf(not(isDisplayed()), isC64Key(hidden))).check(matches(not(isDisplayed())));
        }
        waitForIdle();
        for (String type: typeKeys) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            waitForIdle();
            onView(Matchers.allOf(isDisplayed(),isC64Key(type))).perform(click());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            waitForIdle();

        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(screenshot,1, TimeUnit.SECONDS)));
        if (toggleKey != null) {
            onView(isC64Key(toggleKey)).check(matches(isHighlightedC64Key()));
            onView(isC64Key(toggleKey)).perform(tap());
            onView(isC64Key(toggleKey)).check(matches(not(isHighlightedC64Key())));
        }
    }

    @Test
    public void testC128KeyboardLayouts() {
        List<String> functionKeys = Arrays.asList("F1", "F3", "F5", "F7");
        onView(withText(R.string.name_c128)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        for (String key : Arrays.asList("ESC", "TAB", "ALT", "CAPS\nLOCK")) {
            onView(allOf(isDisplayed(), isC64Key(key))).check(matches(isDisplayed()));
        }
        onView(withId(R.id.sw_alpha_num))
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        for (String key : functionKeys) {
            onView(Matchers.allOf(isDisplayed(), isC64Key(key))).check(matches(isDisplayed()));
        }
        onView(withId(R.id.sw_alpha_num)).perform(click());

        testLanguage(R.string.IDMS_LANGUAGE_FINNISH, "ASCII\nCC",
                Arrays.asList("*", "+", "£"),
                Arrays.asList(":", ";", "@","Å", "Ö", "Ä","-","=","@"),
                "screenshot-c128-finnish.pixelbuffer");


        testLanguage(R.string.IDMS_LANGUAGE_FRENCH, "ASCII\nCC",
                Arrays.asList("←", "+", "£"),
                Arrays.asList("A", "Z", "Q", "W", "M", "<", "é", "\"","'", "(", "§","è","!","ç",")","-","$","=","↑", "@",";", ":","M","ù",",","*"),
                "screenshot-c128-french.pixelbuffer");

        testLanguage(R.string.IDMS_LANGUAGE_GERMAN, "ASCII\nDIN",
                Arrays.asList("←","*","+","/","=","£","@","↑",":",";"),
                Arrays.asList("ß", "SHIFT","+", "SHIFT","-", "#", "[", "]","Z", "Y", "SHIFT","3", "SHIFT", "7", "Ü", "Ö","Ä"),
                "screenshot-c128-german.pixelbuffer");

        testLanguage(R.string.IDMS_LANGUAGE_ITALIAN, "ASCII\nCC",
                Arrays.asList("←", "+", "£"),
                Arrays.asList("Z", "W", "M", "<", "£", "é", "\"","'", "(","_","è","&","ç","à","$","↑", "@",";", ":","M","ù",",","*","ì"),
                "screenshot-c128-italian.pixelbuffer");


        /*
        testLanguage(R.string.IDMS_LANGUAGE_NORWEGIAN, null,
                Collections.singletonList("£"),
                Arrays.asList("Ø", "SHIFT", ":", "SHIFT", ";"),
                "screenshot-c128-norwegian.pixelbuffer");

         */
        testLanguage(R.string.IDMS_LANGUAGE_SWEDISH, "ASCII\nCC",
                Collections.singletonList("£"),
                Arrays.asList("Å", "Ö", "Ä", "SHIFT", "/", "SHIFT", ":", "SHIFT",";"),
                "screenshot-c128-swedish.pixelbuffer");

    }
    @Test
    public void test_c128_ascii_cc_key_toggle() {
        prepareMachine(R.string.name_c128);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDMS_LANGUAGE_FRENCH)).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(Matchers.allOf(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MP_RESET))),
                withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MI_RESET_HARD))))).perform(click());
        waitForActivity(EmulationActivity.class, 500, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        onView(isC64Key("ASCII\nCC")).check(matches(not(isHighlightedC64Key())));
        onView(allOf(isDisplayed(), isC64Key("1"))).perform(tap());

        onView(isC64Key("ASCII\nCC")).perform(tap());
        onView(isC64Key("ASCII\nCC")).check(matches(isHighlightedC64Key()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(allOf(isDisplayed(), isC64Key("&"))).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-c128-mixed-charset-fr.pixeldata")));

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDMS_LANGUAGE_GERMAN)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(Matchers.allOf(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MP_RESET))),
                withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MI_RESET_HARD))))).perform(click());
        waitForIdle(5, TimeUnit.SECONDS);

        waitForActivity(EmulationActivity.class, 500, TimeUnit.MILLISECONDS);

        onView(isC64Key("ASCII\nCC")).check(matches(not(isDisplayed())));
        onView(isC64Key("ASCII\nDIN")).check(matches(not(isHighlightedC64Key())));
        onView(isC64Key("ASCII\nDIN")).check(matches(isDisplayed()));
        onView(allOf(isDisplayed(), isC64Key("@"))).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(isC64Key("ASCII\nDIN")).perform(tap());
        //onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(allOf(isDisplayed(), isC64Key("Ü"))).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-c128-mixed-charset-de.pixeldata")));


    }
    @Test
    public void test_c128_ascii_cc_key_autooff() {
        prepareMachine(R.string.name_c128);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDMS_LANGUAGE_FRENCH)).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(isC64Key("ASCII\nCC")).perform(tap());
        onView(isC64Key("ASCII\nCC")).check(matches(isHighlightedC64Key()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.gh_c128_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDMS_LANGUAGE_ITALIAN)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(isC64Key("ASCII\nCC")).check(matches(not(isHighlightedC64Key())));
        onView(isC64Key("ASCII\nCC")).perform(tap());
        onView(isC64Key("ASCII\nCC")).check(matches(isHighlightedC64Key()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.sp_c128languages)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDMS_LANGUAGE_ITALIAN)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(isC64Key("ASCII\nCC")).check(matches(isHighlightedC64Key()));
    }

    @Test
    @ScreenshotTest
    //@SdkSuppress(minSdkVersion=20)
    public void test_exact_keyboard() {
        testExactKeyboardVisibility(R.string.name_c64, null, null);
        testExactKeyboardVisibility(R.string.name_vic20, null, null);
        testExactKeyboardVisibility(R.string.name_pet, null, null);
        testExactKeyboardVisibility(R.string.name_pet, () -> switchToPetModel("8032"), null);
        testExactKeyboardVisibility(R.string.name_c128, null, null);
    }
}