package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.hasFocus;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isFocused;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.anyOf;
import static org.hamcrest.Matchers.instanceOf;

import android.view.KeyEvent;

import androidx.test.espresso.NoMatchingViewException;

import junit.framework.AssertionFailedError;

import org.junit.Test;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class TvScreenshotsTest extends MainActivityTestBase{

    @Test
    @TvTest
    @SpecialTest
    public void takeTvScreenshots() {
        try {
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        captureDeviceScreen("main-activity");
        navigateToHamburger();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(BrowserActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle(10, TimeUnit.SECONDS);
        captureDeviceScreen("licences");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText(R.string.manual)).perform(click());
        waitForIdle(10, TimeUnit.SECONDS);
        onView(withId(R.id.bn_reload)).check(matches(isDisplayed()));
        captureDeviceScreen("manual");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        navigateToView(KeyEvent.KEYCODE_DPAD_LEFT, KeyEvent.KEYCODE_UNKNOWN, allOf(instanceOf(TileView.class), withChild(withText(R.string.name_c64))));
        captureDeviceScreen("first-tile-focusd");
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        captureDeviceScreen("c64-activity-default");

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("menu");
        //onView(withText(R.string.rewind)).perform(click());
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        captureDeviceScreen("timemachine");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("savestate");
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        captureDeviceScreen("savestates-extended-menu");
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForDialog(withText(R.string.add_to_main_activity));
        captureDeviceScreen("add-to-start-screen");
        onView(withId(R.id.pb_next)).perform(click());
        waitForIdle();
        captureDeviceScreen("add-to-start-screen-pt-2");
        onView(isRoot()).perform((closeSoftKeyboard()));

        onView(isRoot()).perform((closeSoftKeyboard()));
        waitForIdle();
        captureDeviceScreen("add-to-start-screen-pt-2-wo-keyboard");
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForActivity(ShareEmulationActivity.class,2,TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("share-activity");
        captureDeviceScreen("share-activity-wo-keyboard");
        boolean found = false;
        while (!found) {
            pressBack();
            waitForIdle();
            try {
                onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
                found = true;
            } catch (NoMatchingViewException e) {
                waitForIdle(250, TimeUnit.MILLISECONDS);
            }
        }
        // now we are back to the emulation
        //onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle();
        captureDeviceScreen("settings-all-closed");
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("settings-keyboard");
        for (String s : Arrays.asList("settings-joystick", "settings-c64-devices",
                "settings-c64-vic-ii", "settings-c64-sid")) {
            onView(allOf(isFocused(), anyOf(instanceOf(GroupHeader.class),withParent(instanceOf(GroupHeader.class))))).check(matches(isFocused()));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
            onView(allOf(isFocused(), anyOf(instanceOf(GroupHeader.class),withParent(instanceOf(GroupHeader.class))))).check(matches(isFocused()));
            waitForIdle();
            captureDeviceScreen(s);

        }
        pressBack();
        waitForIdle();

        try {
            openDocument(extractTestAsset("soundloop.tap"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();

        captureDeviceScreen("attach-tape");
        try {
            onView(withId(R.id.bn_tape)).check(matches(hasFocus()));
        } catch (AssertionFailedError e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
        }
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();

        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("attach-disk");
        try {
            onView(withText(R.string.IDMS_DRIVE_8)).check(matches(hasFocus()));
        } catch (AssertionFailedError e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            waitForIdle();
        }
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();


        try {
            openDocument(extractTestAsset("fliplist1.vfl"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("fliplist-from-file-selection");
        pressBack();

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("menu-extended");
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        captureDeviceScreen("tape-functions");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_MENU));
        waitForIdle();
        onView(withText(R.string.rewind)).check(matches(isFocused()));
        //onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(withText(R.string.IDS_KEYBOARD)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));

        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("keyboard");
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);

        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        navigateToView(KeyEvent.KEYCODE_DPAD_RIGHT, KeyEvent.KEYCODE_UNKNOWN, withChild(withText("Pac-Mania")));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("pac-mania-startscreen");
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("pac-mania-menu");
        onView(withText(R.string.softkeys)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        waitForIdle();
        onView(withText(R.string.softkeys)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("pac-mania-softkeys");
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("pac-mania-highscore");

    }
}
