package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.anyOf;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.instanceOf;

import static de.rainerhock.eightbitwonders.EmulationActivity.PAUSE_TICK_COUNT;
import static de.rainerhock.eightbitwonders.EmulationActivity.PAUSE_TICK_DURATION;

import android.view.KeyEvent;
import android.widget.TabWidget;

import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import de.rainerhock.eightbitwonders.vice.ViceFileActionActivity;

public class TimeMachineTest extends C64EmulationTestBase {
    @SuppressWarnings("deprecation")
    @Test
    public void t_0010_dialog() {
        /*
        Action: Open 1SECINTERVAL.PRG on disk image testprograms.d64
        Expected result: program is started and starts printing 255
        */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withId(R.id.gv_monitor)).check(doesNotExist());
        onView(withId(R.id.lv_imagecontents)).check(matches(isDisplayed()));
        onData(isOption("1SECINTERVAL")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-wait-20sec.pixelbuffer",25, TimeUnit.MINUTES)));
        /*
        Action: open hamburger menu and tap on menuitem for time machine
        Expected result: Dialog time machine is showing
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        waitForIdle(10, TimeUnit.SECONDS);
        /*
        Action: slide to the right side of seekbar
        Expected result: text is like "10 seconds ago".
         */
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.BOTTOM_RIGHT, Press.FINGER));
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(
                withText(containsString("8,")), withText(containsString("8.")),
                withText(containsString("9,")), withText(containsString("9.")),
                withText(containsString("10.")),withText(containsString("10,"))
        )));
        /*
        Action: hit play button
        Expected result: screen from 10 seconds ago is shown.
         */
        onView(withId(R.id.bn_apply)).perform(click());
        testBePreparedDialog();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("screenshot-travel-10sec.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(showsBitmapEqualToAsset("screenshot-wait-20sec.pixelbuffer",10, TimeUnit.MINUTES)));
        /*
        Action: open hamburger menu and tap on menuitem for time machine
        Expected result: Dialog time machine is showing
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        /*
        Action: slide to the center of seekbar
        Expected result: text is like "5 seconds ago".
        */
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER));
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(withText(containsString("4.")),withText(containsString("4,")),withText(containsString("5.")),withText(containsString("5,")))));
        onView(withId(R.id.iv_bitmap)).check(matches(showsBitmapEqualToAsset("screenshot-travel-7sec.pixelbuffer")));
        onView(withId(R.id.bn_apply)).perform(click());
        testBePreparedDialog();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-travel-5sec.pixelbuffer", 2, TimeUnit.SECONDS)));

        /*
        Action: slide to the right side of seekbar
        Expected result: text is like "5 seconds ago".
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER));
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(withText(containsString("4.")),withText(containsString("4,")),withText(containsString("5.")),withText(containsString("5,")),withText(containsString("6.")),withText(containsString("6,")))));
        /*
        Action: tap on play button
        Expected result: dialog disappears, emulation is continued.
         */
        onView(withId(R.id.bn_apply)).perform(click());
        testBePreparedDialog();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: open time machine dialog
        Expected result: Emulation is paused.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        waitForIdle();
        onView(isRoot()).check(matches(not(isScreenUpdating())));

    }

    private void testBePreparedDialog() {
        long now = System.currentTimeMillis();
        waitForIdle();
        onView(instanceOf(EmulationDialogFragmentRootview.class)).check(matches(isDisplayed()));
        try {
            Thread.sleep((PAUSE_TICK_COUNT* PAUSE_TICK_DURATION)-(System.currentTimeMillis()-now));
        }

        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        onView(instanceOf(EmulationDialogFragmentRootview.class)).check(doesNotExist());
    }

    @Test
    public void t_0110_pause() throws InterruptedException {
        /*
        Action: Pause emulation for 5 seconds and then start time machine.
        Expected result: time machine can travel back less than 5 seconds.
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.pause)).perform(click());
        Thread.sleep(5500);
        onView(withText(R.string.cont)).perform(click());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        waitForIdle();
        //noinspection deprecation
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER));
        //noinspection unchecked
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(
                withText(containsString("1.")),
                withText(containsString("1,")),
                withText(containsString("2.")),
                withText(containsString("2,")),
                withText(containsString("3.")),
                withText(containsString("3,")),
                withText(containsString("4.")),
                withText(containsString("4,")),
                withText(containsString("5.")),
                withText(containsString("5,")))));


    }
    @Test
    public void t_0140_joystick() {
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForActivity(ViceFileActionActivity.class,250,TimeUnit.MILLISECONDS);

        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu))
                .perform(setJoysticksConnected(DpadJoystick.class, true))
                .perform(tap());

        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).perform(click());
        onView(withTagValue(equalTo("port#2"))).perform(click());
        onData(isOption(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_NONE))).perform(click());

        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN,KeyEvent.KEYCODE_BUTTON_A,-42));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP,KeyEvent.KEYCODE_BUTTON_A,-42));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        //noinspection deprecation
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle(2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    @Test
    public void t_0160_save_from_timemachine() {
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
        waitForIdle(5, TimeUnit.SECONDS);
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        waitForIdle(7, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
                //.check(matches(not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 2, TimeUnit.SECONDS))));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        waitForIdle();
        /*
        Action: slide to the right side of seekbar
        Expected result: text is like "10 seconds ago".
         */
        //noinspection deprecation
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.BOTTOM_RIGHT, Press.FINGER));
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(withText(containsString("9,")), withText(containsString("9.")), withText(containsString("10.")),withText(containsString("10,")))));
        onView(withId(R.id.bn_save)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 10, TimeUnit.SECONDS))));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();

        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).perform(click());
        testBePreparedDialog();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 5, TimeUnit.SECONDS)));


    }

}
