package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.StringRes;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class TilePositionTest extends MainActivityTestBase{
    private static View findMatchingView(ViewGroup root, Matcher<View> matcher) {
        final View[] result = new View[1];
        root.findViewsWithText(new ArrayList<>(), "", View.FIND_VIEWS_WITH_TEXT); // trigger layout traversal

        root.post(() -> {}); // ensure layout pass

        for (int i = 0; i < root.getChildCount(); i++) {
            View child = root.getChildAt(i);
            if (matcher.matches(child)) {
                result[0] = child;
                break;
            }
            if (child instanceof ViewGroup) {
                View nested = findMatchingView((ViewGroup) child, matcher);
                if (nested != null) {
                    result[0] = nested;
                    break;
                }
            }
        }
        return result[0];
    }
    private static Matcher<View> isFullyBelow(final Matcher<View> referenceMatcher) {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View targetView) {
                ViewGroup rootView = (ViewGroup) targetView.getRootView();
                View referenceView = findMatchingView(rootView, referenceMatcher);
                if (referenceView == null) return false;

                int[] referenceLocation = new int[2];
                int[] targetLocation = new int[2];

                referenceView.getLocationOnScreen(referenceLocation);
                targetView.getLocationOnScreen(targetLocation);

                int referenceBottom = referenceLocation[1] + referenceView.getHeight();
                int targetTop = targetLocation[1];

                return targetTop >= referenceBottom;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is fully below the matched view");
            }
        };
    }
    private static Matcher<View> isFullyAbove(final Matcher<View> referenceMatcher) {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View targetView) {
                ViewGroup rootView = (ViewGroup) targetView.getRootView();
                View referenceView = findMatchingView(rootView, referenceMatcher);
                if (referenceView == null) return false;

                int[] referenceLocation = new int[2];
                int[] targetLocation = new int[2];

                referenceView.getLocationOnScreen(referenceLocation);
                targetView.getLocationOnScreen(targetLocation);

                int referenceTop = referenceLocation[1];
                int targetBottom = targetLocation[1] + targetView.getHeight();

                return targetBottom <= referenceTop;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is fully above the matched view");
            }
        };
    }
    private Matcher<View> isTile(@StringRes int name) {
        return allOf(instanceOf(TileView.class),withChild(withText(name)));
    }
    private Matcher<View> isTile(String name) {
        return allOf(instanceOf(TileView.class),withChild(withText(name)));
    }
    private final static String PLAIN_C64 ="plain-c64";
    @Test
    public void testPositions() throws IOException {
        waitForIdle();
        onView(withText(PLAIN_C64)).check(doesNotExist());
        onView(isTile(R.string.name_c64))
                .check(matches(isFullyBelow(withText(R.string.preinstalled))))
                .check(matches(isFullyAbove(withText(R.string.more_content))));
        onView(isContentSourceViewWithTitle(R.string.import_local_content))
                .check(matches(isFullyBelow(withText(R.string.more_content))));
        onView(withText(R.string.usercontent)).check(matches(not(isDisplayed())));
        setIntentCallback(extractTestAsset("plain-c64.8bw"));
        onView(isContentSourceViewWithTitle(R.string.import_local_content))
                .perform(scrollTo())
                .perform(click());
        waitForIdle();
        onView(withText(R.string.usercontent)).perform(scrollTo());
        onView(withText(PLAIN_C64))
                .check(matches(isFullyBelow(withText(R.string.usercontent))))
                .check(matches(isFullyAbove(withText(R.string.more_content))));
        onView(withText(R.string.preinstalled)).perform(scrollTo()).perform(click());
        onView(withText(R.string.import_local_content)).perform(scrollTo()).perform(click());
        onView(withText(R.string.more_content)).perform(scrollTo());
        waitForIdle();
        onView(withText(R.string.more_content)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(not(isDisplayed())));
        //waitForIdle(1, TimeUnit.MINUTES);
        onView(withText(R.string.import_local_content)).check(matches(not(isDisplayed())));
        onView(withText(R.string.preinstalled)).check(matches(isFullyAbove(withText(R.string.usercontent))));
        onView(withText(R.string.usercontent)).check(matches(isFullyAbove(withText(R.string.more_content))));
        onView(withText(R.string.preinstalled)).perform(scrollTo());
        waitForIdle();
        onView(withText(R.string.preinstalled)).perform(click());
        onView(withText(R.string.more_content)).perform(scrollTo());
        waitForIdle();
        onView(withText(R.string.more_content)).perform(click());
        onView(withText(R.string.preinstalled)).perform(scrollTo());
        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts))
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(PLAIN_C64)).check(doesNotExist());
        onView(withText(R.string.usercontent)).check(matches(not(isDisplayed())));

    }
}
