package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasExtraWithKey;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.widget.EditText;
import android.widget.TabWidget;

import androidx.test.espresso.intent.Intents;
import androidx.test.espresso.intent.matcher.IntentMatchers;
import androidx.test.filters.LargeTest;
import androidx.test.platform.app.InstrumentationRegistry;

import junit.framework.AssertionFailedError;

import org.hamcrest.CoreMatchers;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@LargeTest
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class SnapshotsTest extends MainActivityTestBase {
    private static final String SNAPSHOT = "_SNAPSHOT_%d_";

    @Test
    public void t_0010_first_snapshot() {
        startC64(String.format(SNAPSHOT, 0));
        test_snapshot(0);
        onView(withText(String.format(SNAPSHOT, 0))).check(doesNotExist());
    }
    @Test
    public void t_0110_last_snapshot() {
        startC64(String.format(SNAPSHOT, 4));
        test_snapshot(4);
        onView(withText(String.format(SNAPSHOT, 4))).check(doesNotExist());

    }
    private static final String SAVE_REBOOT = "SAVE_REBOOT_";
    @Test
    public void t_0150_save_reboot(){
        startC64(SAVE_REBOOT);
        try {
            openDocument(extractTestAsset("soundloop.vsf"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        closeAndRestartActivity();
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()))
                .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer", 20, TimeUnit.SECONDS)));
        waitForIdle();
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(SAVE_REBOOT, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(SAVE_REBOOT)).check(doesNotExist());


    }
    private void startC64(@SuppressWarnings("SameParameterValue") String name) {
        onView(withText(name)).check(doesNotExist());
        /*
        Action: start C64 emulation
        Expected result: Emulation is showing.
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: Open menu with the hamburger and choose "Create Link"/"Verknüpfung erstellen
        Expected result: Dialog is showing up.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());

        /*
        Action: type "joy" as name and click on "OK"
        Expected result: Emulation is shown again
         */

        waitForIdle();
        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(name))
                .perform(closeSoftKeyboard());
        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(name, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));



    }
    private void create_snapshot(int index) {
        waitForIdle();
        File root = new File(InstrumentationRegistry.getInstrumentation().getTargetContext().getFilesDir(), "snapshots/C64/default/");
        for (int slot = 1; slot <=5; slot++) {
            File folder = new File(root, String.valueOf(slot));
            for (String name : Arrays.asList("data", "timestamp")) {
                File f = new File(folder, name);
                if (f.exists()) {
                    if (!f.delete()) {
                        throw new RuntimeException("Could not delete " + f);
                    }
                }
            }
        }
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(instanceOf(EmulationTestInterface.class)).check(matches(not(isScreenUpdating())));
        for (int i = 0; i<6; i++) {
            onView(allOf(withText(String.valueOf(i+1)),
                    isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
            waitForIdle();
            onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isEnabled()));
            onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(matches(withText(R.string.no_image)));
            onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(doesNotExist());
            onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
            onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(matches(isDisplayed()));
        }
        pressBack();
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(index+1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        for (int i = 0; i<6; i++) {
            onView(allOf(withText(String.valueOf(i+1)),
                    isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
            waitForIdle();
            if (i != index) {
                onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isEnabled()));
                onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(matches(withText(R.string.no_image)));
                onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(doesNotExist());
                onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
                onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(matches(isDisplayed()));
            } else {
                onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isDisplayed()));
                onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(doesNotExist());
                onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(matches(isDisplayed()));
                onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(matches(isEnabled()));
                onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(doesNotExist());

            }
        }
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(index+1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);

        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        waitForIdle();

    }
    private void test_snapshot(int index) {
        create_snapshot(index);
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot())
                .perform(createdTileAction(String.format(SNAPSHOT, index), longClick()));
        waitForIdle(1, TimeUnit.SECONDS);
        //onView(isRoot()).perform(waitForMatch(withText(R.string.uninstall), 5, TimeUnit.SECONDS));
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();

    }
    private static final String DELETE_SNAPSHOT = "_DELETE_SNAPSHOT";
    @Test
    public void t_0220_delete_snapshot() {
        /*
        Action: start Emulation, tap on hamburger, choose savestates from the menu, create snapshot
                in slot 2.
        Expected r
        esult: Emulation is running, no dialog
         */
        startC64(DELETE_SNAPSHOT);
        create_snapshot(1);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isEnabled()));
        onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(matches(withText(R.string.no_image)));
        onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_more))).check(doesNotExist());
        onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(matches(isDisplayed()));

        onView(allOf(withText(String.valueOf(2)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isDisplayed()));
        onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(matches(isDisplayed()));
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(matches(isEnabled()));
        onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(doesNotExist());
        /*
        Action: tap on button "more" and select "delete"
        Expected result: Dialog still visible, snapshot slot is empty (no image, no date,
        no buttons start or more)
         */
        onView(allOf(isDisplayed(), withId(R.id.bn_more)))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();
        onView(withText(R.string.delete)).inRoot(isPlatformPopup()).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isEnabled()));
        onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(matches(withText(R.string.no_image)));
        onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_more))).check(doesNotExist());
        onView(allOf(isDisplayed(), withText(R.string.available_snapshot_slot))).check(matches(isDisplayed()));
        /*
        Action: close dialog, quit emulation and restart C64
        Expected result: Emulation is running.
         */
        pressBack();
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(DELETE_SNAPSHOT, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: tap on hamburger, choose save state from the menu, select tab 2
        Expected result: snapshot slot is empty (no image, no date, no buttons start or more)
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(2)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isEnabled()));
        onView(allOf(isDisplayed(), withId(R.id.tv_no_bitmap))).check(matches(withText(R.string.no_image)));
        onView(allOf(isDisplayed(), withId(R.id.iv_bitmap))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
        onView(allOf(isDisplayed(), withId(R.id.bn_more))).check(doesNotExist());
        pressBack();
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(DELETE_SNAPSHOT, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();

    }

    @Test
    public void t_0250_share_snapshot_screenshot() {
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        poke53280_0();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));

        waitForIdle(50, TimeUnit.MILLISECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save)))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_more)))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();
        prepareIntentHandling();
        onView(withText(R.string.share_screenshot)).inRoot(isPlatformPopup()).perform(click());

    }

    private void prepareIntentHandling() {
        Intents.release();
        Intents.init();
        intending(anyOf(allOf(IntentMatchers.hasAction(Intent.ACTION_CHOOSER), hasExtraWithKey(Intent.EXTRA_INTENT)), hasAction(Intent.ACTION_SEND))).respondWithFunction(intent -> {
            Intent dataIntent;
            if (intent.getAction().equals(Intent.ACTION_SEND)) {
                dataIntent = intent;
            } else if (intent.getAction().equals(Intent.ACTION_CHOOSER)) {
                dataIntent = intent.getExtras().getParcelable(Intent.EXTRA_INTENT);
            } else {
                dataIntent = null;
            }
            if (dataIntent != null) {
                if (dataIntent.getExtras().get(Intent.EXTRA_STREAM)
                        instanceof Uri) {
                    try {
                        InputStream fis = InstrumentationRegistry.getInstrumentation()
                                .getContext().getContentResolver().openInputStream(
                                        (Uri)dataIntent.getExtras().get(Intent.EXTRA_STREAM));
                        Bitmap bmp = BitmapFactory.decodeStream(fis);
                        if (bmp != null) {
                            ByteBuffer b = ByteBuffer.allocate(bmp.getByteCount());
                            //noinspection resource
                            InputStream is = getInstrumentation().getContext().getAssets()
                                    .open("expected_bitmaps/1k-black-pixels.pixelbuffer");
                            byte[] compare = new byte[1024];
                            if (is.read(compare) == compare.length) {
                                bmp.copyPixelsToBuffer(b);
                                byte[] data = Arrays.copyOf(b.array(), 1024);
                                if (Arrays.equals(data, compare)) {
                                    return new Instrumentation.ActivityResult(Activity.RESULT_OK, null);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }

                }
            }
            throw new AssertionFailedError("created intent "+intent+" does not match.");
        });
    }
    private void poke53280_0() {
        onView(isC64Key("P")).perform(tap());
        onView(isC64Key("O")).perform(tap());
        onView(isC64Key("K")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("5")).perform(tap());
        onView(isC64Key("3")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(isC64Key("8")).perform(tap());
        onView(CoreMatchers.allOf(isDisplayed(), isC64Key("0"))).perform(tap());
        onView(CoreMatchers.allOf(isDisplayed(), isC64Key(","))).perform(tap());
        onView(isC64Key("0")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());

    }
    @Test
    public void t_0720_share_currentstate_screenshot() {
        /*
        Action: start C64
        Expected result: Emulation is running
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Action: type BLERB
        Expected result: BLERB is displayed
         */
        poke53280_0();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
        waitForIdle(50, TimeUnit.MILLISECONDS);
        /*
        Action:
        - open menu,
        - tap on savestate
        - tap on button use current state
        - tap on create screenshot
        - share screenshot and open it from there
        Expected result: C64-Screenshot with text BLERB
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).perform(click());
        waitForIdle();
        prepareIntentHandling();
        onView(withText(R.string.share_screenshot)).inRoot(isPlatformPopup()).perform(click());

    }
}