package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;

import androidx.test.espresso.ViewAssertion;

import org.hamcrest.Matchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PetSettingsTest extends PetEmulationTestBase{
    private void checkExtendedResetMenu(ViewAssertion a) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(withText(R.string.reset_to_6502)).check(a);
        onView(withText(R.string.reset_to_6809)).check(a);
        onView(withText(R.string.reset_to_programmable)).check(a);


    }

    @Test
    public void test40colpet() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        switchToPetModel("4032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isC64Key("!")).check(matches(isDisplayed()));
        onView(isC64Key("TAB")).check(doesNotExist());
        checkExtendedResetMenu(doesNotExist());
        pressBack();
    }
    @Test
    public void test80colpet() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        switchToPetModel("8032");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet8032.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isC64Key("!")).check(doesNotExist());
        onView(isC64Key("TAB")).check(matches(isDisplayed()));
        checkExtendedResetMenu(doesNotExist());
        pressBack();
    }
    @Test
    public void testSuperPet() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        switchToPetModel("SuperPET");
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet8032.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isC64Key("!")).check(doesNotExist());
        onView(isC64Key("TAB")).check(matches(isDisplayed()));
        checkExtendedResetMenu(matches(isDisplayed()));
        onView(withText(R.string.reset_to_6502)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_to_programmable)).check(matches(isEnabled()));
        onView(withText(R.string.reset_to_6809))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-superpet-6809.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        waitForIdle();
        onView(withText(R.string.reset_to_6809)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_to_programmable)).check(matches(isEnabled()));
        onView(withText(R.string.reset_to_6502))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet8032.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    @Test
    public void testOtherSettings() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_petsettings)).perform(click());
        waitForIdle();
        onView(withId(R.id.sp_petmodel)).perform(scrollTo()).perform(click());
        onData(isOption("SuperPET")).perform(click());
        onView(withText(R.string.use_reset_to_switch_superpet_cpu)).check(matches(isDisplayed()));
        onView(withId(R.id.sp_petmodel)).perform(scrollTo()).perform(click());
        onData(isOption("4032")).perform(click());
        onView(withText(R.string.use_reset_to_switch_superpet_cpu)).check(matches(not(isDisplayed())));
        onView(withId(R.id.gh_crtc_settings)).perform(scrollTo()).perform(click());
        onView(withTagValue(equalTo("CRTCExternalPaletteFile"))).perform(scrollTo()).perform(click());
        onData(isOption("amber")).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032-amber.pixelbuffer", 10, TimeUnit.SECONDS)));

    }
    @Test
    public void testDriveSettings() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_petsettings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withTagValue(Matchers.equalTo("Drive8Type"))).perform(scrollTo()).perform(click());
        onData(isOption("CBM 2031")).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-pet4032.pixelbuffer", 10, TimeUnit.SECONDS)));
        try {
            openDocument(extractTestAsset("petdisk.d80"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        waitForIdle();

        onView(isC64Key("C")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("A")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-wrong-drive.pixeldata", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        //onView(withId(R.id.petsettings)).perform(scrollTo()).perform(click());
        //waitForIdle();
        onData(isOption("CBM 2031")).inAdapterView(withTagValue(Matchers.equalTo("Drive8Type")))
                .check(matches(isDisplayed()));

        onView(withTagValue(Matchers.equalTo("Drive8Type"))).perform(scrollTo())
                .perform(click());
        onData(isOption("CBM 8050")).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        waitForIdle(30, TimeUnit.SECONDS);
        waitForIdle();
        try {
            openDocument(extractTestAsset("petdisk.d80"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        onView(isC64Key("C")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("A")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        //waitForIdle(100, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-correct-drive.pixeldata", 10, TimeUnit.SECONDS)));


    }
}
