package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;

import android.view.View;

import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class MapJoystickToKeyboardTest extends PetEmulationTestBase{
    private Matcher<View> spinnerElementMatcher(final int rowId, String tag) {
        return allOf(withParent(withParent(allOf(withParent(isDisplayed()), withId(rowId)))), withTagValue(Matchers.equalTo(tag)));
    }
    private void clickSpinnerElement(final String key, final int rowId, final String tag) {
        Matcher<View> m = spinnerElementMatcher(rowId, tag);
        onView(m).perform(scrollTo()).perform(click());
        onData(isOption(key)).inRoot(isPlatformPopup()).perform(click());
    }
    private void testSpinnerElement(final String key, final int rowId, final String tag) {
        Matcher<View> m = spinnerElementMatcher(rowId, tag);
        onData(isOption(key)).inAdapterView(m).check(matches(isDisplayed()));
    }
    @Test
    public void testKeyboardMapping() {
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_joysticks)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.sw_enable_keystroke_joysticks)).perform(scrollTo()).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#42"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        waitForIdle();
        String shifttext = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.left_shift_key);
        onView(withTagValue(CoreMatchers.equalTo("port#73"))).perform(scrollTo());
        waitForIdle();
        clickSpinnerElement("W", R.id.tr_up_key, "key");
        clickSpinnerElement("S", R.id.tr_down_key, "key");
        clickSpinnerElement("A", R.id.tr_left_key, "key");
        clickSpinnerElement("D", R.id.tr_right_key, "key");
        clickSpinnerElement("?", R.id.tr_fire_key, "key");
        clickSpinnerElement(shifttext, R.id.tr_fire_key, "modificator");
        testSpinnerElement("W", R.id.tr_up_key, "key");
        testSpinnerElement("S", R.id.tr_down_key, "key");
        testSpinnerElement("A", R.id.tr_left_key, "key");
        testSpinnerElement("D", R.id.tr_right_key, "key");
        testSpinnerElement("?", R.id.tr_fire_key, "key");
        testSpinnerElement(shifttext, R.id.tr_fire_key, "modificator");

        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        //onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        FingerState directionState = new FingerState();
        FingerState fireState = new FingerState();
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 10, 50));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 50, 10));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 90, 50));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 50, 90));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.UP, fireState, 50, 50));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-pet-joystickkeys.pixeldata", 1, TimeUnit.SECONDS)));
    }
}
