package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.endsWith;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import android.view.KeyEvent;

import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class KeyboardJoystickTest extends C64JoystickTestBase {
    @Test
    public void t_0010_setup() {
        prepare_port_0_with_dpad_keys();

        /*
        Action: Set Port #0 to None set F9 for fire on Keyset B in Port #1
        Expected result: key F9 for Port 1 is displayed, port 0 is not visible

         */
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        configDirection("FIRE", KeyEvent.KEYCODE_F9, R.string.IDS_PRESS_KEY_FIRE);
        /*
        Action: Set Joystick in Port #1 to None and Joystick in Port #0 to KEYSET A
        Expected Result: Port #0 is displayed with saved values
         */
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_KEYSET_A)).perform(click());
        onView(withTagValue(equalTo("N"))).check(matches(withText(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_DPAD_UP).replace("KEYCODE_",""))));
        onView(withTagValue(equalTo("E"))).check(matches(withText(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_DPAD_RIGHT).replace("KEYCODE_",""))));
        onView(withTagValue(equalTo("W"))).check(matches(withText(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_DPAD_LEFT).replace("KEYCODE_",""))));
        onView(withTagValue(equalTo("S"))).check(matches(withText(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_DPAD_DOWN).replace("KEYCODE_",""))));
        onView(withTagValue(equalTo("FIRE"))).check(matches(withText(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_TAB).replace("KEYCODE_",""))));

        pressBack();
    }

    @Test
    public void t_0190_use_keyset_a() {
        prepare_port_0_with_dpad_keys();
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(20, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_TAB));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_TAB));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    @Test
    public void t_0240_garbage_keys() {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        for (int i = 0; i< 10; i++) {
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DPAD_LEFT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_DPAD_LEFT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_TAB,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_TAB,10,100));
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer")));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_KEYSET_A)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        for (int i = 0; i< 20; i++) {
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DPAD_LEFT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_DPAD_LEFT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DPAD_RIGHT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_DPAD_RIGHT,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_TAB,10,100));
            onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_TAB,10,100));
        }
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer"))));
    }
    @Test
    public void t_0250_use_keyset_b() {
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        configDirection("FIRE", KeyEvent.KEYCODE_F9, R.string.IDS_PRESS_KEY_FIRE);
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());

        waitForIdle();
        onView(withTagValue(equalTo("FIRE"))).perform(click());
        onView(withText(R.string.IDS_ROMSET_ARCHIVE_DELETE)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 2, TimeUnit.SECONDS))));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));

    }
    @Test
    public void t_0400_check_dialog() {
        /*
        Action: open settings, set keyset b, assign F9 to Fire, open dialog to assign key again
        Expected result:
        * text indicating that F9 is assigned, ending with F9.
        * Button delete visible
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_A)).perform(click());
        onView(withTagValue(equalTo("FIRE"))).perform(click());
        onView(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_PRESS_KEY_FIRE)))).check(matches(isDisplayed()));

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_F9));
        waitForIdle();
        onView(withTagValue(equalTo("FIRE"))).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_current_value))
                .check(matches(withText(endsWith("F9"))))
                .check(matches(isDisplayed()));
        /*
        Action: Remove assignment of F9 by pressing "delete, open dialog once more
        Expected result: No text about current assignment, no button delete
         */

        onView(withId(R.id.bn_delete)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("FIRE"))).perform(click());
        onView(withId(R.id.tv_current_value)).check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_delete)).check(matches(not(isDisplayed())));


    }
}