package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;

import static de.rainerhock.eightbitwonders.SettingsActivity.CONFIGURATION;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.lifecycle.Lifecycle;
import androidx.test.espresso.assertion.ViewAssertions;

import androidx.test.ext.junit.rules.ActivityScenarioRule;

import org.junit.Before;
import org.junit.Rule;

abstract class EmulationTestBase extends TestBase{
    abstract protected EmulationConfiguration getConfiguration(Context context);
    protected ActivityScenarioRule<EmulationActivity> getActivityRule()
    {
        Context context = getInstrumentation().getTargetContext();
        EmulationConfiguration conf = getConfiguration(context);
        prepareUseropts();

        return new ActivityScenarioRule<>(new Intent(
                context,
                EmulationActivity.class).putExtra(CONFIGURATION, conf));
    }
    @SuppressWarnings("unused")
    protected void closeAndRestartActivity() {
        mActivityRule = getActivityRule();
    }
    @Rule
    public ActivityScenarioRule<EmulationActivity> mActivityRule = getActivityRule();
    protected void pauseAndResumeActivity()
    {
        Log.v(getClass().getSimpleName(), "pauseAndResumeActivity called");
        mActivityRule.getScenario().moveToState(Lifecycle.State.CREATED);
        mActivityRule.getScenario().moveToState(Lifecycle.State.RESUMED);
        waitForIdle();
        Log.v(getClass().getSimpleName(), "pauseAndResumeActivity called");

    }

    @SuppressWarnings("unused")
    protected void destroyAndResumeActivity()
    {
        mActivityRule.getScenario().moveToState(Lifecycle.State.CREATED);
        mActivityRule.getScenario().moveToState(Lifecycle.State.STARTED);
        mActivityRule.getScenario().moveToState(Lifecycle.State.RESUMED);
    }
    @Before
    public void init() {
        super.init();

        setIsolatedEmulationActivityTest(true);
        /*
        try {
            onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 20, TimeUnit.SECONDS)));
        } catch( AssertionFailedError e) {
            try {
                onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-ntsc.pixelbuffer", 5, TimeUnit.SECONDS)));
            } catch (AssertionError e2) {
                onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-ntsc-v2.pixelbuffer", 5, TimeUnit.SECONDS)));
            }
        }

         */
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(ViewAssertions.matches(isScreenInitialized()));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(ViewAssertions.matches(isScreenUpdating(100)));

    }
    @Override
    protected Activity getCurrentScenarioActivity() {
        final BaseActivity[] activity = new BaseActivity[1];
        mActivityRule.getScenario().onActivity(a -> activity[0] = a);
        return activity[0];
    }

}
