package de.rainerhock.eightbitwonders;


import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.matcher.RootMatchers.withDecorView;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isFocusable;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;


import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.is;

import android.app.Activity;
import android.app.Instrumentation.ActivityResult;
import android.content.Context;
import android.content.Intent;

import android.media.AudioManager;
import android.net.Uri;
import android.os.Debug;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;

import androidx.appcompat.view.menu.MenuView;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.assertion.PositionAssertions;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.intent.Intents;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.ext.junit.runners.AndroidJUnit4;
import androidx.test.filters.LargeTest;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;



@RunWith(AndroidJUnit4.class)
@LargeTest
@FixMethodOrder(MethodSorters.NAME_ASCENDING)

public class EmulationActivityTouchTest extends C64EmulationTestBase {
    public static void startLogging() {
        Debug.startMethodTracing("trace-"+EmulationActivityTouchTest.class.getSimpleName()+".log");
    }

    static class TestIsZoomedMatcher extends TypeSafeMatcher<View> {
        @Override
        protected void describeMismatchSafely(View item, Description mismatchDescription) {
            int[] location = new int[2];
            item.getLocationOnScreen(location);

            mismatchDescription.appendText("xleft = ");
            mismatchDescription.appendValue(location[0]);
            mismatchDescription.appendText("(expected 0), width = ");
            mismatchDescription.appendValue(item.getWidth());
            mismatchDescription.appendText(", (expected ");
            mismatchDescription.appendValue(Objects.requireNonNull(getActivity())
                    .getWindow().getDecorView().getRootView().getWidth());
            mismatchDescription.appendText(")");
        }

        @Override
        protected boolean matchesSafely(View item) {
            String tag=getClass().getSimpleName()+".matchesSafely";
            Log.v(tag, item.toString());
            if (item instanceof MonitorGlSurfaceView) {
                MonitorGlSurfaceView v = (MonitorGlSurfaceView) item;
                int[] location = new int[2];
                v.getLocationOnScreen(location);
                Log.v(tag,String.format("x = %d, w = %d, w0 = %d", location[0], v.getWidth(), Objects.requireNonNull(getActivity()).getWindow().getDecorView().getRootView().getWidth()));
                return (location[0] == 0) || (v.getWidth() == getActivity().getWindow().getDecorView().getRootView().getWidth());
            }
            Log.v(tag,"failed");
            return false;

        }

        @Override
        public void describeTo(Description description) {
            description.appendText("instanceof MonitorGLSurfaceView with xleft = 0 or width = root width");


        }
    }
    private static Matcher<? super View> isZoomed() {
        return new TestIsZoomedMatcher();
    }



    private static ViewAction performVolumeChanges() {
        return new ViewAction() {
            @Override
            public String getDescription() {
                return "check if volume keys are handled correct.";
            }

            @Override
            public Matcher<View> getConstraints() {
                return isRoot();
            }

            @Override
            public void perform(UiController uiController, View view) {
                AudioManager audioManager = (AudioManager) view.getContext().getSystemService(Context.AUDIO_SERVICE);
                boolean mute = audioManager.isStreamMute(AudioManager.STREAM_MUSIC);
                try {
                    uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_VOLUME_MUTE));
                    uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_VOLUME_MUTE));
                    uiController.loopMainThreadForAtLeast(500);
                    boolean ok = audioManager.isStreamMute(AudioManager.STREAM_MUSIC) != mute;
                    uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_VOLUME_MUTE));
                    uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_VOLUME_MUTE));
                    uiController.loopMainThreadForAtLeast(500);
                    if (!ok) {
                        int vol = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)+audioManager.getStreamVolume(AudioManager.STREAM_RING);
                        uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_VOLUME_UP));
                        uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_VOLUME_UP));
                        uiController.loopMainThreadForAtLeast(500);
                        ok = vol != audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)+audioManager.getStreamVolume(AudioManager.STREAM_RING);
                    }
                    if (!ok) {
                        int vol = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)+audioManager.getStreamVolume(AudioManager.STREAM_RING);
                        uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_VOLUME_DOWN));
                        uiController.injectKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_VOLUME_DOWN));
                        uiController.loopMainThreadForAtLeast(500);
                        ok = vol != audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)+audioManager.getStreamVolume(AudioManager.STREAM_RING);
                    }

                    if (!ok) {
                        throw new RuntimeException("Volume key did not change volume");
                    }
                }
                catch (InjectEventSecurityException e) {
                    throw new RuntimeException(e);
                }

            }
        };
    }
    @Test
    public void t_0010_keyboardVisibility() {
        /*
        Action: Test started
        Expected result: Activity showing with keyboard enabled, Emulation screen visible.
         */
        onView(withId(R.id.gv_monitor)).check(ViewAssertions.matches(isScreenInitialized()));
        /*
        Action: Device in portrait mode
        Expected Result: virtual keyboard visible.
         */
        rotate(orientationPortrait(),isDisplayed());
        /*
        Action: Device in landscape mode
        Expected Result: virtual keyboard not visible.
         */

        rotate(orientationLandscape(), not(isDisplayed()));
        /*
        Action: Device in portrait mode
        Expected Result: virtual keyboard visible.
         */
        rotate(orientationPortrait(),isDisplayed());
        /*
        Action: Device in landscape mode
        Expected Result: virtual keyboard not visible.
         */
        rotate(orientationLandscape(), not(isDisplayed()));
    }

    @Test
    public void t_0050_emulation_monitor_geometry() {
        //while (true) {
            /*
            Action: Rotate Device to landscape mode
            Expected Result: virtual keyboard not visible, emulation screen not zoomed.
             */
            rotate(orientationLandscape(), not(isDisplayed()));
            onView(withId(R.id.gv_monitor))
                    // Screen is not zoomed initially, but will be on double tap.
                    .check(ViewAssertions.matches(isScreenInitialized()))
                    .check(matches(ViewMatchers.isDisplayed()))
                    .perform(idleSync(1, TimeUnit.SECONDS))
                    .check(matches(not(isZoomed())));
            /*
            Action: Double tap on emulation screen
            Expected Result: Emulation screen is zoomed and can be scrolled up and down,
            but not to the left and right.
             */
            waitForIdle();
            onView(withId(R.id.gv_monitor))
                    .perform(doubleClick())
                    .perform(idleSync())
                    .check(matches(isZoomed()))
                    .check(matches(isScrolledToTop()))
                    .perform(swipeToTop())
                    .perform(idleSync())
                    .check((matches(not(isScrolledToTop()))))
                    .perform(swipeToBottom())
                    .perform(idleSync())
                    .check(matches(isScrolledToTop()))
                    .check(matches(isScrolledToLeft()))
                    .perform(swipeToLeft())
                    .perform(idleSync())
                    .check(matches(isScrolledToLeft()))
                    .perform(swipeToRight())
                    .perform(idleSync())
                    .check(matches(isScrolledToLeft()));
            /*
            Action: Toggle virtual keyboard visibility
            Expected Result: Emulation screen is still zoomed.
             */
            toggleKeyboard();
            onView(withId(R.id.gv_monitor))
                    .check(matches(isZoomed()));
            /*
            Action: Rotate device to portrait mode and back to landscape
            Expected Result: keyboard is visible in landscape mode, since it was enabled.
             */
            rotate(orientationPortrait(), isDisplayed());
            rotate(orientationLandscape(), isDisplayed());
            /*
            Action: Toggle virtual keyboard visibility
            Expected Result: keyboard not visible, emulation screen still zoomed.
             */
            toggleKeyboard();
            onView(withId(R.id.keyboardview))
                    .check(matches(not(ViewMatchers.isDisplayed())));
            onView(withId(R.id.gv_monitor))
                    .check(matches(isZoomed()));
            /*
            Action: Rotate device to portrait mode
            Expected Result: keyboard is visible
             */
            rotate(orientationPortrait(), isDisplayed());
        //}
    }

    @Test
    public void t_0140_simple_input() {
        /*
        Action: type in some characters with the virtual keyboard.
        Expected Result: Characters are displayed in the emulation screen.
         */

        rotate(orientationPortrait(),isDisplayed());
        onView(isRoot()).perform(performVolumeChanges());
        onView(isC64Key("CTRL")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("C=")).perform(tap());
        onView(isC64Key("C")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("HOME")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-type-characters.pixelbuffer")));
    }
    private Matcher<Root> inEmulationDialog() {
        EmulationActivity[] activity = new EmulationActivity[1];
        mActivityRule.getScenario().onActivity(a -> activity[0] = a);
        return withDecorView(Matchers.not(is(activity[0].getWindow().getDecorView())));

    }
    @Test
    public void t_0170_pausing_and_restarting_emulation() {
        Intents.release();
        Intents.init();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        /*
        Action: Press Home Button and relaunch activity
        Expected Result: Pause dialog is visible, Emulation not running.
         */
        rotate(orientationPortrait(), isDisplayed());
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isScreenInitialized()))
                .check(matches(ViewMatchers.isDisplayed()))
                .check(matches(isScreenUpdating()));
        pauseAndResumeActivity();
        onView(instanceOf(EmulationTestInterface.class))
                .inRoot(inEmulationDialog())
                .check(matches(isScreenInitialized()))
                .check(matches(not(isScreenUpdating())));
        /*
         Action: Press Button in pause dialog
         Expected Result: Dialog disappears, Emulation is running.
         */
        onView(withText(R.string.cont)).perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: Tap Hamburger and choose Pause from the menu
        Expected Result: Pause dialog is visible, Emulation not running.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.pause))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForActivity(EmulationActivity.class);
        /*
        Action: Press Home Button and relaunch activity
        Expected Result: Pause dialog is visible, Emulation not running.
         */
        Log.v(getClass().getSimpleName(), "HURZ!");
        onView(instanceOf(EmulationTestInterface.class))
                .inRoot(inEmulationDialog())
                .check(matches(not(isScreenUpdating())));
        pauseAndResumeActivity();
        onView(instanceOf(EmulationTestInterface.class))
                .inRoot(inEmulationDialog())
                .check(matches(not(isScreenUpdating())))
                .check(matches(isDisplayed()));
        /*
        Action: click button in pause dialog
        Expected Result: emulation running, no dialog visible
         */
        onView(withText(R.string.cont)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
        /*
         Action: Cancel opening a disk image
         Expected Result: Dialog disappears, Emulation is running.
         */
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER)))
                .respondWith(new ActivityResult(Activity.RESULT_CANCELED, null));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.start_open_file)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: Open disk image and run program
        Expected Result: Program is launched.
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withId(R.id.lv_imagecontents)).check(matches(isDisplayed()));
        onData(isOption("SOUNDLOOP")).inAdapterView(withId(R.id.lv_imagecontents)).perform(click());
        waitForActivity(EmulationActivity.class, 20, TimeUnit.SECONDS);

        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer", 30, TimeUnit.SECONDS)));
        /*
        Action: Open Menu with the hamburger menu and select Keyboard.
        Expected Result: Keyboard is invisible
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle(500, TimeUnit.MILLISECONDS);
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());

        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        /*
        Action: Press Home Button and relaunch activity
        Expected Result: Pause dialog is visible, Keyboard invisible.
         */
        Log.v(getClass().getSimpleName(), "HURZ2!");
        pauseAndResumeActivity();
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .inRoot(inEmulationDialog())
                .check(matches(isDisplayed()));
        pressBack();
        try {
            onView(withId(R.string.cont)).perform(click());
        } catch (NoMatchingViewException e) {
            // ok
        }
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating(10)));

        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        onView(allOf(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MP_RESET))),
                withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_MI_RESET_HARD))))).perform(click());
        onView(instanceOf(EmulationTestInterface.class)).check(matches(isScreenUpdating()));
        /*
         Action: Open Menu with the hamburger and then open submenu Reset
         Expected: Result: Emulation is not running.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDMS_RESET)).perform(click());
        waitForIdle();
        onView(instanceOf(EmulationTestInterface.class)).check(matches(not(isScreenUpdating())));
        /*
        Action: Close Reset menu
        Expected Result: menu invisible, Emulation is running.
         */
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));

        /*
        Action: double tap on emulation screen
        Expected Result: nothing happening (portrait mode)
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isZoomed()))
                .perform(doubleClick());
        waitForActivity(EmulationActivity.class, 100, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isZoomed()));
        /*
        Action: double tap fast on emulation screen in landscape mode
        Expected Result: emulation screen will zoom in and out.
         */
        rotate(orientationLandscape(),not(isDisplayed()));
        waitForView(allOf(withId(R.id.gv_monitor),not(isZoomed())),1000, TimeUnit.MILLISECONDS);
        doubleTapOnMonitor();
        doubleTapOnMonitor();
        doubleTapOnMonitor();
        doubleTapOnMonitor();
        doubleTapOnMonitor();
        /*
        Action: open "Quit" dialog and rotate
        Expected result: Dialog still visible
         */
        pressBack();
        onView(instanceOf(EmulationTestInterface.class)).check(matches(isDisplayed()));
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        onView(allOf(withText(R.string.global_action_logout), isDescendantOfA(instanceOf(EmulationDialogFragmentRootview.class)))).check(matches(isDisplayed()));
        /*
        Action: Close dialog and open pause dialog, then rotate
        Expected Result: Pause dialog still visible, emulation not running.
         */
        pressBack();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.pause)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .inRoot(inEmulationDialog())
                .check(matches(isDisplayed()));
        onView(isRoot()).perform(orientationPortrait());
        onView(instanceOf(EmulationTestInterface.class))
                .inRoot(inEmulationDialog())
                .check(matches(not(isScreenUpdating())));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .inRoot(inEmulationDialog())
                .check(matches(isDisplayed()));
        /*
        Action: Leave pause Dialog
        Expected Result: Emulation running.
         */
        pressBack();
        onView(withText(R.string.cont)).check(doesNotExist());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: lock device, rotate it, unlock it (skip on emulators)
        Expected result: Emulation not running, dialog active
         */
        if (lockAndLock()) {
            waitForIdle();
            //onView(isRoot()).perform(waitForMatch(withText(R.string.play_symbol), 1, TimeUnit.SECONDS));
            onView(instanceOf(EmulationDialogFragmentRootview.class))
                    .check(matches(not(isScreenUpdating())));
            onView(withText(R.string.cont)).check(matches(isDisplayed()));
            /*
            Action: leave dialog
            Expected Result: Emulation Running, no dialog active;
             */
            pressBack();
        }
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isDisplayed()));
    }

    private void doubleTapOnMonitor() {
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .perform(doubleClick())
                .perform(idleSync(1, TimeUnit.SECONDS))
                .check(matches(isZoomed()))
                .perform(doubleClick())
                .perform(idleSync(1, TimeUnit.SECONDS))
                .check(matches(not(isZoomed())));
    }


    @Test
    public void t_0470_menu_states_and_audio_pausing() {
        /*
        Action: starting emulation
        Expected result: no audio playing
         */
        rotate(orientationPortrait(),isDisplayed());
        onView(withId(R.id.gv_monitor)).check(matches(not(isAudioPlaying())));
        /*
        Action: launch a program playing sound
        Expected result: audio playing
         */
        Intent resultData = new Intent();
        ActivityResult result =
                new ActivityResult(Activity.RESULT_OK, resultData);
        try {
            resultData.setData(Uri.fromFile(new File(extractTestAsset("soundloop.vsf"))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER))).respondWith(result);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.start_open_file)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer",20, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));
        /*
        Action: open menu
        Expected result: no audio output
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS))
                .check(matches(not(isScreenUpdating())))
                .check(matches(not(isAudioPlaying())));
        /*
        Action: close menu
        Expected result: audio output.
         */
        pressBack();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));
        /*
        Action: open menu
        Expected result:
        - no audio output and no screen update
        - keyboard button is checked
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD))
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())))
                .check(matches(isCheckedButton()))
        /*
        Action: choose Button Keyboard
        Expected result:
        - Audio output and screen update
        - Keyboard disappeared
         */
                .perform(click())
                .check(doesNotExist());
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isAudioPlaying()))
                .check(matches(isScreenUpdating()));
        /*
        Action: open menu
        Expected result:
        - no audio output and no screen update
        - keyboard button is unchecked
        - warp button is unchecked
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD))
                .check(matches(not(isCheckedButton())))
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));
        onView(withText(R.string.IDMS_WARP_MODE))
                .check(matches(not(isCheckedButton())))
        /*
        Action: Select warp button
        Expected result:
        - menu disappears
        - video updating
        - no sound output
         */
                .perform(click())
                .check(doesNotExist());
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(not(isAudioPlaying())))
                .check(matches(isScreenUpdating()));
        /*
        Action: open menu
        Expected result:
        - no audio output and no screen update
        - keyboard button is unchecked
        - warp button is checked
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD))
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())))
                .check(matches(not(isCheckedButton())));
        onView(withText(R.string.IDMS_WARP_MODE))
                .check(matches(isCheckedButton()))
        /*
        Action: tap warp button
        Expected Result:
        - dialog disappears
         */
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isAudioPlaying()))
                .check(matches(isScreenUpdating()));
    }
    @Test
    public void t_0560_pause_and_resume() {
        /*
        Action: starting emulation
        Expected result: no audio playing
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        rotate(orientationPortrait(),isDisplayed());
        onView(withId(R.id.gv_monitor)).check(matches(not(isAudioPlaying())));
        /*s
        Action: launch a program playing sound
        Expected result: audio playing
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        Intent resultData = new Intent();
        ActivityResult result =
                new ActivityResult(Activity.RESULT_OK, resultData);
        try {
            resultData.setData(Uri.fromFile(new File(extractTestAsset("soundloop.vsf"))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER))).respondWith(result);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.start_open_file)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isAudioPlaying(1, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        /*
        Action: open menu
        Expected result: no audio playing and screen not updated
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isRoot())
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        /*
        Action: press home screen and return to app
        Expected result: Expected result: no audio playing and screen not updated, dialog open
        (may be pause-Dialog or the one that was open before
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        pauseAndResumeActivity();
        waitForIdle();
        onView(isRoot())
                .inRoot(inEmulationDialog())
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        /*
        Action: lock and unlock device (skip on emulators)
        Expected result: Expected result: no audio playing and screen not updated, dialog open
        (may be pause-Dialog or the one that was open before
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        if (lockAndLock()) {
            waitForIdle();
            /*
            onView(isRoot())
                    .check(matches(not(isAudioPlaying())))
                    .check(matches(not(isScreenUpdating())));

             */
            onView(isMenuPresent(R.string.start_open_file))
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));


            /*
            Action: leave dialog
            Expected result: audio playing and screen updated
             */
        }
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        //waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BACK));
        //waitForIdle(250, TimeUnit.MILLISECONDS);
        try {
            onView(withText(R.string.IDS_MP_SETTINGS)).check(matches(isDisplayed()));
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BACK));
        } catch (NoMatchingViewException e) {
            // that's ok
        }

        onView(isRoot())
                .check(matches(isAudioPlaying()))
                .check(matches(isScreenUpdating()))
                .check(matches(isDisplayed()));
        /*
        Action: lock and unlock screen (skip on emulators)
        Expected result: Pause dialog active, no audio output, screen not updating
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        if (lockAndLock()) {
            waitForIdle();
            //onView(isRoot()).perform(waitForMatch(instanceOf(EmulationTestInterface.class), 5, TimeUnit.SECONDS));
            onView(instanceOf(EmulationTestInterface.class))
                    .check(matches(not(isAudioPlaying())))
                    .check(matches(not(isScreenUpdating())));
            onView(withText(R.string.cont)).check(matches(isDisplayed()));
            /*
            Action: leave dialog
            Expected result:  audio playing, screen updated.
             */
            Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
            pressBack();
        }
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isAudioPlaying()))
                .check(matches(isScreenUpdating()));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .check(doesNotExist());
        /*
        Press back button to leave the activity (skip for emulators)
        Expected result: Confirmation dialog, no audio output, screen not updated.
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        pressBack();
        onView(withText(R.string.global_action_logout)).check(matches(isDisplayed()));
        if (lockAndLock()) {
            waitForIdle();
            onView(instanceOf(EmulationTestInterface.class))
                    .check(matches(not(isAudioPlaying())))
                    .check(matches(not(isScreenUpdating())));
            onView(instanceOf(EmulationDialogFragmentRootview.class))
                    .check(matches(isDisplayed()));
            /*
            Action:
            - Press back button once to close the dialog and once more to leave the activity
            - leave activity and return.
            Expected result:
            - Dialog active (may be pause or confirmation)
            - no audio output, screen not updated.
             */
            Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        }
        pressBack();
        waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
        pressBack();
        pauseAndResumeActivity();
        waitForIdle();
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .check(matches(isDisplayed()));
        /*
        Action: leave dialog
        Expected result:  audio playing, screen updated.
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        pressBack();
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isAudioPlaying(3, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .check(doesNotExist());
        /*
        Action: leave activity and return.
        Expected result:
        - Pause Dialog active
        - no audio output, screen not updated.
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        pauseAndResumeActivity();
        onView(instanceOf(EmulationTestInterface.class))
                .inRoot(inEmulationDialog())
                .check(matches(not(isAudioPlaying())))
                .check(matches(not(isScreenUpdating())));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .check(matches(isDisplayed()));
        /*
        Action: leave dialog
        Expected result:  audio playing, screen updated, no dialog
         */
        Log.v(getClass().getSimpleName(), new Exception().getStackTrace()[0].toString());
        pressBack();
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isAudioPlaying()))
                .check(matches(isScreenUpdating()));
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .check(doesNotExist());
    }
    @SuppressWarnings("SpellCheckingInspection")
    @Test
    public void t_0710_stop_and_restart() {
        /*
        Action: starting emulation
        Expected result: screen updating
         */
        //rotate(orientationPortrait(),isDisplayed());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

        /*
        Action: type in BLERB
        Expected result: BLERB showing up on the screen
         */
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating(2)));
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        /*
        Action: simulate activity being killed for e.g. low memory and restart it
        Expected result: Pause Dialog
         */
        mActivityRule.getScenario().recreate();
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(instanceOf(EmulationDialogFragmentRootview.class))
                .inRoot(inEmulationDialog())
                .check(matches(isDisplayed()));
        /*
        Action: leave dialog
        Expected result: activity was fully recreated with typed-in text visible again.
         */
        pressBack();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));

    }
    public static Matcher<View> withIndex(final Matcher<View> matcher, final int index) {
        return new TypeSafeMatcher<View>() {
            int mCurrentIndex = 0;

            @Override
            public void describeTo(Description description) {
                description.appendText("with index: ");
                description.appendValue(index);
                matcher.describeTo(description);
            }

            @Override
            public boolean matchesSafely(View view) {
                return matcher.matches(view) && mCurrentIndex++ == index;
            }
        };
    }
    @Test
    public void t_0740_menu_layout() {
        List<Integer> invisibleFirst = Arrays.asList(R.string.flip_file, R.string.detach_file, R.string.IDMS_DATASSETTE_CONTROL);
        rotate(orientationPortrait(),isDisplayed());
        onView(withId(R.id.gv_monitor))
                .perform(idleSync(1, TimeUnit.SECONDS))
                .check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle(2, TimeUnit.SECONDS);
        for (int i:invisibleFirst) {
            try {
                onView(withText(i)).check(matches(not(isDisplayed())));
            } catch (NoMatchingViewException e) {
                // that's ok.
            }
        }
        onView(withText(R.string.IDMS_WARP_MODE)).check(PositionAssertions.isCompletelyBelow(withText(R.string.IDS_KEYBOARD)));
        onView(withText(R.string.IDS_KEYBOARD)).check(matches(isCheckedButton()));
        onView(isRoot()).perform(orientationLandscape());
        waitForIdle();
        boolean dialogStyle;
        try {
            onView(instanceOf(EmulationDialogFragmentRootview.class)).check(matches(isDisplayed()));
            dialogStyle = true;
        } catch (NoMatchingViewException e) {
            dialogStyle = false;
        }
        if (dialogStyle) {
            for (int i : invisibleFirst) {
                onView(withText(i))
                        .check(matches(isDisplayed()))
                        .check(matches(not(isEnabled())))
                        .check(matches(anyOf(isDescendantOfA(Matchers.instanceOf(MenuView.ItemView.class)), not(isFocusable()))));
            }
            onView(withText(R.string.IDMS_WARP_MODE)).check(PositionAssertions.isCompletelyRightOf(withText(R.string.IDS_KEYBOARD)));
            onView(withText(R.string.IDS_KEYBOARD)).check(matches(not(isCheckedButton())));
        } else {
            for (int i:invisibleFirst) {
                try {
                    onView(withText(i)).check(matches(not(isDisplayed())));
                } catch (NoMatchingViewException e) {
                    // that's ok.
                }
            }

        }
        try {
            try {
                // Check if menu is visible and if so close it.
                onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
                pressBack();
                waitForIdle();
            } catch (NoMatchingViewException e) {
                // that's ok
            }
            openDocument(extractTestAsset("soundloop.tap"));
            onView(withText(R.string.IDS_ATTACH))
                    .check(matches(isDisplayed()))
                    .perform((click()));
            waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
            openDocument(extractTestAsset("fliplist1.vfl"));


        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(anyOf(withText("flipdisk 2.d64"),withText("FLIPDISK 2.D64")))
                .check(matches(isDisplayed()))
                .check(matches(isEnabled()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        for (int i:invisibleFirst) {
            onView(withText(i))
                    .check(matches(isDisplayed()))
                    .check(matches(isEnabled()))
                    .check(matches(anyOf(isDescendantOfA(Matchers.instanceOf(MenuView.ItemView.class)), isFocusable())));
        }
        // Detach all images to make menu visible without scrolling
        waitForIdle();
        onView(withText(R.string.detach_file))
                .perform(scrollTo())
                .perform(click());
        waitForIdle();
        onView(withIndex(instanceOf(Button.class),0)).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.detach_file)).perform(scrollTo()).check(matches(isDisplayed()));
        onView(isRoot()).perform(orientationPortrait());
        waitForIdle();
        onView(withText(R.string.detach_file)).perform(scrollTo()).perform(click());
        onView(withIndex(instanceOf(Button.class),0)).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withText(R.string.detach_file)).check(doesNotExist());
        waitForIdle();

    }
    @Test
    public void t_swipe_to_hide_keyboard() {
        /*
        Action: open in portrait mode
        Expected result: keyboard is visible.
         */
        rotate(orientationPortrait(),isDisplayed());
        /*
        Action: Press back button
        Expected result: Dialog "Quit"
         */
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).check(matches(isDisplayed()));
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        /*
        Action: rotate to landscape mode
        Expected result: keyboard is not visible.
         */
        rotate(orientationLandscape(),not(isDisplayed()));
        /*
        Actíon: enable keyboard
        Expected result: keyboard is visible
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle(500, TimeUnit.MILLISECONDS);
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        /*
        Action: Press back
        Expected result: keyboard is hidden.
         */
        pressBack();
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(withText(R.string.quit)).check(doesNotExist());
        /*
        Action: rotate portrait mode
        Expected result: keyboard is visible.
        */
        rotate(orientationPortrait(),isDisplayed());
        /*
        Action: Press back button
        Expected result: Dialog "Quit"
         */
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).check(matches(isDisplayed()));


    }
    @Test
    @SpecialTest
    public void test_crash() {
        Intents.release();
        Intents.init();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        try {
            openDocument(extractTestAsset("__crashtest__.vsf"));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.jv_fire)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
    }
}