package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import android.widget.EditText;

import androidx.test.filters.SdkSuppress;

import org.junit.Test;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class C64SettingsTest extends MainActivityTestBase{
    @Test
    public void t_0070_vicii_settings() {
        onView(withText(TWO_DRIVES)).check(doesNotExist());
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 500, TimeUnit.MILLISECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("VICIIBorderMode"))),withTagValue(equalTo("3"))))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb-borderless.pixelbuffer", 2, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.cb_c64_crt_emulation))
                .check(matches(not(isChecked())))
                .perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
        try {
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb-borderless-crt.pixelbuffer", 5, TimeUnit.SECONDS)));
        } catch (AssertionError e) {
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb-borderless-crt-variant.pixelbuffer", 5, TimeUnit.SECONDS)));
        }
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withTagValue(equalTo("VICIIExternalPaletteFile"))).perform(click());
        waitForIdle();
        onData(isOption("frodo")).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("screenshot-frodo-borderless.pixelbuffer")));



    }
    final private static String TWO_DRIVES="_2_DRIVES_";
    @Test
    public void t_0160_save_correct_settings() {
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("Drive9Type"))).perform(click());
        onData(isOption("CBM 1541")).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        type_load_directory(9);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9.pixelbuffer",60,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        /*
        Action: type "joy" as name and click on "OK"
        Expected result: Emulation is shown again
         */

        waitForIdle(1, TimeUnit.SECONDS);
        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(TWO_DRIVES))
                .perform(closeSoftKeyboard());

        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_DRIVES, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9.pixelbuffer",40,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_c64_settings)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("Drive9Type"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_DRIVES, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9.pixelbuffer",30,TimeUnit.SECONDS)));
        type_load_directory(9);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9-2nd-attempt-no-device.pixelbuffer",30,TimeUnit.SECONDS)));


        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_DRIVES, longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(TWO_DRIVES)).check(doesNotExist());
    }
    @Test
    @SdkSuppress(minSdkVersion=20)
    public void t_0270_bubble_escape () {
        setTestLocale(Locale.US);
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY,TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-bubble-escape.pixelbuffer",20, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("VICIIBorderMode"))),withTagValue(equalTo("3")))).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-bubble-escape-borderless.pixelbuffer",20, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class);
        onView(isRoot()).perform(createdTileAction("Bubble Escape", click()));
        waitForIdle();
    }
    @Test
    public void test_memory_expansions() throws IOException {
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));
        openDocument(extractTestAsset("reudetect.prg"));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-reu-not-detected.pixelbuffer",5,TimeUnit.SECONDS)));
        openDocument(extractTestAsset("georam64.prg"));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-georam-not-detected.pixelbuffer",5,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo()).perform(click());
        onView(withId(R.id.sp_c64_c128_memory_expansions)).perform(scrollTo()).perform(click());
        onData(isOption("CBM REU 1750 (512k)")).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        openDocument(extractTestAsset("reudetect.prg"));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-reu-detected.pixelbuffer",5,TimeUnit.SECONDS)));
        openDocument(extractTestAsset("georam64.prg"));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-georam-not-detected.pixelbuffer",5,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.sp_c64_c128_memory_expansions)).perform(scrollTo()).perform(click());
        onData(isOption("GeoRAM (512k)")).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        openDocument(extractTestAsset("georam64.prg"));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-georam-detected.pixelbuffer",5,TimeUnit.SECONDS)));

    }
}
