package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.not;

import android.view.KeyEvent;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.test.espresso.NoMatchingViewException;

import junit.framework.AssertionFailedError;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

abstract class C64JoystickTestBase extends C64EmulationTestBase {
    @SuppressWarnings("unused")
    public static DpadJoystick getTestDpad() {
        return new UnitTestDpadJoystick();
    }

    protected void check_diagonals_not_checked (Matcher<Object> optionMatcher) {
        /*
        Action: open settings
        Expected result: Checkbox "Lock diagonals" is not checked.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(optionMatcher).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo());
        onView(allOf(isDisplayed(), withId(R.id.cb_lock_diagonals))).check(matches(not(isChecked())));
        /*
        Action: leave settings and autostart autostart program displaying joystick values.
        Expected result: 255 is displayed
         */
        onView(withId(R.id.bn_apply)).perform(click());

    }

    protected void run_joystick_test_program() {
        run_program("JOYSTICKTEST", "screenshot-joystick-centered.pixelbuffer");
    }

    private void toggle_diagonals_check(Matcher<View> matchBefore) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.cb_lock_diagonals)))
                .check(matches(matchBefore))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle(5,TimeUnit.SECONDS);

    }
    protected void set_check_in_lock_diagonals() {
        toggle_diagonals_check(not(isChecked()));
    }
    protected void unset_check_in_lock_diagonals() {
        toggle_diagonals_check(isChecked());
    }

    protected void prepare_port_0_with_dpad_keys() {
    /*
    Action: open settings and set Cursor Keys + Tab for Keyset A in Port #ß
    Expected result: keys are displayed
     */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_A)).perform(click());
        configDirection("N", KeyEvent.KEYCODE_DPAD_UP, R.string.IDS_PRESS_KEY_NORTH);
        configDirection("W", KeyEvent.KEYCODE_DPAD_LEFT, R.string.IDS_PRESS_KEY_WEST);
        configDirection("S", KeyEvent.KEYCODE_DPAD_DOWN, R.string.IDS_PRESS_KEY_SOUTH);
        configDirection("E", KeyEvent.KEYCODE_DPAD_RIGHT, R.string.IDS_PRESS_KEY_EAST);
        configDirection("FIRE", KeyEvent.KEYCODE_TAB, R.string.IDS_PRESS_KEY_FIRE);
    }

    private void map_secondary_button(@StringRes int textId, @StringRes int oldTextId, String bitmap,
                                      Runnable pressSecondButton, Runnable releaseSecondButton,
                                      String device) {
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        try {
            onView(withTagValue(equalTo("port#2"))).check(matches(isDisplayed()));
        } catch (AssertionFailedError e) {
            onView(withText(R.string.joysticks)).perform(click());
            waitForIdle();
        }
        onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        /* Action
        Choose Joystick "Joystick _UNITTEST_GAMECONTROLLER_JOYSTICK_ (Joystick 1)" and load JOYSTICKTEST from testprograms.
        Expected result: 255 is displayed
         */
        onData(isOption(device)).perform(click());
        waitForIdle();
        //onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(scrollTo());
        if (oldTextId != View.NO_ID) {
            onData(isOption(oldTextId)).inAdapterView(allOf(isDisplayed(), withId(R.id.sp_secondary_button))).check(matches(isDisplayed()));
        }
        waitForIdle();
        //onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(scrollTo());
        //waitForIdle(1, TimeUnit.MINUTES);
        onView(allOf(isDisplayed(), withId(R.id.sp_secondary_button))).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withText(textId)).perform(click());
        // for whatever reason click() causes the Input Type Spinner to be opened to be opened,
        // so we close it.
        try {
            onView(withText(R.string.paddle)).check(matches(isDisplayed()));
            pressBack();
        } catch (NoMatchingViewException e) {
            // that's ok
        }
        onData(isOption(textId)).inAdapterView(allOf(isDisplayed(), withId(R.id.sp_secondary_button))).check(matches(isDisplayed()));
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        pressSecondButton.run();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(bitmap, 20, TimeUnit.SECONDS)));
        releaseSecondButton.run();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
    }

    protected void test_specific_button(Runnable pressSecondButton, Runnable releaseSecondButton,
                                        Runnable joystickRight, Runnable joystickCentered,
                                        final String device) {
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        map_secondary_button(R.string.fire, View.NO_ID, "screenshot-joystick-fire.pixelbuffer", pressSecondButton, releaseSecondButton, device);
        map_secondary_button(R.string.up, R.string.fire, "screenshot-joystick-up.pixelbuffer", pressSecondButton, releaseSecondButton, device);
        map_secondary_button(R.string.down, R.string.up, "screenshot-joystick-down.pixelbuffer", pressSecondButton, releaseSecondButton, device);
        map_secondary_button(R.string.left, R.string.down, "screenshot-joystick-left.pixelbuffer", pressSecondButton, releaseSecondButton, device);
        map_secondary_button(R.string.right, R.string.left, "screenshot-joystick-right.pixelbuffer", pressSecondButton, releaseSecondButton, device);


        //map_secondary_button(R.string.left, View.NO_ID, "screenshot-joystick-left.pixelbuffer");
        pressSecondButton.run();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 20, TimeUnit.SECONDS)));
        joystickRight.run();

        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 1, TimeUnit.SECONDS)));
        releaseSecondButton.run();
        waitForIdle(100, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 200, TimeUnit.MILLISECONDS)));
        joystickCentered.run();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));

    }

    static class UnitTestDpadJoystick extends DpadJoystick {
        boolean deviceHasButtonWithKeycode(int keycode) {
            return Arrays.asList(KeyEvent.KEYCODE_BUTTON_A, KeyEvent.KEYCODE_BUTTON_B)
                    .contains(keycode);
        }
        public UnitTestDpadJoystick() {
            super(null);
        }
        String getId() {
            return "---unittest---";
        }
        @Override
        String getHardwareButtons() {
            return "KEYBUTTON_A";
        }
        @Override
        String getHardwareDescriptor() {
            return "--unittest--";
        }
        @Override
        int getHardwareId() {
            return DEVICE_ID;
        }

        @NonNull
        @Override
        public String toString() {
            return "_UNITTEST_DPAD_JOYSTICK_";
        }
    }
}
