/*
Test script for JavaScriptTests.peeks_and_pokes
*/
key_b = true
emu.addTextVisibilityListener("ready.", emu.TO_VISIBLE, () => {
    // Action: Press Key "A"
    // Expected result: Border color to grey

    // Action: Press Key "A"
    // Expected result: Border color to black
    emu.addKeyboardListener(emu.KEY_PRESSED,1,2,() => {
        emu.poke(53280, (emu.peek(53280)+1) & 255);
        key_b = !key_b;
        return 1;
    });
    emu.addKeyboardListener(emu.KEY_RELEASED,1,2,() => {
        return 1;
    });
    // Action: Press Key "B"
    // Expected result: first to lines of screen contents flip

    emu.addKeyboardListener(emu.KEY_PRESSED,3,4,() => {    
        row1= emu.getScreenAddress(0,0);
        data1 = emu.peek(row1,40);
        row2=emu.getScreenAddress(0,1);
        data2 = emu.peek(row2,40);
        emu.poke(row1,data2);
        emu.poke(row2,data1);
        return 1;
    });
    emu.addKeyboardListener(emu.KEY_RELEASED,3,4,() => {
        return 1;
    });
    // Action: Press KEY "C"
    // Expected result: "8 BIT WONDERS" is printed in the list line
    emu.addKeyboardListener(emu.KEY_PRESSED,2,4,() => {    
        petscii=emu.charconvert("8 bit wonders",emu.SCREENCODE);
        row25=emu.getScreenAddress(0,24);
        emu.poke(row25,petscii);
        return 1;
    });
    emu.addKeyboardListener(emu.KEY_RELEASED,2,4,() => {
        return 1;
    });
    memory=null;
    emu.addTextVisibilityListener("000", emu.TO_VISIBLE, () => {
        row= emu.getScreenAddress(0,23);
        memory = emu.peek(row1,40);
        petscii=emu.charconvert("zeros entered",emu.SCREENCODE);        
        emu.poke(row,petscii);        
        emu.log(emu.LOG_VERBOSE, "addTextVisibilityListener");
    })
    // (Test: delete one character from the screen and background will be blue again.
    emu.addTextVisibilityListener("000", emu.TO_INVISIBLE, () => {
        emu.log(emu.LOG_VERBOSE, "addTextVisibilityListener2 "+memory);
        emu.poke(emu.getScreenAddress(0,23), memory);

    });        
    emu.addMemoryChangedListener(2,emu.LESS,2,() => {
        emu.poke(emu.getScreenAddress(0,22),emu.charconvert("one",emu.SCREENCODE));
    });
    emu.addMemoryChangedListener(2,emu.EQUAL,2,() => {
        emu.poke(emu.getScreenAddress(0,22),emu.charconvert("two",emu.SCREENCODE));
    });
    emu.addMemoryChangedListener(2,emu.EQUAL|emu.MORE,3,() => {
        emu.poke(emu.getScreenAddress(0,22),emu.charconvert("many",emu.SCREENCODE));
    });        
    emu.addKeyboardListener(emu.KEY_PRESSED,2,2,() => {        
        emu.addTask(() => {
            //emu.log(emu.LOG_VERBOSE, "executeAfterVsync_Listenered");
            emu.poke(emu.getScreenAddress(0,21),emu.charconvert("delayed",emu.SCREENCODE));
        },60);
        return true;
    });
    emu.addKeyboardListener(emu.KEY_RELEASED,2,2,() => {        
        return true;
    });
}); 