# 8-Bit Wonders

8-Bit Wonders is an [Emulator](https://en.wikipedia.org/wiki/Emulator) intended to execute programs for old 8-bit computers on devices running Android OS.
At the moment, the following devices are supported:

* [Commodore C64](https://en.wikipedia.org/wiki/Commodore_64)
* [Commodore VIC 20](https://en.wikipedia.org/wiki/VIC-20)
* [Commodore C128](https://en.wikipedia.org/wiki/Commodore_128)
* [Commodore PET series (200x, 30xx, 40xx and 80xx)](https://en.wikipedia.org/wiki/Commodore_PET)

More devices will follow.

Features:
* **Device Compatibility**: Mobile devices and TVs
* **Input Support**: Hardware joysticks, gamepads, mice, and virtual touch joystick
* **Keyboard Options**: Hardware and virtual keyboard with original layout
* **Game Management**: Import/export and download from archive.org
* **Customization**: Map buttons to keystrokes or enable autofire
* **Extras**: Save states and a time machine to turn back time and undo any mistakes or unfortunate events during your gameplay
## Installation

### Stores

The app is available on F-Droid store, Google Play and Amazon Appstore, see [gitlab page](https://eightbitwonders.gitlab.io/app) for links.

### Build with Android Studio

You can get the sources within Android Studio by choosing `File`➔`New`➔`Project from Version Control`. The required URL is https://gitlab.com/eightbitwonders/app.git.

### Build using Android SDK

After cloning the repository from  https://gitlab.com/eightbitwonders/app.git type

```
cd /path/to/repository
./gradlew assembleDebug
```

### Build with docker

After cloning the repository from  https://gitlab.com/eightbitwonders/app.git type

```
docker run  -it -v /path/to/repository:/project registry.gitlab.com/eightbitwonders/buildcontainer/buildcontainer:stable ./gradlew assembleDebug
```

## Getting started

There is an introduction available in [english](https://eightbitwonders.gitlab.io/app/manual-en.htm) and [german](https://eightbitwonders.gitlab.io/app/manual-de.htm).

## Support

See https://eightbitwonders.gitlab.io/app/feedback

## Roadmap

### For Now

- [X] Refactor legacy code for clarity and maintainability.
- [X] Do the final tests.
- [X] Get added to F-Droid store.
- [X] Add TV-Support.
- [X] Get added to Amazon Appstore.
- [X] Get added to Google Play.
- [X] Create access to some free and legal content.
- [X] Create access to even more free and legal content. 
- [X] Add PET emulation.
- [X] Add C128 emulation
- [ ] CRT simulation
- [ ] Unified user interface for TVs and mobile devices

### Future Plans
 
- [ ] Add non-Commodore stuff
- [ ] Why not have a version running in browsers?

## Authors and acknowledgment
A really huge "Thank you!" to the [VICE-Team](https://vice-emu.sourceforge.io/), but many others must not be forgotten. Get more info with "License and information" in the app's main menu.

## License

[GPL 2.0](https://opensource.org/licenses/gpl-2.0.php)

