#!/usr/bin/python3
import hashlib
import os.path
import sys
import urllib.request
from urllib.error import HTTPError
from urllib.parse import urlparse
import yaml

def parsefile(filename):
    with open(filename, "r") as f:
        downloads = yaml.safe_load(f)
        if downloads:
            for localfile in downloads["files"]:
                for download in localfile["downloads"]:
                    data = None
                    #print (download["parts"])
                    httperror = False
                    for part in download["parts"]:

                        url =  urlparse(part)

                        if url:
                            if url.scheme == "https" and filename:
                                try:
                                    response = urllib.request.urlopen(part, None)
                                    if data:
                                        data += response.read()
                                    else:
                                        data = response.read()
                                except HTTPError as e:
                                    sys.stderr.write("HTTP Result %d for %s" % (e.getcode(), e.geturl()))
                                    sys.stderr.write("\n")
                                    data=None
                                    httperror = True
                                    ret = False
                    if data:
                        hashdigest = hashlib.md5(data).hexdigest()
                        if hashdigest == download["hash"]:
                            with open(os.path.join(os.path.dirname(filename), localfile["name"]),"wb") as targetfile:
                                targetfile.write(data)
                                break

                        else:
                            if not httperror:
                                sys.stderr.write ("hash %s calculated for %s does not match stored value %s\n" % (hashdigest, " ".join(download["parts"]), download["hash"]))
                            return False

    return False

    

if __name__ == "__main__":
    error = False
    for filename in sys.argv[1:]:
        print ("Parsing %s" % filename)
        if not parsefile(filename):
            error = True
    if error:
        sys.exit(1)