#!/bin/bash

set -e

REPO=$1
REPO_ENCODED=$(echo $REPO|sed 's/\//\%2f/g')
LOCALPATH=$2
REMOTEPATH=$3
REMOTEPATH_ENCODED=$(echo $REMOTEPATH|sed 's/\//\%2f/g')
COMMIT=$4
EXIST=$(curl --head https://gitlab.com/api/v4/projects/$REPO_ENCODED/repository/files/${REMOTEPATH_ENCODED}?ref=main|grep x-gitlab-last-commit-id|wc -l)

if [ $EXIST -eq 0 ]; then ACTION=create; else ACTION=update; fi
if [ $EXIST -eq 0 ]; then echo Creating new file.; else echo Updating existing file.; fi

PAYLOAD='{ "branch": "main", "commit_message": "Created by Pipeline on commit https://gitlab.com/eightbitwonders/app/-/commit/__COMMIT__", "actions": [ {"action": "__ACTION__", "file_path": "__REMOTEPATH__", "content": "__CONTENT__", "encoding": "base64"}]}'
PAYLOAD=${PAYLOAD//__ACTION__/$ACTION}
PAYLOAD=${PAYLOAD//__REMOTEPATH__/$REMOTEPATH}
PAYLOAD=${PAYLOAD//__COMMIT__/$COMMIT}
PAYLOAD=${PAYLOAD//__CONTENT__/$(base64 -w 0 $LOCALPATH)}
FILENAME=$(mktemp)
echo $PAYLOAD>$FILENAME
curl --request POST --header "PRIVATE-TOKEN: $(cat admin_api_access_token)" --header "Content-Type: application/json" "https://gitlab.com/api/v4/projects/$REPO_ENCODED/repository/commits" --data @${FILENAME}
rm $FILENAME