//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------
#include "cartridge.h"
#define UICART_VIC20_SMART 7
#define UICART_VIC20_BEHRBONZ 8
#define UICART_VIC20_MEGACART 9
#define UICART_VIC20_FINALEXP 10
#define UICART_VIC20_ULTIMEM 11
#define UICART_VIC20_FLASHPLUGIN 12
#define UICART_VIC20_GENERIC 13
#define UICART_VIC20_ADD_GENERIC 14
static cartridge_info_t cartlist[] = {
            { "Smart-attach",               UICART_VIC20_SMART },
            { "Behr Bonz",                  UICART_VIC20_BEHRBONZ },
            { "Mega Cart",                  UICART_VIC20_MEGACART },
            { "Final Expansion",            UICART_VIC20_FINALEXP },
            { "UltiMem",                    UICART_VIC20_ULTIMEM },
            { "Vic Flash Plugin",           UICART_VIC20_FLASHPLUGIN },
            { "Generic",                    UICART_VIC20_GENERIC },
            { "Add to generic cartridge",   UICART_VIC20_ADD_GENERIC },
            { NULL, -1 }
};
cartridge_info_t *cartridge_get_info_list(void)
{
    return &cartlist[0];
}



