//
// Created by rainer on 07.03.23.
//
#include <string.h>
#include "javascript.h"
#include "javascript_callbacks.h"
#include "lib.h"
#include "charset.h"
#include "mem.h"

static JSValue create_softkey(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    int32_t row;
    uint32_t col;
    uint32_t shiftstate;
    expected_parameters parameters[] = {
            {"text",         JS_TAG_STRING, 0, 0,  0},
            {"id",         JS_TAG_STRING, 0, 0,  0},
            {"row",        JS_TAG_INT,    1, -5, 7},
            {"col",        JS_TAG_INT,    1, 0, 7},
            {"shiftstate", JS_TAG_INT,    1, 0,  32767},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        JS_ToInt32(ctx, &row, argv[2]);
        JS_ToUint32(ctx, &col, argv[3]);
        JS_ToUint32(ctx, &shiftstate, argv[4]);
        js_create_softkey(JS_ToCString(ctx, argv[0]),
                          JS_ToCString(ctx, argv[1]),
                          (int) row, (int) col, (int) shiftstate);
        ret = JS_UNDEFINED;
    }
    return ret;
}
static JSValue destroy_softkey(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters parameters[] = {
            {"id",         JS_TAG_STRING, 0, 0,  0}
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        js_destroy_softkey(JS_ToCString(ctx, argv[0]));
        ret = JS_UNDEFINED;
    }
    return ret;
}
static JSValue enable_softkey(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters parameters[] = {
            {"id",         JS_TAG_STRING, 0, 0,  0},
            {"state", JS_TAG_BOOL, 0, 0, 0}
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        js_enable_softkey(JS_ToCString(ctx, argv[0]),
                          JS_ToBool(ctx, argv[1]) ? 1 : 0);
        ret = JS_UNDEFINED;
    }
    return ret;
}


static JSValue show_toast(JSContext *ctx, __attribute__((unused)) JSValueConst this_val, int argc, JSValueConst *argv) {
    expected_parameters parameters[] = {
            {"text",         JS_TAG_STRING, 1, 1,  INT32_MAX},
    };
    JSValue ret = js_checksyntax(__FUNCTION__, ctx, argc, argv, parameters, LEN(parameters));
    if (!JS_IsException(ret)) {
        const char *s = JS_ToCString(ctx, argv[0]);
        js_show_toast(s);
        ret = JS_UNDEFINED;
        JS_FreeCString(ctx, s);
    }
    return ret;
}
const JSCFunctionListEntry uifunctions[] = {
        JS_CFUNC_DEF("createSoftkey", 5, create_softkey),
        JS_CFUNC_DEF("destroySoftkey", 1, destroy_softkey),
        JS_CFUNC_DEF("enableSoftkey", 2, enable_softkey),
        JS_CFUNC_DEF("showToast", 1, show_toast)
};
int uifunctions_size = sizeof(uifunctions)/sizeof(uifunctions[0]);