//
// Created by rainer on 23.01.24.
//
#include <mutex>
#include <list>
extern "C" {
#include "mem.h"
#include "logginghelpers.h"
#include "lib.h"
#include "javascript_callbacks.h"
}

#ifndef APP_JAVASCRIPTTASKLIST_H
#define APP_JAVASCRIPTTASKLIST_H
class JavaScriptTask {
public:
    void setEnabled (bool value);
    void setGarbage();
    bool isGarbage() const;
    [[nodiscard]] uint32_t getId () const;
    virtual ~JavaScriptTask() = default;
    [[nodiscard]] bool isEnabled() const;
    virtual void fullfill() = 0;

protected:
    virtual bool check();
    JavaScriptTask();
private:
    uint32_t mId;
    bool mEnabled = true;
    bool mGarbage = false;
};
class Listener : public JavaScriptTask {
protected:
    Listener(JSContext *ctx, JSValue  func, JSValue  this_obj, int argc, JSValueConst *argv);
    virtual bool execute();
    JSContext *mCtx = nullptr;
    JSValue mFunc = JS_UNDEFINED;
    JSValue mThisObj= JS_UNDEFINED;
public:
    virtual ~Listener() override;
    void fullfill() override;
    JSContext* getContext();
    const static int ACTION_PRESS=1;
    const static int ACTION_RELEASE=2;
private:
    JSValue *mArgv = nullptr;

    int mArgc = 0;


};
class Usertask : public Listener {
public:
    bool check() override;
    Usertask(JSContext* ctx, JSValue  func, JSValue  this_obj, uint32_t vsyncs2skip = 0);
    bool execute() override;

private:
    uint32_t mVsyncs2Skip=0;
};
class KeyboardListener: public Listener{
public:
    KeyboardListener(JSContext *ctx, int row,  int col, unsigned int action,JSValue func, JSValue thisObj);
    bool handle(bool pressed, int row, int col);
private:
    int mRow;
    int mCol;
    unsigned int mAction;

};
class JoystickListener: public Listener{
public:
    JoystickListener(JSContext *ctx, unsigned int joyport, JSValue func, JSValue thisObj);

    bool handle(unsigned int port, uint8_t value);
private:
    unsigned int mJoyport=0;
    unsigned int mLastValue = 255;

};

class GamepadButtonListener : public  Listener {
public:
    GamepadButtonListener (JSContext* ctx, unsigned int action, unsigned int keycode,
                           JSValue function, JSValue thisObj);
    bool handle(bool pressed, int keycode);
private:
    unsigned int mAction = 0;
    unsigned int mKeycode = 0;
};

class TextVisibilityListener : public  Listener{

public:
    TextVisibilityListener(JSContext *ctx, uint8_t *screentext, uint8_t *screentext_reverse,
                           size_t textlen, uint32_t mode, JSValue function, JSValue thisObj);

    bool check() override;

    const static int TO_VISIBLE=1;
    const static int TO_INVISIBLE=2;
private:
    uint8_t *mScreentext;
    uint8_t *mScreentextReverse;
    size_t mTextlen;
    uint32_t mTextVisibilityFilter;
    bool mTextWasVisible=false;

    bool isTextVisible();

};
class MemoryChangedListener : public Listener{
private:
    uint16_t mAdress;
    uint32_t mMemoryOperator;
    int mValue;
    uint8_t mStoredValue;
public:
    MemoryChangedListener(JSContext *ctx, uint16_t adress, uint32_t memory_operator, uint8_t value, JSValue func, JSValue thisObj);

    bool check() override;
    const static int EQUAL = 1 << 0;
    const static int LESS = 1 << 1;
    const static int MORE = 1 << 2;
};

class JavascriptTasklist {
public:
    static uint32_t getNexId();
    void setCurrentListenerId([[maybe_unused]] JSContext* ctx, uint32_t id);
    JSValue  getCurrentListenerId(JSContext* ctx) const;
    const static int NOT_IN_LISTENER = 0;
    static JavascriptTasklist* getInstance();
    static JavascriptTasklist *mInstance;
    JavascriptTasklist();
    virtual ~JavascriptTasklist();
    uint32_t addTask(JavaScriptTask* t);
    void callTasks();
    bool handleKeyboardAction(bool pressed, int row, int col);
    bool handleGamepadAction(bool pressed, int keycode);
    bool handleJoysticks(unsigned int port, uint8_t value);
    void cleanup();
    JSValue enableTask(JSContext* ctx, JSValue taskId);
    JSValue disableTask(JSContext* ctx, JSValue taskId);
    JSValue removeTask(JSContext* ctx, JSValue taskId);

    void gc();

private:
    std::list<JavaScriptTask*> mTasks;
    std::list<JavaScriptTask*> mDeadTasks;
    std::mutex myMutex;
    bool mInTaskExecution = false;
    enum requestedTaskTaste {ENABLED, DISABLED, REMOVED};
    JSValue setTaskState(JSContext* ctx, JSValue taskId, requestedTaskTaste newState);

    uint32_t mCurrentListenerId=NOT_IN_LISTENER;

};
#endif //APP_JAVASCRIPTTASKLIST_H
