//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <jni.h>
#include <pthread.h>
#ifndef EIGHTBITWONDERS_THREADLAUNCHER_H
#define EIGHTBITWONDERS_THREADLAUNCHER_H

typedef struct
{
    pthread_t mainthread;
    pthread_t workerthread;
    JNIEnv* mainenv;
    JNIEnv* workerenv;
    int worker_crashed;
    JavaVM* vm;
    const char* libname;
    jobject instance;
    void* dynlib;
    int is_alive;
    struct{
        int _signo;
        int _code;
        int _errno;
        void* _addr;
    } crashinfo;
    const char recoverysnapshot[1024];
    int recovery_written;
    void *dynlib_common;
    int is_under_test;

} t_shared_data;

void startthread (JNIEnv * env, jobject instance,const char* libname, void* dynlib, void* dynlib_common, JNIEnv* mainenv, pthread_t mainthread);

__attribute__((unused)) __attribute__((unused)) void stop_emulation();
#endif //EIGHTBITWONDERS_THREADLAUNCHER_H
