//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifdef HAVE_COMMON_SO
#include <alarm.h>
#include <clkguard.h>
#include <vdrive.h>
#include <diskimage.h>
#include "machine_specific_bindings.h"
#include "logginghelpers.h"

void raiseException(const char* missing_function) {
    LOGE("%s is missing", missing_function);
}

CLOCK maincpu_clk = 0L;
alarm_context_t *maincpu_alarm_context = NULL;
clk_guard_t *maincpu_clk_guard = NULL;
int maincpu_rmw_flag;
//uint8_t mem_ram[];
unsigned int reg_pc;

CLOCK maincpu_clk_limit;
struct monitor_interface_s *maincpu_monitor_interface;
struct interrupt_cpu_status_s *maincpu_int_status=NULL;
uint8_t plus4tcbm_outputa[2], plus4tcbm_outputb[2], plus4tcbm_outputc[2];
int machine_class;
int console_mode;
int video_disabled_mode;
void set_console_mode(int v) {
    console_mode = v;
}
void set_video_disabled_mode(int v) {
    video_disabled_mode = v;
}
uint8_t *mem_p=NULL;
__attribute__((unused)) void set_ram(uint8_t* v) {
    mem_p=v;
}
uint8_t* get_ram() {
    return mem_p;
}
#endif