//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#include "cartui.h"

extern t_group_entry* groups;
extern t_cartrige_entry cartridges;

int get_groupcount()
{
    cartridge_info_t * cartridges= cartridge_get_info_list();
    int i=0;
    while (cartridges[i].name)
    {
        i++;
    }
    return i;
};
struct
{
    int is_android_text_ressource_id;
    char* name;
    int filter;
} c64cartridge_groups[]={
        {1,"IDS_MI_DETACH_ALL",0},
        { 1,"IDS_RAW",       CARTRIDGE_GROUP_GENERIC },
        { 0,"Freezer",        CARTRIDGE_GROUP_FREEZER },
        { 0,"Games",          CARTRIDGE_GROUP_GAME },
        { 0,"Utilities",      CARTRIDGE_GROUP_UTIL }
};

int get_c64_cartridge_group_count()
{
    return sizeof(c64cartridge_groups)/sizeof(c64cartridge_groups[0]);
}
int get_c64_cartridge_group_filter(int index)
{
    return c64cartridge_groups[index].filter;
}
int get_c64_cartridge_group_text_is_ressource_id(int index)
{
    return c64cartridge_groups[index].is_android_text_ressource_id;
}

char* get_c64_cartridge_group_name(int index)
{
    return c64cartridge_groups[index].name;
}
int get_cartridge_count()
{
    int i=0;
    cartridge_info_t* list= cartridge_get_info_list();
    while (list[i].name)
    {
        i++;
    }
    return i;

}
int get_cartridge_id(int index)
{
    return cartridge_get_info_list()[index].crtid;
}
char* get_cartridge_name(int index)
{
    return cartridge_get_info_list()[index].name;
}
int get_cartridge_flags(int index)
{
    return (int)cartridge_get_info_list()[index].flags;
}