package de.rainerhock.eightbitwonders.vice;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

public class AndroidCompatibilityUtils {

    public static void fixInsets(Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            /*if ((activity.getWindow().getAttributes().flags
                    & WindowManager.LayoutParams.FLAG_FULLSCREEN) == 0) {*/
                View rootLayout = activity.getWindow().getDecorView().getRootView();
                ViewCompat.setOnApplyWindowInsetsListener(rootLayout, new OnApplyWindowInsetsListener() {
                    @NonNull
                    @Override
                    public WindowInsetsCompat onApplyWindowInsets(@NonNull View v, @NonNull WindowInsetsCompat insets) {
                        Insets systemInsets = insets.getInsets(WindowInsetsCompat.Type.systemBars());

                        // Apply padding to avoid status bar, navigation bar, and cutout
                        rootLayout.findViewById(android.R.id.content).setPadding(
                                systemInsets.left,
                                systemInsets.top,
                                systemInsets.right,
                                systemInsets.bottom
                        );

                        return insets;
                    }
                });
                ViewCompat.requestApplyInsets(rootLayout);
            //}
        }
    }
}
