//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.LinkedHashMap;

/**
 * Extension of hashMap with a default value for elements not found in the map.
 * @param <K> key class
 * @param <V> value class
 */
public class LinkedHashMapWithDefault<K, V> extends LinkedHashMap<K, V> {
    private final V mDefaultVal;

    /**
     * Creates an empty {@link LinkedHashMapWithDefault}.
     * @param defaultVal the default val to be returned by {@link #get(Object)}, wenn the
     *                   requested key is not in the map.
     */
    public LinkedHashMapWithDefault(@NonNull final V defaultVal) {
        mDefaultVal = defaultVal;
    }

    @Override
    @NonNull
    public final V get(@Nullable final Object key) {
        if (containsKey(key)) {
            V ret = super.get(key);
            if (ret != null) {
                return ret;
            }

        }
        return mDefaultVal;
    }
}
