//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;



import java.util.concurrent.TimeUnit;

public interface EmulationTestInterface {
    /**
     * Testing: Wait for the screen to be updated.
     * @param t wait for how many time units given in u.
     * @param u unit of time to wait for.
     * @return true if the screen has been redrawn within the given time.
     */
    @SuppressWarnings("SameParameterValue")
    boolean waitForScreenRedraw(long t, TimeUnit u);
    /**
     * Testing: Wait for the screen to be first drawn.
     * @param t wait for how many time units given in u.
     * @param u unit of time to wait for.
     * @return true if the screen has been drawn within the given time.
     */
    @SuppressWarnings("SameParameterValue")
    boolean waitForScreenInit(long t, TimeUnit u);
    /**
     * Testing: Wait for the screen to match a specific value.
     * @param t wait for how many time units given in u.
     * @param u unit of time to wait for.
     * @param data data to match, to be determined with
     * {@link android.graphics.Bitmap#copyPixelsToBuffer(java.nio.Buffer)} (Buffer)}
     * @return true if the screen's pixels match the given data within the given time.
     */
    @SuppressWarnings("SameParameterValue")
    boolean waitForBitmap(byte[] data, long t, TimeUnit u);
    /**
     * Testing: Wait for audio output.
     * @param t wait for how many time units given in u.
     * @param u unit of time to wait for.
     * @return true if there was audio output.
     */
    boolean waitForAudio(long t, TimeUnit u);
}
