package de.rainerhock.eightbitwonders;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.SeekBar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class AnalogController extends Joystick {
    private String mUseroptskeyPaddleSensitivy = null;
    private String mUseroptskeyMouseSensitivy = null;
    private float mMovementFactor = 1f;

    private static final Set<Emulation.InputButton> PADDLEBUTTONS_BOTH
            = new HashSet<Emulation.InputButton>() {{
        add(Emulation.InputButton.ANALOG_PRIMARY);
        add(Emulation.InputButton.ANALOG_SECONDARY);
    }};
    private static final Set<Emulation.InputButton> PADDLEBUTTONS_X
            = new HashSet<Emulation.InputButton>() {{
        add(Emulation.InputButton.ANALOG_PRIMARY);
    }};
    private static final Set<Emulation.InputButton> PADDLEBUTTONS_Y
            = new HashSet<Emulation.InputButton>() {{
        add(Emulation.InputButton.ANALOG_SECONDARY);
    }};
    private static final Set<Emulation.InputButton> BUTTONS_EMPTY
            = new HashSet<>();
    private static final List<Integer> PRIMARY_BUTTON_TRIGGER_KEYS = Arrays.asList(
            KeyEvent.KEYCODE_BUTTON_THUMBL, KeyEvent.KEYCODE_BUTTON_THUMBR,
            KeyEvent.KEYCODE_BUTTON_L1, KeyEvent.KEYCODE_BUTTON_R1, PSEUDO_KEYCODE_PADDLE_X);

    private static final List<Integer> SECONDARY_BUTTON_TRIGGER_KEYS = Arrays.asList(
            KeyEvent.KEYCODE_BUTTON_L2, KeyEvent.KEYCODE_BUTTON_R2, PSEUDO_KEYCODE_PADDLE_Y);

    @Override
    protected Set<Emulation.InputButton> mapRealButtons(final Set<Integer> realButtons) {

        switch (getCurrentDeviceType()) {

            case DSTICK:
                return super.mapRealButtons(realButtons);
            case PADDLE:
            case MOUSE:
                boolean swap = "1".equals(mSwapButtons);
                boolean xPressed = realButtons.contains(KeyEvent.KEYCODE_BUTTON_X);
                boolean yPressed = realButtons.contains(KeyEvent.KEYCODE_BUTTON_Y);
                for (int keycode : PRIMARY_BUTTON_TRIGGER_KEYS) {
                    if (realButtons.contains(keycode)) {
                        if (swap) {
                            yPressed = true;
                        } else {
                            xPressed = true;
                        }
                        break;
                    }
                }
                for (int keycode : SECONDARY_BUTTON_TRIGGER_KEYS) {
                    if (realButtons.contains(keycode)) {
                        if (swap) {
                            xPressed = true;
                        } else {
                            yPressed = true;
                        }
                        break;
                    }
                }
                if (xPressed && yPressed) {
                    return PADDLEBUTTONS_BOTH;
                }
                //noinspection ConstantValue
                if (xPressed && !yPressed) {
                    return PADDLEBUTTONS_X;
                }
                //noinspection ConstantValue
                if (!xPressed && yPressed) {
                    return PADDLEBUTTONS_Y;
                }
            default:
                break;
        }
        return BUTTONS_EMPTY;

    }
    private String mSwapButtons = "0";
    protected abstract boolean showMouseUsageHint();
    private static final String SHOW_MOUSE_USAGE_HINT = "_SHOW_MOUSE_USAGE_HINT_";
    public static final class AnalogDeviceSettingsFragment extends InputDeviceConfigFragment {

        @Override
        public View onCreateView(final LayoutInflater inflater, final ViewGroup container,
                                 final Bundle savedInstanceState) {
            View ret = inflater.inflate(R.layout.fragment_config_analog_controller,
                    container, false);
            SettingsActivity activity = ((SettingsActivity) requireActivity());
            SettingsController sc = activity.getSettingsController();
            SeekBar sb = ret.findViewById(R.id.sb_sensitivy);
            //populateButtonSettings(ret, sc, activity, requireArguments());
            String progressTag = getResources().getString(R.string.key_analog_controller_speed)
                    + "_" + requireArguments().getString("joystickId");
            int progressId = View.generateViewId();
            sb.setProgress(sc.getCurrentValue(progressTag, sb.getProgress()));
            sb.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                @Override
                public void onProgressChanged(final SeekBar seekBar, final int i, final boolean b) {
                    sc.storeValue(progressId, progressTag, sb.getProgress());
                }

                @Override
                public void onStartTrackingTouch(final SeekBar seekBar) {

                }

                @Override
                public void onStopTrackingTouch(final SeekBar seekBar) {

                }
            });
            CheckBox cb = ret.findViewById(R.id.cb_swapbuttons);
            String swapTag = getResources().getString(R.string.key_analog_controller_swap_buttons)
                    + "_" + requireArguments().getString("joystickId");
            int swapId = View.generateViewId();

            cb.setChecked("1".equals(sc.getCurrentValue(swapTag, "0")));
            cb.setOnCheckedChangeListener((compoundButton, b)
                    -> sc.storeValue(swapId, swapTag, b ? "1" : "0"));
            ret.findViewById(R.id.mouse_usage_hint).setVisibility(
                    requireArguments().getBoolean(SHOW_MOUSE_USAGE_HINT)
                            ? View.VISIBLE : View.GONE);
            return ret;
        }
    }
    private InputDeviceConfigFragment getAnalogConfigFragment() {
        InputDeviceConfigFragment f = new AnalogDeviceSettingsFragment();
        Bundle b = new Bundle();
        b.putBoolean(SHOW_MOUSE_USAGE_HINT, showMouseUsageHint());
        b.putString("joystickId", getId());
        f.setArguments(b);
        return f;

    }
    InputDeviceConfigFragment getPaddleConfigFragment() {
        return getAnalogConfigFragment();
    }
    InputDeviceConfigFragment getMouseConfigFragment() {
        return getAnalogConfigFragment();
    }
    protected float getMovementFactor() {
        return mMovementFactor;
    }

    @Override
    void readUseropts(final BaseActivity activity) {
        if (mUseroptskeyPaddleSensitivy == null) {
            mUseroptskeyPaddleSensitivy = activity.getResources()
                    .getString(R.string.key_gamepad_sensitivity_paddle) + "_" + getId();
        }
        if (mUseroptskeyMouseSensitivy == null) {
            mUseroptskeyMouseSensitivy = activity.getResources()
                    .getString(R.string.key_gamepad_sensitivity_mouse) + "_" + getId();
        }
        Useropts useropts = activity.getCurrentUseropts();
        String keySwap = activity.getResources()
                .getString(R.string.key_analog_controller_swap_buttons) + "_" + getId();

        mSwapButtons = useropts.getStringValue(keySwap, "0");
        String keySpeed = activity.getResources()
                .getString(R.string.key_analog_controller_speed) + "_" + getId();
        float maxSpeed = activity.getResources().getInteger(R.integer.gamepad_sensitivity_max);
        float speed = useropts.getIntegerValue(keySpeed, activity.getResources()
                .getInteger(R.integer.gamepad_sensitivity_default));
        mMovementFactor = (float) Math.pow(2, speed / (maxSpeed / 3) - 1);
        super.readUseropts(activity);
    }
}
