grandslam_presents=new Int8Array([0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x03, 0x08,
                                 0x00, 0x09, 0x02, 0x0a, 0x06, 0x0a, 0x04, 0x0b, 0x06, 0x0c]).buffer;
blank18 = new Int8Array(18);
blank3 = new Int8Array(3);

text_highscore = new Int8Array([0xbf, 0xb0, 0xb2, 0xbc, 0xb0, 0xbd, 0x96, 0xc2, 0x8f, 0xb7, 0xb8, 0xb6,
                           0xb7, 0x8f, 0xc2, 0xb2, 0xbe, 0xc1, 0xb4, 0xc2]).buffer;

text_attractmode = new Int8Array([0xcd, 0xce ,0x00 ,0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f,
                             0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x00,
                             0x00, 0x00, 0xc2, 0xb2, 0xbe, 0xc1, 0xb4, 0xa9,
                             0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f,
                             0xcf, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0xb7, 0xb8, 0xc2, 0xb2, 0xbe, 0xc1, 0xb4, 0xa9,
                             0x9f, 0x9f, 0xa0, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f,
                             0x00, 0xb2, 0xc1, 0xb4, 0xb3, 0xb8, 0xc3, 0xc2,
                             0x8f, 0xa1]).buffer;

globalThis.softkeys_created = false;
globalThis.backbutton = 0;

function showToastOnce(text) {
    if (!emu.hasOption(text) || !emu.getOption(text)) {
        emu.showToast(text);
        emu.setOption(text, true);
    }
}
function updateBackButton(mode, text = null) {
    emu.log(emu.LOG_VERBOSE, "updateBackButton ("+mode+")");
    if (mode == emu.TO_INVISIBLE) {
        globalThis.backbutton--;
    }
    if (mode == emu.TO_VISIBLE) {
        globalThis.backbutton++;
    }
    if (globalThis.backbutton < 0) {
        globalThis.backbutton = 0;
    }
    emu.log(emu.LOG_VERBOSE, "globalThis.backbutton = "+globalThis.backbutton);
    if (globalThis.backbutton > 0) {
        emu.createSoftkey("B", text, 7, 4, 0);
    } else {
        emu.destroySoftkey("B");
    }
}
function hideBackButton() {
    updateBackButton(emu.TO_INVISIBLE);
}
function showBackButton(text) {
    updateBackButton(emu.TO_VISIBLE, text);
}
if (emu.getDeviceFeature(emu.DEVICEFEATURE_HARDWARE_KEYBOARD)) {
     showToastOnce("Press fire to start.");
} else {
    emu.addTextVisibilityListener(text_highscore, emu.TO_VISIBLE, () => {
        showBackButton("OK");
    });
    emu.addTextVisibilityListener(text_highscore, emu.TO_INVISIBLE, () => {
        hideBackButton();
    });

    emu.addTextVisibilityListener(text_attractmode, emu.TO_VISIBLE, () => {
        showBackButton("Back");
    });

    emu.addTextVisibilityListener(grandslam_presents, emu.TO_VISIBLE, () => {
        showToastOnce("Press fire to start.");
        emu.poke(emu.getScreenAddress(11,19),blank18.buffer);
        emu.poke(emu.getScreenAddress(11,20),blank18.buffer);
        emu.addTask(() => {
            for (y=21;y<24;y++) {
                emu.poke(emu.getScreenAddress(11,y),blank3.buffer);
            }
        }, 1);
        if (!globalThis.softkeys_created) {

            emu.createSoftkey("S", "Start", 7, 0, 0);
            emu.createSoftkey("H", "Highscores", 3, 5, 0);
            emu.createSoftkey("M", "Music on/off", 4, 4, 0);
            emu.createSoftkey("DN", "Day/Night Mode", 0, 5, 0);
            emu.destroySoftkey("B");
            showToastOnce("Press A/B/Fire to start or softkeys for options below.");
            globalThis.softkeys_created = true;
        }
        hideBackButton();

    });
    emu.addTextVisibilityListener(grandslam_presents, emu.TO_INVISIBLE, () => {
        emu.log(emu.LOG_VERBOSE, "Grandslam presents -> invisible, globalThis.softkeys_created="+globalThis.softkeys_created);
        if (globalThis.softkeys_created) {
            emu.destroySoftkey("S");
            emu.destroySoftkey("H");
            emu.destroySoftkey("M");
            emu.destroySoftkey("DN");
            globalThis.softkeys_created = false;
        }

    });
}
emu.destroySoftkey("B");
emu.destroySoftkey("S");
emu.destroySoftkey("H");
emu.destroySoftkey("M");
emu.destroySoftkey("DN");
