package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.espresso.web.assertion.WebViewAssertions.webContent;
import static androidx.test.espresso.web.matcher.DomMatchers.hasElementWithXpath;
import static androidx.test.espresso.web.sugar.Web.onWebView;
import static androidx.test.espresso.web.webdriver.DriverAtoms.findElement;
import static androidx.test.espresso.web.webdriver.DriverAtoms.webClick;
import static org.hamcrest.CoreMatchers.allOf;

import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class WebContentScreenshotsTest extends MainActivityTestBase {
    @Test
    @SpecialTest
    @NetworkAccessTest
    public void takeWebScreenshots() {
        prepareStreamUseropts("C64", "3234dbcdba505276634bd0b7171956db1d2a0246445d02896ea71c2c7bd9c973");
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgC64LibraryAdapter()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext())))
                .perform(scrollTo())
                .perform(click());
        waitForActivity(BrowserActivity.class,2, TimeUnit.SECONDS);
        waitForDialog(withText(R.string.loading_page));
        captureDeviceScreen("archive-org-c64-started");
        waitForView(allOf(withId(R.id.bn_reload), isEnabled()),30, TimeUnit.SECONDS);
        waitForIdle(5, TimeUnit.SECONDS);
        captureDeviceScreen("archive-org-c64-loaded");
        onView(withId(R.id.wv_contents)).perform(navigateTo("https://archive.org/details/Voodoomania_1998_Civitas_Side_A"));
        //waitForIdle(1, TimeUnit.SECONDS);
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_run_emulation), isDisplayed(), isEnabled(), isDisplayed()), HTTP_GET_DELAY , TimeUnit.SECONDS);
        waitForIdle(500, TimeUnit.MILLISECONDS);
        captureDeviceScreen("archive-org-c64-game-page-loaded");
        onView(withId(R.id.bn_run_emulation)).perform(click());
        waitForIdle(500, TimeUnit.MILLISECONDS);
        captureDeviceScreen("archive-org-c64-game-downloading");
        waitForActivity(SettingsActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle();
        captureDeviceScreen("archive-org-c64-game-downloading-settings");
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(BrowserActivity.class, 2, TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        waitForView(allOf(withId(R.id.bn_reload),isDisplayed()), 60 , TimeUnit.SECONDS);
        pressBack();
        waitForIdle();
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgVic20CommunitySoftware()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext())))
                .perform(scrollTo())
                .perform(click());
        waitForIdle(600, TimeUnit.MILLISECONDS);
        //onView(instanceOf(EmulationDialogFragmentRootview.class)).check(matches(isDisplayed()));
        captureDeviceScreen("archive-org-vic20-started");
        waitForIdle(HTTP_GET_DELAY, TimeUnit.SECONDS);
        onWebView().check(webContent(hasElementWithXpath("//button[@id='btn']")));
        waitForIdle();
        captureDeviceScreen("archive-arg-vic20-loaded");
        onWebView().withElement(findElement(Locator.XPATH, "//button[@id='btn']")).perform(webClick());
        //onWebView().withElement(findElement(Locator.XPATH, "//*[@class='section']/div[contains(@style,'display: block')]//button[@id='run']")).perform(webClick());
        waitForIdle(HTTP_GET_DELAY, TimeUnit.SECONDS);
        captureDeviceScreen("archive-arg-vic20-opened");
        pressBack();

    }
}
