package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.PositionAssertions.isCompletelyAbove;
import static androidx.test.espresso.assertion.PositionAssertions.isCompletelyLeftOf;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;

import static androidx.test.espresso.matcher.ViewMatchers.withAlpha;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import androidx.annotation.StringRes;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.assertion.PositionAssertions;

import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TouchJoystickTest extends C64JoystickTestBase {
    @Test
    public void t_0010_0120_visibility() {
        /*
        Action: disable touch joystick in settings
        Expected result: Virtual fire button and joystick are not visible.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_fire)).check(doesNotExist());
        onView(withId(R.id.jv_directions)).check(doesNotExist());
        /*
        Action: enable touch joystick in settings
        Expected result: Virtual fire button and joystick are visible, fire button is on the right side.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions))
                .check(matches(isDisplayed()));

        try {
            onView(withId(R.id.jv_fire))
                    .check(matches(isDisplayed()))
                    .check(PositionAssertions.isCompletelyRightOf(withId(R.id.jv_directions)));
        } catch (AssertionError e) {
            onView(withId(R.id.jv_fire))
                    .check(matches(isDisplayed()))
                    .check(PositionAssertions.isPartiallyRightOf(withId(R.id.jv_directions)));

        }
        /*
        Action: select Fire button to be on the left side in settings
        Expected result: fire button is on the left side.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_left)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        try {
            onView(withId(R.id.jv_fire))
                    .check(matches(isDisplayed()))
                    .check(isCompletelyLeftOf(withId(R.id.jv_directions)));
        } catch (AssertionError e) {
            onView(withId(R.id.jv_fire))
                    .check(matches(isDisplayed()))
                    .check(PositionAssertions.isPartiallyLeftOf(withId(R.id.jv_directions)));

        }
        /*
        Action: check if keyboard is enabled
        Expected result: keyboard is checked in menu and visible, Virtual fire button and joystick are above the keyboard, but not above the hamburger
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD)).check(matches(isCheckedButton()));
        pressBack();
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_directions))
                .check(isCompletelyAbove(withId(R.id.ib_hamburger_menu)))
                .check(isCompletelyAbove(withId(R.id.keyboardview)));
        //try {
            onView(withId(R.id.jv_fire))
                    .check(isCompletelyAbove(withId(R.id.ib_hamburger_menu)))
                    .check(isCompletelyAbove(withId(R.id.keyboardview)));
            /*
        } catch (AssertionError e) {
            onView(withId(R.id.joystickfire))
                    .check(isCompletelyAbove(withId(R.id.hamburger_menu)))
                    .check(isCompletelyAbove(withId(R.id.keyboardview)));

        }

             */
        /*
        Action: disable keyboard
        Expected result: virtual keyboard is not visible, Virtual fire button and joystick are above the hamburger
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        waitForIdle();
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        onView(withId(R.id.jv_directions)).check(isCompletelyAbove(withId(R.id.ib_hamburger_menu)));
        onView(withId(R.id.jv_fire)).check(isCompletelyLeftOf(withId(R.id.ib_hamburger_menu)));
    }


    @Test
    public void t_0080_0160_joystick_interactions()  {
        /*
        Action: enable virtual touch joystick
        Expected result: Virtual touch joystick is displayed
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_fire)).check(matches(isDisplayed()));
        /*
        Action: autostart program displaying joystick values.
        Expected result: 255 is displayed, "center" indicator of the view is highlighted
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joystickcentered"))));
        FingerState directionState = new FingerState();
        FingerState fireState = new FingerState();
        /*
        Action: touch left part of joystick direction view
        Expected result: 251 is displayed, "left" indicator of the view is highlighted.
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 10, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joystickwest"))));

        /*
        Action: move finger to the upper center of joystick direction view
        Expected result: 254 is displayed, "up" indicator of the view is highlighted
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.MOVE, directionState, 50, 10));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joysticknorth"))));
        /*
        Action: remove finger from joystick direction view
        Expected result: 255 is displayed.
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joystickcentered"))));
        /*
        Action: touch upper right part of the joystick direction view
        Expected result: 246 is displayed, up and right indicators are displayed.
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 80, 20));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up-right.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joysticknortheast|joysticknorth|joystickeast"))));

        /*
        Action: remove finger from joystick direction view
        Expected result: 255 is displayed.
         */

        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joystickcentered"))));
        /*
        Action: touch upper right part of the joystick direction view and fire button
        Expected result: 230 is displayed.
         */

        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 80, 20));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up-right-fire.pixelbuffer",10,TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).check(matches(withTagValue(equalTo("joysticknortheast|joysticknorth|joystickeast"))));
        onView(withId(R.id.jv_fire)).check(matches((withTagValue(equalTo("pressed")))));

    }
    @Test
    public void t_0210_diagonals_settings() {
        /*
        Action: open settings
        Expected result: Checkbox "Lock diagonals" is not checked.
         */
        check_diagonals_not_checked(isOption(R.string.virtual_touch_joystick));
        run_joystick_test_program();
        /*
        Action: press direction at about 11:00 clock position
        Expected result: 250 is shown (up left)
         */
        FingerState state = new FingerState();
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, state, 30, 20));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left-up.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: move finger on direction to about 10:00 clock position
        Expected result: 250 is shown (up left)
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.MOVE, state, 20, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left-up.pixelbuffer",10, TimeUnit.SECONDS)));

        /* Action: Remove finger from direction, open settings, check "Log diagonals" and go back.
        Expected result: 255 is displayed
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        set_check_in_lock_diagonals();

        /*
        Action: press direction at about 11:00 clock position
        Expected result: 254 is shown (up)
         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, state, 30, 20));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up.pixelbuffer",10, TimeUnit.SECONDS)));
        /* Action: Remove finger from direction, open settings, check "Log diagonals" and go back.
        Expected result: 255 is displayed
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: press direction at about 11:00 clock position
        Expected result: 251 is shown (left)
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, state, 20, 30));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-left.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: open settings and uncheck "Lock settings"
        Expected result: -
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        unset_check_in_lock_diagonals();

    }
    @SuppressWarnings("deprecation")
    @Test
    public void t_0190_views_alpha() {
         /*
        Action: enable touch joystick in settings and drag opacity of controls to the right
        Expected result: Virtual fire button and joystick are "very" visible with high alpha value.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(allOf(isDisplayed(), withId(R.id.sb_joystick_transparency))).perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions)).check(matches(withAlpha(0.8f)));
         /*
        Action: enable touch joystick in settings and drag opacity of controls to the left
        Expected result: Virtual fire button and joystick are "not so" visible with low alpha value.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.sb_joystick_transparency))).perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_LEFT, Press.FINGER));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions)).check(matches(withAlpha(0.2f)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.sb_joystick_transparency))).perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER));

    }
    private void test_secondary_direction(@StringRes int spinnerElement, @StringRes int symbolText, String screenshotName, boolean firstcall) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo());
        if (firstcall) {
            onView(allOf(isDisplayed(), withText(R.string.second_button_usage))).check(doesNotExist());
            onView(allOf(isDisplayed(), withText(R.string.use_secondary_button)))
                    .check(matches(not(isChecked())))
                    .perform(click());
        }
        onView(allOf(isDisplayed(), withText(R.string.use_secondary_button))).check(matches(isChecked()));
        onView(allOf(isDisplayed(), withId(R.id.sp_secondary_button))).perform(click());
        onData(isOption(spinnerElement)).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.jv_secondary)).check(matches(isDisplayed()));
        onView(allOf(withId(R.id.tv_secondary_function),withParent(withParent(withId(R.id.jv_secondary))))).check(matches(withText(symbolText)));
        FingerState state = new FingerState();
        onView(withId(R.id.jv_secondary)).perform(doFingerAction(FingerAction.DOWN, state, 50, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(screenshotName, 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_secondary)).perform(doFingerAction(FingerAction.UP, state, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    @Test
    public void test_secondary_button() {
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions))
                .check(matches(isDisplayed()));
        onView(withId(R.id.jv_fire))
                .check(matches(isDisplayed()));
        onView(withId(R.id.jv_secondary))
                .check(matches(not(isDisplayed())));
        test_secondary_direction(R.string.up, R.string.up_symbol,"screenshot-joystick-up.pixelbuffer", true);
        test_secondary_direction(R.string.down, R.string.down_symbol,"screenshot-joystick-down.pixelbuffer", false);
        test_secondary_direction(R.string.left, R.string.left_symbol,"screenshot-joystick-left.pixelbuffer", false);
        test_secondary_direction(R.string.right, R.string.right_symbol,"screenshot-joystick-right.pixelbuffer", false);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo());

        onView(allOf(withId(R.id.secondary_buttons),isDisplayed())).check(matches(isDisplayed()));
        onView(allOf(isDisplayed(), withId(R.id.cb_show_secondary_touch_button))).check(matches(isDisplayed()));
        onView(withTagValue(CoreMatchers.equalTo("port#1")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(allOf(withId(R.id.secondary_buttons),isDisplayed())).check(doesNotExist());
        onView(allOf(withId(R.id.cb_show_secondary_touch_button),isDisplayed())).check(doesNotExist());
        onView(withText(R.string.apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.jv_directions)).check(doesNotExist());



    }
}