package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.Espresso.setFailureHandler;
import static androidx.test.espresso.action.ViewActions.actionWithAssertions;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isFocused;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withParentIndex;
import static androidx.test.espresso.matcher.ViewMatchers.withSpinnerText;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.platform.app.InstrumentationRegistry.getInstrumentation;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.isA;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import android.Manifest;
import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.BaseInputConnection;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.SeekBar;
import android.widget.TableRow;
import android.widget.TextView;

import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.appcompat.view.menu.MenuView;
import androidx.core.content.res.ResourcesCompat;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.NoMatchingRootException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.GeneralSwipeAction;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Swipe;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.intent.Intents;
import androidx.test.espresso.matcher.BoundedMatcher;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.rule.GrantPermissionRule;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import androidx.test.uiautomator.UiDevice;

import junit.framework.AssertionFailedError;

import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import de.rainerhock.eightbitwonders.vice.KeyButton;
import de.rainerhock.eightbitwonders.vice.ToggledKeyButton;
import de.rainerhock.eightbitwonders.vice.ViceFactory;


public class TestBase implements Joystick.UnitTestClass, DeviceSupportActivity.KeyboardUnitTest, EmulationActivity.TestInterface {
    protected final static String FAKE_GAMECONTROLLER_DEVICEID ="_UNITTEST_GAMECONTROLLER_JOYSTICK_";

    protected static Matcher<View> isInTableRow(int index) {
        Matcher<View> oneUp = withParent(allOf(withParentIndex(index), CoreMatchers.instanceOf(TableRow.class)));
        //return withParent(oneUp);
        return allOf(CoreMatchers.not(CoreMatchers.instanceOf(TableRow.class)), anyOf(oneUp,withParent(oneUp)));
    }

    protected Activity getCurrentScenarioActivity() {
        throw new IllegalStateException(
                "Must not reach "+getClass().getSimpleName()+".getCurrentScenarioActivity");
    }
    protected static final int HTTP_GET_DELAY = 300;
    protected static final int DEVICE_ID = -42;
    private final static int MAX_RETRIES_NAVIGATION=10;
    /*
        use with
        @ClassRule
        public static final ForceLocaleRule localeTestRule = new ForceLocaleRule(Locale.GERMAN);
         */
    @Rule
    public GrantPermissionRule mRuntimePermissionRuleRead =
            GrantPermissionRule.grant(android.Manifest.permission.READ_EXTERNAL_STORAGE);
    @Rule
    public GrantPermissionRule mRuntimePermissionRuleWrite =
            GrantPermissionRule.grant(Manifest.permission.WRITE_EXTERNAL_STORAGE);
    private int mScreenshotIndex = 0;

    static List<ViewAction> createTypeActions(List<Integer> keycodes, @SuppressWarnings("SameParameterValue") int minimalDownTime, @SuppressWarnings("SameParameterValue") int maximalDownTime) {
        List<ViewAction> ret = new LinkedList<>();
        for (int keycode : keycodes) {
            int delay = ThreadLocalRandom.current().nextInt(minimalDownTime, maximalDownTime + 1);
            ret.add(new ViewAction() {
                @Override
                public String getDescription() {
                    return "hold key representing "+KeyEvent.keyCodeToString(keycode)+" for "+delay+" ms";
                }

                @Override
                public Matcher<View> getConstraints() {
                    return isEnabled();
                }

                @Override
                public void perform(UiController uiController, View view) {
                    BaseInputConnection conn = new BaseInputConnection(view, false);
                    conn.sendKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, keycode));
                    try {
                        Thread.sleep(delay);
                        conn.sendKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, keycode));
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }

                }
            });
        }
        return ret;
    }

    static ViewAction pressDpadJoystickKey(int keycode) {
        return keyAction(KeyEvent.ACTION_DOWN, keycode, DEVICE_ID);
    }

    static ViewAction releaseDpadJoystickKey(int keycode) {
        return keyAction(KeyEvent.ACTION_UP, keycode, DEVICE_ID);
    }

    protected String buildScreenshotFilename(int index, String keyword) {
        return String.format("%s-%02d-%s.png", getClass().getSimpleName(), index, keyword);
    }
    protected String getScreenshotFolder() {
        return "test-screenshots";
    }
    protected void captureDeviceScreen(String name) {
        mScreenshotIndex++;
        try {
            UiDevice.getInstance(getInstrumentation())
                            .takeScreenshot(new File(getDir(getScreenshotFolder()),
                                    buildScreenshotFilename(mScreenshotIndex, name)),
                            1,100);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressWarnings("unused")
    void navigateToFirstTile() {
        navigateToView(KeyEvent.KEYCODE_DPAD_LEFT, KeyEvent.KEYCODE_DPAD_UP, withChild(withText(R.string.name_c64)));
    }
    void navigateToHamburger() {
        navigateToView(KeyEvent.KEYCODE_DPAD_UP, KeyEvent.KEYCODE_UNKNOWN, withId(R.id.bn_info));
    }

    void navigateToView(int key1, int key2, Matcher<View> m) {
        int tries = -1;
        while (true) {
            try {
                onView(m).check(matches(isFocused()));
                break;
            }
            catch (NoMatchingViewException | AssertionFailedError e) {
                if (tries == MAX_RETRIES_NAVIGATION) {
                    throw new RuntimeException(e);
                }
            }

            tries++;
            onView(isRoot()).perform(pressKey(key1));
            waitForIdle();
            if (key2 != KeyEvent.KEYCODE_UNKNOWN) {
                onView(isRoot()).perform(pressKey(key2));
                waitForIdle();
            }
        }

    }

    @SuppressWarnings("unused")
    private void navigateToFirstButton() {
        navigateToView(KeyEvent.KEYCODE_DPAD_LEFT, KeyEvent.KEYCODE_DPAD_UP, withParentIndex(0));
    }

    protected void waitForProgressDialog(Matcher<View> matchWhenDisappeared) {
        long start = System.nanoTime();
        while (true) {
            try {
                //getInstrumentation().waitForIdleSync();
                Log.v("FRAGMENT_LOADING_PAGE", "Searching");
                onView(instanceOf(EmulationDialogFragmentRootview.class)).inRoot(isDialog()).check(matches(isDisplayed()));
                Log.v("FRAGMENT_LOADING_PAGE", "found dialog");
                break;
            }
            catch (AssertionError | NoMatchingRootException e) {
                if ((System.nanoTime() - start) > TimeUnit.MILLISECONDS.toNanos(200)) {
                    Log.v("FRAGMENT_LOADING_PAGE", "no dialog, timeout");
                    throw e;
                } else {
                    waitForIdle();
                    waitForIdle(50, TimeUnit.MILLISECONDS);
                    Log.v("FRAGMENT_LOADING_PAGE", "no dialog, waiting");
                }
            }
        }
        start = System.nanoTime();
        while (true) {
            try {
                getInstrumentation().waitForIdleSync();
                onView(matchWhenDisappeared).check(matches(matchWhenDisappeared));
                Log.v("FRAGMENT_LOADING_PAGE", "found after dialog object");
                break;
            }
            catch (AssertionError | PerformException | NoMatchingViewException e) {
                if ((System.nanoTime() - start) > TimeUnit.SECONDS.toNanos(HTTP_GET_DELAY)) {
                    Log.v("FRAGMENT_LOADING_PAGE", "no after dialog object, timeout");
                    throw (e);
                } else {
                    waitForIdle(100, TimeUnit.MILLISECONDS);
                    Log.v("FRAGMENT_LOADING_PAGE", "no after dialog object, waiting");
                }
            }
        }
        getInstrumentation().waitForIdleSync();
        onView(matchWhenDisappeared).check(matches(matchWhenDisappeared));

    }

    void switchToPetModel(final String model) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        try {
            onView(withId(R.id.sp_petmodel)).check(matches(isDisplayed()));
        } catch (AssertionFailedError e) {
            onView(withId(R.id.gh_petsettings)).perform(click());
        }
        waitForIdle();
        onView(withId(R.id.sp_petmodel)).perform(scrollTo()).perform(click());
        onData(isOption(model)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
    }

    protected void rotate(ViewAction action, Matcher<View> matcher) {
        onView(isRoot()).perform(action);
        waitForView(allOf(withId(R.id.keyboardview), matcher), 5, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview)).check(matches(matcher));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));

    }

    protected ViewAction doubleClick() {
        return actionWithAssertions(
                new GeneralClickAction(
                        Tap.DOUBLE,
                        view -> {
                            int[] locationOnScreen = new int[2];
                            view.getLocationOnScreen(locationOnScreen);
                            return new float[]{locationOnScreen[0]+64,locationOnScreen[1]+64};
                        },
                        Press.FINGER,
                        InputDevice.SOURCE_UNKNOWN,
                        MotionEvent.BUTTON_PRIMARY));
    }
    protected void waitForView(final Matcher<View> viewMatcher, final long t, final TimeUnit u) {
        onView(isRoot()).perform(new ViewAction() {
            @Override
            public Matcher<View> getConstraints() {
                return instanceOf(View.class);
            }

            @Override
            public String getDescription() {
                return "wait for a view matching <" + viewMatcher + "> during " + u.toMillis(t) + " millis.";
            }

            @Override
            public void perform(final UiController uiController, final View view) {
                uiController.loopMainThreadUntilIdle();
                long maxtime  = u.toMillis(t);
                long worktime = 0;
                View rootView = null;
                Collection<Activity> allActivities = ActivityLifecycleMonitorRegistry.getInstance()
                        .getActivitiesInStage(Stage.RESUMED);
                if (allActivities.isEmpty()) {
                    throw new NoActivityResumedException("No activity in state resumed.");
                } else {
                    Activity activity = allActivities.iterator().next();
                    do {
                        try {
                            Log.v("waitForView", "checking views in "+activity);
                            rootView = ((ViewGroup) activity
                                    .findViewById(android.R.id.content)).getChildAt(0);
                            if (rootView != null) {
                                for (View child : TreeIterables.breadthFirstViewTraversal(rootView)) {
                                    // found view with required ID
                                    if (viewMatcher.matches(child)) {
                                        Log.v("waitForView", "match: "+child);
                                        return;
                                    }
                                }
                            }
                            Log.v("waitForView", "no match in "+activity);
                            //uiController.loopMainThreadForAtLeast(100);
                            long time0 = System.currentTimeMillis();
                            uiController.loopMainThreadForAtLeast(100);
                            long time1 = System.currentTimeMillis();
                            worktime += (time1-time0);
                            Log.v("waitForView", "used " + worktime+" of "+maxtime+" ms");
                        }
                        catch (RuntimeException e) {
                            //uiController.loopMainThreadForAtLeast(100);
                            Log.v("waitForView", "exception during check", e);

                        }
                    } while (worktime < maxtime);
                }

                assert rootView != null;
                String hierarchy = HumanReadables.getViewHierarchyErrorMessage(rootView, null, "", null);
                throw new PerformException.Builder()
                        .withActionDescription(this.getDescription())
                        .withViewDescription(HumanReadables.describe(rootView))
                        .withCause(new Exception(hierarchy))
                        .build();
            }
        });
    }
    protected void waitForActivity(Class<? extends Activity> activity) {
        waitForActivity(activity, 1, TimeUnit.SECONDS);
    }
    private final static Matcher<Root> FOCUSSED_ROOT_MATCHER = new BaseMatcher<Root>() {
        @Override
        public boolean matches(Object item) {
            return item instanceof Root &&  item.toString().contains(", has-window-focus=true,");
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("fake matcher");
        }
    };

    protected void waitForActivity(Class<? extends Activity> activity, int t, TimeUnit u) {

        onView(isRoot()).inRoot(FOCUSSED_ROOT_MATCHER).perform(new ViewAction() {
            @Override
            public Matcher<View> getConstraints() {
                return isRoot();
            }

            @Override
            public String getDescription() {
                return "Check if an instance of "+activity+" is resumed after " +t+" "+u+".";
            }

            @Override
            public void perform(UiController uiController, View view) {
                long maxtime = u.toMillis(t);
                long worktime = 0;
                do {
                    Log.v("waitforactivity", "do");
                    Collection<Activity> allActivities = ActivityLifecycleMonitorRegistry.getInstance()
                            .getActivitiesInStage(Stage.RESUMED);
                    for (Activity a : allActivities) {
                        Log.v("waitforactivity", "checking if "+a+" is instance of"+activity);
                        if (activity.isInstance(a)) {
                            Log.v("waitforactivity", "match");
                            waitForIdle();
                            return;
                        }
                    }
                    Log.v("waitforactivity", "sleeping");
                    long start = System.currentTimeMillis();
                    uiController.loopMainThreadForAtLeast(250);
                    long ellapsed = System.currentTimeMillis() - start;
                    worktime += ellapsed;
                    Log.v("waitforactivity", "idling for " + ellapsed +" ms");
                    Log.v("waitforactivity", "used "+worktime+ " of " +maxtime + "ms");

                } while (worktime < maxtime);
                Log.v("waitforactivity", "error");
                throw (new NoActivityResumedException("No instance of " + activity + "in state resumed after " + worktime + "ms."));
            }
        });

    }

    protected void run_potentiometer_test_program() {
        run_program("MOUSE", "screenshot-paddle-default.pixelbuffer");
    }

    protected void run_program(String name, String expectedScreenshot) {
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption(name)).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(expectedScreenshot, 10, TimeUnit.SECONDS)));
    }

    protected static class ForceLocaleRule implements TestRule {

        private final Locale testLocale;
        private Locale deviceLocale;

        public ForceLocaleRule(Locale testLocale) {
            this.testLocale = testLocale;
            TestBase.setTestLocale(testLocale);
        }

        @NonNull
        @Override
        public Statement apply(@NonNull Statement base, @NonNull org.junit.runner.Description description) {
            return new Statement() {
                public void evaluate() throws Throwable {
                    try {
                        if (testLocale != null) {
                            deviceLocale = Locale.getDefault();
                            setLocale(testLocale);
                        }

                        base.evaluate();
                    } finally {
                        if (deviceLocale != null) {
                            setLocale(deviceLocale);
                        }
                    }
                }
            };
        }

        private void setLocale(Locale locale) {
            Resources resources = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources();
            Locale.setDefault(locale);
            Configuration config = resources.getConfiguration();
            config.locale = locale;
            resources.updateConfiguration(config, resources.getDisplayMetrics());
            TestBase.setTestLocale(locale);
        }
    }

    private final String[] PREFS = new String[]
            {"de.rainerhock.eightbitwonders.emu_%s.conf_default.xml",
                    "de.rainerhock.eightbitwonders.emu_%s.emulator.xml"
            };
    protected List<String> getAllFilepaths() {
        List<String> ret = new LinkedList<>();
        for (String machine : new ViceFactory().getEmulatorIds()) {
            for (String t : PREFS) {
                ret.add(InstrumentationRegistry.getInstrumentation().getTargetContext().getFilesDir().getParentFile() + "/shared_prefs/" + String.format(t, machine));
            }
        }
        for (String s:Arrays.asList("bubble_escape","formula_1_simulator","monty_on_the_run","pac_mania")) {
            ret.add(InstrumentationRegistry.getInstrumentation().getTargetContext().getFilesDir().getParentFile() + "/shared_prefs/" +
                    "de.rainerhock.eightbitwonders.emu_C64.conf_"+s+".xml");
        }
        return ret;
    }
    private static boolean mUseKeyboard = true;
    @Override
    public boolean isKeyboardEnabled() {
        Log.v("keyboardVisibility", "Unit Test value "+TestBase.mUseKeyboard);
        return TestBase.mUseKeyboard;
    }

    @Override
    public Set<Class<Joystick>> getDisabledJoystickClasses() {
        return TestBase.disabledJoystickClasses;
    }

    @NonNull
    @Override
    public List<Joystick> getTestJoysticks() {
        List<Joystick> ret = new LinkedList<>();
        ret.add(C64JoystickTestBase.getTestDpad());
        ret.add(new MouseControllerTest.TestMouseController(InstrumentationRegistry.getInstrumentation().getTargetContext()));
        ret.add(new GameControllerJoystickTest.UnitTestGameControllerJoystick(InstrumentationRegistry.getInstrumentation().getTargetContext(), null,
                MotionEvent.AXIS_HAT_X, MotionEvent.AXIS_HAT_Y,
                new Integer[]{}, new Integer[]{KeyEvent.KEYCODE_BUTTON_L1},
                Joystick.ValueType.MOVEMENT));
        /*
                        KeyEvent.KEYCODE_BUTTON_2, KeyEvent.KEYCODE_BUTTON_3,
                        KeyEvent.KEYCODE_BUTTON_4, KeyEvent.KEYCODE_BUTTON_5,
                        KeyEvent.KEYCODE_BUTTON_6, KeyEvent.KEYCODE_BUTTON_7,
                        KeyEvent.KEYCODE_BUTTON_8, KeyEvent.KEYCODE_BUTTON_11,
                        KeyEvent.KEYCODE_BUTTON_12, KeyEvent.KEYCODE_BUTTON_13,
                        KeyEvent.KEYCODE_BUTTON_14, KeyEvent.KEYCODE_BUTTON_15}));

         */

        ret.add(new GameControllerJoystickTest.UnitTestGameControllerJoystick(InstrumentationRegistry.getInstrumentation().getTargetContext(), null,
                MotionEvent.AXIS_X, MotionEvent.AXIS_Y,
                new Integer[]
                        {MotionEvent.AXIS_LTRIGGER, MotionEvent.AXIS_BRAKE},
                new Integer[]
                        {KeyEvent.KEYCODE_BUTTON_THUMBL, KeyEvent.KEYCODE_BUTTON_L2},
                Joystick.ValueType.MOVEMENT));
        ret.add(new GameControllerJoystickTest.UnitTestGameControllerJoystick(InstrumentationRegistry.getInstrumentation().getTargetContext(), null,
                MotionEvent.AXIS_Z, MotionEvent.AXIS_RZ,
                new Integer[]{MotionEvent.AXIS_RTRIGGER, MotionEvent.AXIS_THROTTLE,
                        MotionEvent.AXIS_GAS},
                new Integer[]{KeyEvent.KEYCODE_BUTTON_R1, KeyEvent.KEYCODE_BUTTON_R2,
                        KeyEvent.KEYCODE_BUTTON_THUMBR},Joystick.ValueType.MOVEMENT));
        for (Joystick j:ret ) {
            if (j instanceof GameControllerJoystick) {
                ((GameControllerJoystick) j).setOtherControllerjoysticks(
                        getOtherGameControllerJoysticks(ret, (GameControllerJoystick) j));
            }
        }
        return ret;
    }

    @NonNull
    private static GameControllerJoystick[] getOtherGameControllerJoysticks(List<Joystick> ret, GameControllerJoystick joy) {
        ArrayList<GameControllerJoystick> others = new ArrayList<>();
        for (Joystick o : ret) {
            if (o instanceof GameControllerJoystick) {
                GameControllerJoystick other = (GameControllerJoystick) o;
                if (other != joy) {
                    others.add(other);
                }
            }
        }
        GameControllerJoystick[] array = new GameControllerJoystick[others.size()];
        others.toArray(array);
        return array;
    }

    final private static Set<Class<Joystick>> disabledJoystickClasses= new LinkedHashSet<>();
    @Override
    public boolean useThisJoystick(Joystick joy) {
        if (disabledJoystickClasses.contains(Joystick.class)) {
            return false;
        }
        Class<?> c = joy.getClass();
        while (c != Joystick.class) {
            c= Objects.requireNonNull(c).getSuperclass();
            if (disabledJoystickClasses.contains(c)) {
                return false;
            }
        }

        return true;
    }
    protected ViewAction idleSync() {
        return idleSync(250, TimeUnit.MILLISECONDS);
    }
    protected  ViewAction idleSync(long additional_time, TimeUnit u) {
        return new ViewAction() {
            @Override
            public String getDescription() {
                if (additional_time == 0) {
                    return "wait for idle";
                } else {
                    return "wait for idle and "+u.toMillis(additional_time) +"ms";
                }
            }

            @Override
            public Matcher<View> getConstraints() {
                return instanceOf(View.class);
            }

            @Override
            public void perform(UiController uiController, View view) {
                view.post(() -> {
                    long ms = u.toMillis(additional_time);
                    if (ms > 0)
                        try {
                            Thread.sleep(ms);
                        }
                        catch (InterruptedException e) {
                            Log.w("Junit TetBase", "ignore InterruptedException", e);
                        }
                });
            }
        };

    }
    private static final String TAG = C64EmulationTestBase.class.getSimpleName();
    protected void waitForIdle() {
        waitForIdle(250, TimeUnit.MILLISECONDS);
    }
    protected static void waitForIdle(long t, TimeUnit u) {
        //InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        try {
            Thread.sleep(u.toMillis(t));
        }
        catch (InterruptedException e) {
            Log.w("Junit TetBase", "ignore InterruptedException", e);
        }

    }
    protected void pressBack() {
        Log.v("performing pressBack", "UiDevice.getInstance");
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressBack();
        waitForIdle();
    }
    protected void setIntendedFile(File file) {
        init();
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT), hasAction(Intent.ACTION_CREATE_DOCUMENT))).respondWithFunction(intent ->
        {
            Intent resultData = new Intent();
            Instrumentation.ActivityResult ret = new Instrumentation.ActivityResult(Activity.RESULT_OK, resultData);
            resultData.setData(Uri.fromFile(file));
            return ret;
        });

    }
    protected void setIntentCallback(String filename) {
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER))).respondWithFunction(intent -> {
            if (intent.getBooleanExtra("retry", false )) {
                return new Instrumentation.ActivityResult(Activity.RESULT_CANCELED, null);
            }
            Intent resultData = new Intent();
            Instrumentation.ActivityResult ret = new Instrumentation.ActivityResult(Activity.RESULT_OK, resultData);

            resultData.setData(Uri.fromFile(new File(filename)));
            return ret;
        });

    }
    protected void chooseFileMenu() {
        onView(isRoot()).perform(ViewActions.pressMenuKey());
        waitForIdle();
        //onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.start_open_file))
                .check(matches(isDisplayed()))
                .perform(click());

    }
    protected String extractTestAsset(@SuppressWarnings("SameParameterValue") String name) throws IOException {
        InputStream is = InstrumentationRegistry.getInstrumentation().getContext().getAssets().open("test_assets/"+name);
        byte[] b = new byte[is.available()];
        if (is.read(b) > 0) {
            File out = new File(InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir(), name);
            @SuppressWarnings("IOStreamConstructor")
            OutputStream os = new FileOutputStream(out);
            os.write(b);
            os.close();
            is.close();
            return out.getAbsolutePath();
        }
        throw new IOException(String.format("Could not read %s or %s is empty", name, name));
    }
    protected void openDocument(String filename) {
        setIntentCallback(filename);
        try {
            Thread.sleep(250);
            chooseFileMenu();
            Thread.sleep(100);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }


    protected static ViewAction tap() {
        return click();

    }


    protected static ViewAction swipeToBottom() {
        Log.v(EmulationActivityTouchTest.class.getSimpleName(), ".switeToBottom");
        return new GeneralSwipeAction(Swipe.SLOW, GeneralLocation.CENTER,
                GeneralLocation.BOTTOM_CENTER, Press.FINGER);
    }
    protected static ViewAction swipeToTop() {
        Log.v(EmulationActivityTouchTest.class.getSimpleName(), ".switeToTop");
        return new GeneralSwipeAction(Swipe.SLOW, GeneralLocation.CENTER,
                GeneralLocation.TOP_CENTER, Press.FINGER);
    }
    protected static ViewAction swipeToRight() {
        return new GeneralSwipeAction(Swipe.SLOW, GeneralLocation.TOP_CENTER,
                GeneralLocation.TOP_RIGHT, Press.FINGER);
    }
    protected static ViewAction swipeToLeft() {
        return new GeneralSwipeAction(Swipe.SLOW, GeneralLocation.TOP_CENTER,
                GeneralLocation.TOP_LEFT, Press.FINGER);
    }
    protected static Matcher<View> isCheckedButton() {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View item) {
                if (item instanceof Button) {
                    Drawable compare = ResourcesCompat.getDrawable(
                            item.getContext().getResources(),
                            android.R.drawable.checkbox_on_background, item.getContext().getTheme());
                    Button b = (Button) item;
                    Drawable[] d = b.getCompoundDrawables();
                    if (d[2] instanceof BitmapDrawable && compare instanceof BitmapDrawable) {
                        return ((BitmapDrawable) d[2]).getBitmap().sameAs(((BitmapDrawable) compare).getBitmap());
                    }
                }
                if (item instanceof TextView) {
                    View parent = item;
                    while (parent != null) {
                        if (parent instanceof ViewGroup) {
                            ViewGroup vg = (ViewGroup) parent;
                            for (int i = 0; i < vg.getChildCount(); i++) {
                                if (vg.getChildAt(i) instanceof CheckBox) {
                                    CheckBox cb = (CheckBox) vg.getChildAt(i);
                                    if (cb.isChecked()) {
                                        return true;
                                    }
                                }
                            }
                        }
                        try {
                            parent = (View) parent.getParent();
                        } catch (ClassCastException e) {
                            break;
                        }
                    }
                }
                return false;
            }
            @Override
            public void describeTo(Description description) {
                description.appendText("is a checked menubutton");
            }
        };
    }

    protected void createAndAttachTapeImage(String filename, String path) {
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isScreenInitialized()));
            /*
            Action: Open menu and select Menuitem create file
            Expected result: Activity "Create Image" showing up with image type d64 preselected
            and button create disabled.
            */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.create_and_attach_image)).perform(click());
        waitForIdle();
        onView(withText(R.string.create)).perform(scrollTo()).check(matches(not(isEnabled())));
            /*
            Action: type in tape image name
            Expected result: Button Create is now enabled
             */
        onView(withId(R.id.et_name)).perform(typeText("test"));
        onView(withText(R.string.create)).check(matches(isEnabled()));
            /*
            Action: choose tap as image type
            Expected result: Edittext for ID is hidden.
             */

        onView(withId(R.id.sp_typ)).check(matches(withSpinnerText("d64")));

        onView(withId(R.id.et_id)).check(matches(isDisplayed()));
        onView(withId(R.id.sp_typ)).perform(click());
        onData(isOption("tap")).perform(click());
        //onView(withId(R.id.etId)).check(doesNotExist());
            /*
            Action: create image
            Expected result: Activity to choose what to do with image
             */
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER))).respondWithFunction(intent ->
        {
            Intent resultData = new Intent();
            Instrumentation.ActivityResult ret = new Instrumentation.ActivityResult(Activity.RESULT_OK, resultData);
            resultData.setData(Uri.parse(path));
            return ret;
        });
        onView(withText(R.string.create)).perform(click());
        onView(withText(filename)).check(matches(Matchers.anything()));
            /*
            Action: Choose to attach tape image
            Expected result: Emulation running
             */
        onView(withText(R.string.IDS_ATTACH))
                .check(matches(isDisplayed()))
                .perform((click()));
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
    }

    protected void type_load_directory(int drive) {
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("O")).perform(tap());
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("D")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("4")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(allOf(isDisplayed(), isC64Key(","))).perform(tap());
        onView(isC64Key(String.valueOf(drive))).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());

    }

    protected ViewAction createTypeAction(@SuppressWarnings("SameParameterValue") int keyaction, int keycode, @SuppressWarnings("SameParameterValue") int minimalDownTime, @SuppressWarnings("SameParameterValue") int maximalDownTime)
    {
        ViewAction typeAction =createTypeAction(keyaction, keycode);
        int waitDown = ThreadLocalRandom.current().nextInt(minimalDownTime, maximalDownTime + 1);
        try {
            Thread.sleep(waitDown);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        return new ViewAction() {
            @Override
            public Matcher<View> getConstraints() {
                return typeAction.getConstraints();
            }

            @Override
            public String getDescription() {
                return typeAction.getDescription()+" and wait for "+waitDown+" ms";
            }

            @Override
            public void perform(UiController uiController, View view) {
                typeAction.perform(uiController, view);
            }
        };
    }
    protected static ViewAction keyAction(int action, int keycode, int deviceId) {
        KeyEvent e = new KeyEvent(System.currentTimeMillis(), System.currentTimeMillis() ,action, keycode, 0, 0,deviceId, 0);
        return new ViewAction() {
            @Override
            public String getDescription() {
                return "send keyevent "+e;
            }

            @Override
            public Matcher<View> getConstraints() {
                return isEnabled();
            }

            @Override
            public void perform(UiController uiController, View view) {
                Activity a = getActivity();
                if (a != null) {
                    a.dispatchKeyEvent(e);
                }
            }
        };
    }
    protected ViewAction createTypeAction(int keyaction, int keycode) {
        KeyEvent e = new KeyEvent(keyaction, keycode);
        return new ViewAction() {
            @Override
            public String getDescription() {
                return "sending "+e;
            }

            @Override
            public Matcher<View> getConstraints() {
                return isEnabled();
            }

            @Override
            public void perform(UiController uiController, View view) {
                if ( Build.FINGERPRINT.contains("generic")) {
                    BaseInputConnection conn = new BaseInputConnection(view, false);
                    conn.sendKeyEvent(e);
                } else {
                    Activity a = getActivity();
                    if (a != null) {
                        a.dispatchKeyEvent(e);
                    }
                }
            }
        };
    }

    protected void configDirection(String tag, int keycode, @IdRes int pressKeyRes) {
        onView(withTagValue(equalTo(tag))).perform(scrollTo()).perform(click());
        onView(withText(containsString(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(pressKeyRes)))).check(matches(isDisplayed()));
        //onView(withText(pressKeyRes)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(keycode));
        onView(withTagValue(equalTo(tag))).check(matches(withText(KeyEvent.keyCodeToString(keycode).replace("KEYCODE_",""))));
        onView(withTagValue(equalTo(tag))).perform(click());
        waitForIdle();
        //onView(withText(R.string.IDS_ROMSET_ARCHIVE_DELETE)).check(matches(isDisplayed()));
        onView(withText(android.R.string.cancel)).perform(click());
        onView(withTagValue(equalTo(tag))).check(matches(withText(KeyEvent.keyCodeToString(keycode).replace("KEYCODE_",""))));
    }
    final private Map<String, ByteArrayOutputStream> mStoredFiles = new HashMap<>();
    final private List<String> mRemoveFiles = new LinkedList<>();
    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    private boolean copyTestConfig(AssetManager am, String folder, String name) throws IOException {
        for (String asset: Objects.requireNonNull(am.list(folder))) {
            if (asset.equals(name)) {
                byte[] buffer = new byte[1024];
                int count;
                InputStream is = am.open(folder+(folder.isEmpty() ? "" : "/")+name);
                String targetfolder = InstrumentationRegistry.getInstrumentation().getTargetContext().getFilesDir().getParentFile() + "/shared_prefs";
                if (!new File(targetfolder).isDirectory()) {
                    //noinspection ResultOfMethodCallIgnored
                    new File(targetfolder).mkdirs();
                }
                //noinspection IOStreamConstructor
                OutputStream os = new FileOutputStream(targetfolder+"/" + (name));
                while ((count = is.read(buffer)) > 0) {
                    os.write(buffer,0,count);
                }
                is.close();
                os.close();
                return true;
            }
        }
        return false;
    }
    private void prepareUseropts(List<String> paths) {
        for (String path: paths) {
            try {
                File input = new File(path);
                if (input.exists()) {
                    byte[] buffer = new byte[1024];
                    int count;
                    FileInputStream fis = new FileInputStream(input);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((count = fis.read(buffer)) > 0) {
                        bos.write(buffer,0,count);
                    }
                    fis.close();
                    mStoredFiles.put(path,bos);
                } else {
                    mRemoveFiles.add(path);
                }
                String name = input.getName();
                AssetManager am = InstrumentationRegistry.getInstrumentation().getContext().getAssets();
                if (!copyTestConfig(am,"testconfigs/" + getClass().getSimpleName(), name))  {
                    if (!copyTestConfig(am,"testconfigs",name)) {
                        if (input.exists()) {
                            if (!input.delete()) {
                                Log.v(getClass().getSimpleName()+".prepareUseropts()", "cannot remove "+input.getAbsolutePath());
                            }
                        }
                    }

                }

            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
    protected void prepareUseropts() {
        prepareUseropts(getAllFilepaths());

    }
    protected void prepareStreamUseropts(String emulatorId, String confId) {
        List<String> files = new LinkedList<>();
        File filesdir = getInstrumentation().getTargetContext().getFilesDir();
        files.add(filesdir.getParentFile() + "/shared_prefs/"
                + String.format("de.rainerhock.eightbitwonders.emu_%s.conf_%s.xml",
                emulatorId, confId));
        files.add(filesdir.getParentFile() + "/shared_prefs/"
                + String.format("de.rainerhock.eightbitwonders.emu_%s.conf__%s.xml",
                emulatorId, confId));
        for (String template : Arrays.asList("/initial_snapshots/%s_%s_default", "/initial_snapshots/%s__%s_default")) {
            File initialSnapshotDir = new File(getInstrumentation().getTargetContext().getCacheDir()
                    + String.format(template, emulatorId, confId));
            File[] snapshots = initialSnapshotDir.listFiles();
            if (snapshots != null) {
                for (File f : snapshots) {
                    files.add(f.getAbsolutePath());
                }
            }
        }
        File overlays = new File(new File(filesdir, "streams"), confId);
        String[] filenames = overlays.list();
        if (filenames != null) {
            for (String filename : filenames) {
                files.add(new File(overlays, filename).getAbsolutePath());
            }
        }
        prepareUseropts(files);
    }
    @Before
    public void init() {
        //noinspection ResultOfMethodCallIgnored
        new File(InstrumentationRegistry.getInstrumentation().getTargetContext().getFilesDir(),"test_data").mkdirs();
        Intents.release();
        Intents.init();
        setFailureHandler(new DefaultFailureHandler(getInstrumentation().getTargetContext(), false));

        //waitForEmulationShutdown();


    }



    private static boolean mIsolatedEmulationActivityTest = false;

    protected void setIsolatedEmulationActivityTest(@SuppressWarnings("SameParameterValue") boolean value) {
        mIsolatedEmulationActivityTest = value;
    }
    @Override
    public boolean isIsolatedEmulationActivityTest() {
        return mIsolatedEmulationActivityTest;
    }
    private static Locale mTestLocale = null;
    @Override
    public Locale getTestLocale() {
        return mTestLocale;
    }
    protected static void setTestLocale(Locale l) {
        mTestLocale = l;
    }

    private abstract static class TestIsScrolledToPositionMatcher extends TypeSafeMatcher<View> {
        abstract int getPosition(ScrollView sv);
        abstract int getPosition(WebView wv);
        protected int getExceedingHeight(View v) {
            int fullheight = v.getHeight();
            View p = v;
            do {
                if (p instanceof ScrollView) {
                    return fullheight - p.getHeight();
                }
                p = (View) p.getParent();
            } while (p != null);
            return 0;
        }
        @Override
        protected boolean matchesSafely(View item) {
            View p = item;
            do {
                if (p instanceof ScrollView) {
                    Log.v(getClass().getSimpleName(), ".getPosition((ScrollView) p) = "+getPosition((ScrollView) p));
                    return getPosition((ScrollView) p) == 0;

                }
                if (p instanceof WebView) {
                    return getPosition((WebView) p) == 0;
                }
                p = (View) p.getParent();
            } while (p != null);
            return false;
        }

    }
    private static class TestIsScrolledToTopMatcher extends TestIsScrolledToPositionMatcher {
        @Override
        int getPosition(ScrollView wv) {
            return wv.getScrollY();
        }

        @Override
        int getPosition(WebView wv) { return wv.getScrollY(); }

        @Override
        public void describeTo(Description description) {
            description.appendText("Checks if a ScrollView ist scrolled to the top.");
        }

    }
    private static class TestIsScrolledToLeftMatcher extends TestIsScrolledToPositionMatcher {

        @Override
        int getPosition(ScrollView sv) {
            return sv.getScrollX();
        }
        @Override
        int getPosition(WebView wv) { return wv.getScrollX(); }
        @Override
        public void describeTo(Description description) {
            description.appendText("Checks if a ScrollView ist scrolled to the left.");
        }
    }
    protected static Matcher<? super View> isScrolledToTop() {
        return new TestIsScrolledToTopMatcher();
    }
    protected static Matcher<? super View> isScrolledToLeft() {
        return new TestIsScrolledToLeftMatcher();
    }
    protected static Matcher<? super View> isScrolledToCenterY() {
        return isScrolledToY(2);
    }
    protected static Matcher<? super View> isScrolledToBottom() {
        return isScrolledToY(1);
    }
    protected static Matcher<? super View> noScrollingRequired() {
        return new TypeSafeMatcher<View>() {
            private int mH1=-1;
            private int mH2=-1;
            @Override
            protected boolean matchesSafely(View item) {
                View p = item;
                int h = item.getHeight();
                mH1 = h;
                do {
                    if (p instanceof ScrollView) {
                        mH2 = p.getHeight();
                        if (p.getHeight() < h) {
                            return false;
                        }

                    }
                    if (!(p.getParent() instanceof View)) {
                        return true;
                    }
                    p = (View) p.getParent();
                } while (p != null);
                return true;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("visible area is not smaller than full height");
                if (mH1 >= 0 && mH2 >= 0) {
                    description.appendText(" (full height = "+mH1+ ", visible height = "+mH2+")");
                }
            }
        };
    }
    private static Matcher<? super View> isScrolledToY(int part) {
        return new TestIsScrolledToPositionMatcher() {
            public void describeTo(Description description) {
                description.appendText("Checks if a ScrollView ist centered vertically.");
            }

            @Override
            int getPosition(ScrollView sv) {

                return sv.getScrollY();
            }

            @Override
            int getPosition(WebView wv) {
                return wv.getScrollY();
            }
            private int getScrollPosition(View item) {
                View p = item;
                do {
                    if (p instanceof ScrollView) {
                        Log.v(getClass().getSimpleName(), ".getPosition((ScrollView) p) = "+getPosition((ScrollView) p));
                        return getPosition((ScrollView) p);

                    }
                    if (p instanceof WebView) {
                        return getPosition((WebView) p);
                    }
                    p = (View) p.getParent();
                } while (p != null);
                return 0;

            }
            @Override
            protected boolean matchesSafely(View item) {
                return getExceedingHeight(item)/part == getScrollPosition(item);
            }
        };
    }
    static protected Activity getActivity() {
        Collection<Activity> allActivities = ActivityLifecycleMonitorRegistry.getInstance()
                .getActivitiesInStage(Stage.RESUMED);
        if (!allActivities.isEmpty()) {
            return allActivities.iterator().next();
        }
        return null;
    }
    private static class OrientationChangeAction implements ViewAction {
        private final int mOrientation;

        private OrientationChangeAction(int orientation) {
            this.mOrientation = orientation;
        }

        @Override
        public Matcher<View> getConstraints() {
            return isRoot();
        }

        @Override
        public String getDescription() {
            return "change orientation to " + mOrientation;
        }
        @Override
        public void perform(UiController uiController, View view) {
            uiController.loopMainThreadUntilIdle();
            Activity activity = getActivity();
            if (activity == null && view instanceof ViewGroup) {
                ViewGroup v = (ViewGroup) view;
                int c = v.getChildCount();
                for (int i = 0; i < c && activity == null; ++i) {
                    activity = getActivity();
                }
            }
            Objects.requireNonNull(activity).setRequestedOrientation(mOrientation);
            uiController.loopMainThreadForAtLeast(2000);
            Collection<Activity> resumedActivities = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
            if (resumedActivities.isEmpty()) {
                throw new RuntimeException("Could not change orientation");
            }
        }

    }
    protected static ViewAction setHardwarekeyboardConnected(boolean enabled) {
        return new ViewAction() {
            @Override
            public String getDescription() {
                return (enabled ? "Enable" : "Disable")+" hardware keyboard";
            }

            @Override
            public Matcher<View> getConstraints() {
                return isDisplayed();
            }

            @Override
            public void perform(UiController uiController, View view) {
                Activity a = getActivity();
                Runnable update;
                if (a instanceof DeviceSupportActivity) {
                    DeviceSupportActivity ea = (DeviceSupportActivity) a;
                    update = ea::updateHardware;
                } else {
                    update = () -> {
                    };
                }
                TestBase.mUseKeyboard = enabled;
                update.run();

            }
        };
    }
    protected static ViewAction setJoysticksConnected(Class<? extends Joystick> joystickClass, boolean enabled) {
        return new ViewAction() {
            @Override
            public String getDescription() {
                return (enabled ? "Enable" : "Disable")+" Joysticks of class "+joystickClass.getSimpleName();
            }

            @Override
            public Matcher<View> getConstraints() {
                return isDisplayed();
            }

            @Override
            public void perform(UiController uiController, View view) {
                Activity a = getActivity();
                Runnable update;
                if (a instanceof EmulationActivity) {
                    EmulationActivity ea = (EmulationActivity) a;
                    update = ea::updateHardwareForTest;
                } else if (a instanceof DeviceSupportActivity) {
                    DeviceSupportActivity dsa = (DeviceSupportActivity) a;
                    update = dsa::updateHardware;
                } else {
                    update = () -> {
                    };
                }

                if (enabled && disabledJoystickClasses.remove(joystickClass)) {
                    update.run();
                }
                //noinspection unchecked
                if (!enabled && disabledJoystickClasses.add((Class<Joystick>) joystickClass)) {
                    update.run();
                }
            }
        };
    }
    protected static ViewAction orientationLandscape() {
        return new OrientationChangeAction(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
    }

    protected static ViewAction orientationPortrait() {
        return new OrientationChangeAction(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
    }
    @SuppressWarnings("unused")
    protected static TypeSafeMatcher<View> isInPortraitMode() {
        return isInOrientation(false);
    }
    @SuppressWarnings("unused")
    protected static TypeSafeMatcher<View> isInLandscapeMode() {
        return isInOrientation(true);
    }
    private static TypeSafeMatcher<View> isInOrientation(boolean isLandscape) {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View item) {
                Activity a = getActivity();
                DisplayMetrics dm = new DisplayMetrics();
                if (a != null) {
                    a.getWindowManager().getDefaultDisplay().getMetrics(dm);
                }
                return (dm.widthPixels > dm.heightPixels) == isLandscape;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Check if device is in "+(isLandscape ? "landscape": "portrait") +" mode");
            }
        };
    }
    private abstract static class EmulationTestmatcher extends EmulatorStateMatcher {
        abstract boolean doTest(EmulationTestInterface item);
        @Override
        protected boolean matchesSafely(View item) {
            EmulationTestInterface eti = getSurfaceView(item);
            if (item instanceof EmulationTestInterface) {
                return doTest((EmulationTestInterface) item);
            }
            if (eti != null) {
                return doTest(eti);
            }
            return false;
        }

    }
    private static class IsDrawnMatcher extends EmulationTestmatcher {
        @Override
        public void describeTo(Description description) {
            description.appendText("Checks if emulation initializes screen");
        }

        @Override
        boolean doTest(EmulationTestInterface item) {
            return item.waitForScreenInit(1, TimeUnit.SECONDS);
        }
    }
    protected Matcher<View> isScreenInitialized() {
        return new IsDrawnMatcher();
    }
    protected TypeSafeMatcher<View> isScreenUpdating() {
        return isScreenUpdating(1);
    }
    protected TypeSafeMatcher<View> isScreenUpdating(int times) {
        return new EmulationTestmatcher() {
            private String mHint = "";
            @Override
            public void describeTo(Description description) {
                description.appendText("Checks if emulation is updating screen."+mHint);
            }
            @Override
            boolean doTest(EmulationTestInterface item) {
                boolean ret = false;
                for (int i=0;i<times;i++) {
                    if (item.waitForScreenRedraw(400, TimeUnit.MILLISECONDS)) {
                        return true;
                    }
                }
                if (item instanceof MonitorGlSurfaceView) {
                    MonitorGlSurfaceView v = (MonitorGlSurfaceView) item;
                    byte[] data = v.getLastRecordedBitmap();
                    if (data != null) {
                        try {
                            File dir = getErrorScreenshotDir();
                            int index = 0;
                            while (new File(dir,"non-updating-"+index+".pixelbuffer").exists()) {
                                index++;
                            }
                            File f = new File(dir, "non-updating-"+index+".pixelbuffer");
                            Log.v(TAG, "matchesSafely writing last bitmap to " + f.getAbsolutePath());

                            //noinspection IOStreamConstructor
                            OutputStream os = new FileOutputStream(f);
                            os.write(data);
                            os.close();
                            mHint = " stalled-picture: " + f.getAbsolutePath();
                        }
                        catch (IOException e) {
                            mHint = " (error: " + e.getLocalizedMessage() + ")";
                            throw new RuntimeException(e);

                        }
                    } else {
                        mHint = "(bitmap never set)";
                        Log.v(TAG, "matchesSafely no bitmap ever set");
                    }
                }
                return ret;
            }
        };
    }
    abstract private static class EmulatorStateMatcher extends TypeSafeMatcher<View> {
        EmulationTestInterface getSurfaceView(View item) {
            if (item instanceof EmulationTestInterface) {
                return (EmulationTestInterface) item;
            }
            Activity a = getActivity();
            View gl = null;
            if (a != null) {
                gl = a.findViewById(R.id.gv_monitor);
            }
            if (gl != null) {
                return (EmulationTestInterface) gl;
            }
            return null;
        }

    }
    protected TypeSafeMatcher<View> isAudioPlaying() {
        return isAudioPlaying(250, TimeUnit.MILLISECONDS);
    }
    protected TypeSafeMatcher<View> isAudioPlaying(int t, TimeUnit u) {
        return new EmulatorStateMatcher() {
            @Override
            protected boolean matchesSafely(View item) {
                EmulationTestInterface eti = getSurfaceView(item);
                if (eti != null) {
                    return eti.waitForAudio(t, u);
                }
                return false;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Checks if audio is played");
            }
        };
    }


    protected void toggleKeyboard() {
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDS_KEYBOARD)).perform(click());
        onView(instanceOf(EmulationDialogFragmentRootview.class)).check(doesNotExist());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
    }
    protected static TypeSafeMatcher<View> isHighlightedC64Key() {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View item) {
                if (item instanceof KeyButton) {
                    return ((KeyButton) item).isHighlighted();
                }
                if (item instanceof ToggledKeyButton) {
                    return ((ToggledKeyButton) item).isHighlighted();
                }

                return false;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Key is highlighted");
            }
        };
    }
    protected static Matcher<View> isC64Key(String text) {
        return new TypeSafeMatcher<View>() {
            String mSearch = null;
            boolean found = false;
            @Override
            protected boolean matchesSafely(View item) {
                if (!found) {
                    if (mSearch == null) {
                        mSearch = "'" + text + "'";
                    }
                    if (item instanceof KeyButton) {
                        KeyButton b = (KeyButton) item;
                        if (b.toString().startsWith(mSearch)) {
                            found = true;
                            return true;
                        }
                    }
                    if (item instanceof ToggledKeyButton) {
                        ToggledKeyButton b = (ToggledKeyButton) item;
                        if (b.toString().startsWith(mSearch)) {
                            found = true;
                            return true;
                        }
                    }

                }
                return false;
            }
            @Override
            public void describeTo(Description description) {

                description.appendText("is C64 key '"+text+"'");
            }
        };
    }
    protected static Matcher<View> showsBitmapEqualToAsset(
            @SuppressWarnings("SameParameterValue") String name) {
        return showsBitmapEqualToAsset(name, 1, TimeUnit.SECONDS);
    }
    private static boolean canWriteOnExternalStorage() {
        // get the state of your external storage
        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state)) {
            // if storage is mounted return true
            Log.v("sTag", "Yes, can write to external storage.");
            return true;
        }
        return false;
    }
    private static int imageIndex = 0;
    protected static Matcher<View> showsBitmapEqualToAsset(
            String name,
            long t,
            TimeUnit u) {
        return showsBitmapEqualToAsset(name, t,u, true);
    }
    protected static Matcher<View> isScrolledToPosition(final int position, final long t, final TimeUnit u) {
        return new TypeSafeMatcher<View>() {
            @Override
            protected boolean matchesSafely(View item) {
                if (item instanceof MonitorGlSurfaceView) {
                    MonitorGlSurfaceView gl = (MonitorGlSurfaceView) item;
                    return gl.waitForScroll(position, t, u);
                }

                return false;
            }
            @Override
            public void describeTo(Description description) {

            }
};
    }
    protected static Matcher<View> showsBitmapEqualToAsset(
            String name,
            long t,
            TimeUnit u, boolean expectMissmatch) {

        return allOf(isDisplayed(), new TypeSafeMatcher<View>() {
            private String mHint = "";
            @Override
            protected boolean matchesSafely(View item) {
                Log.v(TAG, String.format("matchesSafely for %s entered.", name));
                try (InputStream is = getInstrumentation().getContext().getAssets().open("expected_bitmaps/"+name)) {
                    byte[] b = new byte[is.available()];
                    if (is.read(b) <= 0) {
                        b = null;
                    }
                    if (item instanceof MonitorGlSurfaceView && b != null) {
                        MonitorGlSurfaceView v = (MonitorGlSurfaceView) item;
                        Log.v(TAG, String.format("matchesSafely for %s waiting, width = %d", name, item.getWidth()));
                        if (v.getLastRecordedBitmap() != null) {
                            if (Arrays.equals(b, v.getLastRecordedBitmap())) {
                                Log.v(TAG, String.format("matchesSafely for %s match (previous bitmap)", name));
                                return true;
                            }
                        }
                        if (v.waitForBitmap(b, t, u)) {
                            Log.v(TAG, String.format("matchesSafely for %s match (new bitmap)", name));
                            return true;
                        }

                    }
                    if (item instanceof ImageView) {
                        ImageView iv = (ImageView) item;
                        if (iv.getDrawable() instanceof BitmapDrawable) {
                            Bitmap bmp = ((BitmapDrawable) iv.getDrawable()).getBitmap();
                            int bytes = bmp.getAllocationByteCount();
                            ByteBuffer buffer = ByteBuffer.allocate(bytes); //Create a new buffer
                            bmp.copyPixelsToBuffer(buffer);
                            if (Arrays.equals(b, buffer.array())) {
                                return true;
                            } else {
                                if (expectMissmatch) {
                                    File dir = getErrorScreenshotDir();
                                    File f = new File(dir, name);
                                    //noinspection resource
                                    OutputStream os = new FileOutputStream(f);
                                    os.write(buffer.array());
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                    if (item instanceof MonitorGlSurfaceView) {
                        if (expectMissmatch) {
                            saveBitmap((MonitorGlSurfaceView) item);
                        }
                    }
                    return false;
                }
                catch (FileNotFoundException e) {
                    if (item instanceof MonitorGlSurfaceView) {
                        try {
                            saveBitmap((MonitorGlSurfaceView) item);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    throw new RuntimeException(e);

                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void saveBitmap(MonitorGlSurfaceView item) throws IOException {
                byte[] data = item.getLastRecordedBitmap();
                if (data != null) {
                    File dir = getErrorScreenshotDir();
                    String uniqueName;
                    //noinspection RegExpRedundantEscape
                    String[] tokens = name.split("\\.(?=[^\\.]+$)");
                    if (tokens.length < 2) {
                        uniqueName = String.format("%s-%03d", name, imageIndex);

                    } else {
                        uniqueName = String.format("%s-%03d.%s", tokens[0], imageIndex, tokens[1]);
                    }
                    File f = new File(dir, uniqueName);
                    Log.v(TAG, "matchesSafely writing last bitmap to "+f.getAbsolutePath());
                    imageIndex++;
                    try {
                        //noinspection IOStreamConstructor
                        OutputStream os = new FileOutputStream(f);
                        os.write(data);
                        os.close();
                        mHint = "non-expected result written to "+f.getAbsolutePath();
                    }
                    catch (IOException e) {
                        mHint = "(error: "+e.getLocalizedMessage()+")";
                        throw new RuntimeException(e);

                    }
                } else {
                    mHint = "(bitmap never set)";
                    Log.v(TAG, "matchesSafely no bitmap ever set");
                }
            }

            public void describeTo(Description description) {
                description.appendText("content did not match ").appendText(name).appendText(" ").appendText(mHint);
            }
        });
    }

    @NonNull
    private static File getErrorScreenshotDir() throws IOException {
        return getDir("missmatched-screenshots");
    }
    private static File getDir(String dirname) throws IOException {
        String root = null;
        AssetManager am = getInstrumentation().getContext().getAssets();
        if (Arrays.asList(Objects.requireNonNull(am.list(""))).contains("__ASSETS_TO_SDCARD__") && canWriteOnExternalStorage()) {
            InputStream is = getInstrumentation().getContext().getAssets().open("__ASSETS_TO_SDCARD__");
            String folder = new BufferedReader(new InputStreamReader(is)).readLine();
            if (!folder.isEmpty()) {
                File subfolder = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOCUMENTS).getAbsolutePath(), folder);
                if (subfolder.isDirectory() || subfolder.mkdirs()) {
                    root = subfolder.getAbsolutePath();
                }
            }
            if (root == null) {
                root = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOCUMENTS).getAbsolutePath();
            }
        } else {
            root = InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir().getAbsolutePath();
        }
        File dir = new File(root,dirname);
        if (!dir.isDirectory()) {
            //noinspection ResultOfMethodCallIgnored
            dir.mkdirs();
        }
        return dir;
    }

    protected boolean lockAndLock() {
        Log.i(getClass().getSimpleName()," If you face Problems, add "+Build.FINGERPRINT+" to androidTest/assets/known_lock_not_working_devices");
        if (!isKnownNotLockingDevice()) {
            UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
            try {
                int old=0;
                Activity a = getCurrentActivity();
                if (a != null) {

                    View decorView = a.getWindow().getDecorView();
                    old = decorView.getSystemUiVisibility();

                    a.runOnUiThread(() -> decorView.setSystemUiVisibility(
                            View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                                    | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                                    | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN));
                }
                Thread.sleep(1000);
                //device.pressKeyCode(KeyEvent.KEYCODE_POWER);
                try {
                    device.sleep();
                    Thread.sleep(1000);
                    //device.pressKeyCode(KeyEvent.KEYCODE_POWER);
                    device.wakeUp();
                    Thread.sleep(1000);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
                if (a != null){
                    final int val=old;
                    a.runOnUiThread(() -> a.getWindow().getDecorView().setSystemUiVisibility(val));
                }
                Thread.sleep(1000);

            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        return false;
    }

    private boolean isKnownNotLockingDevice() {
        return isListedDevice("known_lock_not_working_devices", false);
    }
    private boolean isListedDevice(String asset, boolean localfile) {
        AssetManager am = InstrumentationRegistry.getInstrumentation().getContext().getAssets();
        try {
            String[] files = am.list("");
            if (files != null) {
                for (String s : files) {
                    if (s.equals(asset)) {
                        InputStream is = am.open(s);
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String line;
                        while ((line = br.readLine()) != null) {
                            if (line.equals(Build.FINGERPRINT)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        if (!localfile) {
            return isListedDevice(asset+".local", true);
        } else {
            return false;
        }
    }

    protected Activity getCurrentActivity() {
        final Activity[] activity = new Activity[1];

        onView(isRoot()).check((view, noViewFoundException) -> {

            View checkedView = view;

            while (checkedView instanceof ViewGroup && ((ViewGroup) checkedView).getChildCount() > 0) {

                checkedView = ((ViewGroup) checkedView).getChildAt(0);

                if (checkedView.getContext() instanceof Activity) {
                    activity[0] = (Activity) checkedView.getContext();
                    return;
                }
            }
        });
        return activity[0];
    }
    //SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
    // v.getContext().getCacheDir()+"/"+ dateFormat.format(new Date())+".raw-bmp"
    @SuppressWarnings("unused")
    protected static ViewAction captureEmulationScreen() {

        return captureEmulationScreen( new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date())+".raw-bmp");
    }
    @SuppressWarnings("unused")
    protected static ViewAction captureEmulationScreen(String filename) {
        return new ViewAction() {
            @Override
            public String getDescription() {
                return "write bitmap to cachedir";
            }

            @Override
            public Matcher<View> getConstraints() {
                return isA(View.class);
            }

            @Override
            public void perform(UiController uiController, View view) {

                MonitorGlSurfaceView v = (MonitorGlSurfaceView) view;
                int bytes = v.getCurrentBitmap().getAllocationByteCount();
                ByteBuffer buffer = ByteBuffer.allocate(bytes); //Create a new buffer
                v.getCurrentBitmap().copyPixelsToBuffer(buffer);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                try {
                    @SuppressWarnings("IOStreamConstructor")
                    OutputStream os = new FileOutputStream(InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir()+"/"+filename);
                    os.write(buffer.array());
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
    private static class TestTextMatcher extends TypeSafeMatcher<Object> {
        String mName =null;
        @Override
        protected boolean matchesSafely(Object item) {
            if (item instanceof Emulation.DataEntry) {

                return ((Emulation.DataEntry) item).getText().equals(mName);
            }
            return false;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("text is "+mName);
        }
    }
    protected static Matcher<Object> isOption(int resId) {
        return isOption(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(resId));
    }
    protected static Matcher<Object> isOption(String name) {
        TestTextMatcher ret = new TestTextMatcher();
        ret.mName = name;
        return ret;
    }
    private static class ToastMatcher extends TypeSafeMatcher<Root> {
        @Override
        public void describeTo(Description description) {
            description.appendText("is toast");
        }

        @Override
        public boolean matchesSafely(Root root) {
            int type = root.getWindowLayoutParams2().type;
            if (type == WindowManager.LayoutParams.TYPE_TOAST) {
                IBinder windowToken = root.getDecorView().getWindowToken();
                IBinder appToken = root.getDecorView().getApplicationWindowToken();
                // windowToken == appToken means this window isn't contained by any other windows.
                // if it was a window for an activity, it would have TYPE_BASE_APPLICATION.
                return appToken == windowToken;
            }
            return false;
        }
    }

    static Matcher<Root> isToast() {
        return new ToastMatcher();
    }

    protected void checkForToast(@IdRes int resId) {
        checkForToast(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(resId));
    }
    // Espresso vs. Toast does not work with API>=30.
    protected void checkForToast(String message) {
        checkForToast(withText(message));
    }
    protected void checkForToast(Matcher<View> matcher) {
        if (Build.VERSION.SDK_INT < 30 ) {
            Exception e = null;
            for (int i = 0; i <10; i++) {
                try {
                    onView(matcher).inRoot(isToast()).check(matches(isDisplayed()));
                    return;
                } catch (NoMatchingRootException nmv) {
                    e = nmv;
                    try {
                        Thread.sleep(100);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                } catch (Exception other) {
                    if (other instanceof EspressoException) {
                        e = other;
                        try {
                            Thread.sleep(100);
                        }
                        catch (InterruptedException ie) {
                            throw new RuntimeException(ie);
                        }

                    }
                }
            }
            throw new RuntimeException(e);
        }
    }

    protected static class FingerState {
        private MotionEvent mCurrentEvent = null;
        private float[] getCoordinates(View view, int xpos, int ypos) {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            int h = view.getHeight();
            int w = view.getWidth();

            return new float[]{w*xpos / 100f, h*ypos/ 100f};
        }

    }
    protected enum FingerAction {UP, DOWN, MOVE}

    protected ViewAction doFingerAction(FingerAction action, FingerState state, @IntRange(from = 0, to = 100) int xpos, @IntRange(from = 0, to = 100) int ypos) {
        return new ViewAction() {
            @Override
            public String getDescription() {
                return "finger down";
            }

            @Override
            public Matcher<View> getConstraints() {
                return isEnabled();
            }

            @Override
            public void perform(UiController uiController, View view) {
                switch (action) {
                    case DOWN:
                        if (state.mCurrentEvent == null) {
                            float[] precision = new float[]{1f, 1f};
                            float[] coordinates = state.getCoordinates(view, xpos, ypos);
                            state.mCurrentEvent = MotionEvents.obtainDownEvent(coordinates,precision);
                            if (view instanceof TouchDisplayRelativeLayout.TouchDisplayElement) {
                                float x = (xpos / 50f) - 1f;
                                float y = (ypos / 50f) -1f;
                                ((TouchDisplayRelativeLayout.TouchDisplayElement) view).press(x, y);
                            } else {
                                view.onTouchEvent(state.mCurrentEvent);
                            }


                        } else {
                            throw new IllegalStateException("double finger down");
                        }
                        break;
                    case UP:
                        if (state.mCurrentEvent != null) {
                            if (view instanceof TouchDisplayRelativeLayout.TouchDisplayElement) {
                                ((TouchDisplayRelativeLayout.TouchDisplayElement) view).release();
                            } else {
                                view.dispatchTouchEvent(MotionEvents.obtainUpEvent(state.mCurrentEvent, new float[]{state.mCurrentEvent.getX(), state.mCurrentEvent.getY()}));
                            }
                            state.mCurrentEvent = null;
                        } else {
                            throw new IllegalStateException("finger not down");
                        }

                        break;
                    case MOVE:

                        if (state.mCurrentEvent != null) {
                            if (view instanceof TouchDisplayRelativeLayout.TouchDisplayElement) {
                                float x = (xpos / 50f) - 1f;
                                float y = (ypos / 50f) -1f;
                                ((TouchDisplayRelativeLayout.TouchDisplayElement) view).moveTo(x, y);
                            } else {
                                view.onTouchEvent(state.mCurrentEvent);
                            }

                        } else {
                            throw new IllegalStateException("finger not down");
                        }
                        break;
                }
            }
        };
    }
    @After
    public void cleanup() {
        final String tag = "@After";
        // If we are in running emulation, we must go back to main activity to clean up things.
        Log.v(tag, "starting cleanup");
        try {
            // already in main activity: fine
            onView(withId(R.id.preinstalled)).check(matches(withId(R.id.preinstalled)));
            Log.v(tag, "On Main activity, no need to quit emulation.");
        } catch (NoActivityResumedException | NoMatchingViewException  e) {
            try {
                onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
                Log.v(tag, "Emulation must be quit.");
                pressBack();
                waitForIdle();
                onView(withText(R.string.quit)).perform(click());
                try {
                    waitForActivity(MainActivity.class, 1, TimeUnit.SECONDS);
                } catch (Exception e2) {
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            } catch (NoActivityResumedException | NoMatchingViewException e2) {
                Log.v(tag, "On other activity, no need to quit emulation.");
            }
        } catch (RuntimeException e) {
            Log.v(TAG, "Catching weird RuntimeException", e);
        }


        for (String path : mStoredFiles.keySet()) {
            try {
                File f = new File(path);
                File d = f.getParentFile();
                if (d != null && (d.isDirectory() || d.mkdirs())) {

                    FileOutputStream fos = new FileOutputStream(f);
                    if (mStoredFiles.get(path) != null) {
                        fos.write(Objects.requireNonNull(mStoredFiles.get(path)).toByteArray());
                    }
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String path : mRemoveFiles) {
            if (new File(path).isFile()) {
                if (!new File(path).delete()) {
                    Log.e("@After", "Could not delete " + path);
                }
            }
        }
        //waitForEmulationShutdown();
    }
    protected void waitForEmulationShutdown() {
        Log.v("@After", "started shutDownEmulation");
        if (Emulationslist.getCurrentEmulation() != null) {
            if (Emulationslist.getCurrentEmulation().isRunning()) {
                Emulationslist.getCurrentEmulation().terminate(Emulationslist::disposeCurrentEmulation);
            }
            while (Emulationslist.getCurrentEmulation() != null) {
                try {
                    //noinspection BusyWait
                    Thread.sleep(250);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            Emulationslist.disposeCurrentEmulation();
        }
        try {
            Thread.sleep(1000);
        }
        catch (InterruptedException e) {
            Log.e("@After", "interrupted", e);
            throw new RuntimeException(e);
        }

        Log.v("@After", "finished shutDownEmulation");
    }

    static Matcher<View> isMenuPresent(@IdRes int anyTextId) {
        return anyOf(
                allOf(withText(anyTextId),isDescendantOfA(Matchers.instanceOf(MenuView.ItemView.class))),
                allOf(Matchers.instanceOf(EmulationDialogFragmentRootview.class), Matchers.not(withParent(Matchers.instanceOf(EmulationDialogFragmentRootview.class)))));
    }
    protected void addTestConfigurations() {
        String folder = "test_assets/test_packages/" + getClass().getSimpleName();
        if (getCurrentActivity() instanceof MainActivity) {
            MainActivity a = (MainActivity) getCurrentActivity();
            a.setTestConfigurationFolder(InstrumentationRegistry.getInstrumentation().getContext().getAssets(), folder);
        }
    }
    protected static Matcher<View> isWithProgress(final int expectedProgress) {
        return new BoundedMatcher<View, SeekBar>(SeekBar.class) {
            @Override
            public void describeTo(Description description) {
                description.appendText("expected: ");
                description.appendText(""+expectedProgress);
            }

            @Override
            public boolean matchesSafely(SeekBar seekBar) {
                return seekBar.getProgress() == expectedProgress;
            }
        };
    }

}
