package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import android.view.KeyEvent;

import org.hamcrest.CoreMatchers;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SwapJoysticksTest extends C64JoystickTestBase {
    @Test
    public void test_swap_joysticks() {
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        configDirection("FIRE", KeyEvent.KEYCODE_F9, R.string.IDS_PRESS_KEY_FIRE);
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        FingerState fireState = new FingerState();
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.UP, fireState, 50, 50));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.swap_joysticks)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.UP, fireState, 50, 50));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));




    }
}
