package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static androidx.test.espresso.web.sugar.Web.onWebView;
import static androidx.test.espresso.web.webdriver.DriverAtoms.findElement;
import static androidx.test.espresso.web.webdriver.DriverAtoms.webClick;
import static androidx.test.espresso.web.webdriver.DriverAtoms.webScrollIntoView;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import android.content.Context;
import android.content.pm.PackageManager;
import android.view.KeyEvent;
import android.view.View;


import androidx.annotation.StringRes;
import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PromoPicturesTest extends MainActivityTestBase{
    interface DeviceTypeSpecificFunctions {
        void openEmulationMenu();
        void pressFireButton();
        void pressFireButton(int duration);
        boolean isTv();
    }
    class TvSpecificFunctions implements DeviceTypeSpecificFunctions
    {
        @Override
        public void openEmulationMenu() {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_MENU));
            waitForIdle();
        }

        @Override
        public void pressFireButton() {
            pressFireButton(1000 / 25);
        }

        @Override
        public void pressFireButton(int duration) {
            onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BUTTON_THUMBL, -73));
            //onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle(duration, TimeUnit.MILLISECONDS);
            onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_THUMBL, -73));
            //onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_CENTER));

        }

        @Override
        public boolean isTv() {
            return true;
        }
    }
    class TouchSpecificFunctions implements DeviceTypeSpecificFunctions {
        @Override
        public void openEmulationMenu() {
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        }

        @Override
        public void pressFireButton() {
            onView(withId(R.id.jv_fire)).perform(tap());
        }

        @Override
        public void pressFireButton(int duration) {
            FingerState fireState = new FingerState();
            onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
            waitForIdle(duration, TimeUnit.MILLISECONDS);
            onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.UP, fireState, 50, 50));

        }

        @Override
        public boolean isTv() {
            return false;
        }
    }
    @Test
    @SpecialTest
    @PreviewScreenshotTest
    public void takePromoScreenshots() throws IOException {
        final Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
        final boolean isTv;
        final DeviceTypeSpecificFunctions dsf;
        if (ctx.getPackageManager().hasSystemFeature(PackageManager.FEATURE_TELEVISION)
                || ctx.getPackageManager().hasSystemFeature(PackageManager.FEATURE_LEANBACK)) {
            isTv = true;
            dsf = new TvSpecificFunctions();
        } else {
            isTv = !ctx.getPackageManager().hasSystemFeature(PackageManager.FEATURE_TOUCHSCREEN);
            dsf = new TouchSpecificFunctions();
        }
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, isTv));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));

        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        captureDeviceScreen("preinstalled");
        waitForIdle();
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-w-cursor.pixelbuffer",10, TimeUnit.SECONDS)));
        openDocument(extractTestAsset("10printmaze.vsf"));
        waitForIdle(250, TimeUnit.MILLISECONDS);
        captureDeviceScreen("emulation");
        dsf.openEmulationMenu();
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_joysticks)).perform(scrollTo()).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));

        openDocument(extractTestAsset("giana.vsf"));
        setOrientation(dsf, R.string.landscape);
        captureDeviceScreen("ggs");
        dsf.openEmulationMenu();
        waitForIdle();
        onView(withText(R.string.rewind)).perform(click());
        waitForIdle();
        onView(withId(R.id.choose_moment)).check(matches(isDisplayed()));
        captureDeviceScreen("timemachine");
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        waitForIdle();
        dsf.openEmulationMenu();
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_save)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()));
        waitForIdle();
        dsf.openEmulationMenu();
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed()));
        captureDeviceScreen("savestates");
        pressBack();
        setOrientation(dsf, R.string.portrait);
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5,TimeUnit.SECONDS);
        /*
        onView(isRoot()).perform(createdTileAction("Formula 1 Simulator", click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle(2, TimeUnit.SECONDS);
        dsf.pressFireButton();
        waitForIdle(2, TimeUnit.SECONDS);
        dsf.pressFireButton();

        waitForIdle(5, TimeUnit.SECONDS);
        captureDeviceScreen("formula-1-simpulator");
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).perform(click());

         */
        waitForIdle();
        //onView(withId(R.id.preinstalled)).perform(click());

        onView(withId(R.id.imported)).check(matches(withId(R.id.imported))).perform(scrollTo());
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("download-sources");
        onView(isContentSourceViewWithTitle(new ArchiveOrgAccess.ArchiveOrgVic20CommunitySoftware()
                .getTitle(InstrumentationRegistry.getInstrumentation().getTargetContext()))).perform(click());
        waitForActivity(BrowserActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        try {
            onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
        } catch (Exception e) {
            waitForProgressDialog(withId(R.id.wv_contents));
        }
        waitForIdle();
        onView(withId(R.id.wv_contents)).check(matches(isDisplayed()));
        onWebView().withElement(findElement(Locator.XPATH, "//div/button/span[text()='Gridrunner (Japan, USA)']"))
                .perform(webScrollIntoView()).perform(webClick());
        waitForIdle(20, TimeUnit.SECONDS);
        waitForIdle();
        captureDeviceScreen("archive_org");
        pressBack();
        waitForActivity(MainActivity.class);
        onView(withId(R.id.preinstalled)).perform(scrollTo());
        onView(isRoot()).perform(createdTileAction("C64", click()));
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        dsf.openEmulationMenu();
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(withId(R.id.gh_joysticks)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withText(R.string.use_secondary_button)))
                .check(matches(not(isChecked())))
                .perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.sp_secondary_button))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.autofire_toggle)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo());
        waitForIdle();
        captureDeviceScreen("settings");

    }

    private void setOrientation(DeviceTypeSpecificFunctions dsf, @StringRes int textId) {
        if (!dsf.isTv()) {

            dsf.openEmulationMenu();
            waitForIdle();
            onView(withText(R.string.IDMS_SETTINGS)).perform(click());
            waitForIdle();
            onView(withId(R.id.gh_mobile_device_settings)).perform(scrollTo()).perform(click());
            waitForIdle();
            onView(withText(textId)).perform(scrollTo()).perform(click());
            onView(withId(R.id.gh_mobile_device_settings)).perform(scrollTo()).perform(click());
            onView(withId(R.id.bn_apply)).perform(click());
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        }
    }


    @Override
    protected String buildScreenshotFilename(int index, String keyword) {
        return String.format("%02d.png",index);
    }
    @Override
    protected String getScreenshotFolder() {
        return "preview-screenshots";
    }

}
