package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasData;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.view.View;
import android.widget.TextView;

import androidx.test.espresso.intent.Intents;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;


public class OtherActivitiesTest extends MainActivityTestBase {
    static Matcher<View> withPart(String part) {
        return new TypeSafeMatcher<View>() {

            @Override
            public void describeTo(Description description) {
                description.appendText("checks for regex "+part);
            }

            @Override
            protected boolean matchesSafely(View item) {
                try {
                    TextView tv = (TextView) item;
                    return tv.getText().toString().contains(part);

                } catch( ClassCastException e) {
                    return false;
                }

            }
        };
    }

    @Test
    public void t_0070_licences() {
        Intents.release();
        Intents.init();
        intending(allOf(hasAction(Intent.ACTION_VIEW),hasData(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.tutorials_url))))
                .respondWithFunction(intent -> new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        onView(withId(R.id.bn_info)).perform(click());
        //waitForActivity(BrowserActivity.class);
    }
    @Test
    public void t_0100_goto_website() {
        onView(withId(R.id.bn_info)).perform(click());
        onView(withText(R.string.licences)).perform(click());
        waitForActivity(BrowserActivity.class);
    }
    @Test
    public void t_0390_videotutorials() {
        onView(withId(R.id.bn_info)).perform(click());
        Intents.release();
        Intents.init();
        intending(allOf(hasAction(Intent.ACTION_VIEW),hasData(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.tutorials_url))))
                .respondWithFunction(intent -> new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        onView(withText(R.string.title_videotutorials)).perform(click());
        onView(withId(R.id.bn_info)).check(matches(isDisplayed()));

    }
}