package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.clearText;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.hasFocus;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.anyOf;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.instanceOf;

import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.TabWidget;

import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.TypeTextAction;

import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ConfigurationTest extends MainActivityTestBase {
    private final static String JOY1 = "_JOY_";
    private final static String JOY2 = "_JOY2_";
    private final static String TIMEMACHINE = "_TIMEMACHINE_";
    private static final String UPDATED_FROM_SAVESTATE = "_UPDATED_FROM_SAVESTATE_";

    @Test
    public void t_0010_single_joystick() {
        // Error if Configuration already exists.
        onView(withText(JOY1)).check(doesNotExist());
        /*
        Action: launch C64 emulation and start DELAYTEST-JOY from Testprograms
        Expected result: Program is launched.
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onData(isOption("DELAYTEST-JOY")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        /*
        Action: Open joystick settings, choose None as Port #1, DPAD-Joystick as Port #2, leave
        Expected result: Program still running
         */
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(equalTo("port#2"))).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).perform(click());
        pressBack();
        waitForIdle();
        /*
        Action: press joystick button
        Expected result: Sound is played, screen content changing
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-1.pixelbuffer",2, TimeUnit.SECONDS)))
                .check(matches(not(isAudioPlaying())));
                /*
                Action: press joystick button
                Expected result: Sound is played, screen content changing
                 */
        onView(withId(R.id.gv_monitor))
                .perform(TestBase.pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-2.pixelbuffer",2, TimeUnit.SECONDS)))
                .perform(TestBase.releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        /*
        Action: Open menu with the hamburger and choose "Create Link"/"Verknüpfung erstellen
        Expected result: Dialog is showing up.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());

        waitForIdle();
        /*
        Action: type "joy" as name and click on "OK"
        Expected result: Emulation is shown again
         */

        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(JOY1))
                .perform(closeSoftKeyboard());
        waitForIdle();
        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        /*
        Action: click on "joy"
        Expected result: Emulation is showing up in the same state as when it was saved.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY1, click()));
        waitForIdle();
        /*
        Action: Press fire button on DPAD-Joystick
        Expected result: Sound is played, screen content changing.
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-2.pixelbuffer",2, TimeUnit.SECONDS)))
                .perform(TestBase.pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-3.pixelbuffer",2, TimeUnit.SECONDS)))
                .perform(TestBase.releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A))
                .check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: Press fire button on DPAD-Joystick once more
        Expected result: Sound is played, screen content changing.
         */

        onView(withId(R.id.gv_monitor))
                .perform(TestBase.pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-4.pixelbuffer",2, TimeUnit.SECONDS)))
                .perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_THUMBL, GameControllerJoystickTest.DEVICE_ID))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-4.pixelbuffer",2, TimeUnit.SECONDS)));
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        /*
        Action: click on "joy"
        Expected result: Emulation is showing up in the same state as when it was saved.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY1, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-2.pixelbuffer",2, TimeUnit.SECONDS)));
        /*
        Action: Disconnect all hardware joystick
        Expected result: virtual touch joysticks are not showing up.
         */
        onView(withId(R.id.gv_monitor))
                .perform(setJoysticksConnected(GameControllerJoystick.class, false))
                .perform(setJoysticksConnected(DpadJoystick.class, false));
        waitForIdle();

        onView(withId(R.id.jv_fire)).check(doesNotExist());
        onView(withId(R.id.jv_directions)).check(doesNotExist());
        onView(withId(R.id.jv_wheel)).check(doesNotExist());
        onView(withId(R.id.jv_flipswitch)).check(doesNotExist());
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: long click on "joy" and choose "Start" from the menu
        Expected result: emulation is shown.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY1, longClick()));
        onView(withText(R.string.IDMS_START)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-2.pixelbuffer",2, TimeUnit.SECONDS)));
        /*
        Action: Open Settings and section joystick
        Expected result: No Joystick in Port #2
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onData(isOption(R.string.IDS_NONE)).inAdapterView(withTagValue(equalTo("port#2")))
                .check(matches(isDisplayed()));
        /*
        Action: connect DPAD
        Expected result: DPAD in Port #2
         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class,true));
        onData(isOption(R.string.IDS_NONE)).inAdapterView(withTagValue(equalTo("port#2")))
                .check(matches(isDisplayed()));
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).inAdapterView(withTagValue(equalTo("port#2")))
                .check(matches(isDisplayed()));
        pressBack();

        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        /*
        Action tap on tile and open joystick settings
        Expected result: DPAD isn Port #2
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY1, click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystickdelaytest-2.pixelbuffer",2, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).inAdapterView(withTagValue(equalTo("port#2")))
                .check(matches(isDisplayed()));
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        /*
        Action: long click on "joy" and choose "Uninstall"/"Deinstallieren" from the menu
        Expected result: tile "joy" is deleted.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY1, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(JOY1)).check(doesNotExist());
    }
    @Test
    public void t_0130_multi_joysticks(){
        // Error if Configuration already exists.
        onView(withText(JOY2)).check(doesNotExist());
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        /*
        Action: launch C64 emulation and start JOYSTICKTEST from Testprograms
        Expected result: Program is launched, 255 is displaye
         */
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: Tap Hamburger and open "Settings"/"Einstellungen" from the menu
        Expected result: there is a Section "Joysticks"
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        /*
        Action: choose DPAD joystick for Port 1, virtual Touchscreen joystick for port 2, leave settings.
        Expected result: 255 is shown
         */
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString())).perform(click());
        onView(withTagValue(equalTo("port#2"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        /*
        Action: Press up on the dpad and release after a while
        Expected result: 254 is showing as long as up is pressed, then 255.
         */
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer")));
        onView(withId(R.id.screen)).perform(TestBase.pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-up.pixelbuffer",5,TimeUnit.SECONDS)))
                .perform(TestBase.releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer",5,TimeUnit.SECONDS)));
        /*
        Action: Open menu with the hamburger and choose "Create Link"/"Verknüpfung erstellen
        Expected result: Dialog is showing up.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        waitForIdle();
        /*
        Action: type "joy2" as name and click on "OK"
        Expected result: Emulation is shown again
         */

        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(JOY2))
                .perform(closeSoftKeyboard());
        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy"
         */
        waitForIdle();
        pressBack();
        waitForIdle();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: Disconnect DPAD joystick and click on "joy2"
        Expected results
        * Emulation is showing up in the same state as when it was saved
        * there is a toast "Joystick in Port #1 is not connected" / "...ist nicht verbunden".
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot())
                .perform(setJoysticksConnected(DpadJoystick.class,false))
                .perform(createdTileAction(JOY2, click()));
        /*
        Resources res = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources();
        String text=res.getString(R.string.not_connected, res.getString(R.string.IDS_JOYSTICK_IN_PORT_1));
        checkForToast(text);
         */
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer")));

        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "joy2"
         */
        pressBack();
        onView(withText(R.string.global_action_logout))
                .perform(click());
        /*
        Action: long click on "joy2" and choose "Uninstall"/"Deinstallieren" from the menu
        Expected result: tile "joy2" is deleted.
         */
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(JOY2, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(JOY2)).check(doesNotExist());
    }
    @Test
    public void t_0260_timeshifted() {
        // Error if Configuration already exists.
        onView(withText(TIMEMACHINE)).check(doesNotExist());
        /*
        Action: launch C64
        Expected result: emulation is shown
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: wait 7 seconds, type in BLERB, wait another 5 seconds
        Excpected result: BLERB is shown
         */
        waitForIdle(7, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating(2)));
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        waitForIdle(5, TimeUnit.SECONDS);
        /*
        Action: wait another 5 seconds, type in more text
        Expected result: text is shown
         */
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer"))));
        waitForIdle(5, TimeUnit.SECONDS);
        /*
        Action: create main entry with moment 10 secs ago and leave emulation
        Expected result: tile exists.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        waitForIdle();
        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(TIMEMACHINE))
                .perform(closeSoftKeyboard());
        //noinspection deprecation
        onView(withId(R.id.sb_seekbar))
                .check(matches(isDisplayed()))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER));
        onView(withId(R.id.tv_time_offset)).check(matches(anyOf(withText(containsString("10.")),withText(containsString("10,")))));
        onView(withId(R.id.bn_ok)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, click()));
        waitForIdle();
        /*
        Action: start created entry
        Expected result: Excpected result: only BLERB is shown
         */
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer",2, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(TIMEMACHINE)).check(doesNotExist());
    }
    @Test
    public void t_0320_create_from_savestate() {
        // Error if Configuration already exists.
        /*
        Action: Run C64 Emulation and type BLERB
        Expected result: blerb is displayed
         */
        onView(withText(TIMEMACHINE)).check(doesNotExist());
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        waitForIdle(7, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        /*
        Action: create save state
        Expected result: Emulation running, showing text BLERB
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        waitForIdle();

        /*
        Action: type in more text
        Expected result: text is shown
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));

        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer"))));
        /*
        Action:
        - open Savestates dialog
        - choose new state created recently
        - tap on button "more"
        Expected result:
        - there is an item labeled Add to main activity
        - there is no item labeled Use this state on start screen
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();

        onView(allOf(isDisplayed(), withId(R.id.bn_more))).perform(click());
        waitForIdle();

        onView(withText(R.string.use_on_main_activity)).inRoot(isPlatformPopup()).check(doesNotExist());
        /*
        Action: click on item "Add to main activity", type in "_TIMEMACHINE_" and tap on ok
        Expected result: Dialog disappears, Emulation is running, but has not changed
         */
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .check(matches(hasFocus()))
                .perform(new TypeTextAction(TIMEMACHINE, false, null))
                .perform(closeSoftKeyboard());
        waitForIdle();
        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer"))));
        waitForIdle();
        /*
        Action: leave emulation and run recently created tile "_TIMEMACHINE_"
        Expected result: Emulation running and showing BLERB, but not XXX
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, click()));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        pressBack();
        /*
        Action: delete recently created tile _TIMEMACHINE_
        Expected result: tile does not exist.
         */
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
    }
    @Test
    public void t_0430_update() {
        // Error if Configuration already exists.
        onView(withText(UPDATED_FROM_SAVESTATE)).check(doesNotExist());
        /*
        Action: Start C64 Emulation
        Expected result: Emulation is running
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        waitForIdle(5, TimeUnit.SECONDS);
        /*
        Action: open menu, choose save state, choose create link,
                type in "_UPDATES_FROM_SAVESTATE_" and tap OK.
        Expected result: Dialog is closed, emulation running.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_current_state_functions)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).inRoot(isPlatformPopup()).perform(click());
        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .inRoot(isDialog())
                .perform(typeText(UPDATED_FROM_SAVESTATE))
                .perform(closeSoftKeyboard());
        onView(withText(android.R.string.ok))
                .inRoot(isDialog())
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile "_UPDATES_FROM_SAVESTATE_"
         */
        pressBack();
        waitForIdle();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        /*
        Action: tap on _UPDATES_FROM_SAVESTATE_, wait for emulation to show up,
        Expected result: Emulation running
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(UPDATED_FROM_SAVESTATE, click()));
        waitForIdle();
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer")));
        /*
        Action: type in BLERB
        Expected result: BLERB is displayed
         */

        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        /*
        Action: create save state
        Expected result: Emulation running, showing text BLERB
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        /*
        Action: open menu and choose save states, tap on "Use this state on main screen"
        Expected result: Dialog disappears, Emulation running.
         */
        onView(withText(R.string.savestate)).perform(click());
        onView(allOf(withText(String.valueOf(1)),
                isDescendantOfA(instanceOf(TabWidget.class)))).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_more))).perform(click());
        onView(withText(R.string.use_on_main_activity)).inRoot(isPlatformPopup()).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer",1,TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating(2)));

        /*
        Action: close emulation and tap on _UPDATES_FROM_SAVESTATE_
        Expected result: Emulation is running, BLERB is displayed
         */
        pressBack();
        waitForIdle();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(UPDATED_FROM_SAVESTATE, click()));
        waitForIdle();
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating(2)))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer")));
        /*
        Action:
        - close emulation, long tap on _UPDATES_FROM_SAVESTATE_, choose rename
        - enter _BLERB_ as the new name, click "OK".
        Expected result:
        - _UPDATES_FROM_SAVESTATE_ is not displayed anymore
        - _BLERB_ is displayed
         */
        pressBack();
        waitForIdle();

        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(UPDATED_FROM_SAVESTATE, longClick()));
        onView(withText(R.string.rename)).perform(click());
        onView(withId(R.id.tv_name))
                .perform(clearText())
                .perform(typeText("_BLERB_"));
        onView(withId(R.id.bn_ok)).perform(click());
        waitForIdle();
        onView(withText(UPDATED_FROM_SAVESTATE)).check(doesNotExist());
        onView(withText("_BLERB_")).check(matches(isDisplayed()));
        /*
        Action: close emulation, long tap on _BLERB_, choose uninstall
        Expected result: _BLERB_ is not displayed anymore
         */

        onView(isRoot()).perform(createdTileAction("_BLERB_", longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText("_BLERB")).check(doesNotExist());
    }
}