package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;

import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class AllIncludedBundleTest extends MainActivityTestBase{
    private void runAndTestScreen(int tileId, String expectedScreenshot) {
        String tilename = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(tileId);
        runAndTestScreen(tilename, expectedScreenshot);
    }
    private void runAndTestScreen(String tilename, String expectedScreenshot) {
        onView(isRoot()).perform(createdTileAction(tilename, click()));
        waitForEmulation(expectedScreenshot);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(expectedScreenshot,10,TimeUnit.SECONDS)));
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);

    }
    @FullLocalTest
    @SpecialTest
    @Test
    public void test_all_included() {
        setNetworkEnabled(false);
        setTestLocale(Locale.US);
        removePackageDownloads("C64", "bubble_escape");
        removePackageDownloads("C64", "formula_1_simulator");
        removePackageDownloads("C64", "monty_on_the_run");
        removePackageDownloads("C64", "pacmania");
        removeSystemDownloads("C64");
        removeSystemDownloads("VIC20");
        removeSystemDownloads("DRIVES");
        removeSystemDownloads("PRINTER");
        runAndTestScreen(R.string.name_c64, "snapshot-machine-ready.pixelbuffer");
        runAndTestScreen(R.string.name_vic20, "screenshot-machine-ready-vic20.pixelbuffer");
        runAndTestScreen("Bubble Escape", "screenshot-bubble-escape.pixelbuffer");
        onView(isRoot()).perform(createdTileAction("C64", click()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(allOf(isDisplayed(),withText(R.string.IDS_DEVICES))).perform(click());
        onView(withText(R.string.IDMS_TRUE_DRIVE_EMU))
                .perform(scrollTo())
                .check(matches(isChecked()));
        pressBack();

        waitForIdle();
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 30, TimeUnit.SECONDS)));


    }
}
