#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Probably never needed anymore, used to convert VICE-2.4 (re-)sources to android-Ressource-Files
import os
import re
import xml.dom.minidom
from xml.sax.saxutils import unescape
already_added={}
regex_foldername=re.compile("values-..$")
regex_translate_c_src=re.compile("/\\*.*\\\*/.*\{.*\}.*", 0)
def macrolist():
    write_definitions=[]
    for folder in already_added:
        for key in already_added[folder]:
            if not key in write_definitions:
                write_definitions.append(key)
    return write_definitions
def write_cdefs(filename):
    f=open(filename,"w")
    f.write("#include \"translate.h\"\n")
    f.write("#include <stdio.h>\n")
    f.write("#include \"translate_javastubs.h\"\n")
    f.write("t_javaResId translate_resources_gen[]= {\n")
    for key in macrolist():
        f.write("\t{%s,\"%s\"},\n" % (key,key))    
    f.write("\t{0,NULL}\n")
    f.write("};")
def write_header(filename):
    f=open(filename,"w")
    f.write("#ifndef VICE_TRANSLATE_H\n");
    f.write("#define VICE_TRANSLATE_H\n");
    f.write("\n");
    f.write("#include \"translate_funcs.h\"\n");
    f.write("\n");
    f.write("#define USE_PARAM_STRING 0\n");
    f.write("#define USE_PARAM_ID 1\n");
    f.write("\n");
    f.write("#define USE_DESCRIPTION_STRING 0\n");
    f.write("#define USE_DESCRIPTION_ID 1\n");
    f.write("\n");
    f.write("#define IDCLS_UNUSED 65536\n");    
    f.write("#define IDGS_UNUSED IDCLS_UNUSED\n");
    f.write("\n");
    f.write("#define IDCLS_SPECIFY_SIDCART_ENGINE_MODEL 0xffffff /* special case translation */\n");
    f.write("#define IDCLS_SPECIFY_SID_ENGINE_MODEL 0xfffffe /* special case translation */\n");
    f.write("#define IDCLS_SPECIFY_SIDDTV_ENGINE_MODEL 0xfffffd /* special case translation */\n");
    for i,value in enumerate(macrolist()):
        f.write("#define %s %d\n" % (value.strip(),i+65537))
    f.write("#endif\n")
def modify(value):
    value=value.strip();
    if value.find("N_(")==0:
        value=value[3:-2];                
    value=value.replace("\"","")#.decode(encoding="cp1252").encode(encoding='UTF-8',errors='strict');
    value=value.replace("'","\\’").replace("`","\\’");

    return value
def isNewValue(folder,key,value):
    if not folder in already_added.keys():
        already_added[folder]=[]
    if not key in already_added[folder]:
        already_added[folder].append(key)
        return True
    return False
def windows2res(src,resdir,dest):
    languages={"LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL":"values-de","LANGUAGE LANG_ENGLISH, SUBLANG_NEUTRAL":"values"}
    state=0
    folders={}    
    f=open(src,"r")
    for line in f:
        line=line.strip()
        if state==0 and line=="STRINGTABLE":
            state=1
        elif state==2 and line=="BEGIN":
            state=3
        elif state in (2,3) and line=="END":
            state=0;
        elif state==1 and line.startswith("LANGUAGE"):
            if line in languages.keys():
                folder=languages[line]
                if (not folder in folders.keys()):
                    if folder=="values" or re.match(regex_foldername,folder):
                        folders[folder]={}                
                state=2
        elif state==3 and not line.startswith("#"):
            key,value=line.split(None,1);
            value=value[1:-1]
            value=value.replace("'","\\’").replace("`","\\’")
            if folder=="values" or re.match(regex_foldername,folder):             
                if len(value)>0 and isNewValue(folder,key.strip(),value):
                    folders[folder][key.strip()]=value
    writedata(folders,resdir,dest)
        
def translate2res(src,resdir,dest):
    folders={}
    lastmakro="****";
    f=open(src,"r",encoding="cp1252")
    for line in f:
        if re.match(regex_translate_c_src, line):
            makro,value=line.split("{")[1].split("}")[0].split(",",1)
            if makro.find(lastmakro)==-1:
                key=makro
                lastmakro=makro
                folder="values"
            else:
                folder="values-"+makro[len(lastmakro)+1:].lower()
            if folder=="values" or re.match(regex_foldername,folder):
                if (not folder in folders.keys()):
                        folders[folder]={}
                value=modify(value)
                if len(value)>0 and isNewValue(folder,key.strip(),value):
                    folders[folder][key.strip()]=value

    writedata(folders,resdir,dest)
# folders[folder]=Ordner
# folders[folder].keys()=IDs
# folders[folder][key aus keys] = Inhalt
# alle mit {} initialisieren    
def writedata(folders,resdir,dest):
    for folder in folders.keys():
        if os.path.isdir(os.path.join(resdir,folder)):
            document=xml.dom.minidom. getDOMImplementation().createDocument(None,"resources",None)
            document.documentElement.setAttribute("tools:ignore","Typos")
            document.documentElement.setAttribute("xmlns:tools","http://schemas.android.com/tools");
            document.encoding="utf-8"
            for value in folders[folder].keys():
                node=document.createElement("string");
                node.setAttribute("name", value);
                node.setAttribute("formatted", "false");
                text=document.createTextNode(unescape(folders[folder][value]));
                node.appendChild(text)
                node.setAttribute("tools:ignore","TypographyEllipsis|TypographyDash")
                document.documentElement.appendChild(node)
            f=open(os.path.join(resdir,folder,dest),"w")
            document.writexml(writer=f, encoding="utf-8",indent="\t",newl="\n",addindent="\t")
                    
if __name__=="__main__":

    projectdir=os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))),"app","src","main")
    #print (projectdir)
    translate2res(os.path.join(projectdir,"jni","arch","amigaos","intl_text.c"), os.path.join(projectdir,"res"),"strings_translate_ui.xml")
    translate2res(os.path.join(projectdir,"jni","translate_text.c"), os.path.join(projectdir,"res"),"strings_translate.xml")
    windows2res(os.path.join(projectdir,"jni","arch","win32","res.rc"), os.path.join(projectdir,"res"),"strings_translate_winres.xml")
    write_cdefs(os.path.join(projectdir,"jni","arch","android","translate_resources_gen.c"))
    write_header(os.path.join(projectdir,"jni","arch","android","translate.h"))    
