
#python3 tools/rp9scanner.py "<files with wildcard>" <node path> <attribute name | sort | grep "^  \*.*" | uniq#

#python3 tools/rp9scanner.py "/home/rainer/Seafile/8-Bit-Wonders/rp9/Titles/Games/A*.rp9" \*//rp9:image priority\
#| sort | grep "^  \*.*" | uniq

import os.path
import sys
import zipfile
import xml.etree.ElementTree as ET
import glob

def extract_and_query(zip_path, xpath_expr, attr_name):
    try:
        with zipfile.ZipFile(zip_path, 'r') as zip_ref:
            print ("%s:" % os.path.basename(zip_path))
            if 'rp9-manifest.xml' not in zip_ref.namelist():
                print("Error: 'rp9-manifest.xml' not found in the ZIP archive.")
                return

            with zip_ref.open('rp9-manifest.xml') as xml_file:
                namespaces = {'rp9': 'http://www.retroplatform.com'}
                tree = ET.parse(xml_file)
                root = tree.getroot()
                matches = root.findall(xpath_expr, namespaces)

                if not matches:
                    print("  # No matches found for the given XPath (%s)." % xpath_expr)
                    return

                for i, elem in enumerate(matches, 1):
                    # print(f"\nMatch {i}:")
                    isAttr = False
                    if attr_name:
                        attr_value = elem.attrib.get(attr_name)
                        if attr_value is not None:
                            isAttr = True
                            print(f"  * Attribute '{attr_name}': {attr_value}")
                    if not isAttr:
                        print(" * "+ET.tostring(elem, encoding='unicode'))

    except zipfile.BadZipFile:
        print("Error: The provided file is not a valid ZIP archive.")
    except ET.ParseError:
        print("Error: Failed to parse the XML file.")
    except Exception as e:
        print(f"Unexpected error: {e}")

if __name__ == "__main__":
    if len(sys.argv) != 3 and len(sys.argv) != 4:
        print("Usage: python extract_xpath_from_zip.py <zip_file> <xpath>")
        sys.exit(1)

    zip_pattern = sys.argv[1]
    xpath_query = sys.argv[2]
    attr_name = sys.argv[3] if len(sys.argv) == 4 else None

    matching_files = glob.glob(zip_pattern, recursive=True)

    if not matching_files:
        print("No %s matching ZIP files found." % sys.argv[1])
        sys.exit(1)

    for zip_file in matching_files:
        extract_and_query(zip_file, xpath_query, attr_name)