function basename(name) {
    s = name.substring(0, name.lastIndexOf('.')) || name
    return s.substring(1+s.lastIndexOf('/'));
}
function friendly_name(name) {
    pos = name.indexOf("(SYS ");
    if (pos >= 0) {
        return name.substring(0, pos-1);
    }
    return name;
}
function emulation_action(action, node) {
    while (node.getAttribute("class") != "section") {
        node = node.parentNode;
    }
    image = node.getElementsByTagName("img")[0];
    topButton = node.getElementsByTagName("button")[0];

    data = new Map();
    data.set("basename", topButton.getElementsByTagName("span")[1].textContent.trim());
    data.set("zipurl", node.getAttribute("id"));
    if (image.hasAttribute("src")) {
        data.set("imageurl", image.getAttribute("src"));
    } else {
        data.set("imageurl", "");
    }
    result={}
    for (k of data.keys()) {
        result[k] = data.get(k);
    }
    callback.setEmulationDescription(action, JSON.stringify(result));
}
function toggleButtons(url) {
    const div = document.evaluate("//div[@class='section'][@id='"+url+"']", document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null).iterateNext();
    div.getElementsByTagName("button")[1].style.display = "inline-block";
    div.getElementsByTagName("button")[2].style.display = "none";

}
// a:link a:hover a:focus{color:#c9c5f6ff;font-style: normal;}
async function buildlist(doc) {
    const images = new Map();

    const table = doc.evaluate("//table[@class='archext']", doc, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null).iterateNext();
    const parent = doc.getElementsByTagName("body")[0];
    const style = document.createElement('style');
    style.innerHTML = "a:link a:hover a:focus {color:#c5f6ff;font-style: normal;}";
    doc.getElementsByTagName("head")[0].appendChild(style);
    const nodes = []
    callback.logVerbose(""+doc);
    callback.logVerbose(""+parent);
    var columns = table.getElementsByTagName('td');
    for(var columnIt = 0; columnIt < columns.length; columnIt++) {
        var column = columns[columnIt];
        if (column.textContent.endsWith(".png") && column.getElementsByTagName("a").length > 0) {
            var href=new URL(column.getElementsByTagName("a")[0].getAttribute("href"), document.URL).href;
            images.set(basename(column.textContent), href);
        }
    }
    if (columns.length > 0) {
        document.body.style.background = "#121212";
    }
    for(var columnIt = 0; columnIt < columns.length; columnIt++) {

        var column = columns[columnIt];

        if (column.textContent.endsWith(".zip") && column.getElementsByTagName("a").length > 0) {
            var href=new URL(column.getElementsByTagName("a")[0].getAttribute("href"), document.URL).href;
            var div = document.createElement('div');
            var label = basename(column.textContent);
            var innerHTML=`
            <button id="btn" type="button" style= "background-color: #121212;
                color: #e1b402; cursor: pointer; padding: 18px; width: 100%;
                border: none; text-align: left; outline: none; font-size: 15px;"
                onMouseOver="this.style.backgroundColor='#4b3f0e'"
                onMouseOut="this.style.backgroundColor='#121212'">
                <span id="showtogglestate" style="color: #009ee0; display: inline-table; width: 1em;">&#x25B6;</span>
                <span style="display: inline-table;">`+ friendly_name(label) +`</span></button>
            <div style="padding: 5%; display: none; overflow: hidden;
                background-color: #121212; border-top-color: #e1b402; border-top-style: solid;">
                <div style="width: max-content; display: block; align-items: center;" >
                    <img loading='lazy' style="object-fit: contain; width:400px; max-width:80%;" src="`+images.get(label)+`"/><br/>
                    <div style="display: flex; justify-content: center; width:400px; max-width:80%;">
                        <br/>
                        <button type="button" id="save" style="font-size: 150%; margin-right: 10px; display: inline-block; color: white; background-color: #565db3;"
                        onMouseOver="this.style.backgroundColor='#636ab9'"
                        onMouseOut="this.style.backgroundColor='#565db3'">&#x2606;</button>
                        <button type="button" id="remove" style="font-size: 150%; margin-right: 10px; display: inline-block; color: white; background-color: #565db3;"
                        onMouseOver="this.style.backgroundColor='#636ab9'"
                        onMouseOut="this.style.backgroundColor='#565db3'">&#x2605;</button>
                        <button type="button" id="run" style="font-size: 150%; display: inline-block; color: white; background-color: #565db3;"
                        onMouseOver="this.style.backgroundColor='#636ab9'"
                        onMouseOut="this.style.backgroundColor='#565db3'">&#x25B6;</button>
                        <br/>
                    </div>
                </div>
            </div>`
            div.setAttribute("style","width:100%; border-top-color: #e1b402; border-top-style: solid;");
            div.setAttribute("class", "section");
            div.setAttribute("id", href);
            div.innerHTML = innerHTML;
            nodes.push(div);
            hideButtonIndex = callback.isOnStartPage(href) ? 1 : 2;
            div.getElementsByTagName("button")[hideButtonIndex].style.display = "none";
            div.getElementsByTagName("button")[0].addEventListener("click", function() {
                var content = this.nextElementSibling;
                if (content.style.display === "block") {
                  this.getElementsByTagName("span")[0].innerHTML="&#x25B6;";
                  content.style.display = "none";
                } else {
                  this.getElementsByTagName("span")[0].innerHTML="&#x25E2;";
                  content.style.display = "block";
                }
            });

            div.getElementsByTagName("button")[1].addEventListener("click", function() {
                node = this;
                while (node.getAttribute("class") != "section") {
                    node = node.parentNode;
                }
                emulation_action("save", this);
                node.getElementsByTagName("button")[2].style.display = "inline-block";
                node.getElementsByTagName("button")[1].style.display = "none";

            });
            div.getElementsByTagName("button")[2].addEventListener("click", function() {
                node = this;
                while (node.getAttribute("class") != "section") {
                    node = node.parentNode;
                }
                href = node.getAttribute("id");
                callback.logVerbose("remove "+href);
                callback.removeFromStartPage(href, "toggleButtons('"+href+"');");
            });
            div.getElementsByTagName("button")[3].addEventListener("click", function() {
                node = this;
                while (node.getAttribute("class") != "section") {
                    node = node.parentNode;
                }
                emulation_action("stream", this);
            });

        }
    }
    parent.innerHTML = "<p div style='color: white; background-color: #121212' align='center'><i>Original: <a style='color: #e1b402;' href='https://archive.org/details/vic20_202209'>https://archive.org/details/vic20_202209</a></i></p>";
    for(var nodesIt = 0; nodesIt < nodes.length; nodesIt++) {
        parent.appendChild(nodes[nodesIt]);
    }
    callback.scriptFinished();
}
//buildlist(document);

(async function() {
        callback.logError("vic20");
        buildlist(document);
        callback.containsEmulation(false);
})();